/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.internal.debugger.extender.breakpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.debugger.extender.DebuggerExtenderAPIVersion;
import oracle.ide.debugger.extender.DebuggerExtenderCallback;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpoint;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerExtender;
import oracle.ideimpl.debugger.extender.CommonExtenderBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointDeclaratorBase;
import oracle.jdevimpl.debugger.BreakpointsWindowSettings;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.extender.evaluator.CustomDataProvider;
import oracle.jdevimpl.internal.debugger.extender.ExtenderManager;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.JDebugger;

public class ExtenderCallback {
    protected CommonExtenderBase extender;
    protected String extenderID;
    protected List<ExtenderBreakpoint> extenderBreakpoints;
    protected CustomDataProvider customDataProvider;
    protected Map<String, CommonBreakpointDeclaratorBase> customBreakpointTypes = new HashMap<String, CommonBreakpointDeclaratorBase>();
    protected DebuggerExtenderAPIVersion _apiVersion;
    protected ExtenderCallbackVersion13 _v13;
    protected ExtenderCallbackVersion12 _v12;

    public DebuggerExtenderAPIVersion getAPIVersion() {
        return this._apiVersion;
    }

    public ExtenderCallbackVersion13 ExtenderCallbackVersion13() {
        if (this instanceof ExtenderCallbackVersion13) {
            return (ExtenderCallbackVersion13)this;
        }
        if (this instanceof ExtenderCallbackVersion12) {
            return null;
        }
        return this._v13;
    }

    public ExtenderCallbackVersion12 ExtenderCallbackVersion12() {
        if (this instanceof ExtenderCallbackVersion12) {
            return (ExtenderCallbackVersion12)this;
        }
        if (this instanceof ExtenderCallbackVersion13) {
            return null;
        }
        return this._v12;
    }

    private ExtenderCallback(CommonExtenderBase extender, String extenderID) {
        this.extender = extender;
        this.extenderID = extenderID;
        if (extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V13) {
            this._apiVersion = DebuggerExtenderAPIVersion.V13;
            this._v13 = new ExtenderCallbackVersion13((oracle.ide.debugger.extender.DebuggerExtender)extender, extenderID);
        } else if (extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V12) {
            this._apiVersion = DebuggerExtenderAPIVersion.V12;
            this._v12 = new ExtenderCallbackVersion12((DebuggerExtender)extender, extenderID);
        } else {
            throw new IllegalArgumentException("Extender is not properly versioned");
        }
    }

    public static ExtenderCallbackVersion12 createExtenderCallbackVersion12(CommonExtenderBase extender, String extenderID) {
        return new ExtenderCallback(extender, extenderID).ExtenderCallbackVersion12();
    }

    public static ExtenderCallbackVersion13 createExtenderCallbackVersion13(CommonExtenderBase extender, String extenderID) {
        return new ExtenderCallback(extender, extenderID).ExtenderCallbackVersion13();
    }

    private ExtenderCallback() {
    }

    public CommonExtenderBase getExtender() {
        return this.extender;
    }

    public String getExtenderId() {
        return this.extenderID;
    }

    public synchronized void deleteExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        if (this._apiVersion == DebuggerExtenderAPIVersion.V13) {
            this.ExtenderCallbackVersion13().getExtenderBreakpoints().remove(breakpoint);
        } else if (this._apiVersion == DebuggerExtenderAPIVersion.V12) {
            this.ExtenderCallbackVersion12().getExtenderBreakpoints().remove(breakpoint);
        } else {
            throw new IllegalStateException("ExtenderCallback not properly versioned");
        }
    }

    public synchronized void addExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        if (this._apiVersion == DebuggerExtenderAPIVersion.V13) {
            this.ExtenderCallbackVersion13().getExtenderBreakpoints().add(breakpoint);
        } else if (this._apiVersion == DebuggerExtenderAPIVersion.V12) {
            this.ExtenderCallbackVersion12().getExtenderBreakpoints().add(breakpoint);
        } else {
            throw new IllegalStateException("ExtenderCallback not properly versioned");
        }
    }

    public synchronized ExtenderBreakpoint getExtenderBreakpoint(CoreBreakpoint breakpoint) {
        List<ExtenderBreakpoint> extenderBreakpoints;
        if (this._apiVersion == DebuggerExtenderAPIVersion.V13) {
            extenderBreakpoints = this.ExtenderCallbackVersion13().getExtenderBreakpoints();
        } else if (this._apiVersion == DebuggerExtenderAPIVersion.V12) {
            extenderBreakpoints = this.ExtenderCallbackVersion12().getExtenderBreakpoints();
        } else {
            throw new IllegalStateException("ExtenderCallback not initialized for API Version");
        }
        for (ExtenderBreakpoint extenderBreakpoint : extenderBreakpoints) {
            if (extenderBreakpoint.getBreakpoint() != breakpoint) continue;
            return extenderBreakpoint;
        }
        return null;
    }

    public CustomDataProvider getCustomDataProvider() {
        if (this.customDataProvider == null) {
            this.customDataProvider = new CustomDataProvider();
        }
        return this.customDataProvider;
    }

    protected ExtenderBreakpoint recognizeBreakpoint(CommonBreakpointBase breakpoint) {
        if (breakpoint instanceof ExtenderBreakpoint) {
            return (ExtenderBreakpoint)breakpoint;
        }
        if (this._apiVersion == DebuggerExtenderAPIVersion.V13) {
            List<? extends DebuggerExtenderBreakpoint> v13extenderBreakpoints = this.ExtenderCallbackVersion13().getBreakpoints();
            if (v13extenderBreakpoints != null) {
                for (CommonBreakpointBase commonBreakpointBase : v13extenderBreakpoints) {
                    if (!this.extender.breakpointsEqual(commonBreakpointBase, breakpoint)) continue;
                    return (ExtenderBreakpoint)commonBreakpointBase;
                }
            }
        } else if (this._apiVersion == DebuggerExtenderAPIVersion.V12) {
            List<? extends DebuggerBreakpoint> v12extenderBreakpoints = this.ExtenderCallbackVersion12().getBreakpoints();
            if (v12extenderBreakpoints != null) {
                for (CommonBreakpointBase commonBreakpointBase : v12extenderBreakpoints) {
                    if (!this.extender.breakpointsEqual(commonBreakpointBase, breakpoint)) continue;
                    return (ExtenderBreakpoint)commonBreakpointBase;
                }
            }
        } else {
            throw new IllegalStateException("ExtenderCallback not initialized for API Version");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean knowsCustomBreakpointType(String customBreakpointType) {
        Map<String, CommonBreakpointDeclaratorBase> map = this.customBreakpointTypes;
        synchronized (map) {
            return this.customBreakpointTypes.get(customBreakpointType) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonBreakpointDeclaratorBase getCustomBreakpointDeclarator(String breakpointTypeString) {
        Map<String, CommonBreakpointDeclaratorBase> map = this.customBreakpointTypes;
        synchronized (map) {
            return this.customBreakpointTypes.get(breakpointTypeString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCustomBreakpointTypes() {
        Map<String, CommonBreakpointDeclaratorBase> map = this.customBreakpointTypes;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.customBreakpointTypes.keySet());
        }
    }

    public class ExtenderCallbackVersion13
    extends ExtenderCallback
    implements DebuggerExtenderCallback {
        private ExtenderCallbackVersion13(oracle.ide.debugger.extender.DebuggerExtender extender, String extenderID) {
            this.extender = extender;
            this.extenderID = extenderID;
            this._apiVersion = DebuggerExtenderAPIVersion.V13;
            this._v13 = this;
        }

        public oracle.ide.debugger.extender.DebuggerExtender getExtender() {
            return (oracle.ide.debugger.extender.DebuggerExtender)this.extender;
        }

        public DebuggerExtenderBreakpoint addBreakpoint(DebuggerExtenderBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            final CoreBreakpoint bp = ExtenderManager.createBreakpoint(breakpoint, null, this.extenderID);
            ExtenderBreakpoint.ExtenderBreakpointVersion13 extenderBreakpoint = ExtenderBreakpoint.createExtenderBreakpointVersion13(bp);
            this.addExtenderBreakpoint(extenderBreakpoint);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDebugger.addBreakpoint(bp);
                }
            });
            return extenderBreakpoint.ExtenderBreakpointVersion13();
        }

        public synchronized List<? extends DebuggerExtenderBreakpoint> getBreakpoints() {
            if (CoreBreakpoint.breakpointsLoaded()) {
                List<ExtenderBreakpoint> currentBreakpoints = this.getExtenderBreakpoints();
                ArrayList<ExtenderBreakpoint.ExtenderBreakpointVersion13> copy = new ArrayList<ExtenderBreakpoint.ExtenderBreakpointVersion13>(currentBreakpoints.size());
                for (ExtenderBreakpoint extenderBreakpoint : currentBreakpoints) {
                    copy.add(extenderBreakpoint.ExtenderBreakpointVersion13());
                }
                return copy;
            }
            return null;
        }

        public DebuggerExtenderBreakpoint getDefaultBreakpointSettings() {
            return ExtenderBreakpoint.createExtenderBreakpointVersion13(new CoreBreakpoint());
        }

        public boolean editBreakpoint(DebuggerExtenderBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                return JDebugger.eeditBreakpoint(extenderBreakpoint.getBreakpoint());
            }
            return false;
        }

        synchronized List<ExtenderBreakpoint> getExtenderBreakpoints() {
            if (this.extenderBreakpoints == null) {
                List breakpoints = CoreBreakpoint.getExtenderBreakpoints((String)this.extenderID);
                this.extenderBreakpoints = new ArrayList();
                for (CoreBreakpoint breakpoint : breakpoints) {
                    ExtenderBreakpoint.ExtenderBreakpointVersion13 extenderBp = ExtenderBreakpoint.createExtenderBreakpointVersion13(breakpoint);
                    this.extenderBreakpoints.add(extenderBp);
                }
            }
            return this.extenderBreakpoints;
        }

        @Deprecated
        public void registerCustomBreakpointType(String customBreakpointType, DebuggerExtenderBreakpoint.BreakpointKind breakpointKind) {
            this.registerCustomBreakpointType(customBreakpointType, breakpointKind, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerCustomBreakpointType(String customBreakpointType, DebuggerExtenderBreakpoint.BreakpointKind breakpointKind, DebuggerExtenderBreakpoint breakpointTemplate) {
            if (customBreakpointType == null || customBreakpointType.trim().length() == 0) {
                throw new IllegalArgumentException("Need valid custom breakpoint type");
            }
            Map map = this.customBreakpointTypes;
            synchronized (map) {
                CustomBreakpointDetails<DebuggerExtenderBreakpoint, DebuggerExtenderBreakpoint.BreakpointKind> details = new CustomBreakpointDetails<DebuggerExtenderBreakpoint, DebuggerExtenderBreakpoint.BreakpointKind>(this.getExtender().getID(), customBreakpointType, breakpointKind, breakpointTemplate);
                this.customBreakpointTypes.put(customBreakpointType, details);
            }
        }

        public Icon getBreakpointIcon(DebuggerExtenderBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                return extenderBreakpoint.getIcon();
            }
            return null;
        }

        public DebuggerExtenderBreakpoint.BreakpointState getBreakpointState(DebuggerExtenderBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint instanceof ExtenderBreakpoint.ExtenderBreakpointVersion13) {
                return ((ExtenderBreakpoint.ExtenderBreakpointVersion13)extenderBreakpoint).getActiveState();
            }
            return null;
        }

        public DebuggerExtenderBreakpoint.BreakpointScope getDefaultBreakpointScope() {
            String defaultScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
            if (defaultScope.equals("workspace")) {
                return DebuggerExtenderBreakpoint.BreakpointScope.WORKSPACE;
            }
            if (defaultScope.equals("project")) {
                return DebuggerExtenderBreakpoint.BreakpointScope.PROJECT;
            }
            if (defaultScope.equals("global")) {
                return DebuggerExtenderBreakpoint.BreakpointScope.GLOBAL;
            }
            return DebuggerExtenderBreakpoint.BreakpointScope.WORKSPACE;
        }

        public boolean setEnableBreakpoint(DebuggerExtenderBreakpoint breakpoint, boolean enable) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                extenderBreakpoint.enableBreakpoint(enable);
                return true;
            }
            return false;
        }

        public boolean deleteBreakpoint(DebuggerExtenderBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                this.deleteExtenderBreakpoint(extenderBreakpoint);
                JDebugger.deleteBreakpoint(extenderBreakpoint.getBreakpoint());
                return true;
            }
            return false;
        }
    }

    public class ExtenderCallbackVersion12
    extends ExtenderCallback
    implements oracle.ide.runner.DebuggerExtenderCallback {
        private ExtenderCallbackVersion12(DebuggerExtender extender, String extenderID) {
            this.extender = extender;
            this.extenderID = extenderID;
            this._apiVersion = DebuggerExtenderAPIVersion.V12;
            this._v12 = this;
        }

        public DebuggerExtender getExtender() {
            return (DebuggerExtender)this.extender;
        }

        public DebuggerBreakpoint addBreakpoint(DebuggerBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            final CoreBreakpoint bp = ExtenderManager.createBreakpoint(breakpoint, null, this.extenderID);
            ExtenderBreakpoint.ExtenderBreakpointVersion12 extenderBreakpoint = ExtenderBreakpoint.createExtenderBreakpointVersion12(bp);
            this.addExtenderBreakpoint(extenderBreakpoint);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDebugger.addBreakpoint(bp);
                }
            });
            return extenderBreakpoint.ExtenderBreakpointVersion12();
        }

        public synchronized List<? extends DebuggerBreakpoint> getBreakpoints() {
            if (CoreBreakpoint.breakpointsLoaded()) {
                List<ExtenderBreakpoint> currentBreakpoints = this.getExtenderBreakpoints();
                ArrayList<ExtenderBreakpoint.ExtenderBreakpointVersion12> copy = new ArrayList<ExtenderBreakpoint.ExtenderBreakpointVersion12>(currentBreakpoints.size());
                for (ExtenderBreakpoint extenderBreakpoint : currentBreakpoints) {
                    copy.add(extenderBreakpoint.ExtenderBreakpointVersion12());
                }
                return copy;
            }
            return null;
        }

        public DebuggerBreakpoint getDefaultBreakpointSettings() {
            return ExtenderBreakpoint.createExtenderBreakpointVersion12(new CoreBreakpoint());
        }

        public boolean editBreakpoint(DebuggerBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                return JDebugger.eeditBreakpoint(extenderBreakpoint.getBreakpoint());
            }
            return false;
        }

        synchronized List<ExtenderBreakpoint> getExtenderBreakpoints() {
            if (this.extenderBreakpoints == null) {
                List breakpoints = CoreBreakpoint.getExtenderBreakpoints((String)this.extenderID);
                this.extenderBreakpoints = new ArrayList();
                for (CoreBreakpoint breakpoint : breakpoints) {
                    ExtenderBreakpoint.ExtenderBreakpointVersion12 extenderBp = ExtenderBreakpoint.createExtenderBreakpointVersion12(breakpoint);
                    this.extenderBreakpoints.add(extenderBp);
                }
            }
            return this.extenderBreakpoints;
        }

        @Deprecated
        public void registerCustomBreakpointType(String customBreakpointType, DebuggerBreakpoint.BreakpointKind breakpointKind) {
            this.registerCustomBreakpointType(customBreakpointType, breakpointKind, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerCustomBreakpointType(String customBreakpointType, DebuggerBreakpoint.BreakpointKind breakpointKind, DebuggerBreakpoint breakpointTemplate) {
            if (customBreakpointType == null || customBreakpointType.trim().length() == 0) {
                throw new IllegalArgumentException("Need valid custom breakpoint type");
            }
            Map map = this.customBreakpointTypes;
            synchronized (map) {
                CustomBreakpointDetails<DebuggerBreakpoint, DebuggerBreakpoint.BreakpointKind> details = new CustomBreakpointDetails<DebuggerBreakpoint, DebuggerBreakpoint.BreakpointKind>(this.getExtender().getID(), customBreakpointType, breakpointKind, breakpointTemplate);
                this.customBreakpointTypes.put(customBreakpointType, details);
            }
        }

        public Icon getBreakpointIcon(DebuggerBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                return extenderBreakpoint.getIcon();
            }
            return null;
        }

        public DebuggerBreakpoint.BreakpointState getBreakpointState(DebuggerBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint instanceof ExtenderBreakpoint.ExtenderBreakpointVersion12) {
                return ((ExtenderBreakpoint.ExtenderBreakpointVersion12)extenderBreakpoint).getActiveState();
            }
            return null;
        }

        public DebuggerBreakpoint.BreakpointScope getDefaultBreakpointScope() {
            String defaultScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
            if (defaultScope.equals("workspace")) {
                return DebuggerBreakpoint.BreakpointScope.WORKSPACE;
            }
            if (defaultScope.equals("project")) {
                return DebuggerBreakpoint.BreakpointScope.PROJECT;
            }
            if (defaultScope.equals("global")) {
                return DebuggerBreakpoint.BreakpointScope.GLOBAL;
            }
            return DebuggerBreakpoint.BreakpointScope.WORKSPACE;
        }

        public boolean setEnableBreakpoint(DebuggerBreakpoint breakpoint, boolean enable) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                extenderBreakpoint.enableBreakpoint(enable);
                return true;
            }
            return false;
        }

        public boolean deleteBreakpoint(DebuggerBreakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
            ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint((CommonBreakpointBase)breakpoint);
            if (extenderBreakpoint != null) {
                this.deleteExtenderBreakpoint(extenderBreakpoint);
                JDebugger.deleteBreakpoint(extenderBreakpoint.getBreakpoint());
                return true;
            }
            return false;
        }
    }

    protected static class CustomBreakpointDetails<B extends CommonBreakpointBase, K extends Enum>
    implements CommonBreakpointDeclaratorBase<B, K> {
        private String customBreakpointType;
        private K kind;
        private B breakpointTemplate;
        private String debuggerExtenderId;

        CustomBreakpointDetails(String debuggerExtenderId, String customBreakpointType, K kind, B breakpointTemplate) {
            this.debuggerExtenderId = debuggerExtenderId;
            this.customBreakpointType = customBreakpointType;
            this.kind = kind;
            this.breakpointTemplate = breakpointTemplate;
        }

        public String getDebuggerExtenderId() {
            return this.debuggerExtenderId;
        }

        public K getBreakpointKind() {
            return this.kind;
        }

        public B getBreakpointTemplate() {
            return this.breakpointTemplate;
        }

        public String getBreakpointTypeString() {
            return this.customBreakpointType;
        }
    }
}

