/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.internal.debugger.extender.breakpoint;

import javax.swing.JPanel;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpoint;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointPanelBase;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.internal.debugger.extender.ExtenderManager;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.ExtenderBreakpoint;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.ExtenderCallback;

public class BreakpointDefinitionPanel {
    private CommonBreakpointPanelBase dbp;
    private CoreBreakpoint existingBp;
    private ExtenderCallback callback;

    public BreakpointDefinitionPanel(CommonBreakpointPanelBase dbp, CoreBreakpoint existingBp, ExtenderCallback callback) {
        this.dbp = dbp;
        this.existingBp = existingBp;
        this.callback = callback;
    }

    public JPanel getPanel() {
        return this.dbp.getPanel();
    }

    public String canOk() {
        return this.dbp.canOk();
    }

    public boolean veto() {
        return this.dbp.veto();
    }

    public CoreBreakpoint onOk() {
        CommonBreakpointBase debuggerBreakpoint = this.dbp.onOk();
        if (debuggerBreakpoint != null) {
            if (debuggerBreakpoint instanceof DebuggerExtenderBreakpoint) {
                CoreBreakpoint newBp = ExtenderManager.createBreakpoint((DebuggerExtenderBreakpoint)debuggerBreakpoint, null, this.callback.getExtenderId());
                if (this.existingBp == null) {
                    ExtenderBreakpoint.ExtenderBreakpointVersion13 extenderBp = ExtenderBreakpoint.createExtenderBreakpointVersion13(newBp);
                    this.callback.addExtenderBreakpoint(extenderBp);
                    return newBp;
                }
                this.existingBp.copyInto(newBp);
                return this.existingBp;
            }
            if (debuggerBreakpoint instanceof DebuggerBreakpoint) {
                CoreBreakpoint newBp = ExtenderManager.createBreakpoint((DebuggerBreakpoint)debuggerBreakpoint, null, this.callback.getExtenderId());
                if (this.existingBp == null) {
                    ExtenderBreakpoint.ExtenderBreakpointVersion12 extenderBp = ExtenderBreakpoint.createExtenderBreakpointVersion12(newBp);
                    this.callback.addExtenderBreakpoint(extenderBp);
                    return newBp;
                }
                this.existingBp.copyInto(newBp);
                return this.existingBp;
            }
            return null;
        }
        return null;
    }
}

