/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.internal.debugger.extender;

import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.debugger.extender.DebuggerExtenderAPIVersion;
import oracle.ide.debugger.extender.DebuggerExtenderCallback;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpoint;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpointLogEntry;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpointPanel;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerBreakpointPanel;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtender2;
import oracle.ide.runner.DebuggerExtenderDeclarator;
import oracle.ide.runner.DebuggerPropertiesBreakpoint;
import oracle.ideimpl.debugger.extender.CommonExtenderBase;
import oracle.ideimpl.debugger.extender.CommonExtenderDeclaratorBase;
import oracle.ideimpl.debugger.extender.CommonLocationBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointDeclaratorBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointPanelBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonExceptionBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonFileLineBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonMethodBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonPropertiesBreakpointBase;
import oracle.ideimpl.debugger.extender.breakpoint.CommonURLLineBreakpointBase;
import oracle.ideimpl.debugger.extender.evaluator.CommonEvaluatorBase;
import oracle.ideimpl.debugger.extender.event.CommonListenerBase;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.extender.evaluator.EvaluatorHandle;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.BreakpointDefinitionPanel;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.BreakpointDetails;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.ExtenderBreakpoint;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.ExtenderCallback;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

public class ExtenderManager {
    private Map<String, ExtenderCallback> extenderMap = new HashMap<String, ExtenderCallback>();
    private Map<String, String> sourceExtensionToDebuggerExtenderMap = new HashMap<String, String>();
    private static ExtenderManager _instance = new ExtenderManager();

    private ExtenderManager() {
    }

    public static ExtenderManager getInstance() {
        return _instance;
    }

    public static DebuggerExtenderAPIVersion getAPIVersionForExtenderId(String extenderId) {
        if (extenderId == null) {
            throw new IllegalArgumentException("silly request for version of null extenderId ");
        }
        Map extenderInfo = DebuggerHook.getDebuggerExtenderDeclarator((String)extenderId);
        if (extenderInfo != null && extenderInfo.size() > 0) {
            CommonExtenderDeclaratorBase declarator = (CommonExtenderDeclaratorBase)extenderInfo.keySet().iterator().next();
            if (declarator instanceof oracle.ide.debugger.extender.DebuggerExtenderDeclarator) {
                return DebuggerExtenderAPIVersion.V13;
            }
            if (declarator instanceof DebuggerExtenderDeclarator) {
                return DebuggerExtenderAPIVersion.V12;
            }
            throw new IllegalArgumentException("Illegal type for declarator " + declarator.getClass().getName());
        }
        throw new IllegalArgumentException("Unknown DebuggerExtender for extenderId: " + extenderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtender(String ID) {
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            return this.extenderMap.containsKey(ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtenderCallback.ExtenderCallbackVersion13 addExtenderVersion13(oracle.ide.debugger.extender.DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return null;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            if (this.extenderMap.containsKey(ID)) {
                return null;
            }
            ExtenderCallback.ExtenderCallbackVersion13 callback = ExtenderCallback.createExtenderCallbackVersion13((CommonExtenderBase)extender, ID);
            this.extenderMap.put(ID, callback);
            DebuggerHook.addDebuggerListener((CommonListenerBase)extender);
            return callback;
        }
    }

    public ExtenderCallback.ExtenderCallbackVersion13 addExtenderVersion13(oracle.ide.debugger.extender.DebuggerExtenderDeclarator declarator) {
        oracle.ide.debugger.extender.DebuggerExtender extender = declarator.getDebuggerExtender();
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback.ExtenderCallbackVersion13 callback = this.addExtenderVersion13(extender);
        declarator.setDebuggerExtenderCallback((DebuggerExtenderCallback)callback);
        extender.breakpointsLoaded();
        return callback;
    }

    public ExtenderCallback.ExtenderCallbackVersion13 addExtenderVersion13(oracle.ide.debugger.extender.DebuggerExtenderDeclarator declarator, List<String> sourceExtensions) {
        oracle.ide.debugger.extender.DebuggerExtender extender = declarator.getDebuggerExtender();
        String extenderId = extender.getID();
        if (sourceExtensions != null && sourceExtensions.size() > 0) {
            throw new IllegalArgumentException("Debugger extender must implement DebuggerExtender2");
        }
        if (sourceExtensions != null) {
            for (String sourceExtension : sourceExtensions) {
                String currentRegistrant = this.sourceExtensionToDebuggerExtenderMap.get(sourceExtension);
                if (currentRegistrant != null && !currentRegistrant.equals(extenderId)) {
                    throw new IllegalArgumentException("Source file extension " + sourceExtension + " cannot be assigned to " + extenderId + " because it is already owned by " + currentRegistrant);
                }
                this.sourceExtensionToDebuggerExtenderMap.put(sourceExtension, extenderId);
            }
        }
        return this.addExtenderVersion13(declarator);
    }

    private CoreBreakpoint overrideSteppingVersion13(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        DebuggerExtenderBreakpoint debuggerBreakpoint;
        oracle.ide.debugger.extender.DebuggerExtender extender = (oracle.ide.debugger.extender.DebuggerExtender)breakpointDetails.getDebuggerExtender();
        ExtenderCallback callback = breakpointDetails.getExtenderCallback();
        if (extender != null && callback != null && (debuggerBreakpoint = (DebuggerExtenderBreakpoint)breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        debuggerBreakpoint = extender.stepOver(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_INTO: {
                        debuggerBreakpoint = extender.stepInto(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_OUT: {
                        debuggerBreakpoint = extender.stepOut(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_TO_END_OF_METHOD: {
                        debuggerBreakpoint = extender.stepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case RUN_TO_CURSOR: {
                        debuggerBreakpoint = extender.runToCursor(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                if (debuggerBreakpoint != null) {
                    return ExtenderManager.createBreakpoint(debuggerBreakpoint, null, callback.getExtenderId());
                }
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            catch (VMDisconnectedException iae) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    private boolean doExtenderActionVersion13(ExtenderAction action, Context context, CoreBreakpoint breakpoint, boolean forceLoadingOfExtender) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, forceLoadingOfExtender);
        if (details != null) {
            try {
                oracle.ide.debugger.extender.DebuggerExtender extender = (oracle.ide.debugger.extender.DebuggerExtender)details.extender;
                ExtenderBreakpoint.ExtenderBreakpointVersion13 extenderBreakpoint = details.extenderBreakpoint.ExtenderBreakpointVersion13();
                ExtenderCallback.ExtenderCallbackVersion13 callback = details.callback.ExtenderCallbackVersion13();
                switch (action) {
                    case SHOW_BREAKPOINT_LOCATION: {
                        return extender.showBreakpointLocation(context, (DebuggerExtenderBreakpoint)extenderBreakpoint);
                    }
                    case CAN_SHOW_BREAKPOINT_LOCATION: {
                        return extender.canShowBreakpointLocation(context, (DebuggerExtenderBreakpoint)extenderBreakpoint);
                    }
                    case BREAKPOINT_DELETED: {
                        callback.deleteExtenderBreakpoint(extenderBreakpoint);
                        extender.breakpointDeleted((DebuggerExtenderBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case IS_EXTENDER_BREAKPOINT: {
                        return true;
                    }
                    case UPDATE_BREAKPOINT_ICON: {
                        extender.updateBreakpointIcon((DebuggerExtenderBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case SHOW_BREAKPOINT_ICON: {
                        extender.breakpointInScope((DebuggerExtenderBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case HIDE_BREAKPOINT_ICON: {
                        extender.breakpointOutOfScope((DebuggerExtenderBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_MOVED: {
                        extender.breakpointChanged((DebuggerExtenderBreakpoint)extenderBreakpoint, DebuggerExtenderBreakpoint.BreakpointState.MOVED);
                        return true;
                    }
                    case BREAKPOINT_REFACTORED: {
                        extender.breakpointChanged((DebuggerExtenderBreakpoint)extenderBreakpoint, DebuggerExtenderBreakpoint.BreakpointState.REFACTORED);
                        return true;
                    }
                    case BREAKPOINT_EDITED: {
                        extender.breakpointChanged((DebuggerExtenderBreakpoint)extenderBreakpoint, DebuggerExtenderBreakpoint.BreakpointState.EDITED);
                        return true;
                    }
                    case BREAKPOINT_ADDED: {
                        extender.breakpointAdded((DebuggerExtenderBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_SCOPE_CHANGED: {
                        extender.breakpointChanged((DebuggerExtenderBreakpoint)extenderBreakpoint, DebuggerExtenderBreakpoint.BreakpointState.SCOPE_CHANGED);
                        return true;
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException extender) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtenderCallback.ExtenderCallbackVersion12 addExtenderVersion12(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return null;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            if (this.extenderMap.containsKey(ID)) {
                return null;
            }
            ExtenderCallback.ExtenderCallbackVersion12 callback = ExtenderCallback.createExtenderCallbackVersion12((CommonExtenderBase)extender, ID);
            this.extenderMap.put(ID, callback);
            DebuggerHook.addDebuggerListener((CommonListenerBase)extender);
            return callback;
        }
    }

    public ExtenderCallback.ExtenderCallbackVersion12 addExtenderVersion12(DebuggerExtenderDeclarator declarator) {
        DebuggerExtender extender = declarator.getDebuggerExtender();
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback.ExtenderCallbackVersion12 callback = this.addExtenderVersion12(extender);
        declarator.setDebuggerExtenderCallback((oracle.ide.runner.DebuggerExtenderCallback)callback);
        extender.breakpointsLoaded();
        return callback;
    }

    public ExtenderCallback.ExtenderCallbackVersion12 addExtenderVersion12(DebuggerExtenderDeclarator declarator, List<String> sourceExtensions) {
        DebuggerExtender extender = declarator.getDebuggerExtender();
        String extenderId = extender.getID();
        if (sourceExtensions != null && sourceExtensions.size() > 0 && !(extender instanceof DebuggerExtender2)) {
            throw new IllegalArgumentException("Debugger extender must implement DebuggerExtender2");
        }
        if (sourceExtensions != null) {
            for (String sourceExtension : sourceExtensions) {
                String currentRegistrant = this.sourceExtensionToDebuggerExtenderMap.get(sourceExtension);
                if (currentRegistrant != null && !currentRegistrant.equals(extenderId)) {
                    throw new IllegalArgumentException("Source file extension " + sourceExtension + " cannot be assigned to " + extenderId + " because it is already owned by " + currentRegistrant);
                }
                this.sourceExtensionToDebuggerExtenderMap.put(sourceExtension, extenderId);
            }
        }
        return this.addExtenderVersion12(declarator);
    }

    private CoreBreakpoint overrideSteppingVersion12(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = (DebuggerExtender)breakpointDetails.getDebuggerExtender();
        ExtenderCallback callback = breakpointDetails.getExtenderCallback();
        if (extender != null && callback != null && (debuggerBreakpoint = (DebuggerBreakpoint)breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        debuggerBreakpoint = extender.stepOver(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_INTO: {
                        debuggerBreakpoint = extender.stepInto(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_OUT: {
                        debuggerBreakpoint = extender.stepOut(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_TO_END_OF_METHOD: {
                        debuggerBreakpoint = extender.stepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case RUN_TO_CURSOR: {
                        debuggerBreakpoint = extender.runToCursor(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                if (debuggerBreakpoint != null) {
                    return ExtenderManager.createBreakpoint(debuggerBreakpoint, null, callback.getExtenderId());
                }
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            catch (VMDisconnectedException iae) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    private boolean doExtenderActionVersion12(ExtenderAction action, Context context, CoreBreakpoint breakpoint, boolean forceLoadingOfExtender) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, forceLoadingOfExtender);
        if (details != null) {
            try {
                DebuggerExtender extender = (DebuggerExtender)details.extender;
                ExtenderBreakpoint.ExtenderBreakpointVersion12 extenderBreakpoint = details.extenderBreakpoint.ExtenderBreakpointVersion12();
                ExtenderCallback.ExtenderCallbackVersion12 callback = details.callback.ExtenderCallbackVersion12();
                switch (action) {
                    case SHOW_BREAKPOINT_LOCATION: {
                        return extender.showBreakpointLocation(context, (DebuggerBreakpoint)extenderBreakpoint);
                    }
                    case CAN_SHOW_BREAKPOINT_LOCATION: {
                        return extender.canShowBreakpointLocation(context, (DebuggerBreakpoint)extenderBreakpoint);
                    }
                    case BREAKPOINT_DELETED: {
                        callback.deleteExtenderBreakpoint(extenderBreakpoint);
                        extender.breakpointDeleted((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case IS_EXTENDER_BREAKPOINT: {
                        return true;
                    }
                    case UPDATE_BREAKPOINT_ICON: {
                        extender.updateBreakpointIcon((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case SHOW_BREAKPOINT_ICON: {
                        extender.breakpointInScope((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case HIDE_BREAKPOINT_ICON: {
                        extender.breakpointOutOfScope((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_MOVED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.MOVED);
                        return true;
                    }
                    case BREAKPOINT_REFACTORED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.REFACTORED);
                        return true;
                    }
                    case BREAKPOINT_EDITED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.EDITED);
                        return true;
                    }
                    case BREAKPOINT_ADDED: {
                        extender.breakpointAdded((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_SCOPE_CHANGED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.SCOPE_CHANGED);
                        return true;
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException extender) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    public ExtenderCallback addExtender(String extenderId) {
        if (extenderId == null) {
            throw new IllegalArgumentException("addExtender(" + extenderId + ") is senseless");
        }
        Map extenderInfo = DebuggerHook.getDebuggerExtenderDeclarator((String)extenderId);
        if (extenderInfo != null && extenderInfo.size() > 0) {
            CommonExtenderDeclaratorBase declarator = extenderInfo.keySet().toArray(new CommonExtenderDeclaratorBase[1])[0];
            CommonExtenderBase extender = declarator.getDebuggerExtender();
            List sourceExtensions = (List)extenderInfo.get(declarator);
            if (extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V12 && sourceExtensions != null && sourceExtensions.size() > 0 && !(extender instanceof DebuggerExtender2)) {
                DebuggerHook.notExtender2Error((String)extenderId);
            } else if (sourceExtensions != null) {
                for (String sourceExtension : sourceExtensions) {
                    String currentRegistrant = this.sourceExtensionToDebuggerExtenderMap.get(sourceExtension);
                    if (currentRegistrant != null && !currentRegistrant.equals(extenderId)) {
                        DebuggerHook.duplicateSourceExtensionError((String)extenderId, (String)currentRegistrant, (String)sourceExtension);
                        continue;
                    }
                    this.sourceExtensionToDebuggerExtenderMap.put(sourceExtension, extenderId);
                }
            }
            if (declarator instanceof oracle.ide.debugger.extender.DebuggerExtenderDeclarator) {
                return this.addExtenderVersion13((oracle.ide.debugger.extender.DebuggerExtenderDeclarator)declarator);
            }
            if (declarator instanceof DebuggerExtenderDeclarator) {
                return this.addExtenderVersion12((DebuggerExtenderDeclarator)declarator);
            }
            throw new IllegalArgumentException("Declarator is not of correct class");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            this.extenderMap.remove(ID);
        }
    }

    public boolean isExtenderBreakpoint(CoreBreakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.IS_EXTENDER_BREAKPOINT, null, breakpoint, true);
    }

    public boolean stoppedAtExtenderBreakpoint(BreakpointDetails breakpointDetails) {
        return breakpointDetails != null && breakpointDetails.getDebuggerBreakpoint() != null;
    }

    public void breakpointAdded(CoreBreakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_ADDED, null, breakpoint, false);
    }

    public void breakpointChanged(DebuggingProcess debuggingProcess, CoreBreakpoint breakpoint) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, false);
        if (details != null) {
            if (details.callback.getAPIVersion() == DebuggerExtenderAPIVersion.V13) {
                DebuggerExtenderBreakpoint.BreakpointState newState;
                switch (BreakpointRuntimeSupport.getRuntimeStatus(breakpoint, debuggingProcess)) {
                    case 0: {
                        newState = DebuggerExtenderBreakpoint.BreakpointState.DISABLED;
                        break;
                    }
                    case 1: {
                        newState = DebuggerExtenderBreakpoint.BreakpointState.ENABLED;
                        break;
                    }
                    case 2: {
                        newState = DebuggerExtenderBreakpoint.BreakpointState.UNVERIFIED;
                        break;
                    }
                    case 3: {
                        newState = DebuggerExtenderBreakpoint.BreakpointState.VERIFIED;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                try {
                    oracle.ide.debugger.extender.DebuggerExtender extender = (oracle.ide.debugger.extender.DebuggerExtender)details.extender;
                    extender.breakpointChanged((DebuggerExtenderBreakpoint)details.extenderBreakpoint.ExtenderBreakpointVersion13(), newState);
                }
                catch (VMDisconnectedException extender) {
                }
                catch (Exception ex) {
                    FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                    ex.printStackTrace();
                }
            } else if (details.callback.getAPIVersion() == DebuggerExtenderAPIVersion.V12) {
                DebuggerBreakpoint.BreakpointState newState;
                switch (BreakpointRuntimeSupport.getRuntimeStatus(breakpoint, debuggingProcess)) {
                    case 0: {
                        newState = DebuggerBreakpoint.BreakpointState.DISABLED;
                        break;
                    }
                    case 1: {
                        newState = DebuggerBreakpoint.BreakpointState.ENABLED;
                        break;
                    }
                    case 2: {
                        newState = DebuggerBreakpoint.BreakpointState.UNVERIFIED;
                        break;
                    }
                    case 3: {
                        newState = DebuggerBreakpoint.BreakpointState.VERIFIED;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                try {
                    DebuggerExtender extender = (DebuggerExtender)details.extender;
                    extender.breakpointChanged((DebuggerBreakpoint)details.extenderBreakpoint.ExtenderBreakpointVersion12(), newState);
                }
                catch (VMDisconnectedException extender) {
                }
                catch (Exception ex) {
                    FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    public void breakpointMoved(CoreBreakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_MOVED, null, breakpoint, false);
    }

    public void breakpointRefactored(CoreBreakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_REFACTORED, null, breakpoint, false);
    }

    public void breakpointDeleted(CoreBreakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_DELETED, null, breakpoint, false);
    }

    public void breakpointEdited(CoreBreakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_EDITED, null, breakpoint, false);
    }

    public void breakpointScopeChanged(CoreBreakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_SCOPE_CHANGED, null, breakpoint, false);
    }

    public void debuggeeStoppedAtBreakpoint(Context context, BreakpointDetails breakpointDetails) {
        ExtenderActionDetails actionDetails = this.getExtenderActionDetails(breakpointDetails.getBreakpoint(), true);
        if (actionDetails != null) {
            breakpointDetails.setDebuggerExtender(actionDetails.extender);
            breakpointDetails.setExtenderCallback(actionDetails.callback);
            if (actionDetails.extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V13) {
                breakpointDetails.setDebuggerBreakpoint((CommonBreakpointBase)actionDetails.extenderBreakpoint.ExtenderBreakpointVersion13());
                ((oracle.ide.debugger.extender.DebuggerExtender)actionDetails.extender).debuggeeStoppedAtBreakpoint(context, (DebuggerExtenderBreakpoint)actionDetails.extenderBreakpoint.ExtenderBreakpointVersion13());
            } else {
                breakpointDetails.setDebuggerBreakpoint((CommonBreakpointBase)actionDetails.extenderBreakpoint.ExtenderBreakpointVersion12());
                ((DebuggerExtender)actionDetails.extender).debuggeeStoppedAtBreakpoint(context, (DebuggerBreakpoint)actionDetails.extenderBreakpoint.ExtenderBreakpointVersion12());
            }
        }
    }

    public boolean canShowBreakpointLocation(Context context, CoreBreakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_BREAKPOINT_LOCATION, context, breakpoint, true);
    }

    public boolean showBreakpointLocation(Context context, CoreBreakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.SHOW_BREAKPOINT_LOCATION, context, breakpoint, true);
    }

    public void newDebugSession(Context context) {
        this.callAllExtenders(ExtenderAction.NEW_DEBUG_SESSION, context);
    }

    public boolean canShowIPLocation(Context context, BreakpointDetails breakpointDetails) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_IP_LOCATION, context, breakpointDetails);
    }

    public boolean canShowIPLocation(Context context, DebugLocation location) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_IP_LOCATION, context, location);
    }

    public boolean showIPLocation(Context context, BreakpointDetails breakpointDetails) {
        return this.doExtenderAction(ExtenderAction.SHOW_IP_LOCATION, context, breakpointDetails);
    }

    public boolean showIPLocation(Context context, DebugLocation location) {
        return this.doExtenderAction(ExtenderAction.SHOW_IP_LOCATION, context, location);
    }

    public void setEvaluator(DebuggingProcess process, CoreBreakpoint breakpoint, EvaluatorProxy evaluator) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, true);
        if (details != null) {
            try {
                if (details.extender instanceof oracle.ide.debugger.extender.DebuggerExtender) {
                    EvaluatorHandle.EvaluatorHandleVersion13 debuggerEvaluator = EvaluatorHandle.createEvaluatorHandleVersion13(evaluator, process, details.callback.getCustomDataProvider());
                    details.extender.setEvaluator(process.getContext(), (CommonEvaluatorBase)debuggerEvaluator);
                } else if (details.extender instanceof DebuggerExtender) {
                    EvaluatorHandle.EvaluatorHandleVersion12 debuggerEvaluator = EvaluatorHandle.createEvaluatorHandleVersion12(evaluator, process, details.callback.getCustomDataProvider());
                    details.extender.setEvaluator(process.getContext(), (CommonEvaluatorBase)debuggerEvaluator);
                }
            }
            catch (VMDisconnectedException debuggerEvaluator) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    public CoreBreakpoint stepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_OVER);
    }

    public boolean canStepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_OVER);
    }

    public CoreBreakpoint stepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_INTO);
    }

    public boolean canStepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_INTO);
    }

    public CoreBreakpoint stepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_OUT);
    }

    public boolean canStepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_OUT);
    }

    public CoreBreakpoint stepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    public boolean canStepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    public CoreBreakpoint runToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.RUN_TO_CURSOR);
    }

    public boolean canRunToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.RUN_TO_CURSOR);
    }

    public boolean updateBreakpointIcon(CoreBreakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.UPDATE_BREAKPOINT_ICON, null, breakpoint, false);
    }

    public boolean showBreakpointIcon(CoreBreakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.SHOW_BREAKPOINT_ICON, null, breakpoint, false);
    }

    public boolean hideBreakpointIcon(CoreBreakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.HIDE_BREAKPOINT_ICON, null, breakpoint, false);
    }

    void breakpointsLoaded() {
        this.callAllExtenders(ExtenderAction.BREAKPOINTS_LOADED, null);
    }

    public void temporaryBreakpointSet(Context context, CoreBreakpoint breakpoint) {
        ExtenderCallback callback = this.getCallbackFromId(breakpoint.getDebuggerExtenderID(), true);
        if (callback != null) {
            try {
                if (callback.getAPIVersion() == DebuggerExtenderAPIVersion.V13) {
                    ExtenderBreakpoint.ExtenderBreakpointVersion13 extenderBreakpoint = ExtenderBreakpoint.createExtenderBreakpointVersion13(breakpoint);
                    callback.addExtenderBreakpoint(extenderBreakpoint);
                    ((oracle.ide.debugger.extender.DebuggerExtender)callback.getExtender()).temporaryBreakpointSet(context, (DebuggerExtenderBreakpoint)extenderBreakpoint);
                } else {
                    ExtenderBreakpoint.ExtenderBreakpointVersion12 extenderBreakpoint = ExtenderBreakpoint.createExtenderBreakpointVersion12(breakpoint);
                    callback.addExtenderBreakpoint(extenderBreakpoint);
                    ((DebuggerExtender)callback.getExtender()).temporaryBreakpointSet(context, (DebuggerBreakpoint)extenderBreakpoint);
                }
            }
            catch (VMDisconnectedException extenderBreakpoint) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    public boolean canCreateCustomBreakpoint(String breakpointTypeString, Workspace workspace, Project project) {
        ExtenderCallback callback = this.getExtenderFromCustomBreakpointType(breakpointTypeString, false);
        if (callback != null) {
            try {
                return callback.getExtender().canCreateCustomBreakpoint(breakpointTypeString, workspace, project);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return true;
    }

    public BreakpointDefinitionPanel getCustomBreakpointPanel(String customBreakpointType, CoreBreakpoint breakpoint, ChangeListener changeListener) {
        ExtenderCallback callback = null;
        ExtenderBreakpoint debuggerBreakpoint = null;
        if (breakpoint != null) {
            ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, true);
            if (details != null) {
                callback = details.callback;
                debuggerBreakpoint = callback.getAPIVersion() == DebuggerExtenderAPIVersion.V13 ? details.extenderBreakpoint.ExtenderBreakpointVersion13() : details.extenderBreakpoint.ExtenderBreakpointVersion12();
            }
        } else {
            callback = this.getExtenderFromCustomBreakpointType(customBreakpointType, true);
        }
        try {
            if (callback.getAPIVersion() == DebuggerExtenderAPIVersion.V13) {
                DebuggerExtenderBreakpoint v13breakpoint = debuggerBreakpoint;
                oracle.ide.debugger.extender.DebuggerExtender v13Extender = ((ExtenderCallback.ExtenderCallbackVersion13)callback).getExtender();
                DebuggerExtenderBreakpointPanel dbp = v13Extender.getCustomBreakpointPanel(customBreakpointType, v13breakpoint, changeListener);
                if (dbp != null) {
                    return new BreakpointDefinitionPanel((CommonBreakpointPanelBase)dbp, breakpoint, callback);
                }
            } else {
                DebuggerBreakpoint v12breakpoint = (DebuggerBreakpoint)debuggerBreakpoint;
                DebuggerExtender v12Extender = ((ExtenderCallback.ExtenderCallbackVersion12)callback).getExtender();
                DebuggerBreakpointPanel dbp = v12Extender.getCustomBreakpointPanel(customBreakpointType, v12breakpoint, changeListener);
                if (dbp != null) {
                    return new BreakpointDefinitionPanel((CommonBreakpointPanelBase)dbp, breakpoint, callback);
                }
            }
        }
        catch (VMDisconnectedException v12breakpoint) {
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCustomBreakpointTypes() {
        ArrayList<String> customBreakpointTypes = new ArrayList<String>();
        customBreakpointTypes.addAll(DebuggerHook.getDebuggerExtenderCustomBreakpointTypes());
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                customBreakpointTypes.addAll(callback.getCustomBreakpointTypes());
            }
        }
        return customBreakpointTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonBreakpointDeclaratorBase getCustomBreakpointDeclarator(String customBreakpointType) {
        CommonBreakpointDeclaratorBase declarator = DebuggerHook.getDebuggerExtenderCustomBreakpointDeclarator((String)customBreakpointType);
        if (declarator != null) {
            return declarator;
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                if (!callback.knowsCustomBreakpointType(customBreakpointType)) continue;
                return callback.getCustomBreakpointDeclarator(customBreakpointType);
            }
        }
        return null;
    }

    public static int getBreakpointType(DebuggerExtenderBreakpoint.BreakpointKind kind) {
        int bpType = 0;
        switch (kind) {
            default: {
                bpType = 0;
                break;
            }
            case METHOD: {
                bpType = 1;
                break;
            }
            case URL_LINE: {
                bpType = 5;
                break;
            }
            case EXCEPTION: {
                bpType = 2;
                break;
            }
            case PROPERTIES: {
                bpType = 8;
            }
        }
        return bpType;
    }

    public static int getBreakpointType(DebuggerBreakpoint.BreakpointKind kind) {
        int bpType = 0;
        switch (kind) {
            default: {
                bpType = 0;
                break;
            }
            case METHOD: {
                bpType = 1;
                break;
            }
            case URL_LINE: {
                bpType = 5;
                break;
            }
            case EXCEPTION: {
                bpType = 2;
                break;
            }
            case PROPERTIES: {
                bpType = 8;
            }
        }
        return bpType;
    }

    public static CoreBreakpoint createBreakpoint(DebuggerBreakpoint debuggerBreakpoint, Project project, String extenderId) {
        CoreBreakpoint bp = null;
        switch (debuggerBreakpoint.getKind()) {
            case METHOD: {
                if (!(debuggerBreakpoint instanceof CommonMethodBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonMethodBreakpointBase methodBreakpoint = (CommonMethodBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(methodBreakpoint.getScope(), project, 1, methodBreakpoint.getMethodName());
                break;
            }
            case FILE_LINE: {
                if (!(debuggerBreakpoint instanceof CommonFileLineBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonFileLineBreakpointBase fileLineBreakpoint = (CommonFileLineBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(fileLineBreakpoint.getScope(), project, 0, null, fileLineBreakpoint.getPackage(), fileLineBreakpoint.getFileName(), fileLineBreakpoint.getLine());
                break;
            }
            case URL_LINE: {
                if (!(debuggerBreakpoint instanceof CommonURLLineBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonURLLineBreakpointBase urlLineBreakpoint = (CommonURLLineBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(urlLineBreakpoint.getScope(), project, 5, urlLineBreakpoint.getURL(), urlLineBreakpoint.getLine());
                break;
            }
            case EXCEPTION: {
                if (!(debuggerBreakpoint instanceof CommonExceptionBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonExceptionBreakpointBase exceptionBreakpoint = (CommonExceptionBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(exceptionBreakpoint.getScope(), 2, exceptionBreakpoint.getExceptionName(), exceptionBreakpoint.isBreakOnCaughtExceptions(), exceptionBreakpoint.isBreakOnUncaughtExceptions());
                break;
            }
            case PROPERTIES: {
                if (!(debuggerBreakpoint instanceof DebuggerPropertiesBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerPropertiesBreakpoint propertiesBreakpoint = (DebuggerPropertiesBreakpoint)debuggerBreakpoint;
                bp = new CoreBreakpoint(propertiesBreakpoint.getScope(), 8, propertiesBreakpoint.getProperties());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
        }
        bp.setShallow(true);
        bp.setDebuggerExtenderID(extenderId);
        bp.setEnabled(debuggerBreakpoint.isEnabled());
        bp.setCondition(debuggerBreakpoint.getCondition());
        bp.setEditCondition(debuggerBreakpoint.canEditCondition());
        bp.setHiddenCondition(debuggerBreakpoint.getHiddenCondition());
        bp.setPassCount(debuggerBreakpoint.getPassCount());
        bp.setEditPassCount(debuggerBreakpoint.canEditPassCount());
        bp.setGroupName(debuggerBreakpoint.getGroupName());
        bp.setEditGroupName(debuggerBreakpoint.canEditGroupName());
        bp.setCustomDescription(debuggerBreakpoint.getCustomDescription());
        bp.setCustomTypeString(debuggerBreakpoint.getCustomTypeString());
        bp.setThreadName(null);
        bp.setThreadNameNot(null);
        if (debuggerBreakpoint.getBreakForThreadNamed() != null) {
            bp.setThreadName(debuggerBreakpoint.getBreakForThreadNamed());
        } else if (debuggerBreakpoint.getBreakForThreadNotNamed() != null) {
            bp.setThreadNameNot(debuggerBreakpoint.getBreakForThreadNotNamed());
        }
        bp.setEditBreakForThreads(debuggerBreakpoint.canEditBreakForThreads());
        bp.setActionHalt(debuggerBreakpoint.isHaltOnBreakpointHit());
        bp.setActionBeep(debuggerBreakpoint.isBeepOnBreakpointHit());
        DebuggerBreakpointLogEntry logEntry = debuggerBreakpoint.getLogEntryOnBreakpointHit();
        if (logEntry != null) {
            bp.setActionLog(logEntry.isEnabled());
            bp.setActionLogStack(logEntry.isLogStackTrace());
            bp.setActionLogExpression(logEntry.getLogExpression());
            bp.setActionLogTag(logEntry.getLogTag());
        } else {
            bp.setActionLog(false);
            bp.setActionLogStack(false);
            bp.setActionLogExpression(null);
            bp.setActionLogTag(null);
        }
        bp.setActionEnableOther(debuggerBreakpoint.getEnableBreakpointGroupOnBreakpointHit());
        bp.setActionDisableOther(debuggerBreakpoint.getDisableBreakpointGroupOnBreakpointHit());
        bp.setEditBreakpointHitActions(debuggerBreakpoint.canEditBreakpointHitActions());
        bp.setProperties(debuggerBreakpoint.getProperties());
        bp.setShallow(false);
        return bp;
    }

    public static CoreBreakpoint createBreakpoint(DebuggerExtenderBreakpoint debuggerBreakpoint, Project project, String extenderId) {
        CoreBreakpoint bp = null;
        switch (debuggerBreakpoint.getKind()) {
            case METHOD: {
                if (!(debuggerBreakpoint instanceof CommonMethodBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonMethodBreakpointBase methodBreakpoint = (CommonMethodBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(methodBreakpoint.getScope(), project, 1, methodBreakpoint.getMethodName());
                break;
            }
            case FILE_LINE: {
                if (!(debuggerBreakpoint instanceof CommonFileLineBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonFileLineBreakpointBase fileLineBreakpoint = (CommonFileLineBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(fileLineBreakpoint.getScope(), project, 0, null, fileLineBreakpoint.getPackage(), fileLineBreakpoint.getFileName(), fileLineBreakpoint.getLine());
                break;
            }
            case URL_LINE: {
                if (!(debuggerBreakpoint instanceof CommonURLLineBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonURLLineBreakpointBase urlLineBreakpoint = (CommonURLLineBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(urlLineBreakpoint.getScope(), project, 5, urlLineBreakpoint.getURL(), urlLineBreakpoint.getLine());
                break;
            }
            case EXCEPTION: {
                if (!(debuggerBreakpoint instanceof CommonExceptionBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonExceptionBreakpointBase exceptionBreakpoint = (CommonExceptionBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(exceptionBreakpoint.getScope(), 2, exceptionBreakpoint.getExceptionName(), exceptionBreakpoint.isBreakOnCaughtExceptions(), exceptionBreakpoint.isBreakOnUncaughtExceptions());
                break;
            }
            case PROPERTIES: {
                if (!(debuggerBreakpoint instanceof CommonPropertiesBreakpointBase)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                CommonPropertiesBreakpointBase propertiesBreakpoint = (CommonPropertiesBreakpointBase)debuggerBreakpoint;
                bp = new CoreBreakpoint(propertiesBreakpoint.getScope(), 8, propertiesBreakpoint.getProperties());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
        }
        bp.setShallow(true);
        bp.setDebuggerExtenderID(extenderId);
        bp.setEnabled(debuggerBreakpoint.isEnabled());
        bp.setCondition(debuggerBreakpoint.getCondition());
        bp.setEditCondition(debuggerBreakpoint.canEditCondition());
        bp.setHiddenCondition(debuggerBreakpoint.getHiddenCondition());
        bp.setPassCount(debuggerBreakpoint.getPassCount());
        bp.setEditPassCount(debuggerBreakpoint.canEditPassCount());
        bp.setGroupName(debuggerBreakpoint.getGroupName());
        bp.setEditGroupName(debuggerBreakpoint.canEditGroupName());
        bp.setCustomDescription(debuggerBreakpoint.getCustomDescription());
        bp.setCustomTypeString(debuggerBreakpoint.getCustomTypeString());
        bp.setThreadName(null);
        bp.setThreadNameNot(null);
        if (debuggerBreakpoint.getBreakForThreadNamed() != null) {
            bp.setThreadName(debuggerBreakpoint.getBreakForThreadNamed());
        } else if (debuggerBreakpoint.getBreakForThreadNotNamed() != null) {
            bp.setThreadNameNot(debuggerBreakpoint.getBreakForThreadNotNamed());
        }
        bp.setEditBreakForThreads(debuggerBreakpoint.canEditBreakForThreads());
        bp.setActionHalt(debuggerBreakpoint.isHaltOnBreakpointHit());
        bp.setActionBeep(debuggerBreakpoint.isBeepOnBreakpointHit());
        DebuggerExtenderBreakpointLogEntry logEntry = debuggerBreakpoint.getLogEntryOnBreakpointHit();
        if (logEntry != null) {
            bp.setActionLog(logEntry.isEnabled());
            bp.setActionLogStack(logEntry.isLogStackTrace());
            bp.setActionLogExpression(logEntry.getLogExpression());
            bp.setActionLogTag(logEntry.getLogTag());
        } else {
            bp.setActionLog(false);
            bp.setActionLogStack(false);
            bp.setActionLogExpression(null);
            bp.setActionLogTag(null);
        }
        bp.setActionEnableOther(debuggerBreakpoint.getEnableBreakpointGroupOnBreakpointHit());
        bp.setActionDisableOther(debuggerBreakpoint.getDisableBreakpointGroupOnBreakpointHit());
        bp.setEditBreakpointHitActions(debuggerBreakpoint.canEditBreakpointHitActions());
        bp.setProperties(debuggerBreakpoint.getProperties());
        bp.setShallow(false);
        return bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtenderCallback getExtenderFromCustomBreakpointType(String customBreakpointType, boolean forceLoadingOfExtender) {
        String extenderId = DebuggerHook.getDebuggerExtenderCustomBreakpointExtenderId((String)customBreakpointType);
        if (this.hasExtender(extenderId) || forceLoadingOfExtender) {
            Map<String, ExtenderCallback> map = this.extenderMap;
            synchronized (map) {
                CommonBreakpointDeclaratorBase bpDeclarator = this.getCustomBreakpointDeclarator(customBreakpointType);
                if (bpDeclarator != null) {
                    return this.getCallbackFromId(extenderId, true);
                }
            }
        }
        return null;
    }

    private CoreBreakpoint overrideStepping(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        CommonExtenderBase extender = breakpointDetails.getDebuggerExtender();
        if (extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V13) {
            return this.overrideSteppingVersion13(process, breakpointDetails, action);
        }
        if (extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V12) {
            return this.overrideSteppingVersion12(process, breakpointDetails, action);
        }
        return null;
    }

    private boolean canOverrideStepping(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        CommonBreakpointBase debuggerBreakpoint;
        CommonExtenderBase extender = breakpointDetails.getDebuggerExtender();
        if (extender != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        return extender.canStepOver(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_INTO: {
                        return extender.canStepInto(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_OUT: {
                        return extender.canStepOut(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_TO_END_OF_METHOD: {
                        return extender.canStepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                    }
                    case RUN_TO_CURSOR: {
                        return extender.canRunToCursor(process.getContext(), debuggerBreakpoint);
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, BreakpointDetails breakpointDetails) {
        CommonBreakpointBase debuggerBreakpoint;
        CommonExtenderBase extender = breakpointDetails.getDebuggerExtender();
        if (extender != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case CAN_SHOW_IP_LOCATION: {
                        return extender.canShowIPLocation(context, debuggerBreakpoint);
                    }
                    case SHOW_IP_LOCATION: {
                        return extender.showIPLocation(context, debuggerBreakpoint);
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, DebugLocation location) {
        CommonExtenderBase extender = this.getExtenderForLocation(location);
        if (extender != null) {
            try {
                switch (action) {
                    case CAN_SHOW_IP_LOCATION: {
                        return extender.canShowIPLocation(context, (CommonLocationBase)location);
                    }
                    case SHOW_IP_LOCATION: {
                        return extender.showIPLocation(context, (CommonLocationBase)location);
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, CoreBreakpoint breakpoint, boolean forceLoadingOfExtender) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, forceLoadingOfExtender);
        if (details != null) {
            if (details.extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V13) {
                return this.doExtenderActionVersion13(action, context, breakpoint, forceLoadingOfExtender);
            }
            if (details.extender.getDebuggerExtenderAPIVersion() == DebuggerExtenderAPIVersion.V12) {
                return this.doExtenderActionVersion12(action, context, breakpoint, forceLoadingOfExtender);
            }
            throw new IllegalArgumentException("Extender is not properly versioned");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callAllExtenders(ExtenderAction action, Context context) {
        ArrayList<ExtenderCallback> callbacks = new ArrayList<ExtenderCallback>();
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback2 : this.extenderMap.values()) {
                callbacks.add(callback2);
            }
        }
        for (ExtenderCallback callback : callbacks) {
            try {
                switch (action) {
                    case NEW_DEBUG_SESSION: {
                        callback.getExtender().newDebugSession(context);
                        break;
                    }
                    case BREAKPOINTS_LOADED: {
                        callback.getExtender().breakpointsLoaded();
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            catch (VMDisconnectedException callback2) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    private ExtenderActionDetails getExtenderActionDetails(CoreBreakpoint breakpoint, boolean forceLoadingOfExtender) {
        ExtenderBreakpoint extenderBreakpoint;
        if (breakpoint == null || breakpoint.getDebuggerExtenderID() == null) {
            return null;
        }
        ExtenderCallback callback = this.getCallbackFromId(breakpoint.getDebuggerExtenderID(), forceLoadingOfExtender);
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            return new ExtenderActionDetails(callback, extenderBreakpoint);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtenderCallback getCallbackFromId(String id, boolean forceLoadingOfExtender) {
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            if (this.hasExtender(id)) {
                return this.extenderMap.get(id);
            }
            if (forceLoadingOfExtender) {
                return this.addExtender(id);
            }
            return null;
        }
    }

    private CommonExtenderBase getExtenderForLocation(DebugLocation debugLocation) {
        String sourceFileName = debugLocation.getFilename();
        if (sourceFileName == null || sourceFileName.indexOf(46) == -1) {
            return null;
        }
        String extension = sourceFileName.substring(sourceFileName.lastIndexOf(46) + 1);
        String extenderId = this.sourceExtensionToDebuggerExtenderMap.get(extension);
        if (extenderId == null) {
            return null;
        }
        ExtenderCallback callback = this.extenderMap.get(extenderId);
        if (callback == null) {
            return null;
        }
        return (DebuggerExtender2)callback.getExtender();
    }

    public oracle.ide.runner.DebuggerExtenderCallback addDebuggerExtender(DebuggerExtender extender) {
        ExtenderCallback.ExtenderCallbackVersion12 callback = this.addExtenderVersion12(extender);
        extender.breakpointsLoaded();
        return callback;
    }

    public void addDebuggerExtender(DebuggerExtenderDeclarator extenderDeclarator) {
        if (extenderDeclarator == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback.ExtenderCallbackVersion12 callback = this.addExtenderVersion12(extenderDeclarator);
        if (callback != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDebugger.updateActiveBreakpoints(true);
                }
            });
        }
    }

    public void addDebuggerExtender(DebuggerExtenderDeclarator extenderDeclarator, List<String> sourceExtensions) {
        if (extenderDeclarator == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback.ExtenderCallbackVersion12 callback = this.addExtenderVersion12(extenderDeclarator, sourceExtensions);
        if (callback != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDebugger.updateActiveBreakpoints(true);
                }
            });
        }
    }

    public void removeDebuggerExtender(DebuggerExtender extender) {
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtender argument");
        }
        DebuggerHook.removeDebuggerListener((CommonListenerBase)extender);
        this.removeExtender(extender);
    }

    public static enum ExtenderAction {
        CAN_SHOW_IP_LOCATION,
        SHOW_IP_LOCATION,
        CAN_SHOW_BREAKPOINT_LOCATION,
        SHOW_BREAKPOINT_LOCATION,
        BREAKPOINT_DELETED,
        IS_EXTENDER_BREAKPOINT,
        STEP_OVER,
        STEP_INTO,
        RUN_TO_CURSOR,
        STEP_OUT,
        STEP_TO_END_OF_METHOD,
        SHOW_BREAKPOINT_ICON,
        HIDE_BREAKPOINT_ICON,
        UPDATE_BREAKPOINT_ICON,
        BREAKPOINTS_LOADED,
        NEW_DEBUG_SESSION,
        BREAKPOINT_MOVED,
        BREAKPOINT_REFACTORED,
        BREAKPOINT_EDITED,
        BREAKPOINT_ADDED,
        BREAKPOINT_SCOPE_CHANGED;

    }

    private class ExtenderActionDetails {
        private CommonExtenderBase extender;
        private ExtenderBreakpoint extenderBreakpoint;
        private ExtenderCallback callback;

        ExtenderActionDetails(ExtenderCallback callback, ExtenderBreakpoint breakpoint) {
            this.callback = callback;
            this.extender = callback.getExtender();
            this.extenderBreakpoint = breakpoint;
        }
    }
}

