/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.debugger.plugin.CommonHelperFunctions;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.XSLTArb;

public class XSLTDebugHelper {
    private static final String XML_PARSER_JAR_PATH = "../oracle_common/modules/oracle.xdk_11.1.0/xmlparserv2.jar";
    private static final String XML_PARSER_JAR = "xmlparserv2.jar";
    private static File xsltJar;
    private static boolean firstTime;
    public static final String CLASSNAME_XMLString = "$oracle.xml.xslt.XMLString";
    public static final String CLASSNAME_XMLNode = "$oracle.xml.xslt.XMLNode";
    private static boolean firstTimeDebugging;

    private static boolean supportsJDWP(String className) {
        try {
            Object result;
            Method m;
            Class<?> c = Class.forName(className);
            if (c != null && (m = c.getMethod("supportsJDWP", null)) != null && (result = m.invoke(null, null)) instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static synchronized File getXSLTJarForDebugging() {
        if (firstTime) {
            String dir = Ide.getProperty((String)"XSLTDebuggerJarDirectory");
            if (dir != null) {
                xsltJar = new File(dir, XML_PARSER_JAR);
            } else if (XSLTDebugHelper.supportsJDWP("oracle.xml.xslt.XSLProcessor") || XSLTDebugHelper.supportsJDWP("oracle.xml.parser.v2.XSLProcessor")) {
                URL oracleHome = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
                URL jarFile = URLFactory.newURL((URL)oracleHome, (String)XML_PARSER_JAR_PATH);
                xsltJar = new File(jarFile.getPath());
            }
            firstTime = false;
        }
        return xsltJar;
    }

    public static boolean isXSLTDebuggingSupported() {
        return XSLTDebugHelper.getXSLTJarForDebugging() != null;
    }

    public static String getXSLTPackage() {
        return CommonHelperFunctions.getXSLTPackage();
    }

    @Deprecated
    public static String getXSLTPackage(URL url) {
        return CommonHelperFunctions.getXSLTPackage(url);
    }

    public static boolean verifyPackage(DebugClassInfo clazz, String pkg) {
        String xslName = XSLTDebugHelper.getStylesheetName(clazz, true);
        if (pkg == null || xslName == null) {
            return false;
        }
        String xsltPackagePlusDot = CommonHelperFunctions.getXSLTPackage() + ".";
        if (pkg.startsWith(xsltPackagePlusDot)) {
            return pkg.substring(xsltPackagePlusDot.length()).equals(xslName);
        }
        return false;
    }

    public static boolean isXSLTStylesheet(DebugClassInfo clazz) {
        if (clazz != null && clazz.getLanguage() == 4) {
            String xsltPackagePlusDot = CommonHelperFunctions.getXSLTPackage() + ".";
            String className = clazz.getName();
            if (className.startsWith(xsltPackagePlusDot) && !className.substring(xsltPackagePlusDot.length()).startsWith("XML")) {
                return true;
            }
        }
        return false;
    }

    private static String convertName(String name) {
        StringBuffer sb = new StringBuffer(name);
        int i = 0;
        block8: while (i < sb.length()) {
            if (sb.charAt(i) == '_' && i + 1 < sb.length()) {
                switch (sb.charAt(i + 1)) {
                    default: {
                        i += 2;
                        continue block8;
                    }
                    case '_': {
                        sb.replace(i, i + 2, "_");
                        ++i;
                        continue block8;
                    }
                    case 'A': {
                        sb.replace(i, i + 2, File.separator);
                        ++i;
                        continue block8;
                    }
                    case 'B': {
                        sb.replace(i, i + 2, ".");
                        ++i;
                        continue block8;
                    }
                    case 'C': {
                        sb.replace(i, i + 2, "-");
                        ++i;
                        continue block8;
                    }
                    case 'D': {
                        sb.replace(i, i + 2, " ");
                        ++i;
                        continue block8;
                    }
                    case 'E': 
                }
                sb.replace(i, i + 2, ":");
                ++i;
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getStylesheetName(DebugClassInfo clazz, boolean showFullName) {
        String classNameWithoutPackage = clazz.getNameWithoutPackage();
        String stylesheetName = XSLTDebugHelper.convertName(classNameWithoutPackage);
        if (showFullName) {
            if (stylesheetName.length() > 2 && stylesheetName.charAt(0) == File.separatorChar && stylesheetName.charAt(2) == ':') {
                stylesheetName = stylesheetName.substring(1);
            }
        } else {
            int lastSep = stylesheetName.lastIndexOf(File.separator);
            if (lastSep != -1) {
                stylesheetName = stylesheetName.substring(lastSep + 1);
            }
        }
        return stylesheetName;
    }

    public static String getTemplateName(DebugMethodInfo method, DebugStackFrameInfo stackFrame) {
        String methodName = method.getNameWithoutClassOrSignature();
        if (methodName.startsWith("$$")) {
            DebugDataInfo matchPatternData;
            DebugVariableInfo matchPatternVariable;
            if (stackFrame != null && (matchPatternVariable = stackFrame.getVariable("$matchPattern")) != null && (matchPatternData = matchPatternVariable.getDataInfo()) instanceof DebugDataCompositeInfo) {
                String matchPattern = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)matchPatternData, false, false);
                int index = matchPattern.indexOf(34) == -1 ? 0 : 1;
                return XSLTArb.format(index, matchPattern);
            }
            return XSLTArb.format(2, methodName.substring(2));
        }
        return XSLTDebugHelper.convertName(methodName);
    }

    public static String getXMLNodeTypeName(short type) {
        switch (type) {
            case 1: {
                return XSLTArb.getString(3);
            }
            case 2: {
                return XSLTArb.getString(4);
            }
            case 3: {
                return XSLTArb.getString(5);
            }
            case 4: {
                return XSLTArb.getString(6);
            }
            case 5: {
                return XSLTArb.getString(7);
            }
            case 6: {
                return XSLTArb.getString(8);
            }
            case 7: {
                return XSLTArb.getString(9);
            }
            case 8: {
                return XSLTArb.getString(10);
            }
            case 9: {
                return XSLTArb.getString(11);
            }
            case 10: {
                return XSLTArb.getString(12);
            }
            case 11: {
                return XSLTArb.getString(13);
            }
            case 12: {
                return XSLTArb.getString(14);
            }
        }
        return null;
    }

    public static String getXSLTRunConfigurationClassName() {
        return "oracle.jdevimpl.runner.xslt.XSLTConfiguration";
    }

    public static String getFirstXSLTDebugOption(String port) {
        if (firstTimeDebugging) {
            firstTimeDebugging = false;
        }
        return "-Doracle.xml.xslt.jdwp=server=y,port=" + port;
    }

    public static String getLastXSLTDebugOption() {
        return "-debug";
    }

    static {
        firstTime = true;
        firstTimeDebugging = true;
    }
}

