/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;

public class StackTraceUtility {
    private static Logger logger;

    public static void setLogging(boolean enable) {
        logger = enable ? Logger.getLogger("StackTraceUtility") : null;
    }

    public static StackTraceElement parse(String stackTraceLine) {
        String classLoaderName;
        String logPrefix = "StackTraceUtility.parse()";
        if (stackTraceLine == null) {
            if (logger != null) {
                logger.info(logPrefix + " input is null");
            }
            return null;
        }
        String orgStackTraceLine = stackTraceLine;
        int open = (stackTraceLine = stackTraceLine.replaceFirst("^\\s*at ", "").trim()).indexOf(40);
        if (open == -1) {
            if (logger != null) {
                logger.info(logPrefix + " malformed stack line - no parenthesized filename part: " + orgStackTraceLine);
            }
            return null;
        }
        String parenPart = stackTraceLine.substring(open);
        int parenPartEnd = parenPart.indexOf(41);
        if (parenPartEnd < 0) {
            if (logger != null) {
                logger.info(logPrefix + " malformed stack line - no end paren: " + orgStackTraceLine);
            }
            return null;
        }
        String mainPart = stackTraceLine.substring(0, open);
        String[] parts = mainPart.split("/");
        String string = classLoaderName = parts.length == 3 ? parts[0] : null;
        String modulePart = parts.length == 3 ? parts[1] : (parts.length == 2 ? parts[0] : null);
        String classAndMethod = parts[parts.length - 1];
        if (parts.length > 3) {
            if (logger != null) {
                logger.info(logPrefix + " malformed stack line - too many / separators: " + orgStackTraceLine);
            }
            return null;
        }
        String[] modParts = modulePart != null ? modulePart.split("@") : new String[]{};
        String moduleName = modParts.length > 0 ? modParts[0] : null;
        String moduleVersion = modParts.length > 1 ? modParts[1] : null;
        int dot = classAndMethod.lastIndexOf(".");
        if (dot <= 0) {
            if (logger != null) {
                logger.info(logPrefix + " no class or no method: " + orgStackTraceLine);
            }
            return null;
        }
        String className = classAndMethod.substring(0, dot);
        String methodName = classAndMethod.substring(dot + 1);
        if (!parenPart.matches("\\(.*\\)")) {
            if (logger != null) {
                logger.info(logPrefix + " malformed stack line - parenthesized filename not found: " + orgStackTraceLine);
            }
            return null;
        }
        String fileAndLine = parenPart.substring(1, parenPartEnd);
        String fileName = null;
        int lineNumber = 0;
        if ("Unknown Source".equals(fileAndLine)) {
            lineNumber = -1;
        } else if ("Native Method".equals(fileAndLine)) {
            lineNumber = -2;
        } else {
            int colon = fileAndLine.indexOf(":");
            if (colon == -1) {
                fileName = fileAndLine;
                lineNumber = -1;
            } else {
                fileName = fileAndLine.substring(0, colon);
                try {
                    lineNumber = Integer.parseInt(fileAndLine.substring(colon + 1));
                }
                catch (NumberFormatException e) {
                    if (logger != null) {
                        logger.info(logPrefix + " malformed stack line - non-numeric line number: " + orgStackTraceLine);
                    }
                    return null;
                }
            }
        }
        try {
            Class[] parameterTypes = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE};
            Constructor ctor = StackTraceElement.class.getDeclaredConstructor(parameterTypes);
            StackTraceElement element = (StackTraceElement)ctor.newInstance(classLoaderName, moduleName, moduleVersion, className, methodName, fileName, lineNumber);
            return element;
        }
        catch (NoSuchMethodException e) {
            if (logger != null) {
                logger.info(logPrefix + " fallback to JDK8 StackTraceElement, some data may be lost: " + orgStackTraceLine);
            }
            StackTraceElement result = new StackTraceElement(className, methodName, fileName, lineNumber);
            return result;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            if (logger != null) {
                logger.info(logPrefix + " exception (" + e.getMessage() + "( from line: " + orgStackTraceLine);
            }
            e.printStackTrace();
            return null;
        }
    }

    public static String getPackageFromFullyQualifiedClassName(String fqclass) {
        int separator = fqclass.lastIndexOf(46);
        if (separator != -1) {
            return fqclass.substring(0, separator);
        }
        return "";
    }

    public static String getClassFromFullyQualifiedClassName(String fqclass) {
        int separator = fqclass.lastIndexOf(46);
        if (separator != -1) {
            return fqclass.substring(separator + 1);
        }
        return fqclass;
    }
}

