/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.plugin.evaluator;

import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;

public abstract class CommonEvaluationInfoBase<D, C> {
    protected Object wrappedValue;
    protected String value;
    protected String hexValue;
    protected C classInfo;
    protected D data;

    public CommonEvaluationInfoBase(String value, C classInfo, D data) throws Exception {
        this.init(value, "", classInfo, data);
    }

    public CommonEvaluationInfoBase(String value, C classInfo) throws Exception {
        this.init(value, "", classInfo, null);
    }

    public CommonEvaluationInfoBase(boolean z, C classInfo) throws Exception {
        String hexValue;
        String value;
        Object object = this.wrappedValue = z ? Boolean.TRUE : Boolean.FALSE;
        if (z) {
            value = "true";
            hexValue = "01";
        } else {
            value = "false";
            hexValue = "00";
        }
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(byte b, C classInfo) throws Exception {
        this.wrappedValue = b;
        String value = Byte.toString(b);
        byte i = b;
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 2);
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(char c, C classInfo) throws Exception {
        this.wrappedValue = Character.valueOf(c);
        char[] buf = new char[]{'\'', c, '\''};
        char i = c;
        String value = new String(buf) + "    " + i;
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 4);
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(double d, C classInfo) throws Exception {
        this.wrappedValue = d;
        String value = Double.toString(d);
        long l = Double.doubleToLongBits(d);
        String hexValue = DebugShared.prepadOrTrunc(Long.toHexString(l), '0', 16);
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(float f, C classInfo) throws Exception {
        this.wrappedValue = Float.valueOf(f);
        String value = Float.toString(f);
        int i = Float.floatToIntBits(f);
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 8);
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(int i, C classInfo) throws Exception {
        this.wrappedValue = i;
        String value = Integer.toString(i);
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 8);
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(long l, C classInfo) throws Exception {
        this.wrappedValue = l;
        String value = Long.toString(l);
        String hexValue = DebugShared.prepadOrTrunc(Long.toHexString(l), '0', 16);
        this.init(value, hexValue, classInfo, null);
    }

    public CommonEvaluationInfoBase(short s, C classInfo) throws Exception {
        this.wrappedValue = s;
        String value = Short.toString(s);
        short i = s;
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 4);
        this.init(value, hexValue, classInfo, null);
    }

    private void init(String value, String hexValue, C classInfo, D data) throws Exception {
        if (classInfo == null) {
            throw new Exception("EvaluationInfo classInfo is null");
        }
        this.value = value;
        this.hexValue = hexValue;
        this.classInfo = classInfo;
        this.data = data;
    }

    public D getDataInfo() {
        return this.data;
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean tryCourtesyValue) {
        if (tryCourtesyValue && this.data instanceof DebugDataCompositeInfo && (this.value == null || this.value.length() == 0)) {
            return DebugShared.makeCourtesyValue((DebugDataCompositeInfo)this.data);
        }
        return this.value;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public C getClassInfo() {
        return this.classInfo;
    }

    public abstract boolean isNull();

    public void copyFrom(CommonEvaluationInfoBase<D, C> other) {
        this.value = other.value;
        this.hexValue = other.hexValue;
        this.classInfo = other.classInfo;
        this.data = other.data;
    }

    public Object getWrappedValue() {
        return this.wrappedValue;
    }

    public boolean getBooleanValue() {
        if (this.wrappedValue instanceof Boolean) {
            return (Boolean)this.wrappedValue;
        }
        return DebugSharedPrimitives.booleanDecode(this.value);
    }

    public byte getByteValue() {
        if (this.wrappedValue instanceof Byte) {
            return (Byte)this.wrappedValue;
        }
        return DebugSharedPrimitives.byteDecode(this.value);
    }

    public char getCharValue() {
        if (this.wrappedValue instanceof Character) {
            return ((Character)this.wrappedValue).charValue();
        }
        return DebugSharedPrimitives.charDecode(this.value);
    }

    public double getDoubleValue() {
        if (this.wrappedValue instanceof Double) {
            return (Double)this.wrappedValue;
        }
        return DebugSharedPrimitives.doubleDecode(this.value);
    }

    public float getFloatValue() {
        if (this.wrappedValue instanceof Float) {
            return ((Float)this.wrappedValue).floatValue();
        }
        return DebugSharedPrimitives.floatDecode(this.value);
    }

    public int getIntValue() {
        if (this.wrappedValue instanceof Integer) {
            return (Integer)this.wrappedValue;
        }
        return DebugSharedPrimitives.intDecode(this.value);
    }

    public long getLongValue() {
        if (this.wrappedValue instanceof Long) {
            return (Long)this.wrappedValue;
        }
        return DebugSharedPrimitives.longDecode(this.value);
    }

    public short getShortValue() {
        if (this.wrappedValue instanceof Short) {
            return (Short)this.wrappedValue;
        }
        return DebugSharedPrimitives.shortDecode(this.value);
    }

    public abstract String getStringValue();
}

