/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.plugin;

import java.net.ServerSocket;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class CommonHelperFunctions {
    public static long getObjectNumber(DebugDataCompositeInfo dci) {
        long address;
        DebugVirtualMachine vm = dci.getVM();
        DebugCapabilities capabilities = vm.getCapabilities();
        if (capabilities.canGetUniqueIDs()) {
            long uniqueID = dci.getUniqueID();
            if (uniqueID != 0L) {
                return uniqueID;
            }
        } else if (capabilities.canGetAddresses() && (address = dci.getAddressOfObject()) != 0L) {
            return address;
        }
        return 0L;
    }

    public static int getLocalPort() {
        try {
            ServerSocket available = new ServerSocket(0);
            int port = available.getLocalPort();
            available.close();
            return port;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getLocalPort(int min, int max) {
        for (int port = min; port <= max; ++port) {
            try {
                ServerSocket available = new ServerSocket(port);
                available.close();
                return port;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return 0;
    }

    public static String getXSLTPackage() {
        return "$oracle.xml.xslt";
    }

    public static String getXSLTPackage(URL url) {
        return CommonHelperFunctions.getXSLTPackage() + "." + URLFileSystem.getPlatformPathName((URL)url);
    }
}

