/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UnaryClauseModel;

public class PeriodsClause
extends AbstractRepeatIntervalClause<Integer, UnaryClauseModel<Integer>> {
    public PeriodsClause(RepeatIntervalModel repeatIntervalModel) {
        this(Integer.class, repeatIntervalModel);
    }

    protected PeriodsClause(UnaryClauseModel<Integer> unaryClauseModel) {
        super(unaryClauseModel);
    }

    protected PeriodsClause(Class<Integer> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new UnaryClauseModel<Integer>(clazz, ClauseType.PERIODS, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class Panel
    extends PropertyBasedPanel {
        protected GridBagLayout gridBagLayout1;
        private JCheckBox includeCheckBox;
        protected JLabel periodsLabel;
        protected JSpinner periodsSpinner;
        protected SpinnerNumberModel periodsModel;

        public Panel(Properties properties) {
            super(properties);
            this.gridBagLayout1 = new GridBagLayout();
            this.includeCheckBox = new JCheckBox();
            this.periodsLabel = new JLabel();
            this.periodsSpinner = new JSpinner();
            this.periodsModel = new SpinnerNumberModel(1, 1, 100, 1);
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((UnaryClauseModel)PeriodsClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.includeCheckBox.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_PERIODS_TAB_INCLUDE"));
            this.includeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.includeCheckBox_actionPerformed(actionEvent);
                }
            });
            this.periodsLabel.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_PERIODS_TAB_PERIODS"));
            this.periodsSpinner.setModel(this.periodsModel);
            this.periodsModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (Panel.this.periodsSpinner.isEnabled()) {
                        Panel.this.periodsModel_changed(changeEvent);
                    }
                }
            });
            this.add((Component)this.includeCheckBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.periodsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.periodsSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.enableClause(false);
        }

        public Integer getSelectedClauseElement() {
            return this.periodsModel.getNumber().intValue();
        }

        protected void periodsModel_changed(ChangeEvent changeEvent) {
            ((UnaryClauseModel)PeriodsClause.this.clauseModel).set(this.getSelectedClauseElement());
        }

        protected void selectClauseElement(Integer n, boolean bl) {
            Integer n2;
            if (!(n == null || bl && this.periodsSpinner.isEnabled() || (n2 = this.getSelectedClauseElement()) != null && n2 >= n)) {
                this.periodsModel.setValue(n);
            }
        }

        private void includeCheckBox_actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.includeCheckBox.isSelected();
            this.enableClause(bl);
            if (bl) {
                this.periodsModel_changed(null);
            } else {
                ((UnaryClauseModel)PeriodsClause.this.clauseModel).set(null);
            }
        }

        private void enableClause(boolean bl) {
            this.includeCheckBox.getModel().setSelected(bl);
            this.periodsLabel.setEnabled(bl);
            this.periodsSpinner.setEnabled(bl);
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case PERIODS: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Panel.this.enableClause(repeatIntervalModelEvent.getNewValue() != null);
                        if (repeatIntervalModelEvent.getNewValue() == null) {
                            Panel.this.periodsModel.setValue(1);
                            break;
                        }
                        Panel.this.periodsModel.setValue(repeatIntervalModelEvent.getNewValue());
                        break;
                    }
                    case BYPERIOD: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || repeatIntervalModelEvent.getNewValue() == null) break;
                        if (repeatIntervalModelEvent.getNewValue().getClass().isArray()) {
                            Integer[] integerArray = (Integer[])repeatIntervalModelEvent.getNewValue();
                            if (integerArray.length <= 0) break;
                            Panel.this.selectClauseElement(integerArray[integerArray.length - 1], true);
                            break;
                        }
                        Panel.this.selectClauseElement((Integer)repeatIntervalModelEvent.getNewValue(), true);
                    }
                }
            }
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                try {
                    ((UnaryClauseModel)PeriodsClause.this.clauseModel).set(Integer.valueOf(string));
                }
                catch (Throwable throwable) {
                    ((UnaryClauseModel)PeriodsClause.this.clauseModel).set(null);
                }
            }
        }
    }
}

