/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.TimePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Time;

public class ByTimeClause
extends AbstractRepeatIntervalClause<Time, SortedClauseModel<Time>> {
    public ByTimeClause(RepeatIntervalModel repeatIntervalModel) {
        this(Time.class, repeatIntervalModel);
    }

    protected ByTimeClause(SortedClauseModel<Time> sortedClauseModel) {
        super(sortedClauseModel);
    }

    protected ByTimeClause(Class<Time> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<Time>(clazz, ClauseType.BYTIME, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return this.getHourPanel(properties);
    }

    public JPanel getHourPanel() {
        return this.getHourPanel(null);
    }

    public JPanel getHourPanel(Properties properties) {
        return new HourPanel(properties);
    }

    public JPanel getNoHourPanel() {
        return this.getNoHourPanel(null);
    }

    public JPanel getNoHourPanel(Properties properties) {
        return new NoHourPanel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class HourPanel
    extends NoHourPanel {
        public HourPanel() {
            this(null);
        }

        public HourPanel(Properties properties) {
            this(properties, true, false, null);
        }

        protected HourPanel(Properties properties, boolean bl, boolean bl2, Time[] timeArray) {
            super(properties, bl, bl2, timeArray);
        }
    }

    protected class NoHourPanel
    extends TimePanel {
        public NoHourPanel() {
            this(null);
        }

        public NoHourPanel(Properties properties) {
            this(properties, false, false, null);
        }

        protected NoHourPanel(Properties properties, boolean bl, boolean bl2, Time[] timeArray) {
            super(properties, bl, bl2, false, timeArray);
            ((SortedClauseModel)ByTimeClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                Time time = this.getClauseElement();
                ((SortedClauseModel)ByTimeClause.this.clauseModel).add(time);
            } else if (string.equals("Del")) {
                Time time = this.getClauseElement();
                ((SortedClauseModel)ByTimeClause.this.clauseModel).remove(time);
            } else if (string.equals("Clear")) {
                ((SortedClauseModel)ByTimeClause.this.clauseModel).clear();
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYTIME: {
                        Time[] timeArray;
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        Object object2 = repeatIntervalModelEvent.getOldValue();
                        if (object2 != null && !object2.getClass().isArray()) {
                            timeArray = (Time[])repeatIntervalModelEvent.getOldValue();
                            NoHourPanel.this.changeSelection((Time)timeArray, false);
                        }
                        if (object == null) break;
                        if (object.getClass().isArray()) {
                            timeArray = (Time[])object;
                            NoHourPanel.this.resetSelections(timeArray);
                            break;
                        }
                        timeArray = (Time)object;
                        NoHourPanel.this.changeSelection((Time)timeArray, true);
                    }
                }
            }
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    if ((string2 = string2.trim()) == null || string2.length() != 4 && string2.length() != 6) continue;
                    Integer n = null;
                    Integer n2 = 0;
                    Integer n3 = 0;
                    try {
                        int n4 = -2;
                        int n5 = 0;
                        if (string2.length() == 6) {
                            n = Integer.parseInt(string2.substring(n4 += 2, n5 += 2));
                        }
                        n2 = Integer.parseInt(string2.substring(n4 += 2, n5 += 2));
                        n3 = Integer.parseInt(string2.substring(n4 += 2, n5 += 2));
                        ((SortedClauseModel)ByTimeClause.this.clauseModel).add(new Time(n3, n2, n));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

