/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.JPanel;
import oracle.dbtools.raptor.datatypes.ui.control.FlatButton;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ByClauseButtonPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;

public class ByMonthDayClause
extends AbstractRepeatIntervalClause<Integer, SortedClauseModel<Integer>> {
    public ByMonthDayClause(RepeatIntervalModel repeatIntervalModel) {
        this(Integer.class, repeatIntervalModel);
    }

    protected ByMonthDayClause(SortedClauseModel<Integer> sortedClauseModel) {
        super(sortedClauseModel);
    }

    protected ByMonthDayClause(Class<Integer> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<Integer>(clazz, ClauseType.BYMONTHDAY, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class Panel
    extends ByClauseButtonPanel {
        public Panel(Properties properties) {
            super(1, 31, 7, "BYMONTHDAY", SchedulerArb.getString("REPEAT_INTERVAL_CLAUSE_BYMONTHDAY_PANEL_CHECKBOX"), ByClauseButtonPanel.NO_INITVAL);
            ((SortedClauseModel)ByMonthDayClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals(this.clause)) {
                FlatButton flatButton = (FlatButton)actionEvent.getSource();
                Object object = this.getClauseElement(flatButton);
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    Boolean bl = this.isButtonSelected(flatButton);
                    if (bl != null) {
                        if (!bl.booleanValue()) {
                            ((SortedClauseModel)ByMonthDayClause.this.clauseModel).remove(n);
                        } else {
                            ((SortedClauseModel)ByMonthDayClause.this.clauseModel).add(n);
                        }
                    }
                }
            } else if (string.equals("Clear")) {
                ((SortedClauseModel)ByMonthDayClause.this.clauseModel).clear();
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYMONTHDAY: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        Object object2 = repeatIntervalModelEvent.getOldValue();
                        if (object2 != null && !object2.getClass().isArray()) {
                            Panel.this.changeButtonSelection(object2, false);
                        }
                        if (object == null) break;
                        if (object.getClass().isArray()) {
                            Panel.this.resetButtonSelections((Object[])object);
                            break;
                        }
                        Panel.this.changeButtonSelection(object, true);
                    }
                }
            }
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    string2 = string2.trim();
                    try {
                        ((SortedClauseModel)ByMonthDayClause.this.clauseModel).add(Integer.valueOf(string2));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

