/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.ButtonActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.ListActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;

public class NewJobCreateActionDialogTab_Notification
extends ActionDialogTab {
    private NewJobModel model;
    private ActionControl recipientsCtl = null;
    private ActionControl senderCtl = null;
    private ActionControl subjectCtl = null;
    private ActionControl bodyCtl = null;
    private ActionControl selectEventCtl = null;
    private ActionControl filterConditionCtl = null;
    private ActionControl resetToDefaultsCtl = null;
    private OptionalActionControl optionalFilterConditionCtl = null;
    private OptionalActionControl optionalSenderCtl = null;
    private boolean delayLoading = true;
    private String recipientValue = "";
    private String senderValue = "";
    private String subjectValue = NewJobModel.notificationDefaultSubject;
    private String bodyValue = NewJobModel.notificationDefaultBody;
    private String[] selectedEventValue = NewJobModel.notificationDefaultEvents;
    private String filterConditionValue = null;

    public NewJobCreateActionDialogTab_Notification(String string, String string2, NewJobModel newJobModel) {
        super(string, string2);
        this.model = newJobModel;
        if (this.model != null && newJobModel.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            this.recipientValue = newJobModel.getJobNotificationData("oldJobNotificationRecipient");
            this.senderValue = newJobModel.getJobNotificationData("oldJobNotificationSender");
            this.subjectValue = newJobModel.getJobNotificationData("oldJobNotificationSubject");
            this.bodyValue = newJobModel.getJobNotificationData("oldJobNotificationBody");
            this.filterConditionValue = newJobModel.getJobNotificationData("oldJobNotificationFilterCondition");
            String string3 = newJobModel.getJobNotificationData("oldJobNotificationSelectedEvents");
            if (string3 != null) {
                this.selectedEventValue = string3.split(",");
                for (int i = 0; i < this.selectedEventValue.length; ++i) {
                    this.selectedEventValue[i] = this.selectedEventValue[i].trim();
                }
            }
            this.delayLoading = newJobModel.getDelayLoadingChoice();
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        this.recipientsCtl = new TextBoxActionControl("NOTIFICATION_RECIPIENTS", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_RECIPIENTS_LABEL"), this.recipientValue);
        if (this.senderValue == null) {
            this.senderCtl = new TextBoxActionControl("NOTIFICATION_SENDER", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_SENDER_LABEL"), "");
            this.optionalSenderCtl = new OptionalActionControl(true, this.senderCtl);
        } else {
            this.senderCtl = new TextBoxActionControl("NOTIFICATION_SENDER", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_SENDER_LABEL"), this.senderValue);
            this.optionalSenderCtl = new OptionalActionControl(true, this.senderCtl);
        }
        this.subjectCtl = new TextBoxActionControl("NOTIFICATION_SUBJECT", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_SUBJECT_LABEL"), this.subjectValue);
        this.bodyCtl = new EditorActionControl("NOTIFICATION_BODY", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_BODY_LABEL"), this.bodyValue, null);
        this.selectEventCtl = new ListActionControl("NOTIFICATION_SELECT_EVENTS", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_SELECT_EVENTS_LABEL"), NewJobModel.JOBEVENT_LIST, this.selectedEventValue);
        if (this.filterConditionValue == null) {
            this.filterConditionCtl = new TextBoxActionControl("NOTIFICATION_FILTER_CONDITION", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_FILTER_CONDITION_LABEL"), "");
            this.optionalFilterConditionCtl = new OptionalActionControl(false, this.filterConditionCtl);
        } else {
            this.filterConditionCtl = new TextBoxActionControl("NOTIFICATION_FILTER_CONDITION", SchedulerArb.getString("JOB_CREATE_NOTIFICATION_FILTER_CONDITION_LABEL"), this.filterConditionValue);
            this.optionalFilterConditionCtl = new OptionalActionControl(true, this.filterConditionCtl);
        }
        this.resetToDefaultsCtl = new ButtonActionControl("RESET_TO_DEFAULTS", null, SchedulerArb.getString("JOB_CREATE_PROPERTIES_RESET_TO_DEFAULTS_LABEL"));
        ((JButton)this.resetToDefaultsCtl.getUI()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobCreateActionDialogTab_Notification.this.resetToDefaults();
            }
        });
        SideBySideActionControl sideBySideActionControl = new SideBySideActionControl(null, null, this.resetToDefaultsCtl, null, 2);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add(this.recipientsCtl);
        arrayList.add((ActionControl)this.optionalSenderCtl);
        arrayList.add(this.subjectCtl);
        arrayList.add(this.bodyCtl);
        arrayList.add(this.selectEventCtl);
        arrayList.add((ActionControl)this.optionalFilterConditionCtl);
        arrayList.add((ActionControl)sideBySideActionControl);
        return arrayList;
    }

    private void resetToDefaults() {
        ((ListActionControl)this.selectEventCtl).reset(NewJobModel.notificationDefaultEvents);
        ((EditorActionControl)this.bodyCtl).set(NewJobModel.notificationDefaultBody);
        ((TextBoxActionControl)this.subjectCtl).set(NewJobModel.notificationDefaultSubject);
        this.optionalSenderCtl.set(NewJobModel.notificationDefaultSender);
        this.optionalFilterConditionCtl.set(NewJobModel.notificationDefaultFilterCondition);
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }
}

