/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.wizards.rdfmodel;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.dbtools.rdfgraph.wizards.AbstractWizardAction;
import oracle.dbtools.rdfgraph.wizards.TaskResult;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelBulkLoadWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelDataSourceWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelPrepareLoadWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelSummaryWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelWizardModel;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.Step;

public class RDFModelWizardAction
extends AbstractWizardAction<RDFModelWizardModel> {
    private Dimension _bigSize = new Dimension(900, 600);

    @Override
    public boolean useBigSize() {
        return true;
    }

    @Override
    protected Dimension getBigSize() {
        return this._bigSize;
    }

    @Override
    protected boolean runDialog(JDialog jDialog) {
        ((RDFModelWizardModel)this.getModel()).setDialog(jDialog);
        return super.runDialog(jDialog);
    }

    @Override
    public String getTitle() {
        return RdfgraphArb.getString("RDFModelWizardAction.CREATE_RDFMODEL");
    }

    @Override
    protected FSMBuilder createFSMBuilder() {
        int n;
        FSMBuilder fSMBuilder = new FSMBuilder();
        ArrayList<Step> arrayList = new ArrayList<Step>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("SOURCE_FILE");
        arrayList.add(new Step(RdfgraphArb.getString("RDFModelWizardAction.SOURCE"), RDFModelDataSourceWizardPanel.class, "f1_job_details_html"));
        arrayList2.add("PREPARE_LOAD");
        arrayList.add(new Step(RdfgraphArb.getString("RDFModelWizardAction.PREPARE_LOAD"), RDFModelPrepareLoadWizardPanel.class, "f1_job_properties_html"));
        arrayList2.add("LOAD_INTO_MODEL");
        arrayList.add(new Step(RdfgraphArb.getString("RDFModelWizardAction.LOAD_RDF_MODEL"), RDFModelBulkLoadWizardPanel.class, "f1_job_properties_html"));
        arrayList2.add("SUMMARY");
        arrayList.add(new Step(RdfgraphArb.getString("RDFModelSummaryWizardPanel.SUMMARY"), RDFModelSummaryWizardPanel.class, "f1_job_summary_html"));
        fSMBuilder.newStartState((Step)arrayList.get(n), arrayList2.get(n + 1));
        for (n = 0; n < arrayList.size() - 1; ++n) {
            fSMBuilder.newState(arrayList2.get(n), (Step)arrayList.get(n), arrayList2.get(n + 1));
        }
        fSMBuilder.newFinalState(arrayList2.get(n), (Step)arrayList.get(n));
        return fSMBuilder;
    }

    @Override
    protected RDFModelWizardModel createModel() {
        RDFModelWizardModel rDFModelWizardModel = new RDFModelWizardModel();
        rDFModelWizardModel.setConnection(this.getConnection());
        HashMap<String, String> hashMap = RDFStringUtils.extracNetworkInfoFromNodeURL(this.getDBObject().getURL().toString());
        if (hashMap != null) {
            rDFModelWizardModel.setNetworkOwner(hashMap.get("NETWORK_OWNER"));
            rDFModelWizardModel.setNetworkName(hashMap.get("NETWORK_NAME"));
        }
        return rDFModelWizardModel;
    }

    @Override
    protected void queueActionTask() throws TraversalException {
        RaptorTask<TaskResult> raptorTask = new RaptorTask<TaskResult>(RdfgraphArb.getString("RDFModelWizardAction.BULK_LOADING_INTO_MODEL"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected TaskResult doWork() throws TaskException {
                this.setMessage(RdfgraphArb.getString("RDFModelWizardAction.BULK_LOADING_FROM_STAGING_TABLE___"));
                TaskResult taskResult = new TaskResult();
                RDFModelWizardAction.this.commitActionTask((RDFModelWizardModel)RDFModelWizardAction.this.getModel(), taskResult);
                this.setMessage(taskResult.getMessage());
                if (!taskResult.getStatus()) {
                    throw new TaskException((Throwable)taskResult.getException());
                }
                return taskResult;
            }
        };
        raptorTask.setCancellable(this.isActionTaskCancellable());
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        RDFModelWizardAction.this.cancelActionTask((RDFModelWizardModel)RDFModelWizardAction.this.getModel());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        RDFModelWizardAction.this.onActionTaskFailed(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        RDFModelWizardAction.this.onActionTaskCompleted(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    protected void commitActionTask(RDFModelWizardModel rDFModelWizardModel, TaskResult taskResult) {
        rDFModelWizardModel.processScript(this.getTitle(), taskResult);
    }

    @Override
    protected void cancelActionTask(RDFModelWizardModel rDFModelWizardModel) {
        rDFModelWizardModel.cancelProcessScript();
    }

    @Override
    protected boolean isActionTaskBackgroundable() {
        return true;
    }

    @Override
    protected boolean isActionTaskCancellable() {
        return true;
    }

    @Override
    protected String getObjectType() {
        return "RDFMODEL";
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    public class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return RDFModelWizardAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            return "";
        }

        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            vector.add("NAME");
            return vector;
        }
    }
}

