/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.wizards.rdfmodel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.wizards.AbstractWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelWizardModel;

public class RDFModelPrepareLoadWizardPanel
extends AbstractWizardPanel<RDFModelWizardModel>
implements ActionListener,
LayoutControl {
    private JLabel sourceLbl;
    private JTextField sourceTxt;
    private JLabel stagingTblLbl;
    private JTextField stagingTbl;
    private JCheckBox newStagingChk;
    private JButton loadDataBtn;
    JPanel logPanel;
    JTextArea txtLogArea;

    @Override
    protected void initializeUI(RDFModelWizardModel rDFModelWizardModel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.sourceLbl = new JLabel(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.SOURCE_FILE_"));
        this.add(this.sourceLbl, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.sourceTxt = new JTextField(rDFModelWizardModel.getSourceFile().toString());
        this.sourceTxt.setEditable(false);
        this.add(this.sourceTxt, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.newStagingChk = new JCheckBox(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.CREATE_STAGING_TABLE"));
        this.newStagingChk.setSelected(true);
        this.add(this.newStagingChk, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.stagingTblLbl = new JLabel(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.STAGING_TABLE_NAME_"));
        this.add(this.stagingTblLbl, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.stagingTbl = new JTextField(rDFModelWizardModel.stripExtension(rDFModelWizardModel.getSourceFile()) + "_stab");
        this.add(this.stagingTbl, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.loadDataBtn = new JButton(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.LOAD_DATA_INTO_STAGING_TABLE"));
        this.loadDataBtn.addActionListener(this);
        this.add(this.loadDataBtn, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.txtLogArea = new JTextArea();
        this.logPanel = LayoutControl.GBC.createTitledSubPanel((String)RdfgraphArb.getString("LOG"), (Component)this.txtLogArea);
        this.add(this.logPanel, LayoutControl.GBC.gbc((int)0, (int)4, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.enableButtons(true, ((RDFModelWizardModel)this.getModel()).getInsertedTriples() > 0.0, false);
    }

    @Override
    protected void onEntry(RDFModelWizardModel rDFModelWizardModel) {
        this.enableButtons(true, ((RDFModelWizardModel)this.getModel()).getInsertedTriples() > 0.0, false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.loadDataBtn) {
            String string = this.stagingTbl.getText();
            if (this.newStagingChk.isSelected() && !((RDFModelWizardModel)this.getModel()).createStagingTable(string)) {
                ((RDFModelWizardModel)this.getModel()).setCreateStagingTbl(true);
                return;
            }
            InsertTriplesIntoStagingTask insertTriplesIntoStagingTask = new InsertTriplesIntoStagingTask(string);
            this.txtLogArea.append(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.ADDING_TASK_TO_THE_QUEUE"));
            RaptorTaskManager.getInstance().addTask((RaptorTask)insertTriplesIntoStagingTask);
            insertTriplesIntoStagingTask.setMessage(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.INSERTING_RAW_TRIPLES_INTO_STAGING_TABLE"));
        }
    }

    public class InsertTriplesIntoStagingTask
    extends RaptorTask<String> {
        private String stagingTblName;

        public InsertTriplesIntoStagingTask(String string) {
            super("ListTask", true, IRaptorTaskRunMode.IDE_STATUSBAR);
            this.stagingTblName = string;
        }

        protected String doWork() {
            Object object = "";
            try {
                if (((RDFModelWizardModel)RDFModelPrepareLoadWizardPanel.this.getModel()).loadFileIntoStaging(this.stagingTblName)) {
                    ((RDFModelWizardModel)RDFModelPrepareLoadWizardPanel.this.getModel()).setStagingTblName(this.stagingTblName);
                }
            }
            catch (SQLException sQLException) {
                object = (String)object + RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.ERROR_") + sQLException.getMessage();
            }
            long l = this.getDescriptor().getElapsedTime();
            object = (String)object + RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.GETTING_TASK_RESULT");
            String string = NumberFormat.getInstance().format(((RDFModelWizardModel)RDFModelPrepareLoadWizardPanel.this.getModel()).getInsertedTriples());
            object = (String)object + RdfgraphArb.format("RDFModelPrepareLoadWizardPanel.INSERTED_TRIPLES_INTO", string, ((RDFModelWizardModel)RDFModelPrepareLoadWizardPanel.this.getModel()).getStagingTblName());
            String string2 = String.format(RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel._D_MIN__D_SEC"), TimeUnit.MILLISECONDS.toMinutes(l), TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(l)));
            Object object2 = object = (String)object + RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.TOTAL_TIME_") + string2;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ String val$logTxt;
                {
                    this.val$logTxt = string;
                }

                @Override
                public void run() {
                    RDFModelPrepareLoadWizardPanel.this.txtLogArea.append(this.val$logTxt);
                    RDFModelPrepareLoadWizardPanel.this.enableButtons(true, true, true);
                }
            });
            return null;
        }
    }
}

