/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.EventQueue;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.rdfgraph.ui.RDFSourceTable;
import oracle.dbtools.rdfgraph.ui.SourceRow;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchProgress;

public class TableSearchRunnable
implements Runnable {
    private final SearchProgress _progress;
    private final SearchCategory _category;
    private final String _text;
    private String[] columnNames;
    private String querySource;
    private String searchCol;
    private final int BATCH_COUNT = 10;
    private TableActionControl resultTablecontrol;
    private Connection connection;

    public void setSearchCol(String string) {
        this.searchCol = string;
    }

    public String getSearchCol() {
        return this.searchCol;
    }

    public void setQuerySource(String string) {
        this.querySource = string;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public TableSearchRunnable(SearchProgress searchProgress, SearchCategory searchCategory, String string) {
        this._progress = searchProgress;
        this._category = searchCategory;
        this._text = string.toUpperCase();
    }

    public void setResultTablecontrol(TableActionControl tableActionControl) {
        this.resultTablecontrol = tableActionControl;
    }

    public TableActionControl getResultTablecontrol() {
        return this.resultTablecontrol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<SourceRow> arrayList = new ArrayList<SourceRow>(10);
        try {
            this._progress.setDeterminate(this.getNumberOfThingsToSearch());
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
            String string = this.getQuerySource();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(this.getSearchCol(), this._text);
            List list = dBUtil.executeReturnList(string, hashMap);
            int n = 0;
            for (Map map : list) {
                Object[] objectArray = new Object[this.getColumnNames().length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = map.get(this.getColumnNames()[i].toUpperCase());
                }
                arrayList.add(new SourceRow(objectArray));
                if (++n >= 50) continue;
                this._progress.setProgress(n);
            }
        }
        finally {
            this.addToModel(arrayList);
            this._progress.finish();
        }
    }

    private int getNumberOfThingsToSearch() {
        return 50;
    }

    private boolean isMatch(RDFSourceTable rDFSourceTable, SearchCategory searchCategory, String string) {
        return false;
    }

    private void addToModel(final List<SourceRow> list) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableSearchRunnable.this.getResultTablecontrol().setRows(list);
            }
        });
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }
}

