/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.RDFSourceTableSearchRunnable;
import oracle.dbtools.rdfgraph.ui.SourceRow;
import oracle.dbtools.rdfgraph.ui.TableSearchRunnable;
import oracle.dbtools.util.Logger;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class TableSearchAndSelectActionControl
extends ActionControl
implements SearchListener,
LayoutControl {
    JPanel mPanel = LayoutControl.GBC.createPanel();
    SearchField txtSearch;
    TableActionControl resultTable;
    JTable jResultTable;
    Connection connection;
    TableSearchRunnable searchRunnable;
    String[] columnNames;
    String searchCol;
    private List<ActionControl> childControls;
    private List<SourceRow> selectedRows;
    String querySource;

    public void setSearchCol(String string) {
        this.searchCol = string;
    }

    public String getSearchCol() {
        return this.searchCol;
    }

    public SourceRow getSelectedRow() {
        int n = this.jResultTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        Object[] objectArray = new Object[this.getColumnNames().length];
        for (int i = 0; i < this.getColumnNames().length; ++i) {
            objectArray[i] = (String)this.jResultTable.getModel().getValueAt(n, i);
        }
        return new SourceRow(objectArray);
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setQuerySource(String string) {
        this.querySource = string;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setSearchRunnable(TableSearchRunnable tableSearchRunnable) {
        this.searchRunnable = tableSearchRunnable;
    }

    public TableSearchRunnable getSearchRunnable() {
        return this.searchRunnable;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public TableSearchAndSelectActionControl(String string, Connection connection) {
        super(string, string);
        String string2 = "SELECT owner, object_name, object_type from all_objects WHERE object_name like '%' || :table_name || '%' AND object_type IN ('TABLE', 'VIEW')";
        String[] stringArray = new String[]{"OWNER", "OBJECT_NAME"};
        this.setConnection(connection);
        this.setQuerySource(string2);
        this.setColumnNames(stringArray);
        this.init();
    }

    private void init() {
        Object object;
        this.selectedRows = new ArrayList<SourceRow>();
        this.childControls = new ArrayList<ActionControl>();
        JLabel jLabel = new JLabel(RdfgraphArb.getString("TableSearchAndSelectActionControl.SEARCH_"));
        this.txtSearch = new SearchField();
        jLabel.setLabelFor((Component)this.txtSearch);
        this.txtSearch.getTextField().setColumns(15);
        this.txtSearch.setStyle(SearchField.Style.SEARCH);
        this.txtSearch.addSearchListener((SearchListener)this);
        try {
            object = this.connection.getMetaData();
            this.txtSearch.setText(object.getUserName().toUpperCase() + ".%");
        }
        catch (SQLException sQLException) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
        }
        object = new ArrayList<String>(Arrays.asList(this.getColumnNames()));
        this.resultTable = new TableActionControl("available_sources", (List)object, new ArrayList(), 10);
        this.jResultTable = ((TableActionControlPanel)this.resultTable.getUI()).getTable();
        this.jResultTable.setCellSelectionEnabled(false);
        this.jResultTable.setRowSelectionAllowed(true);
        this.jResultTable.setSelectionMode(0);
        this.mPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP));
        this.mPanel.add((Component)this.txtSearch, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
        this.mPanel.add((Component)new JScrollPane(this.resultTable.getUI()), LayoutControl.GBC.gbc((int)0, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
    }

    public void searchPerformed(SearchEvent searchEvent) {
        RDFSourceTableSearchRunnable rDFSourceTableSearchRunnable = new RDFSourceTableSearchRunnable(searchEvent.getSearchProgress(), searchEvent.getSearchCategory(), searchEvent.getSearchText());
        rDFSourceTableSearchRunnable.setResultTablecontrol(this.resultTable);
        rDFSourceTableSearchRunnable.setConnection(this.connection);
        Thread thread = new Thread((Runnable)rDFSourceTableSearchRunnable, RdfgraphArb.getString("SEARCHING"));
        thread.start();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    public ActionControl.Value getValue() {
        return new ActionControl.Value();
    }

    public Component getUI() {
        return this.mPanel;
    }

    public void setEditable(boolean bl) {
    }

    public List<ActionControl> getChildControls() {
        return this.childControls;
    }
}

