/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;

public class ProgressDialog
extends JDialog {
    private boolean isCancelled = false;
    private boolean isCustomCancel = false;
    private boolean isClosedAction = false;
    private JButton cancelButton = new JButton();
    private JProgressBar progressBar = new JProgressBar();
    private JLabel taskMessage = new JLabel();

    public ProgressDialog(Window window) {
        super(window, "", Dialog.ModalityType.APPLICATION_MODAL);
        try {
            this.jbInit();
            if (window != null) {
                Dimension dimension = window.getSize();
                Point point = window.getLocation();
                this.setLocation(point.x + dimension.width / 4, point.y + dimension.height / 4);
            } else {
                this.setLocationRelativeTo(null);
            }
            this.progressBar.setIndeterminate(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(350, 140));
        this.setResizable(false);
        this.setTitle(SPARQLArb.getString("ProgressDialog.TITLE"));
        this.setModal(true);
        this.cancelButton.setText(SPARQLArb.getString("ProgressDialog.CANCEL"));
        this.cancelButton.setBounds(new Rectangle(135, 85, 105, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.progressBar.setBounds(new Rectangle(60, 45, 265, 25));
        this.progressBar.setForeground(new Color(52, 113, 211));
        this.taskMessage.setText("");
        this.taskMessage.setBounds(new Rectangle(60, 20, 265, 20));
        this.getContentPane().add((Component)this.taskMessage, null);
        this.getContentPane().add((Component)this.progressBar, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProgressDialog.this.isClosedAction = true;
            }
        });
    }

    public void setMinMaxValues(int n, int n2) {
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.Cancel();
    }

    public void setTaskMessage(String string) {
        this.taskMessage.setText(string);
    }

    public void setProgressValue(int n) {
        this.progressBar.setValue(n);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void Cancel() {
        if (!this.isCustomCancel) {
            this.isCancelled = true;
            this.setVisible(false);
        } else {
            this.disableCancelButton();
        }
    }

    public void enableCancelButton() {
        this.cancelButton.setEnabled(true);
    }

    public void disableCancelButton() {
        this.cancelButton.setEnabled(false);
    }

    public boolean isClosedAction() {
        return this.isClosedAction;
    }

    public boolean isCustomCancel() {
        return this.isCustomCancel;
    }

    public void setCustomCancel(boolean bl) {
        this.isCustomCancel = bl;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }
}

