/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.utils.PLSQLBlockTemplate;
import oracle.dbtools.rdfgraph.utils.RDFDBUtils;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class LoadRDFStagingExternalActionDialog
extends ActionDialog {
    private String title;
    String uname = "";
    Connection conn;
    boolean isCompressionEnabled = false;
    TextBoxActionControl txtSourceTable;
    SqlComboBoxActionControl selectDefDirectory;
    SqlComboBoxActionControl selectLogDirectory;
    SqlComboBoxActionControl selectBadDirectory;
    TextBoxActionControl txtLogFile;
    TextBoxActionControl txtBadFile;
    SpinnerActionControl spinParallel;
    TextBoxActionControl txtSourceTableOwner;
    TextBoxActionControl txtFlags;
    ActionDialogTab inputFilesTab;
    LabelActionControl lblInputFiles;
    ActionDialogTab stagingTab;
    TextBoxActionControl txtStagingTable;
    BooleanCheckBoxActionControl chkCreateStagingTable;
    TextBoxActionControl txtStagingSourceTable;
    ComboBoxActionControl selectStagingInputFormat;
    SpinnerActionControl spinStagingParallel;
    TextBoxActionControl txtStagingTableOwner;
    TextBoxActionControl txtStagingSourceTableOwner;
    TextBoxActionControl txtStagingFlags;

    public LoadRDFStagingExternalActionDialog(String string) {
        this.title = string;
    }

    public LoadRDFStagingExternalActionDialog() {
        this(RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.LOAD_RDF_DATA_INTO_STAGING_TABLE_FROM_EXTERNAL_TABLE"));
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.conn = connection;
        this.txtSourceTable = new TextBoxActionControl("source_table", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.SOURCE_TABLE_"), "");
        ((JFormattedTextField)this.txtSourceTable.getUI()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LoadRDFStagingExternalActionDialog.this.txtStagingSourceTable.set(LoadRDFStagingExternalActionDialog.this.txtSourceTable.getValue().get());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LoadRDFStagingExternalActionDialog.this.txtStagingSourceTable.set(LoadRDFStagingExternalActionDialog.this.txtSourceTable.getValue().get());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LoadRDFStagingExternalActionDialog.this.txtStagingSourceTable.set(LoadRDFStagingExternalActionDialog.this.txtSourceTable.getValue().get());
            }
        });
        this.selectDefDirectory = new SqlComboBoxActionControl("def_directory", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.INPUT_DIRECTORY_"), connection, "SELECT directory_name from ALL_DIRECTORIES");
        this.selectLogDirectory = new SqlComboBoxActionControl("log_directory", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.LOG_DIRECTORY_"), connection, "SELECT directory_name from ALL_DIRECTORIES");
        this.selectBadDirectory = new SqlComboBoxActionControl("bad_directory", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.BAD_DIRECTORY_"), connection, "SELECT directory_name from ALL_DIRECTORIES");
        this.txtLogFile = new TextBoxActionControl("log_file", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.LOG_FILE_"), "");
        this.txtBadFile = new TextBoxActionControl("bad_file", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.BAD_FILE_"), "");
        this.spinParallel = new SpinnerActionControl("parallel", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.PARALLEL_"), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(512), Integer.valueOf(1));
        HashMap hashMap = new HashMap();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.uname = dBUtil.executeOracleReturnOneCol(this.getQuery(connection, "getUser"), hashMap);
        this.txtSourceTableOwner = new TextBoxActionControl("source_table_owner", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.SOURCE_TABLE_OWNER_"), this.uname);
        ((JFormattedTextField)this.txtSourceTableOwner.getUI()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LoadRDFStagingExternalActionDialog.this.txtStagingTable.set(LoadRDFStagingExternalActionDialog.this.txtSourceTableOwner.getValue().get());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LoadRDFStagingExternalActionDialog.this.txtStagingTable.set(LoadRDFStagingExternalActionDialog.this.txtSourceTableOwner.getValue().get());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LoadRDFStagingExternalActionDialog.this.txtStagingTable.set(LoadRDFStagingExternalActionDialog.this.txtSourceTableOwner.getValue().get());
            }
        });
        this.txtFlags = new TextBoxActionControl("flags", RdfgraphArb.getString("FLAGS_"), "");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(LoadRDFStagingExternalActionDialog.this.txtSourceTable);
                this.add(LoadRDFStagingExternalActionDialog.this.selectDefDirectory);
                this.add(LoadRDFStagingExternalActionDialog.this.selectLogDirectory);
                this.add(LoadRDFStagingExternalActionDialog.this.selectBadDirectory);
                this.add(LoadRDFStagingExternalActionDialog.this.txtLogFile);
                this.add(LoadRDFStagingExternalActionDialog.this.txtBadFile);
                this.add(LoadRDFStagingExternalActionDialog.this.spinParallel);
                this.add(LoadRDFStagingExternalActionDialog.this.txtSourceTableOwner);
                this.add(LoadRDFStagingExternalActionDialog.this.txtFlags);
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        this.lblInputFiles = new LabelActionControl("lbl_input_files", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.COMMA_SEPARATED_LIST_MSG"));
        final TextBoxActionControl textBoxActionControl = new TextBoxActionControl("input_files_list", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.INPUT_FILES"), "data1.nt, data2.nt");
        this.inputFilesTab = new ActionDialogTab("input_files", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.INPUT_FILES")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        this.add(LoadRDFStagingExternalActionDialog.this.lblInputFiles);
                        this.add(textBoxActionControl);
                    }
                };
                return arrayList;
            }
        };
        String[] stringArray = new String[]{"N-QUAD", "N-TRIPLE"};
        this.txtStagingTable = new TextBoxActionControl("staging_table", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.STAGING_TABLE_"), "STAGE_TABLE");
        this.chkCreateStagingTable = new BooleanCheckBoxActionControl("create_staging_table", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.CREATE_STAGING_TABLE"), true);
        this.txtStagingSourceTable = new TextBoxActionControl("source_table", RdfgraphArb.getString("SOURCE_EXTERNAL_TABLE") + ":", "");
        this.txtStagingSourceTable.enableUI(false);
        this.selectStagingInputFormat = new ComboBoxActionControl("input_format", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.INPUT_FORMAT"), stringArray);
        this.spinStagingParallel = new SpinnerActionControl("parallel", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.PARALLEL_"), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(512), Integer.valueOf(1));
        this.txtStagingTableOwner = new TextBoxActionControl("staging_table_owner", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.STAGING_TABLE_OWNER_"), this.uname);
        this.txtStagingSourceTableOwner = new TextBoxActionControl("source_table_owner", RdfgraphArb.getString("LoadRDFStagingExternalActionDialog.EXTERNAL_TABLE_OWNER"), this.uname);
        this.txtStagingSourceTableOwner.enableUI(false);
        this.txtStagingFlags = new TextBoxActionControl("flags", RdfgraphArb.getString("FLAGS_"), "");
        this.stagingTab = new ActionDialogTab("staging_tab", RdfgraphArb.get("STAGING_TABLE")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        this.add(LoadRDFStagingExternalActionDialog.this.txtStagingTable);
                        this.add(LoadRDFStagingExternalActionDialog.this.chkCreateStagingTable);
                        this.add(LoadRDFStagingExternalActionDialog.this.txtStagingSourceTable);
                        this.add(LoadRDFStagingExternalActionDialog.this.selectStagingInputFormat);
                        this.add(LoadRDFStagingExternalActionDialog.this.spinStagingParallel);
                        this.add(LoadRDFStagingExternalActionDialog.this.txtStagingTableOwner);
                        this.add(LoadRDFStagingExternalActionDialog.this.txtStagingSourceTableOwner);
                        this.add(LoadRDFStagingExternalActionDialog.this.txtStagingFlags);
                    }
                };
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){
            {
                this.add(LoadRDFStagingExternalActionDialog.this.inputFilesTab);
                this.add(LoadRDFStagingExternalActionDialog.this.stagingTab);
            }
        };
        return arrayList;
    }

    protected String asStringParam(String string) {
        if (string.trim().isEmpty()) {
            return "null";
        }
        return "'" + string + "'";
    }

    protected String asNumParam(String string) {
        if (string.trim().isEmpty()) {
            return "null";
        }
        return string;
    }

    protected String getScript(ActionDialog.Values values) {
        this.isCompressionEnabled = RDFDBUtils.isCompressionEnabled(this.conn);
        PLSQLBlockTemplate pLSQLBlockTemplate = new PLSQLBlockTemplate(this.getQuery(this.conn, "CREATE_SOURCE_EXTERNAL_TABLE"));
        pLSQLBlockTemplate.replaceToken("#source_table#", values.get("source_table"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#def_directory#", values.get("def_directory"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#log_directory#", values.get("log_directory"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#bad_directory#", values.get("bad_directory"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#log_file#", values.get("log_file"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#bad_file#", values.get("bad_file"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#parallel#", values.get("parallel"), PLSQLBlockTemplate.ParamType.NUMERIC);
        pLSQLBlockTemplate.replaceToken("#source_table_owner#", values.get("source_table_owner"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.replaceToken("#flags#", values.get("flags"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate.setEndingSlash(true);
        PLSQLBlockTemplate pLSQLBlockTemplate2 = new PLSQLBlockTemplate(this.getQuery(this.conn, "GRANT_ALTER_SOURCE_EXTERNAL_TABLE"));
        pLSQLBlockTemplate2.replaceToken("#stage_table_source#", values.get("source_table"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate2.replaceToken("#input_files#", ((ActionDialog.Lookup)values.getTabLookup("input_files")).get("input_files_list"), PLSQLBlockTemplate.ParamType.QUOTED_STRING_LIST);
        Boolean bl = ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("create_staging_table") == "true";
        String string = this.getQuery(this.conn, "STAGING_TABLE_QUADS_SCRIPT");
        string = RDFStringUtils.updateScriptCompression(string, this.isCompressionEnabled);
        PLSQLBlockTemplate pLSQLBlockTemplate3 = new PLSQLBlockTemplate(string);
        if (bl.booleanValue()) {
            pLSQLBlockTemplate3.replaceToken("#stage_table_name#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("staging_table"), PLSQLBlockTemplate.ParamType.TABLE_NAME);
        }
        PLSQLBlockTemplate pLSQLBlockTemplate4 = new PLSQLBlockTemplate(this.getQuery(this.conn, "LOAD_INTO_STAGING_TABLE"));
        pLSQLBlockTemplate4.replaceToken("#staging_table#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("staging_table"), PLSQLBlockTemplate.ParamType.TABLE_NAME_PARAM);
        pLSQLBlockTemplate4.replaceToken("#source_table#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("source_table"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#input_format#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("input_format"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#parallel#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("parallel"), PLSQLBlockTemplate.ParamType.NUMERIC);
        pLSQLBlockTemplate4.replaceToken("#staging_table_owner#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("staging_table_owner"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#source_table_owner#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("source_table_owner"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#flags#", ((ActionDialog.Lookup)values.getTabLookup("staging_tab")).get("flags"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.setEndingSlash(true);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(pLSQLBlockTemplate.toString());
        stringBuilder.append(pLSQLBlockTemplate2.toString());
        if (bl.booleanValue()) {
            stringBuilder.append(pLSQLBlockTemplate3.toString());
        }
        stringBuilder.append(pLSQLBlockTemplate4.toString());
        stringBuilder.append("commit; \n");
        return stringBuilder.toString();
    }

    protected String getTitle() {
        return this.title;
    }

    protected String defaultEditPaneTabTitle() {
        return RdfgraphArb.get("SOURCE_EXTERNAL_TABLE");
    }
}

