/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.StringShuttleControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.AbstractRDFActionDialog;
import oracle.dbtools.rdfgraph.ui.SearchAndSelectActionControl;
import oracle.dbtools.rdfgraph.utils.ParamListGenerator;

public class CreateEntailmentActionDialog
extends AbstractRDFActionDialog {
    private TextBoxActionControl txtEnentailmentName;
    private TextBoxActionControl txtInfPasses;
    SearchAndSelectActionControl srchModels;
    SearchAndSelectActionControl srchRulebases;
    StringShuttleControl shtModels;
    StringShuttleControl shtRulebases;
    private SpinnerActionControl spinDOP;
    private BooleanCheckBoxActionControl chkSAME_AS;
    private BooleanCheckBoxActionControl chkInc;
    private BooleanCheckBoxActionControl chkRAW8;
    private BooleanCheckBoxActionControl chkENTAIL_ANYWAY;
    private BooleanCheckBoxActionControl chkUSER_RULES;
    private TextBoxActionControl txtInfComponents;
    private TextBoxActionControl txtOptions;

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        this.txtEnentailmentName = new TextBoxActionControl("index_name_in", RdfgraphArb.getString("CreateEntailmentActionDialog.ENTAILMENT_NAME"), "myrule_idx_mymodel");
        this.txtInfPasses = new TextBoxActionControl("passes", RdfgraphArb.getString("CreateEntailmentActionDialog.PASSES"), "SEM_APIS.REACH_CLOSURE");
        this.txtInfPasses.setEditable(false);
        this.spinDOP = new SpinnerActionControl("dop", "DOP", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(512), Integer.valueOf(1));
        this.chkSAME_AS = new BooleanCheckBoxActionControl("OPT_SAMEAS", "OPT_SAMEAS=T", false, false);
        this.chkInc = new BooleanCheckBoxActionControl("INC", "INC=T", false, false);
        this.chkRAW8 = new BooleanCheckBoxActionControl("RAW8", "RAW8=T", false, false);
        this.chkENTAIL_ANYWAY = new BooleanCheckBoxActionControl("ENTAIL_ANYWAY", "ENTAIL_ANYWAY=T", false, false);
        this.chkUSER_RULES = new BooleanCheckBoxActionControl("USER_RULES", "USER_RULES=T", false, false);
        this.txtInfComponents = new TextBoxActionControl("INF_COMPONENTS_IN", "INF_COMPONENTS_IN", "");
        this.txtOptions = new TextBoxActionControl("OPTIONS", "Additional options", "");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateEntailmentActionDialog.this.txtNetworkOwner);
                this.add(CreateEntailmentActionDialog.this.txtNetworkName);
                this.add(CreateEntailmentActionDialog.this.txtEnentailmentName);
                this.add(CreateEntailmentActionDialog.this.txtInfPasses);
                this.add(CreateEntailmentActionDialog.this.spinDOP);
                this.add(CreateEntailmentActionDialog.this.chkSAME_AS);
                this.add(CreateEntailmentActionDialog.this.chkInc);
                this.add(CreateEntailmentActionDialog.this.chkRAW8);
                this.add(CreateEntailmentActionDialog.this.chkENTAIL_ANYWAY);
                this.add(CreateEntailmentActionDialog.this.chkUSER_RULES);
                this.add(CreateEntailmentActionDialog.this.txtInfComponents);
                this.add(CreateEntailmentActionDialog.this.txtOptions);
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        final ActionDialogTab actionDialogTab = new ActionDialogTab("models_in", RdfgraphArb.getString("MODELS")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        Object object = "SELECT model_name from MDSYS.RDF_MODEL$";
                        if (!CreateEntailmentActionDialog.this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
                            object = "SELECT model_name from " + CreateEntailmentActionDialog.this.txtNetworkOwner.getValue().get() + "." + CreateEntailmentActionDialog.this.txtNetworkName.getValue().get() + "#RDF_MODEL$";
                        }
                        object = (String)object + " where model_type='M'";
                        List list = dBUtil.executeReturnList((String)object, Collections.emptyMap()).stream().map(map -> (String)map.get("MODEL_NAME")).collect(Collectors.toList());
                        CreateEntailmentActionDialog.this.shtModels = new StringShuttleControl("models", "", list, Collections.emptyList());
                        this.add(CreateEntailmentActionDialog.this.shtModels);
                    }
                };
                return arrayList;
            }
        };
        final ActionDialogTab actionDialogTab2 = new ActionDialogTab("rulebases_in", RdfgraphArb.getString("RULEBASES")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        Object object = "SELECT RULEBASE_NAME from MDSYS.SEM_RULEBASE_INFO where STATUS='VALID'";
                        if (!CreateEntailmentActionDialog.this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
                            object = "SELECT RULEBASE_NAME from " + CreateEntailmentActionDialog.this.txtNetworkOwner.getValue().get() + "." + CreateEntailmentActionDialog.this.txtNetworkName.getValue().get() + "#SEM_RULEBASE_INFO where STATUS='VALID'";
                        }
                        List list = dBUtil.executeReturnList((String)object, Collections.emptyMap()).stream().map(map -> (String)map.get("RULEBASE_NAME")).collect(Collectors.toList());
                        CreateEntailmentActionDialog.this.shtRulebases = new StringShuttleControl("rulebases", "", list, Collections.emptyList());
                        this.add(CreateEntailmentActionDialog.this.shtRulebases);
                    }
                };
                return arrayList;
            }
        };
        ActionDialogTab actionDialogTab3 = new ActionDialogTab("inf_components_in", RdfgraphArb.getString("CreateEntailmentActionDialog.INFERENCE_COMPONENTS")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){};
                return arrayList;
            }
        };
        ActionDialogTab actionDialogTab4 = new ActionDialogTab("delta_in", RdfgraphArb.getString("CreateEntailmentActionDialog.INCREMENTAL")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){};
                return arrayList;
            }
        };
        ActionDialogTab actionDialogTab5 = new ActionDialogTab("NGGI", "NGGI"){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){};
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){
            {
                this.add(actionDialogTab);
                this.add(actionDialogTab2);
            }
        };
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "CREATE_ENTAILMENT");
        string = this.updateScriptNetworkInfo(string, values);
        string = string.replaceAll("#index_name_in#", values.get("index_name_in"));
        List list = this.shtModels.getValue().getList("selected");
        List list2 = this.shtRulebases.getValue().getList("selected");
        string = list.size() == 0 ? string.replaceAll("#models_in#", "null") : string.replaceAll("#models_in#", ParamListGenerator.genSEM_MODELS(list));
        string = list2.size() == 0 ? string.replaceAll("#rulebases_in#", "null") : string.replaceAll("#rulebases_in#", ParamListGenerator.genSEM_RULEBASES(list2));
        string = string.replaceAll("#inf_components_in#", values.get("INF_COMPONENTS_IN"));
        string = string.replaceAll("#options#", this.getOptionsString(values));
        return string;
    }

    public String getOptionsString(ActionDialog.Values values) {
        String string;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (values.get("OPT_SAMEAS").equals("true")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("OPT_SAMEAS=T");
        }
        if (values.get("INC").equals("true")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("INC=T");
        }
        if (values.get("RAW8").equals("true")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("RAW8=T");
        }
        if (values.get("ENTAIL_ANYWAY").equals("true")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("ENTAIL_ANYWAY=T");
        }
        if (values.get("USER_RULES").equals("true")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("USER_RULES=T");
        }
        if ((n = Integer.parseInt(values.get("dop"))) > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("DOP=" + Integer.toString(n));
        }
        if ((string = values.get("OPTIONS")) != null && string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0) {
            return "null";
        }
        return "'" + stringBuilder.toString() + "'";
    }

    protected String getTitle() {
        return RdfgraphArb.getString("CreateEntailmentActionDialog.CREATE_ENTAILMENT__RULES_INDEX_");
    }
}

