/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui.ComboMenu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import oracle.dbtools.rdfgraph.ui.ComboMenu.ArrowIcon;
import oracle.dbtools.rdfgraph.ui.ComboMenu.BlankIcon;

public class ComboMenuBar
extends JMenuBar {
    JMenu menu;
    Dimension preferredSize;

    public ComboMenuBar(JMenu jMenu) {
        this.menu = jMenu;
        Color color = UIManager.getColor("Menu.selectionBackground");
        UIManager.put("Menu.selectionBackground", UIManager.getColor("Menu.background"));
        jMenu.updateUI();
        UIManager.put("Menu.selectionBackground", color);
        jMenu.setMinimumSize(new Dimension(40, 20));
        jMenu.setMaximumSize(new Dimension(40, 20));
        MenuItemListener menuItemListener = new MenuItemListener();
        this.setListener(jMenu, menuItemListener);
        this.add(jMenu);
    }

    public void setListener(JMenuItem jMenuItem, ActionListener actionListener) {
        if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.setListener(jMenu.getItem(i), actionListener);
            }
        } else if (jMenuItem != null) {
            jMenuItem.addActionListener(actionListener);
        }
    }

    public String getSelectedItem() {
        return this.menu.getText();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = this.getItemSize(this.menu);
            Insets insets = this.menu.getMargin();
            Dimension dimension3 = new Dimension(dimension2.width, insets.top + insets.bottom + dimension2.height);
            this.setPreferredSize(dimension3);
            this.menu.setPreferredSize(dimension3);
            this.preferredSize = dimension3;
        }
        return this.preferredSize;
    }

    private Dimension getItemSize(JMenu jMenu) {
        Dimension dimension = new Dimension(0, 0);
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            Dimension dimension2 = jMenuItem instanceof JMenu ? this.getItemSize((JMenu)jMenuItem) : (jMenuItem != null ? jMenuItem.getPreferredSize() : new Dimension(0, 0));
            dimension.width = 100;
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        return dimension;
    }

    public static JMenu createMenu(String string) {
        return new ComboMenu(string);
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            ComboMenuBar.this.menu.setText(jMenuItem.getText());
            ComboMenuBar.this.menu.requestFocus();
        }
    }

    public static class ComboMenu
    extends JMenu {
        ArrowIcon iconRenderer = new ArrowIcon(5, true);

        public ComboMenu(String string) {
            super(string);
            this.setBorder(new EtchedBorder());
            this.setIcon(new BlankIcon(null, 11));
            this.setHorizontalTextPosition(2);
            this.setFocusPainted(true);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getPreferredSize();
            int n = Math.max(0, dimension.width - this.iconRenderer.getIconWidth() - 3);
            int n2 = Math.max(0, (dimension.height - this.iconRenderer.getIconHeight()) / 2 - 2);
            this.iconRenderer.paintIcon(this, graphics, n, n2);
        }
    }
}

