/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;

public class StatementHelp {
    private static Map<String, String> sparqlStatements = new LinkedHashMap<String, String>(){
        {
            this.put("PREFIX", "PREFIX |example|: <http://www.example.org/>");
            this.put("SELECT", "SELECT |var_list|");
            this.put("OPTIONAL", "OPTIONAL { |graph_pattern|  }");
            this.put("UNION", " { |graph_pattern1| }  UNION { graph_pattern2  } ");
            this.put("FILTER", "FILTER( |expr|)");
            this.put("FROM", "FROM |graph_iri|");
            this.put("FROM NAMED", "FROM NAMED |graph_iri|");
            this.put("Group Graph Pattern", " { |?var1| ?var2 ?var3 . } ");
            this.put("Triples Block", " |?var1| ?var2 ?var3 . ");
            this.put("GRAPH", " GRAPH ?g {\n    |graph_pattern|\n  }");
            this.put("BIND", "BIND( |expression| AS ?var ) ");
            this.put("BNODE", "BNODE( |literal|) ");
            this.put("BNODE()", "BNODE() ");
        }
    };
    private static Map<String, String> mathStatements = new LinkedHashMap<String, String>(){
        {
            this.put("ABS", "ABS(|rdf_term|)");
            this.put("CEIL", "CEIL(|rdf_term|)");
            this.put("FLOOR", "FLOOR(|rdf_term|)");
            this.put("RAND", "RAND(|rdf_term|)");
            this.put("ROUND", "ROUND(|rdf_term|)");
        }
    };
    private static Map<String, String> stringStatements = new LinkedHashMap<String, String>(){
        {
            this.put("CONCAT", "CONCAT(|term_list|)");
            this.put("CONTAINS", "CONTAINS(|literal|, match)");
            this.put("ENCODE_FOR_URI", "ENCODE_FOR_URI(|literal|)");
            this.put("LCASE", "LCASE(|literal|)");
            this.put("REGEX", "REGEX(|string|, pattern)");
            this.put("REGEX w/flags", "REGEX(|string|, pattern, flags)");
            this.put("REGEX replace", "REPLACE(|string|, pattern,replacement)");
            this.put("REPLACE", "REPLACE(|string|, pattern,replacement, flags)");
            this.put("STRAFTER", "STRAFTER(|literal|, literal)");
            this.put("STRBEFORE", "STRBEFORE(|literal|, literal)");
            this.put("STRDT", "STRDT(|string|, datatype)");
            this.put("STRENDS", "STRENDS(|literal|, match)");
            this.put("STRLANG", "STRLANG (|string|, languageTag)");
            this.put("STRLEN", "STRLEN(|literal|)");
            this.put("STRSTARTS", "STRSTARTS(|literal|, match)");
            this.put("STRUUID", "STRUUID()");
            this.put("SUBSTR", "SUBSTR(|term|, startPos)");
            this.put("UCASE", "UCASE(|literal|)");
        }
    };
    private static Map<String, String> boolStatements = new LinkedHashMap<String, String>(){
        {
            this.put("isBLANK", "isBLANK(|rdf_term|)");
            this.put("isIRI", "isIRI(|rdf_term|)");
            this.put("isLITERAL", "isLITERAL(|rdf_term|)");
            this.put("isNUMERIC", "isNUMERIC(|rdf_term|)");
            this.put("isURI", "isURI(|rdf_term|)");
            this.put("BOUND", "BOUND(|variable|)");
            this.put("IF", "IF(|condition| , expression1, expression2)");
            this.put("EXISTS", "EXISTS(|pattern|)");
            this.put("NOT_EXISTS", "NOT_EXISTS(|pattern|)");
            this.put("sameTerm", "sameTerm(|rdf_term|, |rdf_term2|)");
            this.put("term IN", " |term| IN (term_list)");
            this.put("term NOT IN", " |term| NOT IN (term_list)");
            this.put("LANGMATCHES", "LANGMATCHES(|literal|, literal)");
        }
    };
    private static Map<String, String> dateStatements = new LinkedHashMap<String, String>(){
        {
            this.put("DAY", "DAY(|argument|)");
            this.put("MONTH", "MONTH(|argument|)");
            this.put("YEAR", "YEAR(|argument|)");
            this.put("HOURS", "HOURS(|argument|)");
            this.put("MINUTES", "MINUTES(|argument|)");
            this.put("SECONDS", "SECONDS(|argument|)");
            this.put("NOW", "NOW()");
            this.put("TIMEZONE", "TIMEZONE(|argument|)");
            this.put("TZ", "TZ(|argument|)");
        }
    };
    private static Map<String, String> hashStatements = new LinkedHashMap<String, String>(){
        {
            this.put("MD5", "MD5(|literal|)");
            this.put("SHA1", "SHA1(|literal|)");
            this.put("SHA256", "SHA256(|literal|)");
            this.put("SHA384", "SHA384(|literal|)");
            this.put("SHA512", "SHA512(|literal|)");
        }
    };
    private static Map<String, String> orardfStatements = new LinkedHashMap<String, String>(){
        {
            this.put("textContains", "orardf:textContains(|variable|, pattern)");
            this.put("like", "orardf:like(|variable|,pattern)");
            this.put("textScore", "orardf:textScore(|numeric_value|)");
            this.put("sameCanonTerm", "orardf:sameCanonTerm(|rdf_term|,rdf_term)");
            this.put("hasVID", "orardf:hasVID(|rdf_term|, vid)");
        }
    };
    private static Map<String, String> allStatements = new HashMap<String, String>(){
        {
            this.putAll(sparqlStatements);
            this.putAll(mathStatements);
            this.putAll(boolStatements);
            this.putAll(stringStatements);
            this.putAll(dateStatements);
            this.putAll(hashStatements);
            this.putAll(orardfStatements);
        }
    };

    public static JMenu getStatementHelpMenu() {
        JMenu jMenu = new JMenu(SPARQLArb.getString("StatementHelp.STATEMENT_HELP"));
        JMenu jMenu2 = new JMenu("SPARQL");
        JMenu jMenu3 = new JMenu(SPARQLArb.getString("StatementHelp.MATH"));
        JMenu jMenu4 = new JMenu(SPARQLArb.getString("StatementHelp.CONDITIONS"));
        JMenu jMenu5 = new JMenu(SPARQLArb.getString("StatementHelp.STRING"));
        JMenu jMenu6 = new JMenu(SPARQLArb.getString("StatementHelp.DATE___TIME"));
        JMenu jMenu7 = new JMenu(SPARQLArb.getString("StatementHelp.HASH"));
        JMenu jMenu8 = new JMenu("orardf");
        jMenu.add(jMenu2);
        jMenu.add(jMenu3);
        jMenu.add(jMenu4);
        jMenu.add(jMenu5);
        jMenu.add(jMenu6);
        jMenu.add(jMenu7);
        jMenu.add(jMenu8);
        StatementHelp.addJMenuItemsFromMap(jMenu2, sparqlStatements);
        StatementHelp.addJMenuItemsFromMap(jMenu3, mathStatements);
        StatementHelp.addJMenuItemsFromMap(jMenu4, boolStatements);
        StatementHelp.addJMenuItemsFromMap(jMenu5, stringStatements);
        StatementHelp.addJMenuItemsFromMap(jMenu6, dateStatements);
        StatementHelp.addJMenuItemsFromMap(jMenu7, hashStatements);
        StatementHelp.addJMenuItemsFromMap(jMenu8, orardfStatements);
        return jMenu;
    }

    private static void addJMenuItemsFromMap(JMenu jMenu, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            jMenu.add(new JMenuItem(string));
        }
    }

    public static void setListener(JMenuItem jMenuItem, ActionListener actionListener) {
        if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                StatementHelp.setListener(jMenu.getItem(i), actionListener);
            }
        } else if (jMenuItem != null) {
            jMenuItem.addActionListener(actionListener);
        }
    }

    public static String getCompletion(String string) {
        if (allStatements.containsKey(string)) {
            return allStatements.get(string);
        }
        return "";
    }
}

