/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.plsql.GoToSrc;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;
import oracle.dbtools.rdfgraph.sparql.SPARQLTextNode;
import oracle.dbtools.rdfgraph.sparql.editor.ContextMenuManager;
import oracle.dbtools.rdfgraph.sparql.editor.ModelSelectionDialog;
import oracle.dbtools.rdfgraph.sparql.editor.RDFLoggerImpl;
import oracle.dbtools.rdfgraph.sparql.editor.RulebaseSelectionDialog;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLErrorInfo;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLHighlightEditorPlugin;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLInsightPlugin;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLUndoCommand;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLLanguageSupport;
import oracle.dbtools.rdfgraph.ui.ProgressDialog;
import oracle.dbtools.rdfgraph.utils.ParamListGenerator;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.dbtools.util.Logger;
import oracle.dbtools.worksheet.TextView;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.model.Node;
import oracle.ide.view.StatusProvider;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchFieldBorder;
import oracle.spatial.rdf.client.SPARQLClientUtils;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFLogger;
import oracle.spatial.rdf.server.SPARQLStatementObservable;
import oracle.spatial.rdf.server.SQLEntryPoints;
import oracle.spatial.rdf.server.parser.sparql.ASTAggregate;
import oracle.spatial.rdf.server.parser.sparql.ASTAskQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTDescribeQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTFullSparqlQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTInput;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.TokenMgrError;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;

public class SPARQLQueryEditor
extends AsynchronousViewerEditor
implements LayoutControl,
StatusProvider,
IRaptorTaskListener,
TableColumnModelListener,
BasicEditorPaneContainer,
TextView,
IDBEditor,
GoToSrc {
    private BasicEditorPane SPARQLEditorPane = null;
    private BasicEditorPane sqlEditorPane = null;
    private DBObject dbObject = null;
    private JTextField selModels;
    private Action setModelsAction;
    private JTextField selRulebases;
    private Action setRulebasesAction;
    private JTextField txtOptions;
    ResultSetTable rsTable;
    JScrollPane resultsPane;
    private SPARQLHighlightEditorPlugin errorPlugin;
    private EditorStatusBar statusBar = new EditorStatusBar();
    private SPARQLInsightPlugin insightPlugin = new SPARQLInsightPlugin();
    private BasicEditorOverview overview;
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/rdfgraph/sparql/editor/accelerators.xml")};
    JComponent mPanel;
    CustomTabbedPane tabPanel;
    private int queryDynamicSampling = 6;
    private int queryDop = 0;
    private int queryTime = 0;
    private boolean shortenURIs = true;
    private String matchModel = null;
    private String matchOptions = null;
    protected static final int RUN_SPARQL_QUERY = Ide.findOrCreateCmdID((String)"sparql.run_query");
    boolean is19cOrAfter = false;
    String networkOwner = "MDSYS";
    String networkName = null;
    boolean dbHasJVM = true;
    private String SPARQL_SELECT = "select";
    private String SPARQL_ASK = "ask";
    private String SPARQL_CONSTRUCT = "construct";
    private String SPARQL_DESCRIBE = "describe";
    private String SPARQL_INSERT = "insert";
    private String SPARQL_DELETE = "delete";
    private String SPARQL_LOAD = "load";
    private String SPARQL_CLEAR = "clear";
    private String SPARQL_CREATE = "create";
    private String SPARQL_DROP = "drop";
    private String SPARQL_COPY = "copy";
    private String SPARQL_MOVE = "move";
    private String SPARQL_ADD = "add";
    private String SPARQL_UPDATE = "update";
    private String SPARQL_UNKNOWN = "unknown";
    private final List<String> editSourceCommands = new ArrayList<String>(Arrays.asList("block-indent", "block-outdent", "completion-insight", "toggle-java-comments"));
    private final Controller editSourceController = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (context.getView() == SPARQLQueryEditor.this) {
                String string = ideAction.getCommand();
                if (SPARQLQueryEditor.this.editSourceCommands.contains(string)) {
                    SPARQLQueryEditor.this.SPARQLEditorPane.invokeAction(string);
                    return true;
                }
                if (ideAction.toString().contains("Completion Insight")) {
                    SPARQLQueryEditor.this.SPARQLEditorPane.invokeAction("completion-insight");
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            String string;
            if (context.getView() == SPARQLQueryEditor.this && SPARQLQueryEditor.this.editSourceCommands.contains(string = ideAction.getCommand())) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    };

    public void setQueryDynamicSampl(int n) {
        this.queryDynamicSampling = n;
    }

    public int getQueryDynamicSampling() {
        return this.queryDynamicSampling;
    }

    public void setQueryDop(int n) {
        this.queryDop = n;
    }

    public int getQueryDop() {
        return this.queryDop;
    }

    public void setQueryTimeout(int n) {
        this.queryTime = n;
    }

    public int getQueryTimeout() {
        return this.queryTime;
    }

    public void setShortenURIs(boolean bl) {
        this.shortenURIs = bl;
    }

    public boolean isShortenURIs() {
        return this.shortenURIs;
    }

    public void setMatchModel(String string) {
        this.matchModel = string != null && string.trim().isEmpty() ? null : string;
    }

    public String getMatchModel() {
        return this.matchModel;
    }

    public void setMatchOptions(String string) {
        this.matchOptions = string != null && string.trim().isEmpty() ? null : string;
    }

    public String getMatchOptions() {
        return this.matchOptions;
    }

    public SPARQLQueryEditor() {
        this.setEditorAttribute("scrollable", false);
    }

    protected void setCodeArea(BasicEditorPane basicEditorPane) {
        this.SPARQLEditorPane = basicEditorPane;
    }

    protected BasicEditorPane getCodeArea() {
        return this.SPARQLEditorPane;
    }

    public JComponent createViewerUI() {
        this.initSPARQLEditorPane();
        this.initSQLEditorPane();
        SwingUtilities.invokeLater(() -> this.initToolbar());
        this.initMainPanel();
        return this.mPanel;
    }

    protected void initToolbar() {
        final Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)this.getFixedTopMargin()), Toolbar.class);
        String string = "";
        if (this.getViewerNode() != null) {
            string = this.getViewerNode().getDBObject().getObjectName();
        }
        ToggleAction toggleAction = new ToggleAction(SPARQLArb.getString("RUN_QUERY"), OracleIcons.getIcon((String)"run.png")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<SPARQLErrorInfo> arrayList = new ArrayList<SPARQLErrorInfo>();
                try {
                    Object object;
                    Object object2;
                    Serializable serializable;
                    boolean bl = false;
                    String string = SPARQLQueryEditor.this.getSPARQLqueryType(SPARQLQueryEditor.this.getCodeArea().getText().trim());
                    if (string.equalsIgnoreCase(SPARQLQueryEditor.this.SPARQL_UPDATE)) {
                        bl = true;
                    }
                    OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)SPARQLQueryEditor.this.getViewerNode().getDBObject().getDatabase();
                    String string2 = oracleDatabaseImpl.getQualifiedName();
                    SPARQLQueryEditor.this.rsTable = new ResultSetTable(RdfgraphArb.getString("SPARLQueryEditor.QueryResult"));
                    if (!bl) {
                        SPARQLQueryEditor.this.rsTable.setQuery(string2, SPARQLQueryEditor.this.getSQLScript(), null, null);
                    } else {
                        serializable = new ProgressDialog((Window)Ide.getMainWindow());
                        object2 = new SparqlUpdateThread((ProgressDialog)serializable, SPARQLQueryEditor.this.getConn(), SPARQLQueryEditor.this.getCodeArea().getText().trim(), SPARQLQueryEditor.this.selModels.getText(), SPARQLQueryEditor.this.getMatchModel(), SPARQLQueryEditor.this.getMatchOptions(), SPARQLQueryEditor.this.txtOptions.getText(), SPARQLQueryEditor.this.networkOwner, SPARQLQueryEditor.this.networkName);
                        ((Thread)object2).start();
                        ((Dialog)serializable).setVisible(true);
                        boolean bl2 = ((ProgressDialog)serializable).isClosedAction();
                        ((Window)serializable).dispose();
                        object = "";
                        if (!bl2) {
                            boolean bl3 = ((SparqlUpdateThread)object2).getStatus();
                            if (bl3) {
                                object = "SUCCESS";
                            } else {
                                object = "FAILED";
                                String string3 = ((SparqlUpdateThread)object2).getException();
                                if (string3 != null) {
                                    object = (String)object + ": " + string3;
                                }
                            }
                        } else {
                            object = "BACKGROUND_CANCEL";
                        }
                        SPARQLQueryEditor.this.rsTable.setQuery(string2, "select '" + (String)object + "' UPDATE_STATUS from sys.dual", null, null);
                    }
                    serializable = new ArrayList();
                    serializable.add(SPARQLQueryEditor.this);
                    object2 = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    SPARQLQueryEditor.this.rsTable.getGridModel().open(new RaptorGridTaskWrapper(RdfgraphArb.getString("SPARLQueryEditor.QueryResult"), IRaptorTaskRunMode.MODAL, false, (List)((Object)serializable), object2, arrayList2));
                    RDFPrefixManager.reset();
                    try {
                        RDFPrefixManager.addPrefixes(SPARQLQueryEditor.this.getPrefixMapFromAST());
                    }
                    catch (Exception exception) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.toString(), (String)RdfgraphArb.getString("SPARLQueryEditor.ErrorProcPrefixes"), null);
                    }
                    SPARQLQueryEditor.this.rsTable.getColumnModel().addColumnModelListener(SPARQLQueryEditor.this);
                    object = new JViewport();
                    JTable jTable = SPARQLQueryEditor.this.rsTable.getRowHeader();
                    ((JViewport)object).setView(jTable);
                    ((JComponent)object).setPreferredSize(jTable.getMaximumSize());
                    SPARQLQueryEditor.this.resultsPane.setRowHeader((JViewport)object);
                    SPARQLQueryEditor.this.resultsPane.setViewportView((Component)SPARQLQueryEditor.this.rsTable);
                }
                catch (ParseException parseException) {
                    if (parseException.currentToken != null) {
                        arrayList.add(new SPARQLErrorInfo(parseException.currentToken.beginLine, parseException.currentToken.beginColumn, parseException.currentToken.next.absoluteBeginColumn - 1, parseException.currentToken.next.absoluteEndColumn - 1, parseException.getMessage()));
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)parseException.toString(), (String)RdfgraphArb.getString("PARSE_EXCEPTION"), null);
                }
                catch (ExecutionException executionException) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)executionException.toString(), (String)RdfgraphArb.getString("EXECUTION_EXCEPTION"), null);
                }
                catch (TokenMgrError tokenMgrError) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)tokenMgrError.toString(), (String)RdfgraphArb.getString("TOKEN_ERROR"), null);
                }
                catch (Throwable throwable) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)throwable.toString(), (String)RdfgraphArb.getString("QUERY_THROWABLE"), null);
                }
                finally {
                    SPARQLQueryEditor.this.errorPlugin.setErrors(arrayList);
                    SPARQLQueryEditor.this.errorPlugin.updateHighlight();
                }
            }
        };
        toggleAction.setName(toggleAction.getValue("Name").toString());
        toolbar.add(toggleAction);
        JButton jButton = new JButton("");
        jButton.addActionListener(actionEvent -> {
            RDFPrefixManager.reset();
            try {
                RDFPrefixManager.addPrefixes(this.getPrefixMapFromAST());
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.toString(), (String)RdfgraphArb.getString("SPARLQueryEditor.ErrorProcPrefixes"), null);
            }
            ResultSetTableModel resultSetTableModel = this.rsTable.getGridModel();
            int n = resultSetTableModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = resultSetTableModel.getColumnName(i);
                TableColumn tableColumn = this.rsTable.getColumn((Object)string);
                tableColumn.setCellRenderer(new RDFTermRenderer(this.dbHasJVM));
            }
            resultSetTableModel.fireTableDataChanged();
        });
        MenuToolButton menuToolButton = this.getTemplatesMenu();
        toolbar.addSeparator();
        toolbar.add((Component)menuToolButton);
        toolbar.addSeparator();
        JLabel jLabel = new JLabel(RdfgraphArb.getString("MODELS"));
        toolbar.add((Component)jLabel);
        toolbar.addSeparator(new Dimension(8, 0));
        this.selModels = new JTextField(string);
        this.selModels.setName("targetModels");
        this.selModels.setBorder((Border)new SearchFieldBorder());
        jLabel.setLabelFor(this.selModels);
        toolbar.add((Component)this.selModels);
        this.setModelsAction = new AbstractAction(SPARQLArb.getString("ACTION_SET_MODELS"), OracleIcons.getIcon((String)"search.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.windowForComponent((Component)toolbar);
                List<String> list = ModelSelectionDialog.showDialog(window, SPARQLQueryEditor.this.selModels, SPARQLQueryEditor.this.getModelsFromTextField(), SPARQLQueryEditor.this.getConn(), SPARQLQueryEditor.this.networkOwner, SPARQLQueryEditor.this.networkName);
                SPARQLQueryEditor.this.selModels.setText(String.join((CharSequence)",", list));
                SPARQLQueryEditor.this.updateSQLScript();
            }
        };
        toolbar.add(this.setModelsAction);
        toolbar.addSeparator(new Dimension(24, 0));
        JLabel jLabel2 = new JLabel(RdfgraphArb.getString("RULEBASES"));
        toolbar.add((Component)jLabel2);
        toolbar.addSeparator(new Dimension(8, 0));
        this.selRulebases = new JTextField("");
        this.selRulebases.setName("selectedRulebases");
        jLabel2.setLabelFor(this.selRulebases);
        this.selRulebases.setBorder((Border)new SearchFieldBorder());
        toolbar.add((Component)this.selRulebases);
        this.setRulebasesAction = new AbstractAction(SPARQLArb.getString("ACTION_SET_RULEBASES"), OracleIcons.getIcon((String)"search.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.windowForComponent((Component)toolbar);
                List<String> list = RulebaseSelectionDialog.showDialog(window, SPARQLQueryEditor.this.selRulebases, SPARQLQueryEditor.this.getRulebasesFromTextField(), SPARQLQueryEditor.this.getConn(), SPARQLQueryEditor.this.networkOwner, SPARQLQueryEditor.this.networkName);
                SPARQLQueryEditor.this.selRulebases.setText(String.join((CharSequence)",", list));
                SPARQLQueryEditor.this.updateSQLScript();
            }
        };
        toolbar.add(this.setRulebasesAction);
        toolbar.addSeparator(new Dimension(24, 0));
        JLabel jLabel3 = new JLabel(RdfgraphArb.getString("OPTIONS"));
        toolbar.add((Component)jLabel3);
        toolbar.addSeparator(new Dimension(8, 0));
        String string2 = "";
        if (this.getConn() != null) {
            string2 = Utils.getQuery(this.getClass(), (Connection)this.getConn(), (String)"SEM_MATCH_FLAGS");
        }
        this.txtOptions = new JTextField(" " + string2 + " ");
        this.txtOptions.setBorder((Border)new SearchFieldBorder());
        jLabel3.setLabelFor(this.txtOptions);
        toolbar.add((Component)this.txtOptions);
        toolbar.addSeparator(new Dimension(24, 0));
    }

    private void initSPARQLEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts);
        this.setCodeArea(basicEditorPane);
        BasicDocument basicDocument = (BasicDocument)this.getCodeArea().getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sparql"));
        basicEditorPane.putClientProperty((Object)"nb.ctrltab.popupswitcher.disable", (Object)Boolean.TRUE);
        SPARQLLanguageSupport sPARQLLanguageSupport = new SPARQLLanguageSupport();
        basicDocument.setLanguageSupport((LanguageSupport)sPARQLLanguageSupport);
        basicEditorPane.setDocument((Document)basicDocument);
        basicEditorPane.getDocument().putProperty("__EndOfLine__", "\n");
        basicEditorPane.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.overview = new BasicEditorOverview(basicEditorPane);
        this.errorPlugin = new SPARQLHighlightEditorPlugin(this.overview);
        basicEditorPane.installPlugin((EditorPlugin)this.errorPlugin);
        SwingUtilities.invokeLater(() -> basicEditorPane.installPlugin((EditorPlugin)this.statusBar));
        basicEditorPane.installPlugin((EditorPlugin)this.insightPlugin);
        basicEditorPane.setEditable(true);
        Context context = this.getContext();
        Node node = context.getNode();
        if (node instanceof SPARQLTextNode) {
            SPARQLTextNode sPARQLTextNode = (SPARQLTextNode)node;
            try {
                BufferedReader bufferedReader = new BufferedReader(sPARQLTextNode.getReader());
                String string = null;
                StringBuilder stringBuilder = new StringBuilder();
                string = bufferedReader.readLine();
                while (string != null) {
                    string = bufferedReader.readLine();
                    stringBuilder.append(string);
                    string = bufferedReader.readLine();
                }
                basicEditorPane.setText(stringBuilder.toString());
            }
            catch (IOException iOException) {
                Logger.severe(this.getClass(), (Throwable)iOException);
            }
        } else {
            basicEditorPane.setText(this.getSampleSPARQLQuery());
        }
        basicEditorPane.setCaretPosition(0);
        basicEditorPane.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                UndoableEdit undoableEdit = undoableEditEvent.getEdit();
                SPARQLUndoCommand sPARQLUndoCommand = new SPARQLUndoCommand(undoableEdit);
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                sPARQLUndoCommand.setContext(SPARQLQueryEditor.this.getContext());
                try {
                    commandProcessor.invoke((Command)sPARQLUndoCommand);
                }
                catch (Exception exception) {
                    Logger.severe(this.getClass(), (Throwable)exception);
                }
            }
        });
        basicEditorPane.addPopupManager((PopupManager)new ContextMenuManager(this.getConn(), this));
    }

    private void initSQLEditorPane() {
        SQLScriptProcessor sQLScriptProcessor = new SQLScriptProcessor();
        this.sqlEditorPane = sQLScriptProcessor.getEditorPane();
        JMenuItem jMenuItem = new JMenuItem(RdfgraphArb.getString("OPEN_QUERY_IN_SQL_WORKSHEET"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SPARQLQueryEditor.this.openSQLScriptInWorkSheet();
            }
        });
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        this.sqlEditorPane.addPopupManager(new PopupManager(){

            public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
                jPopupMenu.show((Component)basicEditorPane, mouseEvent.getX(), mouseEvent.getY());
            }

            public void hidePopup(BasicEditorPane basicEditorPane) {
            }
        });
    }

    protected void initMainPanel() {
        this.tabPanel = new CustomTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane((Component)this.getCodeArea()), "Center");
        jPanel.add((Component)this.overview.getGUI(), "East");
        this.tabPanel.addTab(null, RdfgraphArb.getString("SPARQL"), (Component)jPanel);
        this.tabPanel.addTab(null, RdfgraphArb.getString("SQL"), (Component)new JScrollPane((Component)this.sqlEditorPane));
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomTabbedPane customTabbedPane = (CustomTabbedPane)changeEvent.getSource();
                if (customTabbedPane.getSelectedIndex() == 1) {
                    SPARQLQueryEditor.this.updateSQLScript();
                }
            }
        });
        this.rsTable = new ResultSetTable(RdfgraphArb.getString("SPARLQueryEditor.QueryResult"));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent((Component)this.tabPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(0.5);
        this.resultsPane = new JScrollPane((Component)this.rsTable, 22, 30);
        this.resultsPane.putClientProperty("nb.ctrltab.popupswitcher.disable", Boolean.TRUE);
        jSplitPane.setBottomComponent(this.resultsPane);
        jSplitPane.setAutoscrolls(true);
        this.mPanel = jSplitPane;
        this.setContentModelLoaded(true);
    }

    public JComponent getMainPanel() {
        return this.mPanel;
    }

    protected void whenDbNodeChanged() {
        super.whenDbNodeChanged();
        this.selModels.setText(this.getViewerNode().getDBObject().getObjectName());
        this.selRulebases.setText("");
        this.updateSQLScript();
    }

    protected void updateSQLScript() {
        this.sqlEditorPane.setEditable(true);
        try {
            this.sqlEditorPane.setText(this.getSQLScript());
        }
        catch (ParseException parseException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)parseException.toString(), (String)RdfgraphArb.getString("EXECUTION_EXCEPTION"), null);
        }
        catch (Error error) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)error.toString(), (String)RdfgraphArb.getString("PARSE_ERROR"), null);
        }
        catch (BadLocationException badLocationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)badLocationException.toString(), (String)RdfgraphArb.getString("DOCUMENT_ERROR"), null);
        }
        this.sqlEditorPane.setEditable(false);
    }

    protected String getSQLScript() throws ParseException, BadLocationException {
        String string = "";
        String string2 = this.getSPARQLqueryType(this.getCodeArea().getText().trim());
        if (string2.equalsIgnoreCase(this.SPARQL_UNKNOWN) || string2.equalsIgnoreCase(this.SPARQL_UPDATE)) {
            return string;
        }
        if (this.dbHasJVM) {
            string = Utils.getQuery(this.getClass(), (Connection)this.getConn(), (String)"SEM_MATCH_SIMPLE");
            string = string.replace("##select_hint##", this.getSQLSelectHint());
            string = string.replace("##select_list##", this.getSQLSelectList());
            string = string.replace("##query##", this.getCodeArea().getText().trim());
            string = string.replace("##models##", ParamListGenerator.genSEM_MODELS(this.selModels.getText()));
            string = string.replace("##rulebases##", ParamListGenerator.genSEM_RULEBASES(this.selRulebases.getText()));
            string = string.replace("##options##", this.txtOptions.getText());
            if (this.is19cOrAfter) {
                if (this.networkOwner == null || this.networkOwner.trim().isEmpty() || this.networkOwner.equalsIgnoreCase("MDSYS")) {
                    string = string.replace("##network_owner##", "'MDSYS'");
                    string = string.replace("##network_name##", "null");
                } else {
                    string = string.replace("##network_owner##", "'" + this.networkOwner + "'");
                    string = string.replace("##network_name##", "'" + this.networkName + "'");
                }
            }
        } else {
            HashMap hashMap = new HashMap();
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            try {
                string = SPARQLClientUtils.sparqlToSql((Connection)this.getConn(), (String)this.getCodeArea().getText().trim(), (String)this.selModels.getText(), (String)this.txtOptions.getText(), (String[])stringArray, (String[])stringArray2, hashMap, (String)this.networkOwner, (String)this.networkName, (RDFLogger)new RDFLoggerImpl(), null);
            }
            catch (Exception exception) {
                throw new ParseException(exception.getMessage());
            }
        }
        return string;
    }

    private String getSQLSelectHint() {
        int n = this.getQueryDynamicSampling();
        int n2 = this.getQueryDop();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        if (n > 0) {
            stringBuffer.append("dynamic_sampling(" + n + ") ");
        }
        if (n2 > 0) {
            stringBuffer.append("PARALLEL(" + n2 + ") ");
        }
        return "/*+ " + stringBuffer.toString() + " */";
    }

    protected String getSQLSelectList() throws ParseException, BadLocationException {
        List<String> list = this.getVarListFromAST();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (String string2 : list) {
            stringBuffer.append(string + string2 + "$RDFTERM \"?" + string2 + "\"");
            string = ", ";
        }
        return stringBuffer.toString();
    }

    private List<String> getVarListFromAST() throws ParseException, BadLocationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<Object> stack = new Stack<Object>();
        int n = this.getCodeArea().getDocument().getLength();
        String string = this.getCodeArea().getDocument().getText(0, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        ASTInput aSTInput = null;
        sparqlParse sparqlParse2 = new sparqlParse((InputStream)byteArrayInputStream);
        sparqlParse2.reset();
        aSTInput = sparqlParse2.parse(string, "");
        SimpleNode simpleNode = (SimpleNode)aSTInput.jjtGetChild(0);
        if (!(simpleNode instanceof ASTFullSparqlQuery)) {
            throw new ParseException(RdfgraphArb.getString("SPARLQueryEditor.OnlyFullSyntaxSuported"));
        }
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode2 instanceof ASTAskQuery) {
            arrayList.add("ask");
            return arrayList;
        }
        if (simpleNode2 instanceof ASTConstructQuery) {
            arrayList.add("subj");
            arrayList.add("pred");
            arrayList.add("obj");
            return arrayList;
        }
        if (simpleNode2 instanceof ASTDescribeQuery) {
            arrayList.add("subj");
            arrayList.add("pred");
            arrayList.add("obj");
            return arrayList;
        }
        SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(0);
        if (!(simpleNode3 instanceof ASTSelectClause)) {
            return arrayList;
        }
        ASTSelectClause aSTSelectClause = (ASTSelectClause)simpleNode3;
        if (aSTSelectClause.jjtGetLastToken().image == "*") {
            return OptimizerUtils.collectVisibleVars((oracle.spatial.rdf.server.parser.sparql.Node)aSTInput.jjtGetChild(0)).stream().map(aSTTripleAtom -> aSTTripleAtom.name).collect(Collectors.toList());
        }
        stack.push(aSTSelectClause);
        while (!stack.isEmpty()) {
            SimpleNode simpleNode4 = (SimpleNode)stack.pop();
            if (simpleNode4 == null) continue;
            if (simpleNode4 instanceof ASTTripleAtom && simpleNode4.jjtGetFirstToken() != null && (simpleNode4.parent instanceof ASTSelectClause || simpleNode4.parent instanceof ASTSelectExpression) && simpleNode4.jjtGetFirstToken().image.startsWith("?")) {
                arrayList.add(((ASTTripleAtom)simpleNode4).name);
            }
            for (int i = 0; i < simpleNode4.jjtGetNumChildren(); ++i) {
                stack.push((SimpleNode)simpleNode4.jjtGetChild(i));
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private List<String> getModelsFromTextField() {
        String string = this.selModels.getText().trim();
        if (string.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(string.split("\\s*,\\s*"));
        return list;
    }

    private List<String> getRulebasesFromTextField() {
        String string = this.selRulebases.getText().trim();
        if (string.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(string.split("\\s*,\\s*"));
        return list;
    }

    private HashMap<String, String> getPrefixMapFromAST() throws ParseException, BadLocationException, SQLException, RDFException {
        int n = this.getCodeArea().getDocument().getLength();
        String string = this.getCodeArea().getDocument().getText(0, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        ASTInput aSTInput = null;
        sparqlParse sparqlParse2 = new sparqlParse((InputStream)byteArrayInputStream);
        sparqlParse2.reset();
        aSTInput = sparqlParse2.parse(string, SQLEntryPoints.setupNamespaceMap(null), "");
        SimpleNode simpleNode = (SimpleNode)aSTInput.jjtGetChild(0);
        if (!(simpleNode instanceof ASTFullSparqlQuery)) {
            throw new ParseException(RdfgraphArb.getString("SPARLQueryEditor.OnlyFullSyntaxSuported"));
        }
        return sparqlParse2.getNspMap();
    }

    protected void updateContent(boolean bl) {
        if (this.getViewerNode() == null) {
            return;
        }
        this.dbObject = this.getViewerNode().getDBObject();
        Logger.info(this.getClass(), (String)this.dbObject.toString());
        String string = this.dbObject.getDBVersion();
        this.is19cOrAfter = RDFStringUtils.isOracle19cOrAfter(string);
        this.updateNetworkInfo();
        this.updateJVMstatus();
        this.setModelsAndRulebasesEnabled(this.dbHasJVM);
        this.getCodeArea().setEditable(true);
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            protected void doCancel() {
                super.doCancel();
            }

            protected Object doWork() throws Exception {
                return RdfgraphArb.getString("SPARLQueryEditor.Done");
            }
        };
    }

    private void setModelsAndRulebasesEnabled(boolean bl) {
        if (this.selModels != null) {
            this.selModels.setEnabled(bl);
        }
        if (this.setModelsAction != null) {
            this.setModelsAction.setEnabled(bl);
        }
        if (this.selRulebases != null) {
            this.selRulebases.setEnabled(bl);
        }
        if (this.setRulebasesAction != null) {
            this.setRulebasesAction.setEnabled(bl);
        }
    }

    private void updateNetworkInfo() {
        HashMap<String, String> hashMap;
        this.networkOwner = "MDSYS";
        this.networkName = null;
        if (this.is19cOrAfter && (hashMap = RDFStringUtils.extracNetworkInfoFromNodeURL(this.dbObject.getURL().toString())) != null) {
            this.networkOwner = hashMap.get("NETWORK_OWNER");
            this.networkName = hashMap.get("NETWORK_NAME");
        }
    }

    protected void cleanUp() {
    }

    public Object getPrintable() {
        return this.mPanel;
    }

    private String getSampleSPARQLQuery() {
        String string = Utils.getQuery(this.getClass(), (Connection)this.getConn(), (String)"SELECT_SPARQL_TEMPLATE");
        return string;
    }

    private Connection getConn() {
        if (this.getViewerNode() == null) {
            return null;
        }
        if (this.getViewerNode().getDBObject() == null) {
            return null;
        }
        return this.getViewerNode().getDBObject().getConnection();
    }

    private List<String> getAllVarsFromAST(SimpleNode simpleNode) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(simpleNode);
        while (!stack.isEmpty()) {
            object = (SimpleNode)stack.pop();
            if (object == null) continue;
            if (object instanceof ASTTripleAtom && !(object.parent instanceof ASTAggregate)) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)object;
                if (aSTTripleAtom.type == 0) {
                    arrayList.add(aSTTripleAtom.name);
                }
            }
            for (int i = 0; i < object.jjtGetNumChildren(); ++i) {
                stack.push((SimpleNode)object.jjtGetChild(i));
            }
        }
        Collections.reverse(arrayList);
        object = new LinkedHashSet(arrayList);
        arrayList.clear();
        arrayList.addAll((Collection<String>)object);
        return arrayList;
    }

    private JMenuItem createTemplateItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private ToggleAction cretaTemplateItemAction(String string) {
        return new ToggleAction(string, null){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string = jMenuItem.getText();
                boolean bl = true;
                if (!bl) {
                    return;
                }
                String string2 = Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)SPARQLQueryEditor.this.getConn(), (String)(string + "_SPARQL_TEMPLATE"));
                if (string2 == null || string2.isEmpty()) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)RdfgraphArb.format("SPARLQueryEditor.TemplateIsNotAvailable", string), (String)RdfgraphArb.getString("SPARLQueryEditor.TemplateNotAvailable"), null);
                    return;
                }
                SPARQLQueryEditor.this.getCodeArea().setText(string2);
            }
        };
    }

    private MenuToolButton getTemplatesMenu() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string = jMenuItem.getText();
                boolean bl = true;
                if (!bl) {
                    return;
                }
                String string2 = Utils.getQuery(this.getClass(), (Connection)SPARQLQueryEditor.this.getConn(), (String)(string + "_SPARQL_TEMPLATE"));
                if (string2 == null || string2.isEmpty()) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)RdfgraphArb.format("SPARLQueryEditor.TemplateIsNotAvailable", string), (String)RdfgraphArb.getString("SPARLQueryEditor.TemplateNotAvailable"), null);
                    return;
                }
                SPARQLQueryEditor.this.getCodeArea().setText(string2);
            }
        };
        final JPopupMenu jPopupMenu = new JPopupMenu("Templates");
        ToggleAction toggleAction = null;
        MenuToolButton menuToolButton = new MenuToolButton(toggleAction);
        menuToolButton.add((Component)this.createTemplateItem("SELECT", actionListener));
        menuToolButton.add((Component)this.createTemplateItem("SELECT WITH GRAPH", actionListener));
        menuToolButton.add((Component)this.createTemplateItem("CONSTRUCT", actionListener));
        menuToolButton.add((Component)this.createTemplateItem("ASK", actionListener));
        menuToolButton.add((Component)this.createTemplateItem("DESCRIBE", actionListener));
        menuToolButton.add((Component)new JSeparator());
        JMenu jMenu = new JMenu(RdfgraphArb.getString("SPARLQueryEditor.Demographics"));
        menuToolButton.add((Component)jMenu);
        menuToolButton.add((Component)jMenu);
        jMenu.add(this.createTemplateItem("COUNT ALL", actionListener));
        jMenu.add(this.createTemplateItem("COUNT DISTINCT", actionListener));
        jMenu.add(this.createTemplateItem("COUNT DISTINCT CLASSES", actionListener));
        JMenu jMenu2 = new JMenu("Lists");
        menuToolButton.add((Component)jMenu2);
        jMenu2.add(this.createTemplateItem("DISTINCT Predicates", actionListener));
        jMenu2.add(this.createTemplateItem("DISTINCT Classes", actionListener));
        Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)this.getFixedTopMargin()), Toolbar.class);
        ToggleAction toggleAction2 = new ToggleAction("Templates", null){

            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show((Component)actionEvent.getSource(), 0, 0);
            }
        };
        menuToolButton.setName("Templates");
        menuToolButton.setText("Templates");
        return menuToolButton;
    }

    protected void openSQLScriptInWorkSheet() {
        ConnectionSelectorUI.SELECTOR_ACTIVE = true;
        String string = this.getViewerNode().getDBObject().getConnectionName();
        try {
            OpenWorksheetWizard.openNewTempWorksheet((String)string, (String)this.getSQLScript());
        }
        catch (ParseException parseException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)parseException.toString(), (String)RdfgraphArb.getString("PARSE_EXCEPTION"), null);
        }
        catch (BadLocationException badLocationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)badLocationException.toString(), (String)RdfgraphArb.getString("PARSE_ERROR"), null);
        }
    }

    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
        if (raptorTaskEvent.getThrowable() != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getThrowable().getMessage(), (String)RdfgraphArb.getString("EXECUTION_EXCEPTION"), null);
        }
    }

    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (!this.isShortenURIs()) {
            return;
        }
        boolean bl = false;
        Object var3_3 = null;
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)tableColumnModelEvent.getSource();
        Enumeration<TableColumn> enumeration = defaultTableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(new RDFTermRenderer(this.dbHasJVM));
            if (this.dbHasJVM) continue;
            String string = tableColumn.getHeaderValue().toString();
            if (string != null && string.indexOf("$") > -1) {
                if (string.endsWith("$RDFCLBT")) {
                    bl = true;
                }
                tableColumn.setWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setMaxWidth(0);
                continue;
            }
            if (string == null || !string.equals("GRAPH") || !bl) continue;
            tableColumn.setWidth(0);
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public JComponent[] getCustomCells() {
        if (this.statusBar != null) {
            return this.statusBar.getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent jComponent) {
        return true;
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.SPARQLEditorPane;
    }

    public void goTo(int n, int n2) {
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n3 = lineMap.getLineCount();
        if (--n < 0 || n >= n3) {
            n = n < 0 ? 0 : n3 - 1;
        }
        int n4 = lineMap.getLineStartOffset(n);
        int n5 = lineMap.getLineEndOffset(n);
        int n6 = Math.min(n5, n4 + n2);
        basicEditorPane.setCaretPositionCenter(n5);
        basicEditorPane.moveCaretPositionCenter(n4);
        basicEditorPane.getCaret().setSelectionVisible(true);
        basicEditorPane.requestFocusInWindow();
    }

    public void appendText(String string) {
        if (string == null) {
            return;
        }
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        if (basicEditorPane.isEditable()) {
            Document document = basicEditorPane.getDocument();
            try {
                document.insertString(basicEditorPane.getCaretPosition(), string, null);
                basicEditorPane.requestFocusInWindow();
            }
            catch (BadLocationException badLocationException) {
                Logger.severe(this.getClass(), (Throwable)badLocationException);
            }
        }
    }

    public void replaceText(String string) {
        if (string == null) {
            return;
        }
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        String string2 = basicEditorPane.getSelectedText();
        if (string2 != null) {
            basicEditorPane.replaceSelection(string);
        } else {
            basicEditorPane.setText(string);
        }
        basicEditorPane.requestFocusInWindow();
    }

    public Database getDatabase() {
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.severe(this.getClass(), (Throwable)dBException);
        }
        return database;
    }

    public Connection getConnection() {
        return this.getConn();
    }

    public String getConnectionName() {
        return Connections.getInstance().getConnectionName(this.getConn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJVMstatus() {
        this.dbHasJVM = true;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            String string = "select count(*) from\n(\n        select * from all_registry_banners where\n        banner like '%JServer JAVA%' or banner like '%Java Packages%'\n)";
            preparedStatement = this.getConn().prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) != 2) {
                this.dbHasJVM = false;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        return false;
    }

    public String getSPARQLqueryType(String string) {
        int n;
        if (string == null || string.trim().isEmpty()) {
            return this.SPARQL_UNKNOWN;
        }
        String string2 = this.SPARQL_UNKNOWN;
        String string3 = string.trim().toLowerCase();
        String[] stringArray = new String[]{this.SPARQL_SELECT, this.SPARQL_CONSTRUCT, this.SPARQL_DESCRIBE, this.SPARQL_ASK};
        int n2 = Integer.MAX_VALUE;
        for (n = 0; n < stringArray.length; ++n) {
            int n3 = this.getSparqlTypeIndex(string3, stringArray[n]);
            if (n3 <= -1 || n3 >= n2) continue;
            string2 = stringArray[n];
            n2 = n3;
        }
        n = this.getSparqlUpdateTypeIndex(string3);
        if (n > -1 && n < n2) {
            string2 = this.SPARQL_UPDATE;
        }
        return string2;
    }

    private int getSparqlTypeIndex(String string, String string2) {
        String string3;
        if (string == null || string2 == null) {
            return -1;
        }
        String string4 = string.toLowerCase();
        int n = string4.indexOf((string3 = string2.toLowerCase()) + " ");
        if (n == -1 && (n = string4.indexOf(string3 + "\n")) == -1) {
            n = string4.indexOf(string3 + "\t");
        }
        return n;
    }

    private int getSparqlUpdateTypeIndex(String string) {
        if (string == null || string.trim().isEmpty()) {
            return -1;
        }
        String[] stringArray = new String[]{this.SPARQL_INSERT, this.SPARQL_DELETE, this.SPARQL_LOAD, this.SPARQL_CLEAR, this.SPARQL_CREATE, this.SPARQL_DROP, this.SPARQL_COPY, this.SPARQL_MOVE, this.SPARQL_ADD};
        String string2 = string.toLowerCase();
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.getSparqlTypeIndex(string2, stringArray[i]);
            if (n2 <= -1 || n2 >= n) continue;
            n = n2;
        }
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n;
    }

    static class RDFTermRenderer
    extends DefaultTableCellRenderer {
        private boolean hasJVM = true;

        public RDFTermRenderer(boolean bl) {
            this.hasJVM = bl;
        }

        private void updateTextValue(Object object) {
            if (object == null) {
                this.setText("(null)");
                return;
            }
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                try {
                    object = clob.getSubString(1L, (int)clob.length());
                }
                catch (SQLException sQLException) {
                    Logger.severe(this.getClass(), (Throwable)sQLException);
                }
            }
            if (object.toString().startsWith("<")) {
                this.setText(RDFPrefixManager.shortenURI(object.toString()));
            } else {
                this.setText(object.toString());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            int n3;
            String string;
            TableColumn tableColumn;
            String string2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.updateTextValue(object);
            if (!this.hasJVM && object != null && (string2 = jTable.getColumnName(n2)).indexOf("$") == -1 && (tableColumn = jTable.getColumn(string = string2 + "$RDFTERM")) != null && (n3 = jTable.getColumnModel().getColumnIndex(string)) > -1 && (object2 = jTable.getModel().getValueAt(n, n3)) != null) {
                this.updateTextValue(object2.toString());
            }
            return component;
        }
    }

    private class SparqlUpdateThread
    extends Thread {
        private ProgressDialog dlg = null;
        private Connection connection = null;
        private String sparql = null;
        private String model = null;
        private String matchModel = null;
        private String matchOptions = null;
        private String options = null;
        private String networkOwner = null;
        private String networkName = null;
        private boolean status = false;
        private String exception = null;
        private SPARQLStatementObservable observable = new SPARQLStatementObservable();

        public SparqlUpdateThread(ProgressDialog progressDialog, Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.dlg = progressDialog;
            this.connection = connection;
            this.sparql = string;
            this.model = string2;
            this.matchModel = string3;
            this.matchOptions = string4;
            this.options = string5;
            this.networkOwner = string6;
            this.networkName = string7;
        }

        @Override
        public void run() {
            this.status = false;
            this.exception = null;
            if (this.dlg == null) {
                return;
            }
            this.dlg.setTitle(SPARQLArb.getString("UpdateThreadDialog.SPARQL_UPDATE"));
            this.dlg.setTaskMessage(SPARQLArb.getString("UpdateThreadDialog.TASK_MESSAGE"));
            this.dlg.setCustomCancel(true);
            this.dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SparqlUpdateThread.this.observable.cancelSparqlQuery();
                }
            });
            this.dlg.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SparqlUpdateThread.this.observable.cancelSparqlQuery();
                }
            });
            try {
                this.status = SPARQLClientUtils.executeSparqlUpdate((Connection)this.connection, (String)this.sparql, (String)this.model, (String)this.matchModel, (String)this.matchOptions, (String)this.options, (String)this.networkOwner, (String)this.networkName, (RDFLogger)new RDFLoggerImpl(), (Observable)this.observable);
            }
            catch (Exception exception) {
                this.exception = exception.getMessage();
                this.status = false;
            }
            finally {
                this.dlg.setVisible(false);
            }
        }

        public boolean getStatus() {
            return this.status;
        }

        public String getException() {
            return this.exception;
        }
    }
}

