/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.DataTypeNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLConstants;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLStringNode;
import oracle.dbtools.rdfgraph.r2rml.language.TermMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;

public class TermMapPopupDialog
extends JDialog
implements ActionListener {
    private Connection connection;
    private TriplesMapNode tmap;
    private TermMapNode node;
    private JLabel lblTermType;
    private JComboBox selTermType;
    private JLabel lblLanguageTag;
    private JTextField txtLanguageTag;
    private JLabel lblDatatype;
    private JComboBox selDataType;

    public TermMapPopupDialog(Connection connection, TriplesMapNode triplesMapNode, TermMapNode termMapNode) {
        super((Frame)null, R2RMLArb.getString("TermMapPopupDialog.TERM_MAP_PROPERTIES") + termMapNode.getValue(), true);
        this.connection = connection;
        this.tmap = triplesMapNode;
        this.node = termMapNode;
        this.initUI();
        JButton jButton = new JButton(RdfgraphArb.getString("CANCEL"));
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT"));
        jButton2.setPreferredSize(jButton.getPreferredSize());
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton2);
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT").equals(actionEvent.getActionCommand())) {
            String string;
            String string2 = (String)this.selTermType.getSelectedItem();
            if (string2.equals(RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#IRI>"))) {
                this.node.setTermType(new R2RMLNode("<http://www.w3.org/ns/r2rml#IRI>"));
            }
            if (string2.equals(RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#Literal>"))) {
                this.node.setTermType(new R2RMLNode("<http://www.w3.org/ns/r2rml#Literal>"));
            }
            if (string2.equals(RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#BlankNode>"))) {
                this.node.setTermType(new R2RMLNode("<http://www.w3.org/ns/r2rml#BlankNode>"));
            }
            if ((string = this.txtLanguageTag.getText()).trim().isEmpty()) {
                this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#language>");
            } else {
                this.node.setTermLangType(new R2RMLStringNode("\"" + string.trim() + "\""));
            }
            String string3 = this.selDataType.getSelectedItem().toString();
            if (string3.equals(R2RMLArb.getString("TermMapPopupDialog.DEFAULT"))) {
                this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#datatype>");
            } else if (string3.startsWith("xsd")) {
                this.node.setTermDatatype(new DataTypeNode(RDFPrefixManager.expandURI(string3)));
            } else {
                this.node.setTermDatatype(new DataTypeNode(string3));
            }
        }
        this.setVisible(false);
    }

    private void initUI() {
        String[] stringArray;
        JPanel jPanel = new JPanel(new GridLayout(3, 3));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.lblTermType = new JLabel(R2RMLArb.getString("TermMapPopupDialog.TERM_TYPE_"));
        String[] stringArray2 = new String[]{R2RMLArb.getString("TermMapPopupDialog.DEFAULT"), RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#IRI>"), RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#BlankNode>"), RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#Literal>")};
        this.selTermType = new JComboBox<String>(stringArray2);
        this.lblTermType.setLabelFor(this.selTermType);
        if (this.node.getTermType() != null) {
            stringArray = RDFPrefixManager.shortenURI(this.node.getTermType().getValue());
            this.selTermType.setSelectedItem(stringArray);
        }
        jPanel.add(this.lblTermType);
        jPanel.add(this.selTermType);
        this.lblLanguageTag = new JLabel(R2RMLArb.getString("TermMapPopupDialog.LANGUAGE_TAG__"));
        this.txtLanguageTag = new JTextField();
        this.lblLanguageTag.setLabelFor(this.txtLanguageTag);
        if (this.node.getTermLangTag() != null) {
            this.txtLanguageTag.setText(this.node.getTermLangTag().getValue().replace("\"", ""));
        }
        jPanel.add(this.lblLanguageTag);
        jPanel.add(this.txtLanguageTag);
        this.lblDatatype = new JLabel(R2RMLArb.getString("TermMapPopupDialog.DATATYPE_"));
        stringArray = R2RMLConstants.getshortDataypeArray();
        this.selDataType = new JComboBox<String>(stringArray);
        this.lblDatatype.setLabelFor(this.selDataType);
        this.selDataType.setEditable(true);
        if (this.node.getTermDatatype() != null) {
            this.selDataType.setSelectedItem(RDFPrefixManager.shortenURI(this.node.getTermDatatype().getValue()));
        }
        jPanel.add(this.lblDatatype);
        jPanel.add(this.selDataType);
        this.getContentPane().add((Component)jPanel, "Center");
    }
}

