/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.IntegrationPoint;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.externaltools.program.ExternalProgramType;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class ExternalToolBaseProperties
extends HashStructureAdapter {
    static final int INTEG_TOOLS_MENU_ITEM = 1;
    static final int INTEG_CODE_EDITOR_CONTEXT_MENU_ITEM = 2;
    static final int INTEG_NAVIGATOR_CONTEXT_MENU_ITEM = 4;
    static final int INTEG_MAIN_WINDOW_TOOLBAR_BUTTON = 8;
    static final int INTEG_NAVIGATOR_TOOLBAR_BUTTON = 16;
    static final int AVAIL_ALWAYS = 0;
    static final int AVAIL_SELECTION = 1;
    static final int AVAIL_REGEXP = 2;
    static final int AVAIL_TYPES = 3;
    private static final String KEY_ICON_URL = "iconURL";
    private static final String KEY_CAPTION = "caption";
    private static final String KEY_TOOLTIP = "toolTipText";
    private static final String KEY_INTEGRATIONMASK = "integrationMask";
    private static final String KEY_AVAILABILITY = "availability";
    private static final String KEY_AVAILABLE_TYPES = "availableTypes";
    private static final String KEY_RELOAD_BUFFERS = "reloadBuffers";
    private static final String KEY_SCANNER_TAG = "scannerTag";
    private static final String KEY_LOG_OUTPUT = "logOutput";
    private static final String KEY_SAVE_BEFORE_RUN = "saveBeforeRun";
    private static final String KEY_SHOW_IN_RUN_MANAGER = "showInRunManager";

    private ExternalToolBaseProperties(HashStructure hs) {
        super(hs);
    }

    public static ExternalToolBaseProperties getInstance(HashStructure hs) {
        if (hs == null) {
            throw new NullPointerException("hs is null");
        }
        return new ExternalToolBaseProperties(hs);
    }

    public static ExternalToolBaseProperties getInstance(ExternalTool tool) {
        return ExternalToolBaseProperties.getInstance(tool.getData());
    }

    public void setShowInRunManager(boolean showInRunManager) {
        this.getHashStructure().putBoolean(KEY_SHOW_IN_RUN_MANAGER, showInRunManager);
    }

    public boolean getShowInRunManager() {
        return this.getHashStructure().getBoolean(KEY_SHOW_IN_RUN_MANAGER, true);
    }

    public void setScannerTag(String tag) {
        this.getHashStructure().putString(KEY_SCANNER_TAG, tag);
    }

    public String getScannerTag() {
        return this.getHashStructure().getString(KEY_SCANNER_TAG);
    }

    public void setReloadBuffers(boolean reload) {
        this.getHashStructure().putBoolean(KEY_RELOAD_BUFFERS, reload);
    }

    public boolean getReloadBuffers() {
        return this.getHashStructure().getBoolean(KEY_RELOAD_BUFFERS, false);
    }

    public void setLogOutput(boolean logOutput) {
        this.getHashStructure().putBoolean(KEY_LOG_OUTPUT, logOutput);
    }

    public boolean getLogOutput() {
        return this.getHashStructure().getBoolean(KEY_LOG_OUTPUT, true);
    }

    public void setSaveAllBeforeRun(boolean saveAllBeforeRun) {
        this.getHashStructure().putBoolean(KEY_SAVE_BEFORE_RUN, saveAllBeforeRun);
    }

    public boolean getSaveAllBeforeRun() {
        return this.getHashStructure().getBoolean(KEY_SAVE_BEFORE_RUN, false);
    }

    public List<String> getAvailableTypes() {
        return Collections.unmodifiableList(this.getHashStructure().getOrCreateListStructure(KEY_AVAILABLE_TYPES));
    }

    public void setAvailableTypes(List<String> types) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(types);
        this.getHashStructure().putListStructure(KEY_AVAILABLE_TYPES, ls);
    }

    public URL getIconURL() {
        return this.fixDefaultProgramToolIconURL(this.fixURLForBug5442808(this.getHashStructure().getURL(KEY_ICON_URL)));
    }

    public void setIconURL(URL url) {
        this.getHashStructure().putURL(KEY_ICON_URL, this.fixDefaultProgramToolIconURL(this.fixURLForBug5442808(url)));
    }

    public String getCaption() {
        return this.getHashStructure().getString(KEY_CAPTION);
    }

    public void setCaption(String caption) {
        this.getHashStructure().putString(KEY_CAPTION, caption);
    }

    public String getToolTipText() {
        return this.getHashStructure().getString(KEY_TOOLTIP);
    }

    public void setToolTipText(String toolTipText) {
        this.getHashStructure().putString(KEY_TOOLTIP, toolTipText);
    }

    int getIntegrationMask() {
        return this.getHashStructure().getInt(KEY_INTEGRATIONMASK, 1);
    }

    void setIntegrationMask(int mask) {
        this.getHashStructure().putInt(KEY_INTEGRATIONMASK, mask);
    }

    public boolean isIntegrated(IntegrationPoint ip) {
        if (ip == null) {
            throw new NullPointerException("ip is null");
        }
        return ExternalToolBaseProperties.hasIntegration(this.getIntegrationMask(), ip.mask());
    }

    public void setIntegrated(IntegrationPoint ip, boolean integrated) {
        if (integrated != this.isIntegrated(ip)) {
            this.setIntegrationMask(this.getIntegrationMask() + (integrated ? ip.mask() : -ip.mask()));
        }
    }

    public Availability getAvailability() {
        return Availability.fromOldConstant(this.getHashStructure().getInt(KEY_AVAILABILITY, 0));
    }

    public void setAvailability(Availability availability) {
        if (availability == null) {
            availability = Availability.ALWAYS;
        }
        this.getHashStructure().putInt(KEY_AVAILABILITY, availability.oldConstant());
    }

    static boolean hasIntegration(int mask, int integrationType) {
        return (mask & integrationType) != 0;
    }

    private URL fixDefaultProgramToolIconURL(URL iconURL) {
        String path;
        if (iconURL == null) {
            return null;
        }
        if ("code-source".equals(iconURL.getProtocol()) || "jar".equals(iconURL.getProtocol())) {
            String path2 = iconURL.getPath();
            if (path2.endsWith("programtool.gif") && path2.contains("oracle.ide.externaltools")) {
                return ExternalProgramType.getBoilerplateIconURL();
            }
        } else if ("bundleresource".equals(iconURL.getProtocol()) && (path = iconURL.getPath()).endsWith("programtool.gif") && path.contains("oracle/ideimpl/externaltools")) {
            iconURL = ExternalProgramType.getBoilerplateIconURL();
        }
        return iconURL;
    }

    private URL fixURLForBug5442808(URL iconURL) {
        if (iconURL == null) {
            return null;
        }
        if (!iconURL.getProtocol().equals("ide.fileicon")) {
            return iconURL;
        }
        Object path = iconURL.getPath();
        if (((String)path).length() > 0 && ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        return URLFactory.newURL((String)"ide.fileicon.file", (String)iconURL.getUserInfo(), (String)iconURL.getHost(), (int)iconURL.getPort(), (String)path, (String)iconURL.getQuery(), (String)iconURL.getRef());
    }
}

