/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.ui;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import oracle.ide.ExtensionRegistry;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.internal.ClassLoaderProxy;
import oracle.ideimpl.IdeUIManagerImpl;
import oracle.javatools.ui.themes.Theme;
import org.osgi.framework.Bundle;

public class IdeUIManagerOSGiImpl
extends IdeUIManagerImpl {
    private static IdeUIManagerImpl INSTANCE;

    private IdeUIManagerOSGiImpl() {
    }

    public static final synchronized IdeUIManagerImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IdeUIManagerOSGiImpl();
        }
        return INSTANCE;
    }

    protected Theme getTheme(String themeName) {
        Theme theme;
        Bundle themeBundle = Platform.getBundleRegistry().findBundle(themeName);
        if (themeBundle == null) {
            return super.getTheme(themeName);
        }
        URL themeProperties = themeBundle.getEntry("META-INF/theme.properties");
        BufferedInputStream bis = new BufferedInputStream(themeProperties.openStream());
        try {
            Properties p = new Properties();
            p.load(bis);
            Theme result = new Theme(p);
            result.setClassLoader(ClassLoaderProxy.findOrCreateLoader(themeBundle.getSymbolicName()));
            result.setId(themeName);
            theme = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to load theme " + themeProperties, e);
                return null;
            }
        }
        bis.close();
        return theme;
    }
}

