/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension.search;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.extension.spi.ExtensionSource;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.BundleJARExtensionSource;
import oracle.ideimpl.extension.ExtensionSearchStrategy;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class BundleExtensionSearchStrategy
extends ExtensionSearchStrategy {
    private static Logger LOG = Logger.getLogger("oracle.ide.osgi");
    private Collection<ExtensionSource> sources;

    public Collection<ExtensionSource> findExtensionSources() {
        this.sources = new ArrayList<ExtensionSource>();
        List<Bundle> bundles = Platform.getBundleRegistry().getExtensions();
        for (Bundle b : bundles) {
            if ((b.getState() & 3) == 0) {
                this.sources.add(new BundleJARExtensionSource(b));
                continue;
            }
            URL manifestURL = null;
            try {
                URL manifestOSGiURL = b.getEntry("/META-INF/MANIFEST.MF");
                manifestURL = manifestOSGiURL != null ? FileLocator.resolve((URL)manifestOSGiURL) : null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.severe("Extension " + b.getSymbolicName() + " did not resolve properly and will not be loaded by the IDE. See its manifest file " + (String)(manifestURL != null ? manifestURL + " " : "") + " or run with the OSGi console (-console option) to troubleshoot the problem further");
        }
        return this.sources;
    }
}

