/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.extension.ExtensionDependency;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.BundleRegistry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class BundleRegistryImpl
implements BundleRegistry {
    private static Logger LOG = Logger.getLogger("oracle.ide.osgi.extension");
    private final List<Bundle> m_bundles;
    private List<Bundle> m_extensions = null;
    private Set<String> m_extensionIds = null;
    private Map<String, List<ExtensionDependency>> m_extensionId2Dependencies = new HashMap<String, List<ExtensionDependency>>();

    public BundleRegistryImpl(BundleContext bundleContext) {
        this.m_bundles = new ArrayList<Bundle>();
        this.m_bundles.addAll(Arrays.asList(bundleContext.getBundles()));
    }

    @Override
    public List<Bundle> getBundles() {
        return this.m_bundles;
    }

    @Override
    public Bundle findBundle(String bundleId) {
        for (Bundle bundle : this.m_bundles) {
            if (!bundle.getSymbolicName().equals(bundleId)) continue;
            return bundle;
        }
        return null;
    }

    @Override
    public Bundle getBundle(long bundleRuntimeId) {
        return this.m_bundles.get(0).getBundleContext().getBundle(bundleRuntimeId);
    }

    @Override
    public List<Bundle> getExtensions() {
        if (this.m_extensions == null) {
            this._initExtensionDataStructures();
        }
        return this.m_extensions;
    }

    @Override
    public boolean isExtension(String bundleSymbolicName) {
        if (this.m_extensionIds == null) {
            this._initExtensionDataStructures();
        }
        return this.m_extensionIds.contains(bundleSymbolicName);
    }

    @Override
    public List<ExtensionDependency> findExtensionDependencies(String extensionId) {
        if (!this.m_extensionId2Dependencies.containsKey(extensionId)) {
            this.m_extensionId2Dependencies.put(extensionId, new ArrayList());
            PlatformAdmin admin = Platform.getPlatformAdmin();
            BundleDescription bundleDescription = admin.getState(false).getBundle(extensionId, null);
            if (bundleDescription != null) {
                ModuleInfo mi;
                BundleSpecification[] reqBundleSpecifications = bundleDescription.getRequiredBundles();
                if (reqBundleSpecifications.length > 0) {
                    for (BundleSpecification reqBundle : reqBundleSpecifications) {
                        if (!this.isExtension(reqBundle.getName())) continue;
                        this.m_extensionId2Dependencies.get(extensionId).add(new ExtensionDependency(reqBundle.getName()));
                    }
                } else if (bundleDescription.getLocation().startsWith("netigso:") && (mi = Modules.getDefault().findCodeNameBase(extensionId)) != null) {
                    for (Dependency d : mi.getDependencies()) {
                        String depId = this.getExtensionIdFromNbDependency(d);
                        if (depId == null) continue;
                        this.m_extensionId2Dependencies.get(extensionId).add(new ExtensionDependency(depId));
                    }
                }
            } else {
                LOG.severe("no bundle by " + extensionId + " symbolic name was found to exist, and its dependencies could not be found. Did the extension ID match the corresponding bundle symbolic name?");
                return new ArrayList<ExtensionDependency>();
            }
        }
        return this.m_extensionId2Dependencies.get(extensionId);
    }

    private String getExtensionIdFromNbDependency(Dependency d) {
        String id;
        if (d.getType() == 1) {
            boolean isExtension;
            String name = d.getName();
            int majorVersionIndex = name.indexOf(47);
            if (majorVersionIndex > 0) {
                name = name.substring(0, majorVersionIndex);
            }
            if (!(isExtension = this.isExtension(name)) && name.indexOf(95) > 0) {
                name = name.replace('_', '-');
                isExtension = this.isExtension(name);
            }
            id = isExtension ? name : null;
        } else {
            id = null;
        }
        return id;
    }

    private void _initExtensionDataStructures() {
        this.m_extensions = new ArrayList<Bundle>();
        this.m_extensionIds = new HashSet<String>();
        for (Bundle bundle : this.m_bundles) {
            if (bundle.getEntry("META-INF/extension.xml") == null) continue;
            this.m_extensions.add(bundle);
            this.m_extensionIds.add(bundle.getSymbolicName());
        }
    }

    @Override
    public void addBundleListener(BundleListener bundleListener) {
        this.m_bundles.get(0).getBundleContext().addBundleListener(bundleListener);
    }
}

