/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi;

import java.awt.GraphicsEnvironment;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLStreamHandlerFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.LocatorWrapper;
import javax.ide.extension.spi.LocatorWrapperFactory;
import javax.ide.extension.spi.PullManifestParser;
import javax.ide.net.VirtualFileSystem;
import javax.ide.net.VirtualFileSystemHelper;
import javax.naming.InitialContext;
import oracle.ide.IdeArgs;
import oracle.ide.IdeMainWindow;
import oracle.ide.IdeUIManager;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.Layouts;
import oracle.ide.net.IdeWrapperURLStreamHandlerFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.osgi.net.BundleEntryURLFileSystemHelper;
import oracle.ide.osgi.net.BundleVFSHelper;
import oracle.ide.osgi.net.OSGiJarURLFileSystemHelper;
import oracle.ide.osgi.ui.IdeUIManagerOSGiImpl;
import oracle.ideimpl.DefaultIdeCore;
import oracle.ideimpl.IdeUIManagerImpl;
import oracle.ideimpl.extension.GlobalClassLoader;
import org.openide.util.Lookup;

public class OSGiIdeCore
extends DefaultIdeCore {
    public OSGiIdeCore(IdeArgs args) {
        super(args);
    }

    protected IdeUIManager createUIManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        IdeUIManagerImpl uiManager = IdeUIManagerOSGiImpl.getInstance();
        IdeUIManager.setUIManager((IdeUIManager)uiManager);
        return uiManager;
    }

    protected DockStation createDockStation(InitialContext ic) {
        try {
            ClassLoader globalCL = GlobalClassLoader.INSTANCE.getClassLoader();
            assert (globalCL != null);
            ServiceLoader<DockStation> dockStationLoader = globalCL != null ? ServiceLoader.load(DockStation.class, globalCL) : ServiceLoader.load(DockStation.class);
            Iterator<DockStation> iter = dockStationLoader.iterator();
            if (iter.hasNext()) {
                DockStation ds = iter.next();
                DockStation.setDockStation((DockStation)ds);
                return ds;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return super.createDockStation(ic);
    }

    protected ToolbarManager createToolbarManager(InitialContext ic) {
        try {
            ServiceLoader<ToolbarManager> toolbarManagerLoader = ServiceLoader.load(ToolbarManager.class);
            Iterator<ToolbarManager> iter = toolbarManagerLoader.iterator();
            if (iter.hasNext()) {
                ToolbarManager tm = iter.next();
                ToolbarManager.setToolbarManager((ToolbarManager)tm);
                return tm;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return super.createToolbarManager(ic);
    }

    protected EditorManager createEditorManager(InitialContext ic) {
        EditorManager em = (EditorManager)Lookup.getDefault().lookup(EditorManager.class);
        if (em != null) {
            EditorManager.setEditorManager((EditorManager)em);
            return em;
        }
        return super.createEditorManager(ic);
    }

    protected Layouts createLayouts(InitialContext ic) {
        try {
            ServiceLoader<Layouts> layoutsLoader = ServiceLoader.load(Layouts.class);
            Iterator<Layouts> iter = layoutsLoader.iterator();
            if (iter.hasNext()) {
                Layouts layouts = iter.next();
                Layouts.setLayouts((Layouts)layouts);
                return layouts;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return super.createLayouts(ic);
    }

    protected IdeMainWindow getMainWindow() {
        IdeMainWindow mainWindow = null;
        if (!GraphicsEnvironment.isHeadless()) {
            mainWindow = (IdeMainWindow)Lookup.getDefault().lookup(IdeMainWindow.class);
        }
        if (mainWindow == null) {
            mainWindow = super.getMainWindow();
        }
        return mainWindow;
    }

    protected IdeMainWindow createMainWindow(InitialContext ic, IdeMainWindow mainWindow) {
        return super.createMainWindow(ic, mainWindow);
    }

    protected final void registerStreamFactory() {
        VirtualFileSystem.getVirtualFileSystem().registerHelper("bundleentry", (VirtualFileSystemHelper)new BundleVFSHelper());
        URLFileSystem.registerHelper((String)"jar", (URLFileSystemHelper)new OSGiJarURLFileSystemHelper());
        URLFileSystem.registerHelper((String)"bundleentry", (URLFileSystemHelper)BundleEntryURLFileSystemHelper.INSTANCE);
        URLFileSystem.registerHelper((String)"bundleresource", (URLFileSystemHelper)BundleEntryURLFileSystemHelper.INSTANCE);
        PullManifestParser.setLocatorWrapperFactory((LocatorWrapperFactory)new LocatorWrapperFactoryOSGiImpl());
        URLFileSystem.addURLStreamHandlerFactory((String)"ide.file", (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
        URLFileSystem.addURLStreamHandlerFactory((String)"ide.http", (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
        URLFileSystem.addURLStreamHandlerFactory((String)"ide.https", (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
        URLFileSystem.addURLStreamHandlerFactory((String)"ide.jar", (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
        URLFileSystem.addURLStreamHandlerFactory((String)"ide.wsjar", (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
        URLFileSystem.addURLStreamHandlerFactory((String)"ide.zip", (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
    }

    private static class LocatorWrapperFactoryOSGiImpl
    implements LocatorWrapperFactory {
        private LocatorWrapperFactoryOSGiImpl() {
        }

        public LocatorWrapper wrapLocation(LocationAdapter locator) {
            return new PathResolvingLocatorWrapper(locator);
        }
    }

    private static class PathResolvingLocatorWrapper
    implements LocatorWrapper,
    LocationAdapter {
        private static final Map<String, String> _systemIdCache = new ConcurrentHashMap<String, String>();
        private final LocationAdapter m_locationAdapter;

        private PathResolvingLocatorWrapper(LocationAdapter loc) {
            this.m_locationAdapter = loc;
        }

        public String getSystemId() {
            String cachedSystemId = _systemIdCache.get(this.m_locationAdapter.getSystemId());
            if (cachedSystemId == null) {
                URI uri = null;
                try {
                    uri = new URI(this.m_locationAdapter.getSystemId());
                }
                catch (URISyntaxException e) {
                    Logger logger = Logger.getLogger(OSGiIdeCore.class.getName());
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                cachedSystemId = VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(uri);
                _systemIdCache.put(this.m_locationAdapter.getSystemId(), cachedSystemId);
            }
            return cachedSystemId;
        }

        public int getLineNumber() {
            return this.m_locationAdapter.getLineNumber();
        }

        public int getColumnNumber() {
            return this.m_locationAdapter.getColumnNumber();
        }

        public int getCharacterOffset() {
            return this.m_locationAdapter.getCharacterOffset();
        }

        public String getPublicId() {
            return this.m_locationAdapter.getPublicId();
        }

        public LocationAdapter copyMe() {
            return this.createSnapshotCopy();
        }

        public LocatorWrapper createSnapshotCopy() {
            return new PathResolvingLocatorWrapper(this.m_locationAdapter);
        }
    }
}

