/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.util.propertymap.PropertyMap;

public class PropertyMapImplementation
implements PropertyMap {
    private Map properties = new TreeMap();

    @Override
    public void setProperty(String key, String value) {
        if (key != null) {
            if (value == null) {
                this.properties.put(key, "");
            } else {
                this.properties.put(key, value);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        if (key != null) {
            String value = (String)this.properties.get(key);
            if (value == null) {
                return "";
            }
            return value;
        }
        return null;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean hasProperty(String key, String value) {
        return this.properties.containsKey(key) && (this.getProperty(key) == null && value == null || value != null && value.equals(this.getProperty(key)));
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public Collection getPropertyNamesCollection() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public void appendStringProps(String startLineWith, StringBuffer buffer) {
        Iterator it = this.getPropertyNames();
        while (it.hasNext()) {
            String name = String.valueOf(it.next());
            buffer.append(startLineWith);
            buffer.append(name).append(": ").append(this.getProperty(name));
        }
    }
}

