/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class RepositoryUsersDialog
extends CustomDialog
implements AbstractEditorConstants {
    private final String[] ACCESS_LEVELS = new String[]{"FULL ACCESS", "LOGICAL ONLY", "VIEWER"};
    private JPanel buttonPanel;
    private JDialog dialog;
    private AbstractRepositoryManager dbman;
    private JList allUsersList;
    private SortedListModel allUsersModel;
    private JTable tbUsers;
    private JButton btnAdd;
    private JButton btnRemove;
    private List lsUsers;
    private List repUsers = new ArrayList();
    private static final Logger LOGGER = new Logger(RepositoryUsersDialog.class);
    List list = null;

    public RepositoryUsersDialog(ApplicationView appView, AbstractRepositoryManager dbman) {
        super(appView);
        this.dbman = dbman;
        JScrollPane scrollPane = new JScrollPane(this.initUsersPanel());
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.initUsers();
    }

    private void initUsers() {
        try {
            this.repUsers.clear();
            Connection sqlConnection = this.dbman.getConnection();
            Statement stmt = null;
            DatabaseMetaData dbmd = sqlConnection.getMetaData();
            ResultSet resultSet = null;
            String query = "select name, viewer_mode, logical_only, deleted from DMR_Users";
            try {
                stmt = sqlConnection.createStatement();
            }
            catch (SQLException e) {
                LOGGER.error("RepositoryUsersDialog.initUsers: ", e);
            }
            try {
                resultSet = stmt.executeQuery(query);
            }
            catch (SQLException e1) {
                System.out.println(e1.getMessage());
                LOGGER.error("RepositoryUsersDialog.initUsers: ", e1);
            }
            if (resultSet != null) {
                try {
                    while (resultSet.next()) {
                        String name = resultSet.getString(1);
                        String viewer_mode = resultSet.getString(2);
                        String logical_only = resultSet.getString(3);
                        String deleted = resultSet.getString(4);
                        if (this.dbman.getUser().trim().equalsIgnoreCase(name.trim())) continue;
                        int access = 0;
                        if ("Y".equalsIgnoreCase(viewer_mode)) {
                            access = 2;
                        } else if ("Y".equalsIgnoreCase(logical_only)) {
                            access = 1;
                        }
                        UserObj userObj = new UserObj(name, access);
                        if ("Y".equalsIgnoreCase(deleted)) {
                            userObj.isDeleted = true;
                        } else {
                            this.lsUsers.add(userObj);
                        }
                        this.repUsers.add(userObj.clone(userObj));
                    }
                }
                catch (SQLException e) {
                    System.out.println(e.getMessage());
                    LOGGER.error("RepositoryUsersDialog.initUsers: ", e);
                }
                resultSet.close();
                if (stmt != null) {
                    stmt.close();
                }
            }
            resultSet = dbmd.getSchemas();
            while (resultSet.next()) {
                String schema = resultSet.getString(1);
                if (this.dbman.getUser().trim().equalsIgnoreCase(schema.trim()) || this.exists(schema)) continue;
                UserObj userObj = new UserObj(schema.trim(), 0);
                this.allUsersModel.add(userObj);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception ex) {
            MessageDialogs.showErrorMessage(ex.getMessage());
            LOGGER.error("RepositoryUsersDialog.initUsers: ", ex);
        }
    }

    private boolean exists(String schema) {
        for (UserObj next : this.lsUsers) {
            if (!next.name.equalsIgnoreCase(schema)) continue;
            return true;
        }
        return false;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            if (this.isEditable()) {
                JButton ok = new JButton(Messages.getString("RepositoryUsersDialog.OK"));
                ok.setCursor(Cursor.getPredefinedCursor(12));
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RepositoryUsersDialog.this.setUsers();
                        RepositoryUsersDialog.this.close();
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
            }
            JButton cancel = new JButton(this.isEditable() ? Messages.getString("RepositoryUsersDialog.Cancel") : Messages.getString("RepositoryUsersDialog.Close"));
            cancel.setCursor(Cursor.getPredefinedCursor(12));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RepositoryUsersDialog.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(cancel);
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(bnHelp);
        }
        return this.buttonPanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("RepositoryUsersDialog.ManageUsers"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog, true);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "REPOSITORY_USERS_DIALOG";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUsers() {
        block14: {
            PreparedStatement ustmt = null;
            PreparedStatement istmt = null;
            PreparedStatement dstmt = null;
            try {
                Connection sqlConnection = this.dbman.getConnection();
                Iterator it = this.lsUsers.iterator();
                String updateQuery = "update DMR_Users set viewer_mode = ?, logical_only = ?, deleted = 'N' where name = ?";
                String insertQuery = "insert into DMR_Users (name, Viewer_Mode, Logical_Only) values (?, ?, ?)";
                ustmt = sqlConnection.prepareStatement(updateQuery);
                istmt = sqlConnection.prepareStatement(insertQuery);
                while (it.hasNext()) {
                    UserObj next = (UserObj)it.next();
                    UserObj repUser = this.getUser(this.repUsers, next.name);
                    if (repUser != null) {
                        if (!repUser.isDeleted && repUser.access == next.access) continue;
                        try {
                            ustmt.setString(1, next.access == 2 ? "Y" : "N");
                            ustmt.setString(2, next.access == 1 ? "Y" : "N");
                            ustmt.setString(3, next.name);
                            ustmt.executeUpdate();
                            if (!repUser.isDeleted) continue;
                            this.createSynonyms(next.name, this.dbman.getUser());
                            this.grantPrivileges(this.dbman.getUser(), next.name);
                        }
                        catch (SQLException e) {
                            System.out.println(e.getMessage());
                            LOGGER.error("RepositoryUsersDialog.setUsers: ", e);
                        }
                        continue;
                    }
                    try {
                        istmt.setString(1, next.name);
                        istmt.setString(2, next.access == 2 ? "Y" : "N");
                        istmt.setString(3, next.access == 1 ? "Y" : "N");
                        istmt.executeUpdate();
                        this.createSynonyms(next.name, this.dbman.getUser());
                        this.grantPrivileges(this.dbman.getUser(), next.name);
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        LOGGER.error("RepositoryUsersDialog.setUsers: ", e);
                    }
                }
                String deleteQuery = "update DMR_Users set deleted = 'Y' where name = ?";
                dstmt = sqlConnection.prepareStatement(deleteQuery);
                for (UserObj next : this.repUsers) {
                    UserObj deleted = this.getUser(this.lsUsers, next.name);
                    if (deleted != null) continue;
                    try {
                        dstmt.setString(1, next.name);
                        dstmt.executeUpdate();
                        this.dbman.getRepositoryFactory().dropSynonymsFor(next.name, sqlConnection);
                        this.dbman.getRepositoryFactory().revokePrivilegesFrom(next.name, sqlConnection);
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        LOGGER.error("RepositoryUsersDialog.setUsers: ", e);
                    }
                }
                JDBCUtils.close(ustmt);
            }
            catch (SQLException e) {
                LOGGER.error("RepositoryUsersDialog.setUsers: ", e);
                break block14;
            }
            finally {
                JDBCUtils.close(ustmt);
                JDBCUtils.close(istmt);
                JDBCUtils.close(dstmt);
            }
            JDBCUtils.close(istmt);
            JDBCUtils.close(dstmt);
        }
    }

    private void createSynonyms(String userName, String forUser) {
        try {
            Connection sqlConnection = this.dbman.getConnection();
            for (String tbName : this.dbman.getRepositoryFactory().getTableNames()) {
                try {
                    String query = "create or replace synonym " + userName + "." + tbName + " for " + forUser + "." + tbName;
                    PreparedStatement stmt = sqlConnection.prepareStatement(query);
                    stmt.execute();
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println(tbName + " - " + e.getMessage());
                    LOGGER.error("RepositoryUsersDialog.createSynonyms: ", e);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOGGER.error("RepositoryUsersDialog.createSynonyms: ", e);
        }
    }

    private void grantPrivileges(String userName, String toUser) {
        try {
            Connection sqlConnection = this.dbman.getConnection();
            for (String tbName : this.dbman.getRepositoryFactory().getTableNames()) {
                try {
                    String query = "grant select, insert, delete, update on " + userName + "." + tbName + " to " + toUser;
                    String selQuery = "grant select on " + userName + "." + tbName + " to " + toUser;
                    PreparedStatement stmt = tbName.equalsIgnoreCase("Repository") || tbName.equalsIgnoreCase("DMR_Users") ? sqlConnection.prepareStatement(selQuery) : sqlConnection.prepareStatement(query);
                    stmt.execute();
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println(tbName + " - " + e.getMessage());
                    LOGGER.error("RepositoryUsersDialog.grantPrivileges: ", e);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOGGER.error("RepositoryUsersDialog.grantPrivileges: ", e);
        }
    }

    private UserObj getUser(List list, String userName) {
        for (UserObj next : list) {
            if (!next.name.equalsIgnoreCase(userName)) continue;
            return next;
        }
        return null;
    }

    protected JPanel initUsersPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.allUsersModel = new SortedListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUsersListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(200, 300));
        jpanel.add((Component)sp, "West");
        this.lsUsers = new ArrayList();
        this.tbUsers = new JTable(new UserModel());
        TableColumn column = this.tbUsers.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>(this.ACCESS_LEVELS);
        column.setCellEditor(new DefaultCellEditor(comboBox));
        this.tbUsers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RepositoryUsersDialog.this.isEditable() && !e.getValueIsAdjusting()) {
                    if (RepositoryUsersDialog.this.tbUsers.getSelectedRow() == -1) {
                        RepositoryUsersDialog.this.btnRemove.setEnabled(false);
                    } else {
                        RepositoryUsersDialog.this.btnRemove.setEnabled(true);
                    }
                }
            }
        });
        JScrollPane sp2 = new JScrollPane(this.tbUsers);
        sp2.setPreferredSize(new Dimension(300, 300));
        jpanel.add((Component)sp2, "East");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setPreferredSize(new Dimension(36, 300));
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnAdd.addActionListener(new AddUsersActionListener());
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText(Messages.getString("RepositoryUsersDialog.AddUser"));
        this.btnRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveUsersActionListener());
        this.btnRemove.setToolTipText(Messages.getString("RepositoryUsersDialog.RemoveUser"));
        JLabel lbl = new JLabel();
        lbl.setPreferredSize(new Dimension(16, 110));
        buttonsPanel.add(lbl);
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnRemove);
        buttonsPanel.add(toolBar);
        jpanel.add(buttonsPanel);
        return jpanel;
    }

    private int getAccessLevel(String level) {
        int result;
        if (this.list == null) {
            this.list = new ArrayList<String>(Arrays.asList(this.ACCESS_LEVELS));
        }
        if ((result = this.list.indexOf(level)) == -1) {
            result = 0;
        }
        return result;
    }

    private class UserObj {
        public static final int ALL_ACCESS = 0;
        public static final int LOGICAL_ONLY_ACCESS = 1;
        public static final int VIEWER_ONLY_ACCESS = 2;
        String name = "";
        int access = 0;
        boolean isDeleted = false;

        public UserObj(String name, int access) {
            this.name = name;
            this.access = access;
        }

        public UserObj(String name, int access, boolean deleted) {
            this.name = name;
            this.access = access;
            this.isDeleted = deleted;
        }

        public String toString() {
            return this.name;
        }

        public UserObj clone(UserObj userObj) {
            return new UserObj(new String(userObj.name), userObj.access, userObj.isDeleted);
        }
    }

    public class SortedListModel
    extends AbstractListModel {
        private Comparator COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                String str1 = o1.toString();
                String str2 = o2.toString();
                Collator collator = Collator.getInstance();
                int result = collator.compare(str1, str2);
                return result;
            }
        };
        SortedSet model = new TreeSet(this.COMPARATOR);

        @Override
        public int getSize() {
            return this.model.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.model.toArray()[index];
        }

        public void add(Object element) {
            if (this.model.add(element)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(Object[] elements) {
            List<Object> c = Arrays.asList(elements);
            this.model.addAll(c);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.model.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(Object element) {
            return this.model.contains(element);
        }

        public Object firstElement() {
            return this.model.first();
        }

        public Iterator iterator() {
            return this.model.iterator();
        }

        public Object lastElement() {
            return this.model.last();
        }

        public boolean removeElement(Object element) {
            boolean removed = this.model.remove(element);
            if (removed) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return removed;
        }
    }

    private class AllUsersListSelectionHandler
    implements ListSelectionListener {
        private AllUsersListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RepositoryUsersDialog.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RepositoryUsersDialog.this.allUsersList.getSelectedIndex() == -1) {
                    RepositoryUsersDialog.this.btnAdd.setEnabled(false);
                } else {
                    RepositoryUsersDialog.this.btnAdd.setEnabled(true);
                }
            }
        }
    }

    public class UserModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return RepositoryUsersDialog.this.lsUsers.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("RepositoryUsersDialog.UserName");
            }
            if (column == 1) {
                return Messages.getString("RepositoryUsersDialog.AccessLevel");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            UserObj userObj = (UserObj)RepositoryUsersDialog.this.lsUsers.get(row);
            if (col == 0) {
                return userObj.name;
            }
            if (col == 1) {
                return RepositoryUsersDialog.this.ACCESS_LEVELS[userObj.access];
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            UserObj userObj = (UserObj)RepositoryUsersDialog.this.lsUsers.get(row);
            if (col == 1) {
                String at = (String)aValue;
                userObj.access = RepositoryUsersDialog.this.getAccessLevel(at);
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RepositoryUsersDialog.this.allUsersModel.getSize() > 0) {
                Object[] selectedObjects = RepositoryUsersDialog.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RepositoryUsersDialog.this.lsUsers.contains(ob)) continue;
                    RepositoryUsersDialog.this.lsUsers.add(ob);
                    RepositoryUsersDialog.this.allUsersModel.removeElement(ob);
                }
                RepositoryUsersDialog.this.allUsersList.updateUI();
                RepositoryUsersDialog.this.tbUsers.updateUI();
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RepositoryUsersDialog.this.lsUsers.isEmpty()) {
                int[] selected = RepositoryUsersDialog.this.tbUsers.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    Object ob = RepositoryUsersDialog.this.lsUsers.get(selected[i]);
                    if (RepositoryUsersDialog.this.allUsersModel.contains(ob)) continue;
                    RepositoryUsersDialog.this.allUsersModel.add(ob);
                    RepositoryUsersDialog.this.lsUsers.remove(ob);
                }
                RepositoryUsersDialog.this.allUsersList.updateUI();
                RepositoryUsersDialog.this.tbUsers.updateUI();
                RepositoryUsersDialog.this.btnRemove.setEnabled(false);
            }
        }
    }
}

