/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;

public class JListUtils {
    public static void filter(List initialList, DefaultListModel model, String searchString, boolean sort) {
        Iterator it = initialList.iterator();
        model.removeAllElements();
        while (it.hasNext()) {
            Object obj = it.next();
            ModelIDObject o = null;
            String name = "";
            if (obj instanceof DesignObject) {
                o = (DesignObject)obj;
                name = o.getName();
            } else if (obj instanceof StorageObject) {
                o = (StorageObject)obj;
                name = ((StorageObject)o).getName();
            }
            if (searchString.trim() != null && !searchString.trim().equals("")) {
                int idx = ReportUtils.match(name, searchString, false, false, false);
                if (idx > -1) {
                    if (model.contains(o)) continue;
                    model.addElement(o);
                    continue;
                }
                if (!model.contains(o)) continue;
                model.removeElement(o);
                continue;
            }
            model.addElement(o);
        }
        if (sort) {
            JListUtils.sort(model);
        }
    }

    public static DefaultListModel sort(DefaultListModel model) {
        for (int k = 0; k < model.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < model.size() - k; ++i) {
                if (model.get(i).toString().compareTo(model.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = model.get(i);
                model.remove(i);
                model.add(i, model.get(i - 1));
                model.remove(i - 1);
                model.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return model;
    }
}

