/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectReportObjectDialog
extends CustomDialog {
    private static final long serialVersionUID = 3472056109744549424L;
    private boolean result = false;
    private ReportsGenerationDialog parent;
    private JDialog dialog;
    private JPanel mainPanel;
    public JButton bnClose;
    public JButton bnOK;
    private JScrollPane availableObjectsSP;
    private JList availableObjectsList;
    private DefaultListModel availableObjectsModel;
    private ApplicationView appView;
    private boolean subViews;

    public SelectReportObjectDialog(ApplicationView appView, ReportsGenerationDialog parent, boolean subViews) {
        super(appView);
        this.parent = parent;
        this.appView = appView;
        this.subViews = subViews;
        this.init();
        this.initObjectsPanel();
        this.initButtonsPanel();
        this.initData();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(350, 500));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initObjectsPanel() {
        JPanel objectdPanel = new JPanel(new BorderLayout());
        this.availableObjectsModel = new DefaultListModel();
        this.availableObjectsList = new JList(this.availableObjectsModel);
        this.availableObjectsList.setSelectionMode(0);
        this.availableObjectsSP = new JScrollPane(this.availableObjectsList);
        this.availableObjectsSP.setPreferredSize(new Dimension(340, 460));
        objectdPanel.add(this.availableObjectsSP);
        this.availableObjectsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectReportObjectDialog.this.availableObjectsList.getSelectedIndex() == -1) {
                    SelectReportObjectDialog.this.bnOK.setEnabled(false);
                } else {
                    SelectReportObjectDialog.this.bnOK.setEnabled(true);
                }
            }
        });
        this.mainPanel.add((Component)objectdPanel, "North");
    }

    private void initButtonsPanel() {
        JPanel bp = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("ReportsGenerationDialog.OK"));
        this.bnOK.setEnabled(false);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new OKAction());
        bp.add(this.bnOK);
        this.bnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.addActionListener(new CloseAction());
        bp.add(this.bnClose);
        this.mainPanel.add((Component)bp, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private void initData() {
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                this.availableObjectsModel.clear();
                                if (this.parent.getCmbModels().getSelectedItem() == null) break block6;
                                if (!this.subViews) break block7;
                                DesignPart d = (DesignPart)this.parent.getCmbModels().getSelectedItem();
                                Iterator it = d.getDesignSubviews().iterator();
                                while (it.hasNext()) {
                                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                                    this.availableObjectsModel.addElement(ph);
                                }
                                break block6;
                            }
                            if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Tables")) break block8;
                            RelationalDesign d = (RelationalDesign)this.parent.getCmbModels().getSelectedItem();
                            Iterator it = d.getTableSet().iterator();
                            while (it.hasNext()) {
                                Table table = (Table)it.next();
                                this.availableObjectsModel.addElement(table);
                            }
                            break block6;
                        }
                        if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Entities")) break block9;
                        LogicalDesign d = (LogicalDesign)this.parent.getCmbModels().getSelectedItem();
                        Iterator it = d.getEntitySet().iterator();
                        while (it.hasNext()) {
                            Entity entity = (Entity)it.next();
                            this.availableObjectsModel.addElement(entity);
                        }
                        break block6;
                    }
                    if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Structured Types")) break block10;
                    DataTypesDesign d = (DataTypesDesign)this.parent.getCmbModels().getSelectedItem();
                    Iterator it = d.getStructuredTypeSet().iterator();
                    while (it.hasNext()) {
                        StructuredType structuredType = (StructuredType)it.next();
                        this.availableObjectsModel.addElement(structuredType);
                    }
                    break block6;
                }
                if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Collection Types")) break block11;
                DataTypesDesign d = (DataTypesDesign)this.parent.getCmbModels().getSelectedItem();
                Iterator it = d.getCollectionTypeSet().iterator();
                while (it.hasNext()) {
                    CollectionType collectionType = (CollectionType)it.next();
                    this.availableObjectsModel.addElement(collectionType);
                }
                break block6;
            }
            if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Distinct Types")) break block6;
            DataTypesDesign d = (DataTypesDesign)this.parent.getCmbModels().getSelectedItem();
            Iterator it = d.getDistinctTypeSet().iterator();
            while (it.hasNext()) {
                DistinctType distinctType = (DistinctType)it.next();
                this.availableObjectsModel.addElement(distinctType);
            }
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectObjectDialog.SelectObject"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignObject obj = (DesignObject)SelectReportObjectDialog.this.availableObjectsList.getSelectedValue();
            if (SelectReportObjectDialog.this.subViews) {
                // empty if block
            }
            SelectReportObjectDialog.this.close();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectReportObjectDialog.this.close();
        }
    }
}

