/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SelectModelDialog
extends JDialog {
    private static final long serialVersionUID = -7349566331978231952L;
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable designsTable;
    private JTable versionsTable;
    private JTable modelsTable;
    private JTable objectsTable;
    private List versionsList;
    private List desList;
    private List modelsList;
    private List allDesigns;
    private List objectsList;
    private Connection connection;
    private JButton bnOK;
    private String report;
    private static final Logger LOGGER = new Logger(SelectModelDialog.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectModelDialog.this.dispose();
        }
    };

    public SelectModelDialog(Frame owner, Connection connection, ReportsGenerationDialog parent) {
        super(owner, Messages.getString("SelectDesignsDialog.SelectModels"));
        this.connection = connection;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(900, 350));
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
        this.report = (String)parent.getCmbReports().getSelectedItem();
    }

    private JPanel init() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel designsPanel = new JPanel(new BorderLayout());
        designsPanel.setPreferredSize(new Dimension(10, 10));
        designsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Designs")));
        this.desList = new ArrayList();
        this.designsTable = new JTable(new DesignTableModel());
        this.designsTable.setSelectionMode(0);
        this.designsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = SelectModelDialog.this.designsTable.getSelectedRow();
                if (row != -1) {
                    if (SelectModelDialog.this.desList.size() > 0 && row < SelectModelDialog.this.desList.size()) {
                        DesignModel desModel = (DesignModel)SelectModelDialog.this.desList.get(row);
                        SelectModelDialog.this.loadVersions(desModel);
                    }
                } else {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                    SelectModelDialog.this.versionsTable.clearSelection();
                    SelectModelDialog.this.versionsTable.setEnabled(false);
                    SelectModelDialog.this.modelsTable.clearSelection();
                    SelectModelDialog.this.modelsTable.setEnabled(false);
                    SelectModelDialog.this.objectsTable.clearSelection();
                    SelectModelDialog.this.objectsTable.setEnabled(false);
                }
            }
        });
        JScrollPane spd = new JScrollPane(this.designsTable);
        designsPanel.add((Component)spd, "Center");
        JPanel versionsPanel = new JPanel(new BorderLayout());
        versionsPanel.setPreferredSize(new Dimension(10, 10));
        versionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Versions")));
        this.versionsList = new ArrayList();
        this.versionsTable = new JTable(new VersionsTableModel());
        this.versionsTable.setSelectionMode(0);
        this.versionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = SelectModelDialog.this.versionsTable.getSelectedRow();
                if (row != -1) {
                    if (SelectModelDialog.this.versionsList.size() > 0 && row < SelectModelDialog.this.versionsList.size()) {
                        DesignModel desModel = (DesignModel)SelectModelDialog.this.versionsList.get(row);
                        SelectModelDialog.this.loadModels(desModel);
                    }
                } else {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                    SelectModelDialog.this.modelsTable.clearSelection();
                    SelectModelDialog.this.modelsTable.setEnabled(false);
                    SelectModelDialog.this.objectsTable.clearSelection();
                    SelectModelDialog.this.objectsTable.setEnabled(false);
                }
            }
        });
        this.versionsTable.getColumnModel().getColumn(0).setPreferredWidth(130);
        this.versionsTable.getColumnModel().getColumn(0).setMaxWidth(300);
        this.versionsTable.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.versionsTable.getColumnModel().getColumn(1).setMaxWidth(300);
        JScrollPane sp = new JScrollPane(this.versionsTable);
        versionsPanel.add((Component)sp, "Center");
        JPanel modelsPanel = new JPanel(new BorderLayout());
        modelsPanel.setPreferredSize(new Dimension(10, 10));
        modelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Models")));
        this.modelsList = new ArrayList();
        this.modelsTable = new JTable(new ModelsTableModel());
        this.modelsTable.setSelectionMode(0);
        this.modelsTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.modelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = SelectModelDialog.this.modelsTable.getSelectedRow();
                if (selRow != -1) {
                    DesignModel desModel = (DesignModel)SelectModelDialog.this.modelsList.get(selRow);
                    SelectModelDialog.this.loadObjects(desModel);
                    SelectModelDialog.this.bnOK.setEnabled(true);
                } else {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                    SelectModelDialog.this.objectsTable.clearSelection();
                    SelectModelDialog.this.objectsTable.setEnabled(false);
                }
            }
        });
        JScrollPane spModels = new JScrollPane(this.modelsTable);
        modelsPanel.add((Component)spModels, "Center");
        JSplitPane splitPaneVersionsModels = new JSplitPane(0, versionsPanel, modelsPanel);
        splitPaneVersionsModels.setDividerLocation(140);
        JPanel objectsPanel = new JPanel(new BorderLayout());
        objectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Objects")));
        this.objectsList = new ArrayList();
        this.objectsTable = new JTable(new ObjectsTableModel());
        this.objectsTable.setSelectionMode(0);
        this.objectsTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.objectsTable.getColumnModel().removeColumn(this.objectsTable.getColumnModel().getColumn(1));
        this.objectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = SelectModelDialog.this.objectsTable.getSelectedRow();
                if (selRow != -1) {
                    SelectModelDialog.this.bnOK.setEnabled(true);
                }
            }
        });
        JScrollPane spObjects = new JScrollPane(this.objectsTable);
        objectsPanel.add((Component)spObjects, "Center");
        JSplitPane splitPane1 = new JSplitPane(1, designsPanel, splitPaneVersionsModels);
        splitPane1.setDividerLocation(300);
        JSplitPane splitPane2 = new JSplitPane(1, splitPane1, objectsPanel);
        splitPane2.setDividerLocation(600);
        jpanel.add(splitPane2);
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("SelectDesignsDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.setEnabled(false);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectModelDialog.this.report.equals("Domains") || SelectModelDialog.this.report.equals("Glossaries")) {
                    DesignModel designModel = (DesignModel)SelectModelDialog.this.versionsList.get(SelectModelDialog.this.versionsTable.getSelectedRow());
                }
                SelectModelDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.bnOK);
        bottomPanel.add(this.bnOK);
        JButton bnCancel = new JButton(Messages.getString("Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModelDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    private void loadDesignNames() {
        this.desList.clear();
        Iterator it = this.allDesigns.iterator();
        boolean add = false;
        while (it.hasNext()) {
            DesignModel dm = (DesignModel)it.next();
            if (this.desList.size() == 0) {
                this.desList.add(dm);
                continue;
            }
            for (DesignModel dmCurrent : this.desList) {
                if (dm.getDesignName().equals(dmCurrent.getDesignName())) {
                    add = false;
                    break;
                }
                add = true;
            }
            if (!add) continue;
            this.desList.add(dm);
        }
        this.sort(this.desList);
        this.sort(this.desList);
        this.sort(this.desList);
        this.designsTable.updateUI();
        if (this.desList.size() > 0) {
            this.designsTable.setRowSelectionInterval(0, 0);
        }
        this.versionsTable.updateUI();
        this.modelsTable.updateUI();
    }

    private boolean loadDesigns() {
        boolean result;
        block10: {
            result = false;
            try {
                this.allDesigns = new ArrayList();
                if (this.connection == null) break block10;
                try {
                    float vers = SchemaFactory.schemaVersion(this.connection);
                    if (vers != 0.0f) {
                        String query = "SELECT  TO_CHAR(d.date_published,'dd.mm.yyyy hh24:mi:ss'), d.version_comments, d.design_ovid, d.Design_ID, d.design_name, m.model_type, m.model_name, m.model_ovid FROM  \tdmrs_designs d, dmrs_models m WHERE d.design_ovid = m.design_ovid AND   m.model_type IN ('Relational','Logical','Data Types') GROUP BY d.date_published, d.version_comments, d.design_ovid, d.Design_ID, d.design_name, m.model_type, m.model_name, m.model_ovid ORDER BY d.design_name";
                        try {
                            Statement stmt = this.connection.createStatement();
                            ResultSet rset = stmt.executeQuery(query);
                            Statement stmt1 = this.connection.createStatement();
                            while (rset.next()) {
                                DesignModel desModel = new DesignModel();
                                desModel.setDatePublished(rset.getString(1));
                                desModel.setComments(rset.getString(2));
                                desModel.setDesignOVID(rset.getString(3));
                                desModel.setDesignID(rset.getString(4));
                                desModel.setDesignName(rset.getString(5));
                                desModel.setModelType(rset.getString(6));
                                desModel.setModelName(rset.getString(7));
                                desModel.setModelOVID(rset.getString(8));
                                String query1 = " SELECT ovid, table_name, 'Tables' FROM   dmrs_tables  WHERE  model_ovid = '" + rset.getString(8) + "'  UNION ALL  SELECT ovid, entity_name, 'Entities' FROM   dmrs_entities  WHERE  model_ovid = '" + rset.getString(8) + "'  UNION ALL  SELECT structured_type_ovid,  structured_type_name, 'Structured Types' FROM   dmrs_structured_types  WHERE  model_ovid = '" + rset.getString(8) + "'  UNION ALL  SELECT collection_type_ovid,  collection_type_name, 'Collection Types' FROM   dmrs_collection_types  WHERE  model_ovid = '" + rset.getString(8) + "'  UNION ALL  SELECT distinct_type_ovid,  distinct_type_name, 'Distinct Types' FROM   dmrs_distinct_types  WHERE  model_ovid = '" + rset.getString(8) + "' ";
                                ResultSet rset1 = stmt1.executeQuery(query1);
                                while (rset1.next()) {
                                    DesignObjectsModel designObjectsModel = new DesignObjectsModel();
                                    designObjectsModel.setObjectOVID(rset1.getString(1));
                                    designObjectsModel.setObjectName(rset1.getString(2));
                                    designObjectsModel.setObjectType(rset1.getString(3));
                                    desModel.addDesignObjectsModel(designObjectsModel);
                                }
                                this.allDesigns.add(desModel);
                            }
                            stmt.close();
                            stmt1.close();
                            this.loadDesignNames();
                            result = true;
                        }
                        catch (SQLException e) {
                            LOGGER.error("SelectModelDialog.loadDesigns()", e);
                        }
                        break block10;
                    }
                    MessageDialogs.showMessage(Messages.getString("SelectDesignsDialog.ReportingRepositoryNotExisting"));
                }
                catch (DifferentVersionException dve) {
                    MessageDialogs.showWarningMessage(Messages.getString("SelectDesignsDialog.DBSchemaOutOfDate"));
                }
                catch (Exception e) {
                    LOGGER.error("SelectDesignsDialog.loadDesigns()", e);
                    MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"), true);
                }
            }
            catch (Exception e) {
                LOGGER.error("SelectDesignsDialog.loadDesigns()", e);
                MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"));
            }
        }
        return result;
    }

    private void loadVersions(DesignModel desModel) {
        this.versionsList.clear();
        for (DesignModel dm : this.allDesigns) {
            if (!dm.getDesignName().equals(desModel.getDesignName()) || this.versionListed(dm)) continue;
            this.versionsList.add(dm);
        }
        Collections.sort(this.versionsList);
        this.versionsTable.updateUI();
        if (this.versionsList.size() > 0) {
            this.versionsTable.setEnabled(true);
            this.versionsTable.setRowSelectionInterval(0, 0);
            int row = this.versionsTable.getSelectedRow();
            DesignModel selectedVersion = (DesignModel)this.versionsList.get(row);
            this.loadModels(selectedVersion);
        }
        this.sort(this.versionsList);
    }

    private boolean versionListed(DesignModel dModel) {
        for (DesignModel dm : this.versionsList) {
            if (!dm.getDesignOVID().equals(dModel.getDesignOVID())) continue;
            return true;
        }
        return false;
    }

    private void loadModels(DesignModel desModel) {
        this.modelsList.clear();
        Iterator it = this.allDesigns.iterator();
        if (this.report.equals("Tables")) {
            while (it.hasNext()) {
                DesignModel dm = (DesignModel)it.next();
                if (!dm.getDesignOVID().equals(desModel.getDesignOVID()) || !dm.getModelType().equals("Relational")) continue;
                this.modelsList.add(dm);
            }
            this.modelsTable.setBackground(Color.WHITE);
        } else if (this.report.equals("Entities")) {
            while (it.hasNext()) {
                DesignModel dm = (DesignModel)it.next();
                if (!dm.getDesignOVID().equals(desModel.getDesignOVID()) || !dm.getModelType().equals("Logical")) continue;
                this.modelsList.add(dm);
            }
            this.modelsTable.setBackground(Color.WHITE);
        } else if (this.report.equals("Domains") || this.report.equals("Glossaries")) {
            while (it.hasNext()) {
                DesignModel dm = (DesignModel)it.next();
                if (!dm.getDesignOVID().equals(desModel.getDesignOVID())) continue;
                this.modelsList.add(dm);
            }
            this.modelsTable.setBackground(Color.LIGHT_GRAY);
            this.modelsTable.clearSelection();
        } else if (this.report.equals("Structured Types") || this.report.equals("Collection Types") || this.report.equals("Distinct Types")) {
            while (it.hasNext()) {
                DesignModel dm = (DesignModel)it.next();
                if (!dm.getDesignOVID().equals(desModel.getDesignOVID()) || !dm.getModelType().equals("Data Types")) continue;
                this.modelsList.add(dm);
            }
            this.modelsTable.setBackground(Color.WHITE);
        }
        if (this.modelsList.size() == 0 && (this.report.equals("Change Requests") || this.report.equals("Measurements"))) {
            this.bnOK.setEnabled(true);
        }
        this.modelsTable.updateUI();
        if (this.modelsList.size() > 0) {
            this.modelsTable.setEnabled(true);
            this.modelsTable.clearSelection();
            this.modelsTable.setRowSelectionInterval(0, 0);
            this.bnOK.setEnabled(true);
        }
        this.sort(this.modelsList);
    }

    private void loadObjects(DesignModel desModel) {
        this.objectsList.clear();
        ArrayList<DesignObjectsModel> domList = desModel.getDesignObjectsModelList();
        for (DesignObjectsModel dom : domList) {
            if (!this.report.equals(dom.getObjectType())) continue;
            this.objectsList.add(dom);
        }
        this.objectsTable.updateUI();
        this.sortDo(this.objectsList);
    }

    public static void showDialog(Frame owner, Connection connection, ReportsGenerationDialog parent) {
        SelectModelDialog dialog = new SelectModelDialog(owner, connection, parent);
        if (dialog.loadDesigns()) {
            dialog.setVisible(true);
        } else {
            dialog.dispose();
        }
    }

    public void sort(List list) {
        Collections.sort(list, new DesignModelComparator());
    }

    public void sortDo(List list) {
        Collections.sort(list, new DesignObjectComparator());
    }

    private class DesignTableModel
    extends AbstractTableModel {
        private DesignTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.desList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectDesignsDialog.DesignName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignModel desModel = (DesignModel)SelectModelDialog.this.desList.get(row);
            if (col == 0) {
                return desModel.getDesignName();
            }
            return new Integer(row * col);
        }
    }

    private class VersionsTableModel
    extends AbstractTableModel {
        private VersionsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.versionsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectDesignsDialog.Date");
            }
            if (column == 1) {
                return Messages.getString("SelectDesignsDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignModel version = (DesignModel)SelectModelDialog.this.versionsList.get(row);
            if (col == 0) {
                return version.getDatePublished();
            }
            if (col == 1) {
                return version.getComments() == null ? "" : version.getComments();
            }
            return new Integer(row * col);
        }
    }

    private class ModelsTableModel
    extends AbstractTableModel {
        private ModelsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.modelsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("SelectDesignsDialog.ModelName");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignModel model = (DesignModel)SelectModelDialog.this.modelsList.get(row);
            if (col == 0) {
                return model.getModelName();
            }
            return new Integer(row * col);
        }
    }

    private class ObjectsTableModel
    extends AbstractTableModel {
        private ObjectsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.objectsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("SelectDesignsDialog.ObjectName");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObjectsModel dom = (DesignObjectsModel)SelectModelDialog.this.objectsList.get(row);
            if (col == 0) {
                return dom.getObjectName();
            }
            if (col == 1) {
                return dom.getObjectOVID();
            }
            return new Integer(row * col);
        }
    }

    public class DesignModel
    implements Comparable {
        private String datePublished;
        private String comments = "";
        private String designOVID;
        private String designID;
        private String designName;
        private String modelType;
        private String modelName;
        private String modelOVID;
        private boolean selected = false;
        private ArrayList<DesignObjectsModel> designObjectsModelList;

        public String getDatePublished() {
            return this.datePublished;
        }

        public void setDatePublished(String datePublished) {
            this.datePublished = datePublished;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public void setDesignOVID(String designOVID) {
            this.designOVID = designOVID;
        }

        public String getDesignID() {
            return this.designID;
        }

        public void setDesignID(String designID) {
            this.designID = designID;
        }

        public String getDesignName() {
            return this.designName;
        }

        public void setDesignName(String designName) {
            this.designName = designName;
        }

        public String getModelType() {
            return this.modelType;
        }

        public void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelOVID() {
            return this.modelOVID;
        }

        public void setModelOVID(String modelOVID) {
            this.modelOVID = modelOVID;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public ArrayList<DesignObjectsModel> getDesignObjectsModelList() {
            if (this.designObjectsModelList == null) {
                this.designObjectsModelList = new ArrayList();
            }
            return this.designObjectsModelList;
        }

        public void addDesignObjectsModel(DesignObjectsModel dom) {
            this.getDesignObjectsModelList().add(dom);
        }

        public int compareTo(Object o) {
            return SelectModelDialog.this.getName().compareToIgnoreCase(((DesignModel)o).getDesignName());
        }
    }

    public class DesignObjectsModel
    implements Comparable {
        private String objectOVID;
        private String objectType;
        private String objectName;

        public String getObjectOVID() {
            return this.objectOVID;
        }

        public void setObjectOVID(String objectOVID) {
            this.objectOVID = objectOVID;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public int compareTo(Object o) {
            return this.getObjectName().compareToIgnoreCase(((DesignObjectsModel)o).getObjectName());
        }
    }

    class DesignModelComparator
    implements Comparator {
        DesignModelComparator() {
        }

        public int compare(Object one, Object two) {
            DesignModel dm1 = (DesignModel)one;
            DesignModel dm2 = (DesignModel)two;
            String s1 = dm1.getDesignName() + dm1.getDatePublished() + dm1.getComments();
            String s2 = dm2.getDesignName() + dm2.getDatePublished() + dm2.getComments();
            return s1.compareTo(s2);
        }
    }

    class DesignObjectComparator
    implements Comparator {
        DesignObjectComparator() {
        }

        public int compare(Object one, Object two) {
            DesignObjectsModel dm1 = (DesignObjectsModel)one;
            DesignObjectsModel dm2 = (DesignObjectsModel)two;
            String s1 = dm1.getObjectName();
            String s2 = dm2.getObjectName();
            return s1.compareTo(s2);
        }
    }
}

