/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.BaseReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportsTemplatesDialog;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplatesDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SearchResultsReportsGenerationDialog
extends BaseReportsGenerationDialog {
    private String reportTitle = "Search Results";
    private MetaDataManager metaDataManager;
    private ModelIDObject currentModel;
    private static String strSelectedTrue;
    private JComboBox cmbTrue;
    private JComboBox cmbFalse;
    private JCheckBox chbReplaceBooleanValues;
    private boolean saveBooleanLists = false;
    private static String strSelectedFalse;
    private CustomReportTemplatesPersistence customReportTemplatesPersistence;
    private ReportUtils.SortedComboBoxModel cmbTrueModel;
    private ReportUtils.SortedComboBoxModel cmbFalseModel;
    private JCheckBox chbShowFilterInReport;
    private static boolean replaceBooleanValues;
    private static boolean showFilter;
    private List allSearchableProperties;
    private Class currentObjectClass;
    private JPanel customReportsTemplatesPanel;
    private JButton btnManageCustomTemplates;
    private Class clazz;
    private static final Logger LOGGER;

    public SearchResultsReportsGenerationDialog(ApplicationView appView, Class clazz, List objects, HashMap extraParams) {
        super(appView, objects, extraParams);
        this.clazz = clazz;
        this.objectsList = objects;
        this.reportTemplatesPersistence = new ReportTemplatesPersistence(appView);
        this.customReportTemplatesPersistence = new CustomReportTemplatesPersistence(appView);
        this.loadReportTemplates();
        this.loadCustomReportTemplates();
        this.mainPanel.setPreferredSize(new Dimension(460, 280));
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        this.currentModel = (ModelIDObject)extraParams.get("model");
        Object searchFilterObject = extraParams.get("filterObject");
        if (searchFilterObject != null) {
            this.currentObjectClass = ((SearchSet)searchFilterObject).getClazz();
        }
        this.extraParams.put("metadata_manager", this.metaDataManager);
        this.initCenterPanel();
        if (this.objectsList != null) {
            this.initBlankCRTSearchableProperties();
        }
        this.setCodesAndUI();
        this.txtReportTtitle.setText(this.reportTitle);
        this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(appView), "SearchResultsDetails"));
    }

    private void initCenterPanel() {
        this.standardReportsTemplatesPanel = new JPanel(new SpringLayout());
        this.standardReportsTemplatesPanel.setPreferredSize(new Dimension(400, 170));
        this.cmbStandardTemplates = new JComboBox();
        this.cmbStandardTemplates.setPreferredSize(new Dimension(315, 20));
        this.cmbStandardTemplates.setRenderer(new BaseReportsGenerationDialog.StandardComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.standardReportsTemplatesPanel.getLayout(), this.cmbStandardTemplates, 5, 5);
        this.btnManageStandardTemplates = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.btnManageStandardTemplates.setMnemonic(77);
        this.btnManageStandardTemplates.setPreferredSize(new Dimension(105, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.standardReportsTemplatesPanel.getLayout(), this.btnManageStandardTemplates, 325, 5);
        this.btnManageStandardTemplates.addActionListener(new ManageTemplatesAction());
        this.standardReportsTemplatesPanel.add(this.cmbStandardTemplates);
        this.standardReportsTemplatesPanel.add(this.btnManageStandardTemplates);
        this.customReportsTemplatesPanel = new JPanel(new SpringLayout());
        this.cmbCustomTemplates = new JComboBox();
        this.cmbCustomTemplates.setPreferredSize(new Dimension(315, 20));
        this.cmbCustomTemplates.setRenderer(new BaseReportsGenerationDialog.CustomComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbCustomTemplates, 5, 5);
        this.btnManageCustomTemplates = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.btnManageCustomTemplates.setMnemonic(77);
        this.btnManageCustomTemplates.setPreferredSize(new Dimension(105, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.btnManageCustomTemplates, 325, 5);
        this.btnManageCustomTemplates.addActionListener(new CustomReportsAction());
        this.chbReplaceBooleanValues = new JCheckBox(Messages.getString("BaseReportsGenerationDialog.ReplaceBooleanValues"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.chbReplaceBooleanValues, 5, 35);
        JLabel lblTrue = new JLabel(Messages.getString("BaseReportsGenerationDialog.True"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), lblTrue, 200, 35);
        this.cmbTrueModel = new ReportUtils.SortedComboBoxModel(arrTrue);
        this.cmbTrue = new JComboBox(this.cmbTrueModel);
        this.cmbTrue.setEnabled(false);
        this.cmbTrue.setPreferredSize(new Dimension(60, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbTrue, 240, 35);
        this.cmbTrue.setEditable(true);
        JLabel lblFalse = new JLabel(Messages.getString("BaseReportsGenerationDialog.False"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), lblFalse, 335, 35);
        this.cmbFalseModel = new ReportUtils.SortedComboBoxModel(arrFalse);
        this.cmbFalse = new JComboBox(this.cmbFalseModel);
        this.cmbFalse.setEnabled(false);
        this.cmbFalse.setPreferredSize(new Dimension(60, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbFalse, 375, 35);
        this.cmbFalse.setEditable(true);
        this.chbShowFilterInReport = new JCheckBox(Messages.getString("BaseReportsGenerationDialog.ShwoFilterInReport"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.chbShowFilterInReport, 5, 65);
        this.customReportsTemplatesPanel.add(this.cmbCustomTemplates);
        this.customReportsTemplatesPanel.add(this.btnManageCustomTemplates);
        this.customReportsTemplatesPanel.add(this.chbReplaceBooleanValues);
        this.customReportsTemplatesPanel.add(lblTrue);
        this.customReportsTemplatesPanel.add(lblFalse);
        this.customReportsTemplatesPanel.add(this.cmbTrue);
        this.customReportsTemplatesPanel.add(this.cmbFalse);
        this.customReportsTemplatesPanel.add(this.chbShowFilterInReport);
        this.templatesTabbedPane = new JTabbedPane();
        this.templatesTabbedPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportTemplates")));
        this.templatesTabbedPane.setPreferredSize(new Dimension(400, 200));
        this.templatesTabbedPane.addTab(Messages.getString("BaseReportsGenerationDialog.Custom"), this.customReportsTemplatesPanel);
        this.templatesTabbedPane.addTab(Messages.getString("BaseReportsGenerationDialog.Standard"), this.standardReportsTemplatesPanel);
        this.cmbOutFormat.removeItem("RTF");
        this.cmbOutFormat.addItem("XLS");
        this.cmbOutFormat.addItem("XLSX");
        this.templatesTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SearchResultsReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == SearchResultsReportsGenerationDialog.this.customReportsTemplatesPanel) {
                    SearchResultsReportsGenerationDialog.this.reportsPanel.add(SearchResultsReportsGenerationDialog.this.lblOutFormat);
                    SearchResultsReportsGenerationDialog.this.reportsPanel.add(SearchResultsReportsGenerationDialog.this.cmbOutFormat);
                    CommonUtil.setLabelConstraints((SpringLayout)SearchResultsReportsGenerationDialog.this.reportsPanel.getLayout(), SearchResultsReportsGenerationDialog.this.lblOutFormat, 5, 5);
                    CommonUtil.setObjectConstraints((SpringLayout)SearchResultsReportsGenerationDialog.this.reportsPanel.getLayout(), SearchResultsReportsGenerationDialog.this.cmbOutFormat, 140, 5);
                    SearchResultsReportsGenerationDialog.this.reportsPanel.repaint();
                    if (SearchResultsReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("XLS") == -1) {
                        SearchResultsReportsGenerationDialog.this.cmbOutFormat.addItem("XLS");
                    }
                    if (SearchResultsReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("XLSX") == -1) {
                        SearchResultsReportsGenerationDialog.this.cmbOutFormat.addItem("XLSX");
                    }
                } else if (SearchResultsReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == SearchResultsReportsGenerationDialog.this.standardReportsTemplatesPanel) {
                    SearchResultsReportsGenerationDialog.this.reportsPanel.remove(SearchResultsReportsGenerationDialog.this.lblOutFormat);
                    SearchResultsReportsGenerationDialog.this.reportsPanel.remove(SearchResultsReportsGenerationDialog.this.cmbOutFormat);
                    SearchResultsReportsGenerationDialog.this.reportsPanel.repaint();
                }
            }
        });
        this.mainPanel.add((Component)this.templatesTabbedPane, "Center");
    }

    private void setCodesAndUI() {
        Iterator it0;
        this.cmbStandardTemplates.removeAllItems();
        this.cmbStandardTemplates.addItem(blankRT);
        for (StandardReportTemplate rt : this.appView.getReportTemplates()) {
            if (rt.getClazz() != this.clazz) continue;
            this.cmbStandardTemplates.addItem(rt);
        }
        this.cmbStandardTemplates.updateUI();
        if (this.clazz == Table.class || this.clazz == Column.class || this.clazz == FKIndexAssociation.class || this.clazz == Index.class || this.clazz == Entity.class || this.clazz == Domain.class || this.clazz == Attribute.class || this.clazz == CandidateKey.class || this.clazz == Relation.class || this.clazz == StructuredType.class || this.clazz == TypeElement.class || this.clazz == CollectionType.class || this.clazz == DistinctType.class) {
            this.templatesTabbedPane.setEnabledAt(1, true);
            this.templatesTabbedPane.setSelectedIndex(0);
            this.btnManageStandardTemplates.setEnabled(true);
            this.cmbStandardTemplates.setEnabled(true);
        } else {
            this.templatesTabbedPane.setEnabledAt(1, false);
            this.templatesTabbedPane.setSelectedIndex(0);
            this.btnManageStandardTemplates.setEnabled(false);
            this.cmbStandardTemplates.setEnabled(false);
        }
        this.cmbCustomTemplates.removeAllItems();
        this.cmbCustomTemplates.addItem(blankCRT);
        for (CustomReportTemplate crt : this.appView.getCustomReportTemplates()) {
            if (crt.getClazz() != this.clazz) continue;
            this.cmbCustomTemplates.addItem(crt);
        }
        this.cmbCustomTemplates.updateUI();
        ArrayList<String> list = this.appView.getCRTBooleanTList();
        if (list.size() > 0) {
            this.cmbTrueModel.removeAllElements();
            it0 = list.iterator();
            while (it0.hasNext()) {
                this.cmbTrueModel.addElement(it0.next());
            }
        }
        this.cmbTrue.setSelectedItem(strSelectedTrue != null ? strSelectedTrue : "");
        this.cmbTrue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxEdited")) {
                    if (SearchResultsReportsGenerationDialog.this.cmbTrueModel.getIndexOf(SearchResultsReportsGenerationDialog.this.cmbTrue.getSelectedItem()) == -1) {
                        SearchResultsReportsGenerationDialog.this.cmbTrue.insertItemAt(SearchResultsReportsGenerationDialog.this.cmbTrue.getSelectedItem(), 0);
                        SearchResultsReportsGenerationDialog.this.saveBooleanLists = true;
                        strSelectedTrue = (String)SearchResultsReportsGenerationDialog.this.cmbTrue.getSelectedItem();
                    }
                } else if (e.getActionCommand().equals("comboBoxChanged")) {
                    strSelectedTrue = (String)SearchResultsReportsGenerationDialog.this.cmbTrue.getSelectedItem();
                }
            }
        });
        list = this.appView.getCRTBooleanFList();
        if (list.size() > 0) {
            this.cmbFalseModel.removeAllElements();
            it0 = list.iterator();
            while (it0.hasNext()) {
                this.cmbFalseModel.addElement(it0.next());
            }
        }
        this.cmbFalse.setSelectedItem(strSelectedFalse != null ? strSelectedFalse : "");
        this.cmbFalse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxEdited")) {
                    if (SearchResultsReportsGenerationDialog.this.cmbFalseModel.getIndexOf(SearchResultsReportsGenerationDialog.this.cmbFalse.getSelectedItem()) == -1) {
                        SearchResultsReportsGenerationDialog.this.cmbFalse.insertItemAt(SearchResultsReportsGenerationDialog.this.cmbFalse.getSelectedItem(), 0);
                        SearchResultsReportsGenerationDialog.this.saveBooleanLists = true;
                        strSelectedFalse = (String)SearchResultsReportsGenerationDialog.this.cmbFalse.getSelectedItem();
                    }
                } else if (e.getActionCommand().equals("comboBoxChanged")) {
                    strSelectedFalse = (String)SearchResultsReportsGenerationDialog.this.cmbFalse.getSelectedItem();
                }
            }
        });
        this.chbReplaceBooleanValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchResultsReportsGenerationDialog.this.cmbTrue.setEnabled(true);
                    SearchResultsReportsGenerationDialog.this.cmbFalse.setEnabled(true);
                    replaceBooleanValues = true;
                } else {
                    SearchResultsReportsGenerationDialog.this.cmbTrue.setEnabled(false);
                    SearchResultsReportsGenerationDialog.this.cmbFalse.setEnabled(false);
                    replaceBooleanValues = false;
                }
            }
        });
        this.chbReplaceBooleanValues.setSelected(replaceBooleanValues);
        this.chbShowFilterInReport.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                showFilter = e.getStateChange() == 1;
            }
        });
        this.chbShowFilterInReport.setSelected(showFilter);
    }

    private void initBlankCRTSearchableProperties() {
        this.allSearchableProperties = new ArrayList();
        Iterator itSRO = this.objectsList.iterator();
        if (itSRO.hasNext()) {
            SearchResultObject sro = (SearchResultObject)itSRO.next();
            this.allSearchableProperties = ReportUtils.getSearchablePropertyDescriptions(sro.getClazz(), this.metaDataManager);
        }
        blankCRT.getReportSections().clear();
        ArrayList<ReportColumn> tempList = new ArrayList<ReportColumn>();
        for (ClassDescription.PropertyDescription pd : this.allSearchableProperties) {
            ReportColumn po = new ReportColumn(pd.name, ReportUtils.getDisplayName(pd.name), 0.0, "", "", ReportConstants.isPropertyMassUpdatable(pd, this.currentModel), false, false);
            tempList.add(po);
        }
        Collections.sort(tempList, new ReportUtils.ColumnsComparator());
        ClassDescription cd = this.metaDataManager.getClassDescription(this.clazz.getName());
        ReportSection rs = new ReportSection(cd, 0, "");
        rs.setCustomName(this.clazz.getName());
        rs.getReportColumns().addAll(tempList);
        blankCRT.getReportSections().add(rs);
    }

    @Override
    protected void generateReport() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    SearchResultsReportsGenerationDialog.this.extraParams.put("out_format", (String)SearchResultsReportsGenerationDialog.this.cmbOutFormat.getSelectedItem());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("report_template", (StandardReportTemplate)SearchResultsReportsGenerationDialog.this.cmbStandardTemplates.getSelectedItem());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("custom_report_template", (CustomReportTemplate)SearchResultsReportsGenerationDialog.this.cmbCustomTemplates.getSelectedItem());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("pboolean", SearchResultsReportsGenerationDialog.this.chbReplaceBooleanValues.isSelected());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("ptrue", SearchResultsReportsGenerationDialog.this.cmbTrue.getSelectedItem());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("pfalse", SearchResultsReportsGenerationDialog.this.cmbFalse.getSelectedItem());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("reportCaption", SearchResultsReportsGenerationDialog.this.txtReportTtitle.getText());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("show", SearchResultsReportsGenerationDialog.this.chbShowFilterInReport.isSelected());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("parent", SearchResultsReportsGenerationDialog.this);
                    SearchResultsReportsGenerationDialog.this.extraParams.put("subviews", new HashMap());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("reportCustomFilenName", SearchResultsReportsGenerationDialog.this.txtReportFileName.getText());
                    SearchResultsReportsGenerationDialog.this.extraParams.put("cssFiles", "css/osddm_main.css css/osddm_vs.css");
                    SearchResultsReportsGenerationDialog.this.g = new ReportsGenerator(SearchResultsReportsGenerationDialog.this.appView);
                    if (SearchResultsReportsGenerationDialog.this.templatesTabbedPane.getSelectedIndex() == 0) {
                        if (SearchResultsReportsGenerationDialog.this.currentModel instanceof DesignPart) {
                            SearchResultsReportsGenerationDialog.this.g.createReport(SearchResultsReportsGenerationDialog.class, (DesignPart)SearchResultsReportsGenerationDialog.this.currentModel, SearchResultsReportsGenerationDialog.this.getObjectsList(), SearchResultsReportsGenerationDialog.this.extraParams);
                        } else if (SearchResultsReportsGenerationDialog.this.currentModel instanceof StorageDesign) {
                            SearchResultsReportsGenerationDialog.this.g.createReport(SearchResultsReportsGenerationDialog.class, (StorageDesign)SearchResultsReportsGenerationDialog.this.currentModel, SearchResultsReportsGenerationDialog.this.getObjectsList(), SearchResultsReportsGenerationDialog.this.extraParams);
                        }
                    } else if (SearchResultsReportsGenerationDialog.this.templatesTabbedPane.getSelectedIndex() == 1) {
                        SearchResultsReportsGenerationDialog.this.g.createReport(SearchResultsReportsGenerationDialog.this.clazz, (DesignPart)SearchResultsReportsGenerationDialog.this.currentModel, SearchResultsReportsGenerationDialog.this.getObjectsList(), SearchResultsReportsGenerationDialog.this.extraParams);
                    }
                    SearchResultsReportsGenerationDialog.this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(SearchResultsReportsGenerationDialog.this.appView), "SearchResultsDetails"));
                }
                catch (Exception e) {
                    if (SearchResultsReportsGenerationDialog.this.g != null && SearchResultsReportsGenerationDialog.this.g.getMonitor() != null) {
                        SearchResultsReportsGenerationDialog.this.g.getMonitor().close();
                    }
                    JOptionPane.showMessageDialog(SearchResultsReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                    LOGGER.error("BaseReportsGenerationDialog.generateReport() : " + e.getMessage());
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    @Override
    protected void close() {
        if (this.saveBooleanLists) {
            ArrayList<String> currentCRTT = this.appView.getCRTBooleanTList();
            currentCRTT.clear();
            for (int i = 0; i < this.cmbTrue.getItemCount(); ++i) {
                currentCRTT.add((String)this.cmbTrue.getItemAt(i));
            }
            ArrayList<String> currentCRTF = this.appView.getCRTBooleanFList();
            currentCRTF.clear();
            for (int i = 0; i < this.cmbFalse.getItemCount(); ++i) {
                currentCRTF.add((String)this.cmbFalse.getItemAt(i));
            }
            this.customReportTemplatesPersistence.saveReportTemplates();
        }
        this.getDialog().dispose();
    }

    private void loadCustomReportTemplates() {
        if (!ctrLoaded) {
            this.customReportTemplatesPersistence.loadCustomReportTemplates(this.appView);
            ctrLoaded = true;
        }
    }

    private List getObjectsList() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.templatesTabbedPane.getSelectedIndex() == 1) {
            for (SearchResultObject ro : this.objectsList) {
                Object obj = ro.getObj();
                Object object = null;
                object = obj instanceof Index || obj instanceof CandidateKey ? ((KeyObject)obj).getContainerObject() : (obj instanceof Column || obj instanceof Attribute ? ((ContainedObject)obj).getContainer() : (obj instanceof TypeElement ? ((TypeElement)obj).getStructuredType() : (obj instanceof Relation ? ((Relation)obj).getSourceEntity() : (obj instanceof FKIndexAssociation ? ((FKIndexAssociation)obj).getTable() : obj))));
                if (l.contains(object)) continue;
                l.add(object);
            }
        } else if (this.templatesTabbedPane.getSelectedIndex() == 0) {
            for (SearchResultObject ro : this.objectsList) {
                Object obj = ro.getObj();
                boolean add = false;
                if (l.size() == 0) {
                    l.add(ro);
                    continue;
                }
                for (SearchResultObject searchResultObject : l) {
                    Object obj1 = searchResultObject.getObj();
                    if (obj == obj1) {
                        add = false;
                        break;
                    }
                    add = true;
                }
                if (!add) continue;
                l.add(ro);
            }
            return l;
        }
        return l;
    }

    static {
        LOGGER = new Logger(SearchResultsReportsGenerationDialog.class);
    }

    private class ManageTemplatesAction
    implements ActionListener {
        private ManageTemplatesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportTemplatesDialog dialog = new StandardReportTemplatesDialog(SearchResultsReportsGenerationDialog.this.appView, SearchResultsReportsGenerationDialog.this, SearchResultsReportsGenerationDialog.this.clazz, SearchResultsReportsGenerationDialog.this.reportTemplatesPersistence);
            dialog.showDialog();
        }
    }

    private class CustomReportsAction
    implements ActionListener {
        private CustomReportsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomReportsTemplatesDialog dialog = new CustomReportsTemplatesDialog(SearchResultsReportsGenerationDialog.this.appView, SearchResultsReportsGenerationDialog.this.clazz, SearchResultsReportsGenerationDialog.this, SearchResultsReportsGenerationDialog.this.customReportTemplatesPersistence, SearchResultsReportsGenerationDialog.this.allSearchableProperties, SearchResultsReportsGenerationDialog.this.currentModel, SearchResultsReportsGenerationDialog.this.currentObjectClass, SearchResultsReportsGenerationDialog.this.objectsList);
            dialog.showDialog();
        }
    }
}

