/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTabularView;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTabularViewReportDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.printing.PDFExporter;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.BaseReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSeparateFiles;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSingleFile;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.SaxonLoader;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportsGenerator {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
    private ToStringComparator toStringComparator = new ToStringComparator();
    private final String SHOW = "show";
    private String reportsPath;
    private String reportFileName = "";
    private File xsltFile = null;
    private ApplicationView appView;
    private ProgressDialog monitor;
    private String saxonPath;
    private List<String> generatedDiagramsNamesListPerModel = new ArrayList<String>();
    private MetaDataManager metaDataManager;
    private HashMap<DesignPartViewPlaceHolder, List<String>> subviewsMap;
    private Component parent;
    private List<DesignPartViewPlaceHolder> diagramsToBeClosedList = new ArrayList<DesignPartViewPlaceHolder>();
    String modelExtraFilesDirName = "";
    private String reportFilesDirName;
    private String fileFormat;
    private Design design;
    private String reportCaption = "";
    private String customReportFileName = "";
    private boolean clearDiagrams;
    private DesignPartViewPlaceHolder lastDiagram;
    int openedDiagramscounter = 0;
    private Boolean replaceBooleanValues;
    private String strTrue;
    private String strFalse;
    private List currentObjectsList;
    private HashMap extraParams;
    private ModelIDObject model;
    private Settings settings;
    private LinkedHashMap dpvToSVGSuffixMap = new LinkedHashMap();
    private String cssFiles = "";
    private int wordWrappedRowsCount = 0;
    private StandardReportTemplate reportTemplate;
    private LinkedHashMap<String, List> swObjectsMap;
    private static final Logger LOGGER = new Logger(ReportsGenerator.class);

    public ReportsGenerator(ApplicationView appView) {
        this.appView = appView;
        this.settings = appView.getSettings();
        this.saxonPath = this.settings.getDefaultSaxonPath();
    }

    public void createReport(Class clazz, ModelIDObject model, List objects, HashMap extraParams) {
        this.createReport(clazz, model, objects, extraParams, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(Class clazz, ModelIDObject model, List objects, HashMap extraParams, OutputStream outStream) {
        block187: {
            Document doc = null;
            File outputFile = null;
            String tocTagName = "";
            this.reportTemplate = (StandardReportTemplate)extraParams.get("report_template");
            CustomReportTemplate customReportTemplate = (CustomReportTemplate)extraParams.get("custom_report_template");
            this.metaDataManager = this.appView.getXMLTransformationManager().getMetaDataManager();
            this.model = model;
            if (model != null) {
                this.modelExtraFilesDirName = model.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + model.getShortObjectID();
                this.design = model.getDesign();
            }
            this.extraParams = extraParams;
            this.reportsPath = ReportUtils.getReportsPath(this.appView);
            this.fileFormat = ((String)extraParams.get("out_format")).toLowerCase();
            this.subviewsMap = (HashMap)extraParams.get("subviews");
            this.parent = (Component)extraParams.get("parent");
            this.reportCaption = (String)extraParams.get("reportCaption");
            this.replaceBooleanValues = (Boolean)extraParams.get("pboolean");
            this.strTrue = (String)extraParams.get("ptrue");
            this.strFalse = (String)extraParams.get("pfalse");
            this.customReportFileName = ((String)extraParams.get("reportCustomFilenName")).trim();
            Object obj = extraParams.get("clearDiagrams");
            if (obj != null) {
                this.clearDiagrams = (Boolean)obj;
            }
            this.cssFiles = (String)extraParams.get("cssFiles");
            String xsltVersion = "";
            xsltVersion = this.saxonPath != null && !this.saxonPath.equals("") ? "20" : "10";
            this.currentObjectsList = new ArrayList();
            this.swObjectsMap = new LinkedHashMap();
            this.monitor = ApplicationView.isGUIMode() ? new ProgressDialog(this.appView, "", 0, 100, false, false) : new ProgressDialog.NullProgressDialog(this.appView, "", 0, 100);
            this.monitor.setNote(Messages.getString("ReportsGenerationDialog.GatherData"));
            this.monitor.setProgress(1);
            this.monitor.setProgress(5);
            if (clazz == Table.class || clazz == Column.class || clazz == FKIndexAssociation.class || clazz == Index.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleTableDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleTableData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = ApplicationView.isGUIMode() ? new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleTableDetails_" + this.fileFormat + ".xslt") : new File(ApplicationView.dmInternalsDistDir, "reports/xslt/" + xsltVersion + "/SingleTableDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherAllTablesData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = ApplicationView.isGUIMode() ? new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllTablesDetails_" + this.fileFormat + ".xslt") : new File(ApplicationView.dmInternalsDistDir, "reports/xslt/" + xsltVersion + "/AllTablesDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "TableName";
                }
            } else if (clazz == TableView.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleTableViewDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleTableViewData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = ApplicationView.isGUIMode() ? new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleTableViewDetails_" + this.fileFormat + ".xslt") : new File(ApplicationView.dmInternalsDistDir, "reports/xslt/" + xsltVersion + "/SingleTableViewDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesViewsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherAllTablesViewsData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = ApplicationView.isGUIMode() ? new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllTablesViewsDetails_" + this.fileFormat + ".xslt") : new File(ApplicationView.dmInternalsDistDir, "reports/xslt/" + xsltVersion + "/AllTablesViewsDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "ViewName";
                }
            } else if (clazz == Entity.class || clazz == Attribute.class || clazz == CandidateKey.class || clazz == Relation.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleEntityDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleEntityData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleEntityDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllEntitiesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherAllEntitiesData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllEntitiesDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "EntityName";
                }
            } else if (clazz == EntityView.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleEntityViewDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleEntityViewData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleEntityViewDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllEntitiesViewsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherAllEntitiesViewsData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllEntitiesViewsDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "ViewName";
                }
            } else if (clazz == StructuredType.class || clazz == TypeElement.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleStructuredTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleStructuredTypeData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleStructuredTypeDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllStructuredTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherAllStructuredTypesData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllStructuredTypesDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "STName";
                }
            } else if (clazz == CollectionType.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleCollectionTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleCollectionTypeData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleCollectionTypeDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllCollectionTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllCollectionTypesData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllCollectionTypesDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "CTName";
                }
            } else if (clazz == DistinctType.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleDistinctTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleDistinctTypeData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleDistinctTypeDetails_" + this.fileFormat + ".xslt");
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllDistinctTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllDistinctTypesData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllDistinctTypesDetails_" + this.fileFormat + ".xslt");
                    tocTagName = "DTName";
                }
            } else if (clazz == Domain.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllDomainsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherAllDomainsData((DesignPart)model, this.reportTemplate, objects);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllDomainsDetails_" + this.fileFormat + ".xslt");
                tocTagName = "DomainName";
            } else if (clazz == Glossary.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "GlossaryDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                Glossary glossary = (Glossary)extraParams.get("glossary");
                if (glossary != null) {
                    doc = this.gatherGlossaryData(glossary);
                }
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/GlossaryDetails_" + this.fileFormat + ".xslt");
            } else if (clazz == ChangeRequest.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "ChangeRequestsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherChangeRequestsData((DesignPart)model, this.reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/ChangeRequestsDetails_" + this.fileFormat + ".xslt");
                tocTagName = "CRName";
            } else if (clazz == Measurement.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "MeasurementsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherMeasurementsData((DesignPart)model, this.reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/MeasurementsDetails_" + this.fileFormat + ".xslt");
            } else if (clazz == SearchResultsReportsGenerationDialog.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SearchResultsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                if (this.fileFormat.equals("XLS".toLowerCase())) {
                    this.generateSearchResultsXLSFile(customReportTemplate, objects, extraParams);
                } else if (this.fileFormat.equals("XLSX".toLowerCase())) {
                    this.generateSearchResultsXLSXFile(customReportTemplate, objects, extraParams);
                } else {
                    doc = this.generateSearchResultsDomDocument(customReportTemplate, model, objects, extraParams);
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SearchResults_" + this.fileFormat + ".xslt");
                }
                tocTagName = "v1";
            } else if (clazz == CompareTabularViewReportDialog.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "ObjectsComparison") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherObjComparisonData(objects, extraParams);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/ObjectsComparison_" + this.fileFormat + ".xslt");
            } else if (clazz == UserDefinedProperty.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "UserDefinedProperties") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherUDPData((DesignPart)model, this.reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/UserDefinedProperties_" + this.fileFormat + ".xslt");
            }
            this.monitor.setNote("Generating report ...");
            outputFile = new File(this.reportsPath, this.reportFileName);
            BufferedReader xmlISR = null;
            BufferedReader xsltISR = null;
            OutputStreamWriter xmlOSW = null;
            OutputStreamWriter osw = null;
            PrintWriter htmlIDXPW = null;
            PrintWriter htmlTOCPW = null;
            ArrayList<String> diagramsNameList = new ArrayList<String>();
            try {
                if (this.fileFormat.equals("XLS".toLowerCase()) || this.fileFormat.equals("XLSX".toLowerCase())) break block187;
                if (doc != null) {
                    this.monitor.setProgress(40);
                    DOMSource source = new DOMSource(doc);
                    File rawXMLFile = null;
                    rawXMLFile = ApplicationView.isGUIMode() ? new File(this.reportsPath, "report_data.xml") : new File(this.reportsPath, "report_data" + System.currentTimeMillis() + ".xml");
                    Transformer xformer = MDTransformer.transformerFactory().newTransformer();
                    xformer.setOutputProperty("encoding", "UTF-8");
                    xformer.setOutputProperty("indent", "yes");
                    xformer.setOutputProperty("cdata-section-elements", "SelectStatement");
                    xmlOSW = new OutputStreamWriter((OutputStream)new FileOutputStream(rawXMLFile), "UTF-8");
                    xformer.transform(source, new StreamResult(xmlOSW));
                    xmlOSW.flush();
                    if (this.xsltFile.exists()) {
                        this.monitor.setProgress(50);
                        xmlISR = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rawXMLFile), "UTF-8"));
                        StreamSource xmlSource = new StreamSource(xmlISR);
                        xsltISR = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.xsltFile), "UTF-8"));
                        StreamSource xsltSource = new StreamSource(xsltISR);
                        if (((String)extraParams.get("out_format")).equals("PDF")) {
                            this.createPDFReport();
                            this.monitor.setProgress(100);
                            this.monitor.close();
                            ApplicationView.log(Messages.getString("ReportsGenerationDialog.RenderingPDFReport"));
                            JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.PDFRenderingStarted"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                            break block187;
                        }
                        if (this.saxonPath != null && !this.saxonPath.equals("")) {
                            SaxonLoader saxonClassLoader = SaxonLoader.getInstance(this.saxonPath);
                            TransformerFactory transFact = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", saxonClassLoader);
                            MDTransformer.secureTransformerFactory(transFact);
                            Transformer trans = transFact.newTransformer(xsltSource);
                            if (this.cssFiles.trim() != "") {
                                String paramName = "p";
                                int c = 0;
                                for (String string : Arrays.asList(this.cssFiles.split("\\s+"))) {
                                    trans.setParameter(paramName + ++c, string);
                                }
                            }
                            trans.setOutputProperty("encoding", "UTF-8");
                            trans.setOutputProperty("cdata-section-elements", "SelectStatement");
                            trans.transform(xmlSource, new StreamResult(outputFile));
                        } else {
                            TransformerFactory transFact = MDTransformer.transformerFactory();
                            MDTransformer.secureTransformerFactory(transFact);
                            Transformer trans = transFact.newTransformer(xsltSource);
                            if (this.cssFiles.trim() != "") {
                                String paramName = "p";
                                int c = 0;
                                for (String s : Arrays.asList(this.cssFiles.split("\\s+"))) {
                                    trans.setParameter(paramName + ++c, s);
                                }
                            }
                            trans.setOutputProperty("encoding", "UTF-8");
                            trans.setOutputProperty("cdata-section-elements", "SelectStatement");
                            if (outStream == null) {
                                FileOutputStream fos = new FileOutputStream(outputFile);
                                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                trans.transform(xmlSource, new StreamResult(osw));
                                osw.flush();
                                fos.close();
                            }
                        }
                        if (ApplicationView.isGUIMode() && ((String)extraParams.get("out_format")).equals("HTML")) {
                            String repPath;
                            String basePath = Paths.get(ApplicationView.basePath + "/reports", new String[0]).toString();
                            if (!basePath.equals(repPath = Paths.get(this.reportsPath, new String[0]).toString())) {
                                try {
                                    Path jsP;
                                    Path imgP;
                                    Path cssP = Paths.get(this.reportsPath, "/css");
                                    if (!Files.exists(cssP, new LinkOption[0])) {
                                        FileUtils.copyFolder(Paths.get(ApplicationView.basePath, "reports/css"), cssP);
                                    }
                                    if (!Files.exists(imgP = Paths.get(this.reportsPath, "/img"), new LinkOption[0])) {
                                        FileUtils.copyFolder(Paths.get(ApplicationView.basePath, "reports/img"), imgP);
                                    }
                                    if (!Files.exists(jsP = Paths.get(this.reportsPath, "/js"), new LinkOption[0])) {
                                        FileUtils.copyFolder(Paths.get(ApplicationView.basePath, "reports/js"), jsP);
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error when trying to copy CSS, image and js files in reporting directory", e);
                                }
                            }
                            ArrayList<ModelIDObject> objList = new ArrayList<ModelIDObject>();
                            if (clazz != Measurement.class && clazz != SearchResultsReportsGenerationDialog.class) {
                                for (Object objt : objects) {
                                    Object obj3;
                                    if (objt instanceof ModelIDObject) {
                                        ModelIDObject mObj = (ModelIDObject)objt;
                                        objList.add(mObj);
                                        continue;
                                    }
                                    if (!(objt instanceof SearchResultObject) || !((obj3 = ((SearchResultObject)objt).getObj()) instanceof ModelIDObject)) continue;
                                    ModelIDObject modelIDObject = (ModelIDObject)obj3;
                                    objList.add(modelIDObject);
                                }
                            }
                            StringBuffer diagrams = new StringBuffer();
                            if (this.settings.isEmbedDiagramsInReports() && clazz == Table.class || clazz == TableView.class || clazz == Entity.class || clazz == EntityView.class) {
                                ArrayList<DesignPartView> allDiagrams;
                                DesignPart dp = ((DesignObject)objList.get(0)).getDesignPart();
                                if (dp instanceof RelationalDesign) {
                                    allDiagrams = new ArrayList<DesignPartView>();
                                    for (DesignPartView dpv : ((RelationalDesign)dp).getAllDiagrams()) {
                                        List dList = ReportsGenerator.getDisplays(dpv);
                                        allDiagrams.add(dpv);
                                        allDiagrams.addAll(dList);
                                    }
                                    Iterator allDiagramsIt = allDiagrams.iterator();
                                    block75: while (allDiagramsIt.hasNext()) {
                                        DPVRelational dpv = (DPVRelational)((DesignPartView)allDiagramsIt.next());
                                        if (dpv.isMainDiagram() && !this.settings.isEmbedMainDiagramInReports()) continue;
                                        boolean objPresentInDiagram = false;
                                        for (TopView tv : dpv.getTVTablesAndTVViews()) {
                                            ContainerObject co = (ContainerObject)tv.getModel();
                                            DesignObject designObject = (DesignObject)objList.get(0);
                                            if (designObject instanceof ContainedObject) {
                                                for (ContainedObject ctObj : co.getElementsCollection()) {
                                                    if (!objList.contains(ctObj)) continue;
                                                    objPresentInDiagram = true;
                                                    break;
                                                }
                                            } else {
                                                objPresentInDiagram = objList.contains(co);
                                            }
                                            if (!objPresentInDiagram) continue;
                                            break;
                                        }
                                        if (this.dpvToSVGSuffixMap == null) continue;
                                        String suff = (String)this.dpvToSVGSuffixMap.get(dpv);
                                        if (!objPresentInDiagram || suff == null) continue;
                                        if (this.subviewsMap.size() > 0) {
                                            if (this.reportTemplate.isUseDiagrams()) {
                                                diagrams.append("<br><br>");
                                                diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                                diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, suff));
                                                diagrams.append("<br><hr>");
                                                diagramsNameList.add(dpv.getName());
                                                continue;
                                            }
                                            for (Map.Entry<DesignPartViewPlaceHolder, List<String>> entry : this.subviewsMap.entrySet()) {
                                                DesignPartViewPlaceHolder sw = entry.getKey();
                                                if (!sw.getDesignPartView().getName().equals(dpv.getName())) continue;
                                                diagrams.append("<br><br>");
                                                diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                                diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, suff));
                                                diagrams.append("<br><hr>");
                                                diagramsNameList.add(dpv.getName());
                                                continue block75;
                                            }
                                            continue;
                                        }
                                        diagrams.append("<br><br>");
                                        diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                        diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, suff));
                                        diagrams.append("<br><hr>");
                                        diagramsNameList.add(dpv.getName());
                                    }
                                } else if (dp instanceof LogicalDesign) {
                                    allDiagrams = new ArrayList();
                                    for (DesignPartView dpv : ((LogicalDesign)dp).getAllDiagrams()) {
                                        List dList = ReportsGenerator.getDisplays(dpv);
                                        allDiagrams.add(dpv);
                                        allDiagrams.addAll(dList);
                                    }
                                    Iterator allDiagramsIt = allDiagrams.iterator();
                                    block80: while (allDiagramsIt.hasNext()) {
                                        DPVLogical dpv = (DPVLogical)((DesignPartView)allDiagramsIt.next());
                                        if (dpv.isMainDiagram() && !this.settings.isEmbedMainDiagramInReports()) continue;
                                        boolean objPresentInDiagram = false;
                                        for (TopView tv : dpv.getTVEntitiesAndTVViews()) {
                                            ContainerObject co = (ContainerObject)tv.getModel();
                                            DesignObject designObject = (DesignObject)objList.get(0);
                                            if (designObject instanceof ContainedObject) {
                                                for (ContainedObject ctObj : co.getElementsCollection()) {
                                                    if (!objList.contains(ctObj)) continue;
                                                    objPresentInDiagram = true;
                                                    break;
                                                }
                                            } else {
                                                objPresentInDiagram = objList.contains(co);
                                            }
                                            if (!objPresentInDiagram) continue;
                                            break;
                                        }
                                        if (this.dpvToSVGSuffixMap == null) continue;
                                        String suff = (String)this.dpvToSVGSuffixMap.get(dpv);
                                        if (!objPresentInDiagram || suff == null) continue;
                                        if (this.subviewsMap.size() > 0) {
                                            if (this.reportTemplate.isUseDiagrams()) {
                                                diagrams.append("<br><br>");
                                                diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                                diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, suff));
                                                diagrams.append("<br><hr>");
                                                diagramsNameList.add(dpv.getName());
                                                continue;
                                            }
                                            for (Map.Entry<DesignPartViewPlaceHolder, List<String>> entry : this.subviewsMap.entrySet()) {
                                                DesignPartViewPlaceHolder sw = entry.getKey();
                                                if (!sw.getDesignPartView().getName().equals(dpv.getName())) continue;
                                                diagrams.append("<br><br>");
                                                diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                                diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, suff));
                                                diagrams.append("<br><hr>");
                                                diagramsNameList.add(dpv.getName());
                                                continue block80;
                                            }
                                            continue;
                                        }
                                        diagrams.append("<br><br>");
                                        diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                        diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, suff));
                                        diagrams.append("<br><hr>");
                                        diagramsNameList.add(dpv.getName());
                                    }
                                } else if (dp instanceof DataTypesDesign) {
                                    block84: for (DPVDataTypes dPVDataTypes : ((DataTypesDesign)model).getAllDiagrams()) {
                                        if (dPVDataTypes.isMainDiagram() && !this.settings.isEmbedMainDiagramInReports()) continue;
                                        boolean objPresentInDiagram = false;
                                        for (TopView tv : dPVDataTypes.getTVStructuredTypes()) {
                                            StructuredType st = (StructuredType)tv.getModel();
                                            DesignObject dObj = (DesignObject)objList.get(0);
                                            if (dObj instanceof ContainedObject) {
                                                for (ContainedObject containedObject : Arrays.asList(st.getElements())) {
                                                    if (!objList.contains(containedObject)) continue;
                                                    objPresentInDiagram = true;
                                                    break;
                                                }
                                            } else {
                                                objPresentInDiagram = objList.contains(st);
                                            }
                                            if (!objPresentInDiagram) continue;
                                            break;
                                        }
                                        if (this.dpvToSVGSuffixMap == null) continue;
                                        String suff = (String)this.dpvToSVGSuffixMap.get(dPVDataTypes);
                                        if (!objPresentInDiagram || suff == null) continue;
                                        if (this.subviewsMap.size() > 0) {
                                            if (this.reportTemplate.isUseDiagrams()) {
                                                diagrams.append("<br><br>");
                                                diagrams.append("<h3 id=\"" + dPVDataTypes.getName() + "\">").append(dPVDataTypes.getName()).append("</h3>");
                                                diagrams.append(DiagramToSVG.getSVGForDiagram(dPVDataTypes, true, suff));
                                                diagrams.append("<br><hr>");
                                                diagramsNameList.add(dPVDataTypes.getName());
                                                continue;
                                            }
                                            for (Map.Entry<DesignPartViewPlaceHolder, List<String>> pair : this.subviewsMap.entrySet()) {
                                                DesignPartViewPlaceHolder sw = pair.getKey();
                                                if (!sw.getDesignPartView().getName().equals(dPVDataTypes.getName())) continue;
                                                diagrams.append("<br><br>");
                                                diagrams.append("<h3 id=\"" + dPVDataTypes.getName() + "\">").append(dPVDataTypes.getName()).append("</h3>");
                                                diagrams.append(DiagramToSVG.getSVGForDiagram(dPVDataTypes, true, suff));
                                                diagrams.append("<br><hr>");
                                                diagramsNameList.add(dPVDataTypes.getName());
                                                continue block84;
                                            }
                                            continue;
                                        }
                                        diagrams.append("<br><br>");
                                        diagrams.append("<h3 id=\"" + dPVDataTypes.getName() + "\">").append(dPVDataTypes.getName()).append("</h3>");
                                        diagrams.append(DiagramToSVG.getSVGForDiagram(dPVDataTypes, true, suff));
                                        diagrams.append("<br><hr>");
                                        diagramsNameList.add(dPVDataTypes.getName());
                                    }
                                }
                            }
                            if (this.settings.isGenerateHTMLReportTOCInSeparateFile() && objList.size() > 0) {
                                if (!tocTagName.equals("")) {
                                    String htmlIndexFileName = this.reportFileName.substring(0, this.reportFileName.indexOf(".")) + "_index" + this.reportFileName.substring(this.reportFileName.indexOf("."), this.reportFileName.length());
                                    String htmlContentsFileName = this.reportFileName.substring(0, this.reportFileName.indexOf(".")) + "_toc" + this.reportFileName.substring(this.reportFileName.indexOf("."), this.reportFileName.length());
                                    htmlIDXPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.reportsPath, htmlIndexFileName)), "UTF-8"));
                                    htmlIDXPW.print(HTMLReportSeparateFiles.createHTMLIndexPage(htmlContentsFileName, this.reportFileName));
                                    htmlIDXPW.flush();
                                    htmlIDXPW.close();
                                    htmlTOCPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.reportsPath, htmlContentsFileName)), "UTF-8"));
                                    htmlTOCPW.print(HTMLReportSeparateFiles.createHTMLTOCPage(this.reportFileName, objList, this.settings, diagramsNameList, false));
                                    htmlTOCPW.flush();
                                    htmlTOCPW.close();
                                    this.reportFileName = htmlIndexFileName;
                                }
                                HTMLReportSeparateFiles.editHTMLDataPage(outputFile, diagrams.toString(), null, this.settings, false);
                            } else {
                                HTMLReportSingleFile html = new HTMLReportSingleFile(outputFile, null, objList, diagrams.toString(), this.settings, diagramsNameList, false);
                                html.createReport();
                            }
                        }
                        this.monitor.setProgress(100);
                        this.monitor.close();
                        if (ApplicationView.isGUIMode()) {
                            boolean openReport = false;
                            if (Desktop.isDesktopSupported()) {
                                JOptionPane.showMessageDialog(this.parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV1"), this.reportFileName, this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                openReport = true;
                            } else {
                                JOptionPane.showMessageDialog(this.parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV2"), this.reportFileName, this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                            }
                            if (openReport) {
                                Desktop.getDesktop().open(new File(this.reportsPath, this.reportFileName));
                            }
                        } else if (rawXMLFile != null && rawXMLFile.exists()) {
                            rawXMLFile.delete();
                        }
                        break block187;
                    }
                    LOGGER.error("Required XSLT file " + this.xsltFile.getAbsolutePath() + " for report generation not found. Process is terminated.");
                    JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                    break block187;
                }
                JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
            }
            catch (TransformerConfigurationException e) {
                LOGGER.error("TransformerConfigurationException during report generation " + e.getMessage(), e);
                JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
            }
            catch (TransformerException e) {
                LOGGER.error("TransformerException during report generation" + e.getMessage(), e);
                JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
            }
            catch (FileNotFoundException e) {
                if (e.getMessage().contains("Access is denied")) {
                    JOptionPane.showMessageDialog(this.parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), e.getMessage()), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                    LOGGER.error("FileNotFoundException during report generation " + e.getMessage(), e);
                } else {
                    JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                    LOGGER.error("FileNotFoundException during report generation " + e.getMessage(), e);
                }
            }
            catch (IOException e) {
                LOGGER.error("IOException during report generation " + e.getMessage(), e);
                JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.error("IOException during report generation " + e.getMessage(), e);
                JOptionPane.showMessageDialog(this.parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
            }
            finally {
                if (xmlOSW != null) {
                    try {
                        xmlOSW.flush();
                        xmlOSW.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + e.getMessage(), e);
                    }
                }
                if (osw != null) {
                    try {
                        osw.flush();
                        if (outStream == null) {
                            osw.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + this.reportFileName + ": " + e.getMessage(), e);
                    }
                }
                if (htmlIDXPW != null) {
                    htmlIDXPW.close();
                }
                if (htmlTOCPW != null) {
                    htmlTOCPW.close();
                }
                if (xmlISR != null) {
                    try {
                        xmlISR.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close the buffered reader : " + e.getMessage(), e);
                    }
                }
                if (xsltISR != null) {
                    try {
                        xsltISR.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT file : " + e.getMessage(), e);
                    }
                }
                this.monitor.close();
            }
        }
    }

    private Document gatherSingleTableData(DesignPart model, StandardReportTemplate reportTemplate, List tables) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/table", "osdmSingleTable:Table");
            document.appendChild(rootElement);
            String namespace = "osdmSingleTable:";
            this.createHeaderSection(document, namespace, rootElement);
            Table table = (Table)tables.get(0);
            if (reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                this.generateDiagrams(null, table);
            }
            this.currentObjectsList.add(table);
            this.createTableDetailsSection(document, namespace, rootElement, table);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single table report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleEntityData(DesignPart model, StandardReportTemplate reportTemplate, List entities) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entity", "osdmSingleEntity:Entity");
            document.appendChild(rootElement);
            String namespace = "osdmSingleEntity:";
            this.createHeaderSection(document, namespace, rootElement);
            Entity entity = (Entity)entities.get(0);
            if (reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                this.generateDiagrams(null, entity);
            }
            this.currentObjectsList.add(entity);
            this.createEntityDetailsSection(document, namespace, rootElement, entity);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single entity report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllEntitiesData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List entities) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entities", "osdmAllEntities:Entities");
            document.appendChild(rootElement);
            String namespace = "osdmAllEntities:";
            this.createHeaderSection(document, namespace, rootElement);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, entities);
            Element entitiesCollection = document.createElement(namespace + "EntitiesCollection");
            rootElement.appendChild(entitiesCollection);
            if (entities.size() > 0) {
                this.currentObjectsList = entities;
            } else {
                Iterator it0 = ((LogicalDesign)model).getEntitySet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (Entity entity : this.currentObjectsList) {
                Element entityDetails = document.createElement(namespace + "EntityDetails");
                entitiesCollection.appendChild(entityDetails);
                this.createEntityDetailsSection(document, namespace, entityDetails, entity);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all entities report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllTablesData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List tables) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tables", "osdmAllTables:Tables");
            document.appendChild(rootElement);
            String namespace = "osdmAllTables:";
            this.createHeaderSection(document, namespace, rootElement);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, tables);
            Element tablesCollection = document.createElement(namespace + "TablesCollection");
            rootElement.appendChild(tablesCollection);
            if (reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                this.generateDiagrams(model, null);
            }
            if (tables.size() != 0) {
                this.currentObjectsList = tables;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (Table table : this.currentObjectsList) {
                Element tableDetails = document.createElement(namespace + "TableDetails");
                tablesCollection.appendChild(tableDetails);
                this.createTableDetailsSection(document, namespace, tableDetails, table);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherGlossaryData(Glossary glossary) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/glossary", "osdmGlossary:Glossary");
            document.appendChild(rootElement);
            String namespace = "osdmGlossary:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element e = document.createElement(namespace + "GlossaryName");
            e.appendChild(document.createTextNode(glossary.getName()));
            rootElement.appendChild(e);
            String description = glossary.getDescription();
            Element descriptionElement = document.createElement(namespace + "Description");
            descriptionElement.appendChild(document.createCDATASection(description));
            rootElement.appendChild(descriptionElement);
            e = document.createElement(namespace + "FileName");
            e.appendChild(document.createTextNode(glossary.getFileName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "IncompleteModifiers");
            e.appendChild(document.createTextNode(glossary.isIncompleteModifiers() ? "Y" : ""));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CaseSensitive");
            e.appendChild(document.createTextNode(glossary.isCaseSensitive() ? "Y" : ""));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "UniqueAbbreviations");
            e.appendChild(document.createTextNode(glossary.isUniqueAbbreviations() ? "Y" : ""));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "SeparatorType");
            e.appendChild(document.createTextNode(glossary.getSeparatorType()));
            rootElement.appendChild(e);
            String sepChar = "";
            sepChar = glossary.getSeparatorType().equalsIgnoreCase("SPACE") ? " " : String.valueOf(glossary.getMW_SeparatorChar());
            e = document.createElement(namespace + "SeparatorChar");
            e.appendChild(document.createTextNode(sepChar));
            rootElement.appendChild(e);
            int gCounter = 0;
            Element glossaryCollection = null;
            for (GlossaryWord word : glossary.getWords()) {
                if (gCounter == 0) {
                    glossaryCollection = document.createElement(namespace + "GlossaryCollection");
                    rootElement.appendChild(glossaryCollection);
                }
                Element glossaryDetail = document.createElement(namespace + "GlossaryDetail");
                glossaryCollection.appendChild(glossaryDetail);
                e = document.createElement(namespace + "TermName");
                e.appendChild(document.createTextNode(word.getName()));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "Plural");
                e.appendChild(document.createTextNode(word.getPlural()));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "Abbreviation");
                e.appendChild(document.createTextNode(word.getAbbreviation()));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "AltAbbreviation");
                e.appendChild(document.createTextNode(word.getAltAbbrevation()));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "P");
                e.appendChild(document.createTextNode(word.isPrimaryWord() ? "Y" : ""));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "C");
                e.appendChild(document.createTextNode(word.isClassWord() ? "Y" : ""));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "M");
                e.appendChild(document.createTextNode(word.isModifier() ? "Y" : ""));
                glossaryDetail.appendChild(e);
                e = document.createElement(namespace + "Q");
                e.appendChild(document.createTextNode(word.isQualifier() ? "Y" : ""));
                glossaryDetail.appendChild(e);
                String sDescription = word.getShortDescription();
                if (sDescription != "" && sDescription != null) {
                    Element sDescriptionElement = document.createElement(namespace + "SDescription");
                    sDescriptionElement.appendChild(document.createCDATASection(sDescription));
                    glossaryDetail.appendChild(sDescriptionElement);
                }
                ++gCounter;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during glossary report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllDomainsData(DesignPart model, StandardReportTemplate reportTemplate, List domains) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/domains", "osdmAllDomains:Domains");
            document.appendChild(rootElement);
            String namespace = "osdmAllDomains:";
            this.createHeaderSection(document, namespace, rootElement);
            if (domains.size() != 0) {
                this.currentObjectsList = domains;
            } else {
                Iterator it0 = this.design.getDomainSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            int domCounter = 0;
            Element domainsCollection = null;
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (Domain currDomain : this.currentObjectsList) {
                if (domCounter == 0) {
                    domainsCollection = document.createElement(namespace + "DomainsCollection");
                    rootElement.appendChild(domainsCollection);
                }
                Element domainDetails = document.createElement(namespace + "DomainDetails");
                domainsCollection.appendChild(domainDetails);
                Element e = document.createElement(namespace + "DomainName");
                e.appendChild(document.createTextNode(currDomain.getName()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedName");
                e.appendChild(document.createTextNode(currDomain.getShortObjectID()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "Synonyms");
                e.appendChild(document.createTextNode(currDomain.getSynonym()));
                domainDetails.appendChild(e);
                String dataType = this.getSizePrecisionScale(currDomain, currDomain.getLogicalDatatype().getName());
                e = document.createElement(namespace + "DataType");
                e.appendChild(document.createTextNode(dataType));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "LogicalType");
                e.appendChild(document.createTextNode(currDomain.getLogicalDatatype().getName()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "UnitOfMeasure");
                e.appendChild(document.createTextNode(currDomain.getUnitOfMeasure()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "DefaultValue");
                e.appendChild(document.createTextNode(currDomain.getDefaultValue()));
                domainDetails.appendChild(e);
                String description = "";
                description = currDomain.getComment() == null || currDomain.getComment().equals("") ? currDomain.getCommentInRDBMS() : currDomain.getComment();
                if (description != "" && description != null) {
                    Element domainCommentElement = document.createElement(namespace + "DomainComment");
                    domainCommentElement.appendChild(document.createCDATASection(description));
                    domainDetails.appendChild(domainCommentElement);
                }
                if (reportTemplate.isUseDomainConstraints()) {
                    Element rangesCollection = null;
                    if (currDomain.getAVTs().size() > 0 || currDomain.getValueList() != null || currDomain.getCheck() != null) {
                        CheckConstraint ccConstraint;
                        Element constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                        domainDetails.appendChild(constraintsCollection);
                        Element constraintsdetails = document.createElement(namespace + "ConstraintDetails");
                        constraintsCollection.appendChild(constraintsdetails);
                        Iterator itRanges = currDomain.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintsdetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (currDomain.getValueList() != null) {
                            Iterator itVL = currDomain.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)currDomain.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintsdetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if ((ccConstraint = currDomain.getCheck()) != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintsdetails.appendChild(ccCollection);
                            String generic = ccConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = ccConstraint.getTypes();
                            for (int s = 0; s < types.length; ++s) {
                                RDBMSType rdbmsType = (RDBMSType)types[s];
                                String text = ccConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                    }
                }
                this.createUsedInObjectsSection(document, namespace, domainDetails, currDomain);
                ++domCounter;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during domains report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleCollectionTypeData(DesignPart model, StandardReportTemplate reportTemplate, List collectionTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/collectiontype", "osdmSingleCollectionType:CollectionType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleCollectionType:";
            this.createHeaderSection(document, namespace, rootElement);
            CollectionType collectionType = (CollectionType)collectionTypes.get(0);
            this.currentObjectsList.add(collectionType);
            this.createDescriptionAndNotesSection(document, namespace, rootElement, collectionType);
            Element e = document.createElement(namespace + "CTName");
            e.appendChild(document.createTextNode(collectionType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "EncodedName");
            e.appendChild(document.createTextNode(collectionType.getShortObjectID()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTType");
            e.appendChild(document.createTextNode(collectionType.getType()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTMaxElements");
            e.appendChild(document.createTextNode(Integer.valueOf(collectionType.getMaxElement()).toString()));
            rootElement.appendChild(e);
            String dataType = "";
            String dataTypeKind = "";
            String domainName = "";
            DesignObject dtType = collectionType.getDataType();
            if (dtType instanceof Domain) {
                dataTypeKind = "DOM";
                Domain dom = (Domain)dtType;
                domainName = dom.getName();
                dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                domainName = domainName.replace("Unknown", "");
                domainName = domainName.replace("unknown", "");
                domainName = domainName.replace("UNKNOWN", "");
            } else if (dtType instanceof LogicalDatatype) {
                dataTypeKind = "LT";
                LogicalDatatype lt = (LogicalDatatype)dtType;
                dataType = this.getSizePrecisionScale(collectionType.getElementType(), lt.getName());
            } else if (dtType instanceof DistinctType) {
                dataTypeKind = "DT";
            } else if (dtType instanceof StructuredType) {
                dataTypeKind = "ST";
            } else if (dtType instanceof CollectionType) {
                dataTypeKind = "CT";
            }
            e = document.createElement(namespace + "CTDataType");
            e.appendChild(document.createTextNode(dataType));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTDataTypeKind");
            e.appendChild(document.createTextNode(dataTypeKind));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTDomainName");
            e.appendChild(document.createTextNode(domainName));
            rootElement.appendChild(e);
            this.createUsedInObjectsSection(document, namespace, rootElement, collectionType);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single collection type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllCollectionTypesData(DesignPart model, StandardReportTemplate reportTemplate, List collectionTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/collectiontypes", "osdmAllCollectionTypes:CollectionTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllCollectionTypes:";
            this.createHeaderSection(document, namespace, rootElement);
            Element ctCollection = document.createElement(namespace + "CTCollection");
            rootElement.appendChild(ctCollection);
            if (collectionTypes.size() > 0) {
                this.currentObjectsList = collectionTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getCollectionTypeSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (CollectionType collectionType : this.currentObjectsList) {
                Element ctDetails = document.createElement(namespace + "CTDetails");
                ctCollection.appendChild(ctDetails);
                this.createDescriptionAndNotesSection(document, namespace, ctDetails, collectionType);
                Element e = document.createElement(namespace + "CTName");
                e.appendChild(document.createTextNode(collectionType.getLongName()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedName");
                e.appendChild(document.createTextNode(collectionType.getShortObjectID()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTType");
                e.appendChild(document.createTextNode(collectionType.getType()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTMaxElements");
                e.appendChild(document.createTextNode(Integer.valueOf(collectionType.getMaxElement()).toString()));
                ctDetails.appendChild(e);
                String dataType = "";
                String dataTypeKind = "";
                String domainName = "";
                DesignObject dtType = collectionType.getDataType();
                if (dtType instanceof Domain) {
                    dataTypeKind = "DOM";
                    Domain dom = (Domain)dtType;
                    domainName = dom.getName();
                    dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                    domainName = domainName.replace("Unknown", "");
                    domainName = domainName.replace("unknown", "");
                    domainName = domainName.replace("UNKNOWN", "");
                } else if (dtType instanceof LogicalDatatype) {
                    dataTypeKind = "LT";
                    LogicalDatatype lt = (LogicalDatatype)dtType;
                    dataType = this.getSizePrecisionScale(collectionType.getElementType(), lt.getName());
                } else if (dtType instanceof DistinctType) {
                    dataTypeKind = "DT";
                } else if (dtType instanceof StructuredType) {
                    dataTypeKind = "ST";
                } else if (dtType instanceof CollectionType) {
                    dataTypeKind = "CT";
                }
                e = document.createElement(namespace + "CTDataType");
                e.appendChild(document.createTextNode(dataType));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTDataTypeKind");
                e.appendChild(document.createTextNode(dataTypeKind));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTDomainName");
                e.appendChild(document.createTextNode(domainName));
                ctDetails.appendChild(e);
                this.createUsedInObjectsSection(document, namespace, ctDetails, collectionType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all collection type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleStructuredTypeData(DesignPart model, StandardReportTemplate reportTemplate, List structuredTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/structuredtype", "osdmSingleStructuredType:StructuredType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleStructuredType:";
            this.createHeaderSection(document, namespace, rootElement);
            StructuredType structuredType = (StructuredType)structuredTypes.get(0);
            if (reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                this.generateDiagrams(model, null);
            }
            this.currentObjectsList.add(structuredType);
            this.createSTDetailsSection(document, namespace, rootElement, structuredType);
            this.createUsedInObjectsSection(document, namespace, rootElement, structuredType);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single structured type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllStructuredTypesData(DesignPart model, StandardReportTemplate reportTemplate, List structuredTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/structuredtypes", "osdmAllStructuredTypes:StructuredTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllStructuredTypes:";
            this.createHeaderSection(document, namespace, rootElement);
            Element stCollection = document.createElement(namespace + "STCollection");
            rootElement.appendChild(stCollection);
            if (reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                this.generateDiagrams(model, null);
            }
            if (structuredTypes.size() > 0) {
                this.currentObjectsList = structuredTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getStructuredTypeSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (StructuredType structuredType : this.currentObjectsList) {
                Element stDetails = document.createElement(namespace + "STDetails");
                stCollection.appendChild(stDetails);
                this.createSTDetailsSection(document, namespace, stDetails, structuredType);
                this.createUsedInObjectsSection(document, namespace, stDetails, structuredType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all structured types report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleDistinctTypeData(DesignPart model, StandardReportTemplate reportTemplate, List distinctTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/distincttype", "osdmSingleDistinctType:DistinctType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleDistinctType:";
            this.createHeaderSection(document, namespace, rootElement);
            DistinctType distinctType = (DistinctType)distinctTypes.get(0);
            this.currentObjectsList.add(distinctType);
            Element e = document.createElement(namespace + "DTName");
            e.appendChild(document.createTextNode(distinctType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "EncodedName");
            e.appendChild(document.createTextNode(distinctType.getShortObjectID()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTLogicalType");
            e.appendChild(document.createTextNode(distinctType.getLogicalDataType().getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTSize");
            String sz = distinctType.getSize();
            if (sz != null) {
                e.appendChild(document.createTextNode(!sz.equals("") && !sz.equals("0") ? distinctType.getSize() : ""));
            } else {
                e.appendChild(document.createTextNode(""));
            }
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTPrecision");
            int p = distinctType.getPrecision();
            e.appendChild(document.createTextNode(p > 0 ? Integer.valueOf(distinctType.getPrecision()).toString() : ""));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTScale");
            int s = distinctType.getScale();
            e.appendChild(document.createTextNode(s > 0 ? Integer.valueOf(distinctType.getScale()).toString() : ""));
            rootElement.appendChild(e);
            this.createDescriptionAndNotesSection(document, namespace, rootElement, distinctType);
            this.createUsedInObjectsSection(document, namespace, rootElement, distinctType);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single distinct type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllDistinctTypesData(DesignPart model, StandardReportTemplate reportTemplate, List distinctTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/distincttypes", "osdmAllDistinctTypes:DistinctTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllDistinctTypes:";
            this.createHeaderSection(document, namespace, rootElement);
            Element dtCollection = document.createElement(namespace + "DTCollection");
            rootElement.appendChild(dtCollection);
            if (distinctTypes.size() > 0) {
                this.currentObjectsList = distinctTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getDistinctTypeSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (DistinctType distinctType : this.currentObjectsList) {
                Element dtDetails = document.createElement(namespace + "DTDetails");
                dtCollection.appendChild(dtDetails);
                Element e = document.createElement(namespace + "DTName");
                e.appendChild(document.createTextNode(distinctType.getLongName()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedName");
                e.appendChild(document.createTextNode(distinctType.getShortObjectID()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTLogicalType");
                e.appendChild(document.createTextNode(distinctType.getLogicalDataType().getName()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTSize");
                String sz = distinctType.getSize();
                if (sz != null) {
                    e.appendChild(document.createTextNode(!sz.equals("") && !sz.equals("0") ? distinctType.getSize() : ""));
                } else {
                    e.appendChild(document.createTextNode(""));
                }
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTPrecision");
                int p = distinctType.getPrecision();
                e.appendChild(document.createTextNode(p > 0 ? Integer.valueOf(distinctType.getPrecision()).toString() : ""));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTScale");
                int s = distinctType.getScale();
                e.appendChild(document.createTextNode(s > 0 ? Integer.valueOf(distinctType.getScale()).toString() : ""));
                dtDetails.appendChild(e);
                this.createDescriptionAndNotesSection(document, namespace, dtDetails, distinctType);
                this.createUsedInObjectsSection(document, namespace, dtDetails, distinctType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all distinct types report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherChangeRequestsData(DesignPart model, StandardReportTemplate reportTemplate) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/changerequests", "osdmAllChangeRequests:ChangeRequests");
            document.appendChild(rootElement);
            String namespace = "osdmAllChangeRequests:";
            this.createHeaderSection(document, namespace, rootElement);
            Element crCollection = document.createElement(namespace + "CRCollection");
            rootElement.appendChild(crCollection);
            Iterator it = this.design.getChangeRequestSet().iterator();
            while (it.hasNext()) {
                String reason;
                String notes;
                ChangeRequest changeRequest = (ChangeRequest)it.next();
                this.currentObjectsList.add(changeRequest);
                Element crDetails = document.createElement(namespace + "CRDetails");
                crCollection.appendChild(crDetails);
                Element e = document.createElement(namespace + "CRName");
                e.appendChild(document.createTextNode(changeRequest.getLongName()));
                crDetails.appendChild(e);
                String description = changeRequest.getComment();
                if (description != "" && description != null) {
                    Element descriptionElement = document.createElement(namespace + "CRComment");
                    descriptionElement.appendChild(document.createCDATASection(description));
                    crDetails.appendChild(descriptionElement);
                }
                if ((notes = changeRequest.getNotes()) != "" && notes != null) {
                    Element notesElement = document.createElement(namespace + "CRNotes");
                    notesElement.appendChild(document.createCDATASection(notes));
                    crDetails.appendChild(notesElement);
                }
                if ((reason = changeRequest.getReason()) != "" && reason != null) {
                    Element reasonElement = document.createElement(namespace + "CRReason");
                    reasonElement.appendChild(document.createCDATASection(reason));
                    crDetails.appendChild(reasonElement);
                }
                e = document.createElement(namespace + "CRStatus");
                e.appendChild(document.createTextNode(changeRequest.getStatus()));
                crDetails.appendChild(e);
                e = document.createElement(namespace + "CRCompleted");
                e.appendChild(document.createTextNode(changeRequest.isCompleted() ? "Y" : ""));
                crDetails.appendChild(e);
                e = document.createElement(namespace + "CRRequestDate");
                e.appendChild(document.createTextNode(changeRequest.getRequestDate()));
                crDetails.appendChild(e);
                e = document.createElement(namespace + "CRCompletionDate");
                e.appendChild(document.createTextNode(changeRequest.getCompletionDate()));
                crDetails.appendChild(e);
                String implnote = changeRequest.getImplDescription();
                if (implnote != "" && implnote != null) {
                    Element inElement = document.createElement(namespace + "CRImplementationNote");
                    inElement.appendChild(document.createCDATASection(implnote));
                    crDetails.appendChild(inElement);
                }
                if (!reportTemplate.isUseCRImpactedObjects()) continue;
                Element usedInCollection = document.createElement(namespace + "CRUsedInObjectCollection");
                crDetails.appendChild(usedInCollection);
                for (DesignObject dObj : changeRequest.getObjects()) {
                    Element usedInCollectionDetails = document.createElement(namespace + "CRUsedInObjectDetails");
                    usedInCollection.appendChild(usedInCollectionDetails);
                    e = document.createElement(namespace + "ModelName");
                    e.appendChild(document.createTextNode(dObj.getDesignPart().getName()));
                    usedInCollectionDetails.appendChild(e);
                    e = document.createElement(namespace + "ObjectName");
                    e.appendChild(document.createTextNode(dObj.getLongName()));
                    usedInCollectionDetails.appendChild(e);
                    e = document.createElement(namespace + "TypeName");
                    e.appendChild(document.createTextNode(dObj.getObjectTypeName()));
                    usedInCollectionDetails.appendChild(e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all change requests report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherMeasurementsData(DesignPart model, StandardReportTemplate reportTemplate) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/measurements", "osdmAllMeasurements:Measurements");
            document.appendChild(rootElement);
            String namespace = "osdmAllMeasurements:";
            this.createHeaderSection(document, namespace, rootElement);
            Element mrCollection = document.createElement(namespace + "MCollection");
            rootElement.appendChild(mrCollection);
            for (DesignPart dp : this.design.getStorableDesignParts()) {
                List owm = dp.getObjectsWithMeasurements();
                if (owm.size() <= 0) continue;
                for (DesignObject desObject : owm) {
                    for (Measurement measurement : desObject.getMeasurements()) {
                        Element mrDetails = document.createElement(namespace + "MDetails");
                        mrCollection.appendChild(mrDetails);
                        Element e = document.createElement(namespace + "MName");
                        e.appendChild(document.createTextNode(measurement.getLongName()));
                        mrDetails.appendChild(e);
                        Element descriptionElement = document.createElement(namespace + "MComment");
                        descriptionElement.appendChild(document.createCDATASection(measurement.getComment()));
                        mrDetails.appendChild(descriptionElement);
                        Element notesElement = document.createElement(namespace + "MNotes");
                        notesElement.appendChild(document.createCDATASection(measurement.getNotes()));
                        mrDetails.appendChild(notesElement);
                        e = document.createElement(namespace + "MValue");
                        e.appendChild(document.createTextNode(measurement.getValue()));
                        mrDetails.appendChild(e);
                        e = document.createElement(namespace + "MUnit");
                        e.appendChild(document.createTextNode(measurement.getUnit()));
                        mrDetails.appendChild(e);
                        e = document.createElement(namespace + "MType");
                        e.appendChild(document.createTextNode(measurement.getType()));
                        mrDetails.appendChild(e);
                        e = document.createElement(namespace + "MCreationDate");
                        e.appendChild(document.createTextNode(measurement.getCreationDate()));
                        mrDetails.appendChild(e);
                        e = document.createElement(namespace + "MEffectiveDate");
                        e.appendChild(document.createTextNode(measurement.getEffectiveDate()));
                        mrDetails.appendChild(e);
                        if (!reportTemplate.isUseMRImpactedObjects()) continue;
                        Element usedInCollection = document.createElement(namespace + "MUsedInObjectCollection");
                        mrDetails.appendChild(usedInCollection);
                        Element usedInCollectionDetails = document.createElement(namespace + "MUsedInObjectDetails");
                        usedInCollection.appendChild(usedInCollectionDetails);
                        e = document.createElement(namespace + "ModelName");
                        e.appendChild(document.createTextNode(desObject.getDesignPart().getName()));
                        usedInCollectionDetails.appendChild(e);
                        e = document.createElement(namespace + "ObjectName");
                        e.appendChild(document.createTextNode(desObject.getLongName()));
                        usedInCollectionDetails.appendChild(e);
                        e = document.createElement(namespace + "TypeName");
                        e.appendChild(document.createTextNode(desObject.getObjectTypeName()));
                        usedInCollectionDetails.appendChild(e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all measurements report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherUDPData(DesignPart model, StandardReportTemplate reportTemplate) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/udp", "osdmUDP:UDP");
            document.appendChild(rootElement);
            String namespace = "osdmUDP:";
            this.createHeaderSection(document, namespace, rootElement);
            Element udpCollection = document.createElement(namespace + "UDPCollection");
            rootElement.appendChild(udpCollection);
            ArrayList<UserDefinedProperty> udpLlist = new ArrayList<UserDefinedProperty>();
            udpLlist.addAll(this.design.getUserDefinedProperties());
            Collections.sort(udpLlist, new UDPComparator());
            for (UserDefinedProperty udp : udpLlist) {
                String description;
                Element udpDetails = document.createElement(namespace + "UDPDetails");
                udpCollection.appendChild(udpDetails);
                Element e = document.createElement(namespace + "Name");
                e.appendChild(document.createTextNode(udp.getName() + "/" + udp.getLibrary().getFileName()));
                udpDetails.appendChild(e);
                e = document.createElement(namespace + "DisplayName");
                e.appendChild(document.createTextNode(udp.getDisplayName()));
                udpDetails.appendChild(e);
                e = document.createElement(namespace + "Type");
                e.appendChild(document.createTextNode(udp.getType()));
                udpDetails.appendChild(e);
                Element eDefault = document.createElement(namespace + "DefaultValue");
                if (udp.getDefaultValue() != null && !udp.getDefaultValue().trim().equals("")) {
                    eDefault.appendChild(document.createTextNode(udp.getDefaultValue()));
                }
                udpDetails.appendChild(eDefault);
                e = document.createElement(namespace + "FileName");
                e.appendChild(document.createTextNode(udp.getLibrary().getFileName()));
                udpDetails.appendChild(e);
                if (udp.getLovMap().size() > 0) {
                    Element lovCollection = document.createElement(namespace + "LOVCollection");
                    udpDetails.appendChild(lovCollection);
                    for (Map.Entry<String, Boolean> entry : udp.getLovMap().entrySet()) {
                        String value = entry.getKey();
                        Boolean isDefault = entry.getValue();
                        Element lovDetails = document.createElement(namespace + "LOVDetails");
                        lovCollection.appendChild(lovDetails);
                        e = document.createElement(namespace + "Value");
                        e.appendChild(document.createTextNode(value));
                        lovDetails.appendChild(e);
                        if (!isDefault.booleanValue()) continue;
                        eDefault.appendChild(document.createTextNode(value));
                    }
                }
                if (udp.getObjectsVisibilityMap().size() > 0) {
                    Element objScopeCollection = document.createElement(namespace + "ObjectsScopeCollection");
                    udpDetails.appendChild(objScopeCollection);
                    for (Map.Entry<Object, Boolean> entry : udp.getObjectsVisibilityMap().entrySet()) {
                        Class clz = (Class)entry.getKey();
                        Boolean visible = entry.getValue();
                        Element objScopeDetails = document.createElement(namespace + "ObjectDetails");
                        objScopeCollection.appendChild(objScopeDetails);
                        e = document.createElement(namespace + "Type");
                        e.appendChild(document.createTextNode(ReportConstants.classToNameMap.get(clz)));
                        objScopeDetails.appendChild(e);
                        e = document.createElement(namespace + "IsVisible");
                        e.appendChild(document.createTextNode(String.valueOf(visible == true ? "Y" : "")));
                        objScopeDetails.appendChild(e);
                        Integer color = udp.getObjectsColorMap().get(clz);
                        if (color == null) continue;
                        e = document.createElement(namespace + "Color");
                        String col = String.valueOf(Integer.toHexString(color & 0xFFFFFF));
                        col = String.format("%6s", col).replaceAll(" ", "0");
                        e.appendChild(document.createTextNode("#" + col));
                        objScopeDetails.appendChild(e);
                    }
                }
                if ((description = udp.getDescription()) == null || description.trim().length() <= 0) continue;
                Element descriptionElement = document.createElement(namespace + "Description");
                descriptionElement.appendChild(document.createCDATASection(description));
                udpDetails.appendChild(descriptionElement);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during UDP report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document generateSearchResultsDomDocument(CustomReportTemplate crt, ModelIDObject model, List objects, HashMap extraParams) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/searchresults", "osdmSearchResults:SearchResults");
            document.appendChild(rootElement);
            String namespace = "osdmSearchResults:";
            Element rCaption = document.createElement(namespace + "title");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            boolean showFilter = (Boolean)extraParams.get("show");
            Element objShowFilter = document.createElement(namespace + "showFilter");
            objShowFilter.appendChild(document.createTextNode(((Boolean)extraParams.get("show")).toString()));
            rootElement.appendChild(objShowFilter);
            Element objPattern = document.createElement(namespace + "pattern");
            objPattern.appendChild(document.createTextNode((String)extraParams.get("pattern")));
            rootElement.appendChild(objPattern);
            if (showFilter) {
                Element objFilter = document.createElement(namespace + "filter");
                objFilter.appendChild(document.createTextNode(((SearchSet)extraParams.get("filterObject")).getTypeName() + " " + model.getName()));
                rootElement.appendChild(objFilter);
            }
            Element tableWidth = document.createElement(namespace + "tw");
            rootElement.appendChild(tableWidth);
            Element isML = document.createElement(namespace + "multiLevel");
            boolean ml = false;
            if (!crt.getName().trim().equals("") && crt.getReportSections().size() > 1) {
                ml = true;
            }
            isML.appendChild(document.createTextNode(Boolean.toString(ml)));
            rootElement.appendChild(isML);
            Element sections = document.createElement(namespace + "sections");
            rootElement.appendChild(sections);
            Element objectsCollection = document.createElement(namespace + "objects");
            rootElement.appendChild(objectsCollection);
            ArrayList<ReportSection> usedSections = new ArrayList<ReportSection>();
            HashMap usedPropertiesMap = new HashMap();
            ArrayList<String> propertiesList = null;
            int sCounter = 0;
            for (ReportSection rs : crt.getReportSections()) {
                if (rs.getLevel() > 0) {
                    usedSections.add(rs);
                }
                if (sCounter <= 30) {
                    Element section = document.createElement(namespace + "section" + sCounter);
                    section.setAttribute("name", rs.getCustomName());
                    section.setAttribute("tw", "100%");
                    sections.appendChild(section);
                    int columnsCount = 0;
                    int colsWithZeroLength = 0;
                    double percentageUsed = 0.0;
                    for (ReportColumn rc : rs.getReportColumns()) {
                        if (rc.getColumnSize() == 0.0) {
                            ++colsWithZeroLength;
                        } else {
                            percentageUsed += rc.getColumnSize();
                        }
                        ++columnsCount;
                    }
                    double sizeForZeroLengthColumns = 0.0;
                    if (columnsCount != colsWithZeroLength) {
                        if (colsWithZeroLength > 0) {
                            sizeForZeroLengthColumns = (100.0 - percentageUsed) / (double)colsWithZeroLength;
                        }
                        if (rs.getLevel() == 0) {
                            tableWidth.appendChild(document.createTextNode("100%"));
                        }
                    } else {
                        if (colsWithZeroLength > 0) {
                            sizeForZeroLengthColumns = (100.0 - percentageUsed) / (double)colsWithZeroLength;
                        }
                        if (rs.getLevel() == 0) {
                            tableWidth.appendChild(document.createTextNode("100%"));
                        }
                    }
                    HashMap<CallSite, Integer> columnsOrderMap = new HashMap<CallSite, Integer>();
                    int cCounter = 0;
                    propertiesList = new ArrayList<String>();
                    for (ReportColumn rc : rs.getReportColumns()) {
                        propertiesList.add(rc.getPropertyName());
                        if (++cCounter > 30) continue;
                        Element column = document.createElement(namespace + "c" + cCounter);
                        Element show = document.createElement(namespace + "show");
                        show.appendChild(document.createTextNode("true"));
                        Element name = document.createElement(namespace + "name");
                        name.appendChild(document.createTextNode(rc.getPropertyName()));
                        Element cn = document.createElement(namespace + "customName");
                        cn.appendChild(document.createTextNode(rc.getColumnName()));
                        Element w = document.createElement(namespace + "width");
                        double columnSize = rc.getColumnSize();
                        if (columnSize == 0.0) {
                            columnSize = sizeForZeroLengthColumns;
                        }
                        w.appendChild(document.createTextNode(Double.toString(columnSize) + "%"));
                        column.appendChild(show);
                        column.appendChild(name);
                        column.appendChild(cn);
                        column.appendChild(w);
                        section.appendChild(column);
                        if (rc.getColumnOrder().equals("")) continue;
                        columnsOrderMap.put((CallSite)((Object)("c" + cCounter)), Integer.parseInt(rc.getColumnOrder()));
                    }
                }
                usedPropertiesMap.put(rs.getElementClass(), propertiesList);
                ++sCounter;
            }
            Collections.sort(objects, new PropertiesComparator(objects, ((ReportSection)crt.getReportSections().get(0)).getReportColumns()));
            for (SearchResultObject ro : objects) {
                ModelIDObject obj = (ModelIDObject)ro.getObj();
                String objName = obj.getLongName();
                ClassDescription cd = this.metaDataManager.getClassDescription(obj.getClass().getName());
                Element baseObject = document.createElement(namespace + "object");
                objectsCollection.appendChild(baseObject);
                Element values = document.createElement(namespace + "values");
                baseObject.appendChild(values);
                Element elValue = document.createElement(namespace + "v0");
                elValue.appendChild(document.createTextNode(objName));
                values.appendChild(elValue);
                int vCounter = 0;
                for (String propertyName : (List)usedPropertiesMap.get(obj.getClass())) {
                    elValue = document.createElement(namespace + "v" + ++vCounter);
                    values.appendChild(elValue);
                    ClassDescription.PropertyDescription pd = cd.getSearchablePropertyDescriptionByName(propertyName);
                    String value = "";
                    if (pd != null) {
                        String className = pd.className;
                        java.lang.reflect.Method method = pd.getter;
                        value = this.getPropertiesValue(method, className, obj);
                    } else {
                        value = obj.getProperty(propertyName);
                    }
                    elValue.appendChild(document.createTextNode(value));
                }
                sCounter = 0;
                for (ReportSection rs : usedSections) {
                    Object cd1;
                    if (++sCounter > 30) continue;
                    Element section = document.createElement(namespace + "section" + sCounter);
                    section.setAttribute("tw", "100%");
                    baseObject.appendChild(section);
                    java.lang.reflect.Method method = null;
                    if (rs.getType().equals("collection")) {
                        cd1 = (ClassDescription.CollectionDescription)rs.getElement();
                        method = ((ClassDescription.CollectionDescription)cd1).getter;
                    } else if (rs.getType().equals("roPropertiesList")) {
                        ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)rs.getElement();
                        method = pd.getter;
                    } else {
                        cd1 = (ClassDescription)rs.getElement();
                        ClassDescription.PropertyDescription pd = ((ClassDescription)cd1).getSearchablePropertyDescriptionByName(rs.getPropertyName());
                        if (pd != null) {
                            method = pd.getter;
                        }
                    }
                    Iterator<Object> itemsListIt = null;
                    if (method != null) {
                        List<Object> l;
                        Object col = method.invoke((Object)obj, new Object[0]);
                        if (col instanceof Collection) {
                            l = new ArrayList((Collection)col);
                            Collections.sort(l, new PropertiesComparator(l, rs.getReportColumns()));
                            itemsListIt = l.iterator();
                        } else if (col instanceof ElementSet) {
                            l = Arrays.asList(((ElementSet)col).toArray());
                            Collections.sort(l, new PropertiesComparator(l, rs.getReportColumns()));
                            itemsListIt = l.iterator();
                        }
                    }
                    if (itemsListIt == null) continue;
                    while (itemsListIt.hasNext()) {
                        Object rObj = itemsListIt.next();
                        Element oObject = document.createElement(namespace + "object");
                        section.appendChild(oObject);
                        Element values1 = document.createElement(namespace + "values");
                        oObject.appendChild(values1);
                        ClassDescription cd12 = this.metaDataManager.getClassDescription(rObj.getClass().getName());
                        int pCounter = 0;
                        for (ReportColumn rc : rs.getReportColumns()) {
                            elValue = document.createElement(namespace + "v" + ++pCounter);
                            values1.appendChild(elValue);
                            String value = "";
                            ClassDescription.PropertyDescription pd = cd12.getSearchablePropertyDescriptionByName(rc.getPropertyName());
                            if (pd != null) {
                                String className = pd.className;
                                java.lang.reflect.Method method1 = pd.getter;
                                value = this.getPropertiesValue(method1, className, rObj);
                            } else {
                                DesignObject o = (DesignObject)rObj;
                                value = o.getProperty(rc.getPropertyName());
                            }
                            elValue.appendChild(document.createTextNode(value));
                        }
                    }
                }
                Element section = document.createElement(namespace + "section");
                section.setAttribute("tw", "100%");
                baseObject.appendChild(section);
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.generateSearchResultsDomDocument() Exception : " + e.getMessage(), e);
            e.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSearchResultsXLSFile(CustomReportTemplate crt, List objects, HashMap extraParams) {
        OutputStream fileOut = null;
        BaseReportsGenerationDialog parent = (BaseReportsGenerationDialog)extraParams.get("parent");
        Boolean replaceBooleanValues = (Boolean)extraParams.get("pboolean");
        String strTrue = (String)extraParams.get("ptrue");
        String strFalse = (String)extraParams.get("pfalse");
        Boolean showFilter = (Boolean)extraParams.get("show");
        String searchPattern = (String)extraParams.get("pattern");
        Object ssobj = extraParams.get("filterObject");
        String searchFilterObject = "";
        if (ssobj instanceof SearchSet) {
            searchFilterObject = ((SearchSet)ssobj).getTypeName();
        }
        try {
            ModelIDObject obj;
            fileOut = new FileOutputStream(new File(this.reportsPath, this.reportFileName));
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet worksheet = workbook.createSheet(Messages.getString("ReportsGenerator.SearchResultsDetails"));
            HSSFDataValidationHelper dvHelper = new HSSFDataValidationHelper(worksheet);
            HSSFDataValidation validation = null;
            HSSFFont fontC = workbook.createFont();
            fontC.setFontName("Tahoma");
            fontC.setFontHeightInPoints((short)12);
            HSSFPalette palette = workbook.getCustomPalette();
            palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex(), (byte)Integer.parseInt("11011001", 2), (byte)Integer.parseInt("11110101", 2), (byte)Integer.parseInt("11111111", 2));
            palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.DARK_BLUE.getIndex(), (byte)Integer.parseInt("10101101", 2), (byte)Integer.parseInt("11000100", 2), (byte)Integer.parseInt("11001100", 2));
            palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex(), (byte)Integer.parseInt("11110010", 2), (byte)Integer.parseInt("11111111", 2), (byte)Integer.parseInt("11110110", 2));
            String designId = "";
            String modelId = "";
            ModelIDObject currentModel = null;
            Iterator it = objects.iterator();
            if (it.hasNext()) {
                SearchResultObject ro = (SearchResultObject)it.next();
                designId = ((ModelIDObject)ro.getObj()).getDesign().getObjectID();
                modelId = ((ModelIDObject)ro.getObj()).getModelID();
                currentModel = this.getModelByID(((ModelIDObject)ro.getObj()).getDesign(), modelId);
            }
            HSSFRow titleRow = worksheet.createRow(1);
            titleRow.setHeight((short)((double)titleRow.getHeight() * 1.5));
            HSSFCell cell = titleRow.createCell(0);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont fontT = workbook.createFont();
            fontT.setFontName("Tahoma");
            fontT.setFontHeightInPoints((short)13);
            fontT.setBold(true);
            cellStyle.setFont(fontT);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(this.reportCaption);
            if (showFilter.booleanValue()) {
                HSSFFont fontPF = workbook.createFont();
                fontPF.setFontHeightInPoints((short)12);
                fontPF.setBold(true);
                HSSFCellStyle cellStyleFP = workbook.createCellStyle();
                cellStyleFP.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                cellStyleFP.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyleFP.setAlignment(HorizontalAlignment.LEFT);
                this.setXLSCellBorders(cellStyleFP);
                cellStyleFP.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
                cellStyleFP.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cellStyleFP.setFont(fontPF);
                HSSFFont fontPFValue = workbook.createFont();
                fontPFValue.setFontHeightInPoints((short)12);
                HSSFCellStyle cellStyleFPValue = workbook.createCellStyle();
                cellStyleFPValue.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                cellStyleFPValue.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyleFPValue.setAlignment(HorizontalAlignment.LEFT);
                this.setXLSCellBorders(cellStyleFPValue);
                cellStyleFPValue.setFont(fontPFValue);
                HSSFRow patternRow = worksheet.createRow(3);
                patternRow.setHeight((short)((double)patternRow.getHeight() * 1.2));
                cell = patternRow.createCell(0);
                cell.setCellStyle(cellStyleFP);
                cell.setCellValue("Pattern");
                cell = patternRow.createCell(1);
                HSSFCellStyle cellStylePatternValue = workbook.createCellStyle();
                cellStylePatternValue.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                this.setXLSCellBorders(cellStylePatternValue);
                cell.setCellStyle(cellStyleFPValue);
                cell.setCellValue(searchPattern);
                HSSFRow filterRow = worksheet.createRow(4);
                filterRow.setHeight((short)((double)filterRow.getHeight() * 1.2));
                cell = filterRow.createCell(0);
                cell.setCellStyle(cellStyleFP);
                cell.setCellValue("Filter");
                cell = filterRow.createCell(1);
                HSSFCellStyle cellStyleFilterValue = workbook.createCellStyle();
                cellStyleFilterValue.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                this.setXLSCellBorders(cellStyleFilterValue);
                cell.setCellStyle(cellStyleFPValue);
                cell.setCellValue(searchFilterObject + " " + currentModel.getName());
            }
            HSSFFont fontH = workbook.createFont();
            HSSFCellStyle cellStyleH = workbook.createCellStyle();
            cellStyleH.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleH.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleH.setAlignment(HorizontalAlignment.CENTER);
            cellStyleH.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
            cellStyleH.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSCellBorders(cellStyleH);
            fontH.setFontHeightInPoints((short)12);
            fontH.setFontName("Tahoma");
            fontH.setBold(true);
            cellStyleH.setFont(fontH);
            HSSFFont fontH_L1 = workbook.createFont();
            HSSFCellStyle cellStyleL1Header = workbook.createCellStyle();
            cellStyleL1Header.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleL1Header.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleL1Header.setAlignment(HorizontalAlignment.CENTER);
            cellStyleL1Header.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
            cellStyleL1Header.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSCellBorders(cellStyleL1Header);
            fontH_L1.setFontHeightInPoints((short)12);
            fontH_L1.setFontName("Tahoma");
            fontH_L1.setBold(true);
            cellStyleL1Header.setFont(fontH);
            HSSFCellStyle cellStyleL1Data = workbook.createCellStyle();
            cellStyleL1Data.setLocked(false);
            cellStyleL1Data.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleL1Data.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleL1Data.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSCellBorders(cellStyleL1Data);
            cellStyleL1Data.setFont(fontC);
            cellStyleL1Data.setWrapText(true);
            HSSFFont cellStyleL1CollectionNameFont = workbook.createFont();
            HSSFCellStyle cellStyleL1CollectionName = workbook.createCellStyle();
            cellStyleL1CollectionName.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleL1CollectionName.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleL1CollectionName.setAlignment(HorizontalAlignment.LEFT);
            cellStyleL1CollectionName.setFont(fontC);
            cellStyleL1CollectionName.setWrapText(true);
            cellStyleL1CollectionName.setLocked(true);
            cellStyleL1CollectionNameFont.setFontHeightInPoints((short)10);
            cellStyleL1CollectionNameFont.setFontName("Tahoma");
            cellStyleL1CollectionNameFont.setItalic(true);
            cellStyleL1CollectionName.setFont(cellStyleL1CollectionNameFont);
            HSSFCellStyle cellStyleGeneral = workbook.createCellStyle();
            cellStyleGeneral.setLocked(false);
            cellStyleGeneral.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleGeneral.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleGeneral.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSCellBorders(cellStyleGeneral);
            cellStyleGeneral.setFont(fontC);
            cellStyleGeneral.setWrapText(true);
            HSSFCellStyle cellStyleText = workbook.createCellStyle();
            cellStyleText.setLocked(false);
            cellStyleText.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
            cellStyleText.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleText.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSCellBorders(cellStyleText);
            cellStyleText.setFont(fontC);
            cellStyleText.setWrapText(true);
            HSSFCellStyle cellStyleReadOnly = workbook.createCellStyle();
            cellStyleReadOnly.setLocked(true);
            cellStyleReadOnly.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleReadOnly.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleReadOnly.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSCellBorders(cellStyleReadOnly);
            cellStyleReadOnly.setFont(fontC);
            cellStyleReadOnly.setWrapText(true);
            HSSFCreationHelper factory = workbook.getCreationHelper();
            HSSFPatriarch drawing = workbook.getSheetAt(0).createDrawingPatriarch();
            int headerRowIndex = showFilter != false ? 6 : 3;
            int columnsCounter = 0;
            int maxColumnsCount = 0;
            int masterRowCounter = headerRowIndex;
            ArrayList<String> propertiesList = null;
            LinkedHashMap usedPropertiesMap = new LinkedHashMap();
            HashMap<Class, String> sectionsNamesMap = new HashMap<Class, String>();
            HashMap columnsNamesMap = new HashMap();
            HashMap<Class, LinkedList> columnsMap = new HashMap<Class, LinkedList>();
            HashMap<Class, Integer> sectionsLevelsMap = new HashMap<Class, Integer>();
            List crtSectionsList = crt.getReportSections();
            for (ReportSection rs : crtSectionsList) {
                HashMap<String, String> propertiesToColumnsNamesMap = new HashMap<String, String>();
                propertiesList = new ArrayList<String>();
                for (ReportColumn rc : rs.getReportColumns()) {
                    propertiesList.add(rc.getPropertyName());
                    propertiesToColumnsNamesMap.put(rc.getPropertyName(), rc.getColumnName());
                }
                usedPropertiesMap.put(rs.getElementClass(), propertiesList);
                sectionsNamesMap.put(rs.getElementClass(), rs.getCustomName());
                columnsNamesMap.put(rs.getElementClass(), propertiesToColumnsNamesMap);
                columnsMap.put(rs.getElementClass(), rs.getReportColumns());
                sectionsLevelsMap.put(rs.getElementClass(), new Integer(rs.getLevel()));
            }
            int rowCounter = 0;
            HSSFSheet propertiesMapWS = workbook.createSheet("propertiesMap");
            for (Map.Entry pairs : usedPropertiesMap.entrySet()) {
                Class clazz = (Class)pairs.getKey();
                HSSFRow hRow = propertiesMapWS.createRow(rowCounter);
                HSSFCell hCellLevel = hRow.createCell(0);
                hCellLevel.setCellStyle(cellStyleReadOnly);
                hCellLevel.setCellValue((double)((Integer)sectionsLevelsMap.get(clazz)).intValue());
                HSSFCell hCellClassName = hRow.createCell(1);
                hCellClassName.setCellStyle(cellStyleReadOnly);
                hCellClassName.setCellValue(clazz.getName());
                int colCounter = 1;
                for (String propertyName : (List)pairs.getValue()) {
                    HSSFCell hCellPropertyName = hRow.createCell(++colCounter);
                    hCellPropertyName.setCellStyle(cellStyleReadOnly);
                    hCellPropertyName.setCellValue(propertyName);
                }
                ++rowCounter;
            }
            HashMap<Class, CallSite> nameToLOVMap = new HashMap<Class, CallSite>();
            Iterator setsIt = null;
            if (currentModel instanceof DesignPart) {
                setsIt = ((DesignPart)currentModel).getSearchableSets().iterator();
            } else if (currentModel instanceof StorageDesign) {
                setsIt = ((StorageDesign)currentModel).getSearchableSets().iterator();
            }
            int lovSheetCounter = 0;
            while (setsIt.hasNext()) {
                SearchSet ss = (SearchSet)setsIt.next();
                Class clazz = ss.getClazz();
                rowCounter = 0;
                ElementSet elements = (ElementSet)((Object)ss.getSet());
                if (elements.size() <= 0) continue;
                nameToLOVMap.put(ss.getClazz(), (CallSite)((Object)("lov_" + lovSheetCounter)));
                HSSFSheet hiddenWS = workbook.createSheet("lov_" + lovSheetCounter);
                workbook.setSheetHidden(lovSheetCounter + 1, true);
                elements.sort();
                Iterator elIt = elements.iterator();
                while (elIt.hasNext()) {
                    obj = (ModelIDObject)elIt.next();
                    HSSFRow hRow = hiddenWS.createRow(rowCounter);
                    HSSFCell hCellObjID = hRow.createCell(0);
                    hCellObjID.setCellStyle(cellStyleReadOnly);
                    hCellObjID.setCellValue(obj.getObjectID());
                    HSSFCell hCellObjValue = hRow.createCell(1);
                    hCellObjValue.setCellStyle(cellStyleReadOnly);
                    hCellObjValue.setCellValue(obj.getName());
                    ++rowCounter;
                }
                hiddenWS.protectSheet("");
                ++lovSheetCounter;
            }
            HSSFRow headerRow = null;
            boolean createHeader = true;
            int objCount = 0;
            Collections.sort(objects, new PropertiesComparator(objects, ((ReportSection)crt.getReportSections().get(0)).getReportColumns()));
            Iterator objectsIt = objects.iterator();
            while (objectsIt.hasNext()) {
                ++objCount;
                SearchResultObject ro = (SearchResultObject)objectsIt.next();
                obj = (ModelIDObject)ro.getObj();
                String objName = obj.getName();
                ClassDescription cd = this.metaDataManager.getClassDescription(obj.getClass().getName());
                if (usedPropertiesMap.size() == 1) {
                    if (objCount == 1) {
                        headerRow = worksheet.createRow(masterRowCounter);
                        headerRow.setHeight((short)((double)headerRow.getHeight() * 1.2));
                        createHeader = true;
                    } else {
                        createHeader = false;
                    }
                } else {
                    headerRow = worksheet.createRow(masterRowCounter);
                    headerRow.setHeight((short)((double)headerRow.getHeight() * 1.2));
                    createHeader = true;
                }
                int newLines = 1;
                columnsCounter = 0;
                boolean createDataRow = true;
                HSSFRow dataRow = null;
                Iterator usedPropertiesIt = ((List)usedPropertiesMap.get(obj.getClass())).iterator();
                while (usedPropertiesIt.hasNext() && columnsCounter <= 30) {
                    RichTextString str;
                    Comment comment;
                    ClientAnchor anchor;
                    String propertyName = (String)usedPropertiesIt.next();
                    ClassDescription.PropertyDescription pd = cd.getSearchablePropertyDescriptionByName(propertyName);
                    boolean isDynamicProperty = false;
                    String value = "";
                    String className = "java.lang.String";
                    if (pd != null) {
                        className = pd.className;
                        java.lang.reflect.Method method = pd.getter;
                        value = this.getPropertiesValue(method, className, obj);
                    } else {
                        value = obj.getProperty(propertyName);
                        isDynamicProperty = true;
                    }
                    HSSFCell headerCell = null;
                    if (createHeader) {
                        headerCell = headerRow.createCell(columnsCounter);
                        headerCell.setCellStyle(cellStyleH);
                        HashMap propsToNamesMap = (HashMap)columnsNamesMap.get(ro.getClazz());
                        headerCell.setCellValue((String)propsToNamesMap.get(propertyName));
                    }
                    if (createDataRow) {
                        dataRow = createHeader ? worksheet.createRow(masterRowCounter + 1) : worksheet.createRow(masterRowCounter);
                        dataRow.setHeight((short)((double)dataRow.getHeight() * 1.2));
                        createDataRow = false;
                    }
                    cell = dataRow.createCell(columnsCounter);
                    cell.setCellStyle(cellStyleGeneral);
                    cell.setCellValue(value);
                    if (pd == null || ReportUtils.isReadOnlyProperty(cd, pd.name)) {
                        if (isDynamicProperty) {
                            cell.setCellStyle(cellStyleGeneral);
                        } else {
                            cell.setCellStyle(cellStyleReadOnly);
                        }
                    } else if (ReportUtils.isObjectTypeProperty(cd, pd.name)) {
                        String lov = this.getNameLOV(nameToLOVMap, Class.forName(pd.className));
                        DVConstraint dvConstraint = DVConstraint.createFormulaListConstraint((String)(lov + "!B1:B65000"));
                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                        validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                        validation.setErrorStyle(0);
                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                        validation.setShowErrorBox(true);
                        worksheet.addValidationData((DataValidation)validation);
                        cell.setCellStyle(cellStyleGeneral);
                    } else if (className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1) {
                        DVConstraint dvConstraint = DVConstraint.createExplicitListConstraint((String[])new String[]{"true", "false"});
                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                        validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                        validation.setErrorStyle(0);
                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                        validation.setShowErrorBox(true);
                        worksheet.addValidationData((DataValidation)validation);
                        cell.setCellStyle(cellStyleText);
                    } else {
                        cell.setCellStyle(cellStyleGeneral);
                    }
                    if (columnsCounter == 0) {
                        anchor = factory.createClientAnchor();
                        anchor.setCol1(cell.getColumnIndex());
                        anchor.setCol2(cell.getColumnIndex() + 3);
                        anchor.setRow1(cell.getRowIndex());
                        anchor.setRow2(cell.getRowIndex() + 3);
                        comment = drawing.createCellComment(anchor);
                        str = factory.createRichTextString("ObjectID:" + obj.getObjectID() + ";\nClass:" + obj.getClass().getName());
                        comment.setString(str);
                        cell.setCellComment(comment);
                    }
                    if ((headerRow.getRowNum() == 3 || headerRow.getRowNum() == 6) && createHeader) {
                        if (columnsCounter == 0) {
                            anchor = factory.createClientAnchor();
                            anchor.setCol1(headerCell.getColumnIndex());
                            anchor.setCol2(headerCell.getColumnIndex() + 3);
                            anchor.setRow1(headerCell.getRowIndex());
                            anchor.setRow2(headerCell.getRowIndex() + 2);
                            comment = drawing.createCellComment(anchor);
                            str = factory.createRichTextString("DesignID:" + designId);
                            comment.setString(str);
                            headerCell.setCellComment(comment);
                        } else if (columnsCounter == 1) {
                            anchor = factory.createClientAnchor();
                            anchor.setCol1(headerCell.getColumnIndex());
                            anchor.setCol2(headerCell.getColumnIndex() + 3);
                            anchor.setRow1(headerCell.getRowIndex());
                            anchor.setRow2(headerCell.getRowIndex() + 2);
                            comment = drawing.createCellComment(anchor);
                            str = factory.createRichTextString("ModelID:" + modelId);
                            comment.setString(str);
                            headerCell.setCellComment(comment);
                        }
                    }
                    int currentValueNewLines = 1;
                    if (value != null) {
                        Matcher m = Pattern.compile("\n|\r", 8).matcher(value);
                        while (m.find()) {
                            ++currentValueNewLines;
                        }
                    }
                    if (newLines < currentValueNewLines) {
                        newLines = currentValueNewLines;
                    }
                    String[] lines = value.split("\\r?\\n");
                    for (int y = 0; y < lines.length; ++y) {
                        String line = lines[y];
                        if (line.length() <= 255) continue;
                        this.checkWordWrap(line, 255);
                        --newLines;
                    }
                    if (++columnsCounter <= maxColumnsCount) continue;
                    maxColumnsCount = columnsCounter;
                }
                int rowsToIncrease = newLines + this.wordWrappedRowsCount;
                if (rowsToIncrease <= 107) {
                    dataRow.setHeight((short)(dataRow.getHeight() * rowsToIncrease));
                } else {
                    dataRow.setHeight((short)(dataRow.getHeight() * 107));
                }
                this.wordWrappedRowsCount = 0;
                int dataRowsCounter = 0;
                boolean initialDataRowCounter = false;
                boolean headersCounter = false;
                dataRow = null;
                for (Map.Entry pairs : usedPropertiesMap.entrySet()) {
                    Class clazz = (Class)pairs.getKey();
                    usedPropertiesIt = ((List)pairs.getValue()).iterator();
                    if (clazz.equals(obj.getClass())) continue;
                    boolean removeHeaderRow = true;
                    columnsCounter = 1;
                    HSSFRow collectionNameRow = null;
                    if (columnsCounter == 1) {
                        collectionNameRow = worksheet.createRow(masterRowCounter + 3);
                        collectionNameRow.setHeight((short)((double)collectionNameRow.getHeight() * 1.2));
                        masterRowCounter = collectionNameRow.getRowNum();
                        HSSFCell collectionNameCell = collectionNameRow.createCell(columnsCounter);
                        collectionNameCell.setCellValue((String)sectionsNamesMap.get(clazz));
                        collectionNameCell.setCellStyle(cellStyleL1CollectionName);
                    }
                    HSSFRow headerRow_L1 = worksheet.createRow(masterRowCounter + 1);
                    headerRow_L1.setHeight((short)((double)headerRow_L1.getHeight() * 1.2));
                    masterRowCounter = headerRow_L1.getRowNum();
                    TreeMap<Integer, HSSFRow> dataRowsmap = new TreeMap<Integer, HSSFRow>();
                    while (usedPropertiesIt.hasNext()) {
                        String propertyName = (String)usedPropertiesIt.next();
                        HSSFCell headerCell = headerRow_L1.createCell(columnsCounter);
                        headerCell.setCellStyle(cellStyleL1Header);
                        HashMap propsToNamesMap = (HashMap)columnsNamesMap.get(clazz);
                        headerCell.setCellValue((String)propsToNamesMap.get(propertyName));
                        java.lang.reflect.Method method = null;
                        for (ReportSection rs : crtSectionsList) {
                            Object cd1;
                            if (!rs.getElementClass().equals(clazz)) continue;
                            if (rs.getType().equals("collection")) {
                                cd1 = (ClassDescription.CollectionDescription)rs.getElement();
                                method = ((ClassDescription.CollectionDescription)cd1).getter;
                                break;
                            }
                            if (rs.getType().equals("roPropertiesList")) {
                                ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)rs.getElement();
                                method = pd.getter;
                                break;
                            }
                            cd1 = (ClassDescription)rs.getElement();
                            ClassDescription.PropertyDescription pd = ((ClassDescription)cd1).getSearchablePropertyDescriptionByName(rs.getPropertyName());
                            if (pd == null) break;
                            method = pd.getter;
                            break;
                        }
                        dataRowsCounter = 1;
                        if (method != null) {
                            removeHeaderRow = true;
                            List<Object> items = new ArrayList();
                            Object col = method.invoke((Object)obj, new Object[0]);
                            Iterator<Object> itemsListIt = null;
                            if (col instanceof Collection) {
                                items = new ArrayList((Collection)col);
                                Collections.sort(items, new PropertiesComparator(items, (List)columnsMap.get(clazz)));
                                itemsListIt = items.iterator();
                            } else if (col instanceof ElementSet) {
                                items = Arrays.asList(((ElementSet)col).toArray());
                                Collections.sort(items, new PropertiesComparator(items, (List)columnsMap.get(clazz)));
                                itemsListIt = items.iterator();
                            }
                            if (itemsListIt == null) continue;
                            if (items.size() > 0) {
                                removeHeaderRow = false;
                                while (itemsListIt.hasNext()) {
                                    Object rObj = itemsListIt.next();
                                    ClassDescription cd1 = this.metaDataManager.getClassDescription(rObj.getClass().getName());
                                    ClassDescription.PropertyDescription pd = cd1.getSearchablePropertyDescriptionByName(propertyName);
                                    String value = "";
                                    String className = "java.lang.String";
                                    if (pd != null) {
                                        className = pd.className;
                                        java.lang.reflect.Method method1 = pd.getter;
                                        value = this.getPropertiesValue(method1, className, rObj);
                                    } else {
                                        DesignObject o = (DesignObject)rObj;
                                        value = o.getProperty(propertyName);
                                    }
                                    if (columnsCounter == 1) {
                                        dataRow = worksheet.createRow(headerRow_L1.getRowNum() + dataRowsCounter);
                                        dataRow.setHeight((short)((double)dataRow.getHeight() * 1.2));
                                        dataRowsmap.put(new Integer(dataRowsCounter), dataRow);
                                        ++dataRowsCounter;
                                    } else {
                                        dataRow = (HSSFRow)dataRowsmap.get(new Integer(dataRowsCounter));
                                        ++dataRowsCounter;
                                    }
                                    cell = dataRow.createCell(columnsCounter);
                                    cell.setCellStyle(cellStyleL1Data);
                                    cell.setCellValue(value);
                                    if (pd == null || ReportUtils.isReadOnlyProperty(cd1, pd.name)) {
                                        cell.setCellStyle(cellStyleReadOnly);
                                    } else if (ReportUtils.isObjectTypeProperty(cd1, pd.name)) {
                                        String lov = this.getNameLOV(nameToLOVMap, Class.forName(pd.className));
                                        DVConstraint dvConstraint = DVConstraint.createFormulaListConstraint((String)(lov + "!B1:B65000"));
                                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                                        validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                                        validation.setErrorStyle(0);
                                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                                        validation.setShowErrorBox(true);
                                        worksheet.addValidationData((DataValidation)validation);
                                        cell.setCellStyle(cellStyleGeneral);
                                    } else if (className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1) {
                                        DVConstraint dvConstraint = DVConstraint.createExplicitListConstraint((String[])new String[]{"true", "false"});
                                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                                        validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                                        validation.setErrorStyle(0);
                                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                                        validation.setShowErrorBox(true);
                                        worksheet.addValidationData((DataValidation)validation);
                                        cell.setCellStyle(cellStyleText);
                                    } else {
                                        cell.setCellStyle(cellStyleGeneral);
                                    }
                                    if (columnsCounter == 1) {
                                        ClientAnchor anchor = factory.createClientAnchor();
                                        anchor.setCol1(cell.getColumnIndex());
                                        anchor.setCol2(cell.getColumnIndex() + 3);
                                        anchor.setRow1(cell.getRowIndex());
                                        anchor.setRow2(cell.getRowIndex() + 3);
                                        Comment comment = drawing.createCellComment(anchor);
                                        RichTextString str = factory.createRichTextString("ObjectID:" + ((ModelIDObject)rObj).getObjectID() + ";\nClass:" + rObj.getClass().getName());
                                        comment.setString(str);
                                        cell.setCellComment(comment);
                                    }
                                    masterRowCounter = dataRow.getRowNum();
                                }
                            }
                        }
                        if (++columnsCounter <= maxColumnsCount) continue;
                        maxColumnsCount = columnsCounter;
                    }
                    if (!removeHeaderRow) continue;
                    masterRowCounter -= 4;
                    worksheet.removeRow((Row)collectionNameRow);
                    worksheet.removeRow((Row)headerRow_L1);
                }
                if (createHeader) {
                    masterRowCounter += 2;
                    continue;
                }
                ++masterRowCounter;
            }
            for (int i = 0; i < maxColumnsCount; ++i) {
                worksheet.autoSizeColumn(i);
            }
            if (maxColumnsCount == 0) {
                maxColumnsCount = 1;
            }
            worksheet.addMergedRegion(new CellRangeAddress(1, 1, 0, maxColumnsCount - 1));
            worksheet.protectSheet("");
            workbook.write(fileOut);
            fileOut.flush();
            ((FileOutputStream)fileOut).close();
            boolean openReport = false;
            if (Desktop.isDesktopSupported()) {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV1"), this.reportFileName, this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                openReport = true;
            } else {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV2"), this.reportFileName, this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
            }
            if (openReport) {
                Desktop.getDesktop().open(new File(this.reportsPath, this.reportFileName));
            }
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().contains("Access is denied")) {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), e.getMessage()), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                LOGGER.error("Exception during report generation " + e.getMessage(), e);
            } else {
                JOptionPane.showMessageDialog(parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                LOGGER.error("Exception during report generation " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception during report generation " + e.getMessage(), e);
            JOptionPane.showMessageDialog(parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.generateSearchResultsXLSFile() Exception : " + e.getMessage(), e);
        }
        catch (Throwable ex) {
            System.out.println(ex);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.flush();
                    ((FileOutputStream)fileOut).close();
                }
                catch (IOException e) {
                    LOGGER.error("ReportsGenerator.generateSearchResultsXLSFile() : " + e.getMessage(), e);
                }
            }
        }
    }

    private Document gatherSingleTableViewData(DesignPart model, StandardReportTemplate reportTemplate, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tableview", "osdmSingleTableView:TableView");
            document.appendChild(rootElement);
            String namespace = "osdmSingleTableView:";
            this.createHeaderSection(document, namespace, rootElement);
            TableView view = (TableView)views.get(0);
            if (reportTemplate.isUseDiagrams()) {
                this.generateDiagrams(null, view);
                if (this.generatedDiagramsNamesListPerModel.size() > 0) {
                    this.addDiagramsElement(view, document, namespace, rootElement);
                }
            }
            this.currentObjectsList.add(view);
            this.createTableDetailsSection(document, namespace, rootElement, view);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single table view report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleEntityViewData(DesignPart model, StandardReportTemplate reportTemplate, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entityview", "osdmSingleEntityView:EntityView");
            document.appendChild(rootElement);
            String namespace = "osdmSingleEntityView:";
            this.createHeaderSection(document, namespace, rootElement);
            EntityView view = (EntityView)views.get(0);
            if (reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                this.generateDiagrams(null, view);
            }
            this.currentObjectsList.add(view);
            this.createEntityDetailsSection(document, namespace, rootElement, view);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single entity view report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllTablesViewsData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tablesviews", "osdmAllTablesViews:TablesViews");
            document.appendChild(rootElement);
            String namespace = "osdmAllTablesViews:";
            this.createHeaderSection(document, namespace, rootElement);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, views);
            Element viewsCollection = document.createElement(namespace + "TablesViewsCollection");
            rootElement.appendChild(viewsCollection);
            if (views.size() != 0) {
                this.currentObjectsList = views;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableViewSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (TableView view : this.currentObjectsList) {
                Element tableViewDetails = document.createElement(namespace + "TableViewDetails");
                viewsCollection.appendChild(tableViewDetails);
                this.createTableDetailsSection(document, namespace, tableViewDetails, view);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables views report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllEntitiesViewsData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entitiesviews", "osdmAllEntitiesViews:EntitiesViews");
            document.appendChild(rootElement);
            String namespace = "osdmAllEntitiesViews:";
            this.createHeaderSection(document, namespace, rootElement);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, views);
            Element entitiesCollection = document.createElement(namespace + "EntitiesViewsCollection");
            rootElement.appendChild(entitiesCollection);
            if (views.size() > 0) {
                this.currentObjectsList = views;
            } else {
                Iterator it0 = ((LogicalDesign)model).getEntityViewSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (EntityView view : this.currentObjectsList) {
                Element entityViewDetails = document.createElement(namespace + "EntityViewDetails");
                entitiesCollection.appendChild(entityViewDetails);
                this.createEntityDetailsSection(document, namespace, entityViewDetails, view);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all entities views report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private void setXLSCellBorders(HSSFCellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSearchResultsXLSXFile(CustomReportTemplate crt, List objects, HashMap extraParams) {
        OutputStream fileOut = null;
        BaseReportsGenerationDialog parent = (BaseReportsGenerationDialog)extraParams.get("parent");
        Boolean replaceBooleanValues = (Boolean)extraParams.get("pboolean");
        String strTrue = (String)extraParams.get("ptrue");
        String strFalse = (String)extraParams.get("pfalse");
        Boolean showFilter = (Boolean)extraParams.get("show");
        String searchPattern = (String)extraParams.get("pattern");
        Object ssobj = extraParams.get("filterObject");
        String searchFilterObject = "";
        if (ssobj instanceof SearchSet) {
            searchFilterObject = ((SearchSet)ssobj).getTypeName();
        }
        try {
            ModelIDObject obj;
            fileOut = new FileOutputStream(new File(this.reportsPath, this.reportFileName));
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet worksheet = workbook.createSheet(Messages.getString("ReportsGenerator.SearchResultsDetails"));
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(worksheet);
            XSSFDataValidation validation = null;
            XSSFFont fontC = workbook.createFont();
            fontC.setFontName("Tahoma");
            fontC.setFontHeightInPoints((short)12);
            String designId = "";
            String modelId = "";
            ModelIDObject currentModel = null;
            Iterator it = objects.iterator();
            if (it.hasNext()) {
                SearchResultObject ro = (SearchResultObject)it.next();
                designId = ((ModelIDObject)ro.getObj()).getDesign().getObjectID();
                modelId = ((ModelIDObject)ro.getObj()).getModelID();
                currentModel = this.getModelByID(((ModelIDObject)ro.getObj()).getDesign(), modelId);
            }
            XSSFRow titleRow = worksheet.createRow(1);
            titleRow.setHeight((short)((double)titleRow.getHeight() * 1.5));
            XSSFCell cell = titleRow.createCell(0);
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFFont fontT = workbook.createFont();
            fontT.setFontName("Tahoma");
            fontT.setFontHeightInPoints((short)13);
            fontT.setBold(true);
            cellStyle.setFont((Font)fontT);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue(this.reportCaption);
            if (showFilter.booleanValue()) {
                XSSFFont fontPF = workbook.createFont();
                fontPF.setFontHeightInPoints((short)12);
                fontPF.setBold(true);
                XSSFCellStyle cellStyleFP = workbook.createCellStyle();
                cellStyleFP.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                cellStyleFP.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyleFP.setAlignment(HorizontalAlignment.LEFT);
                this.setXLSXCellBorders(cellStyleFP);
                cellStyleFP.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cellStyleFP.setFont((Font)fontPF);
                XSSFFont fontPFValue = workbook.createFont();
                fontPFValue.setFontHeightInPoints((short)12);
                XSSFCellStyle cellStyleFPValue = workbook.createCellStyle();
                cellStyleFPValue.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                cellStyleFPValue.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyleFPValue.setAlignment(HorizontalAlignment.LEFT);
                this.setXLSXCellBorders(cellStyleFPValue);
                cellStyleFPValue.setFont((Font)fontPFValue);
                XSSFRow patternRow = worksheet.createRow(3);
                patternRow.setHeight((short)((double)patternRow.getHeight() * 1.2));
                cell = patternRow.createCell(0);
                cell.setCellStyle((CellStyle)cellStyleFP);
                cell.setCellValue("Pattern");
                cell = patternRow.createCell(1);
                XSSFCellStyle cellStylePatternValue = workbook.createCellStyle();
                cellStylePatternValue.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                this.setXLSXCellBorders(cellStylePatternValue);
                cell.setCellStyle((CellStyle)cellStyleFPValue);
                cell.setCellValue(searchPattern);
                XSSFRow filterRow = worksheet.createRow(4);
                filterRow.setHeight((short)((double)filterRow.getHeight() * 1.2));
                cell = filterRow.createCell(0);
                cell.setCellStyle((CellStyle)cellStyleFP);
                cell.setCellValue("Filter");
                cell = filterRow.createCell(1);
                XSSFCellStyle cellStyleFilterValue = workbook.createCellStyle();
                cellStyleFilterValue.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
                this.setXLSXCellBorders(cellStyleFilterValue);
                cell.setCellStyle((CellStyle)cellStyleFPValue);
                cell.setCellValue(searchFilterObject + " " + currentModel.getName());
            }
            XSSFFont fontH = workbook.createFont();
            XSSFCellStyle cellStyleH = workbook.createCellStyle();
            cellStyleH.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleH.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleH.setAlignment(HorizontalAlignment.CENTER);
            cellStyleH.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSXCellBorders(cellStyleH);
            fontH.setFontHeightInPoints((short)12);
            fontH.setFontName("Tahoma");
            fontH.setBold(true);
            cellStyleH.setFont((Font)fontH);
            XSSFFont fontH_L1 = workbook.createFont();
            XSSFCellStyle cellStyleL1Header = workbook.createCellStyle();
            cellStyleL1Header.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleL1Header.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleL1Header.setAlignment(HorizontalAlignment.CENTER);
            cellStyleL1Header.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSXCellBorders(cellStyleL1Header);
            fontH_L1.setFontHeightInPoints((short)12);
            fontH_L1.setFontName("Tahoma");
            fontH_L1.setBold(true);
            cellStyleL1Header.setFont((Font)fontH);
            XSSFCellStyle cellStyleL1Data = workbook.createCellStyle();
            cellStyleL1Data.setLocked(false);
            cellStyleL1Data.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleL1Data.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleL1Data.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSXCellBorders(cellStyleL1Data);
            cellStyleL1Data.setFont((Font)fontC);
            cellStyleL1Data.setWrapText(true);
            XSSFFont cellStyleL1CollectionNameFont = workbook.createFont();
            XSSFCellStyle cellStyleL1CollectionName = workbook.createCellStyle();
            cellStyleL1CollectionName.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleL1CollectionName.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleL1CollectionName.setAlignment(HorizontalAlignment.LEFT);
            cellStyleL1CollectionName.setFont((Font)fontC);
            cellStyleL1CollectionName.setWrapText(true);
            cellStyleL1CollectionName.setLocked(true);
            cellStyleL1CollectionNameFont.setFontHeightInPoints((short)10);
            cellStyleL1CollectionNameFont.setFontName("Tahoma");
            cellStyleL1CollectionNameFont.setItalic(true);
            cellStyleL1CollectionName.setFont((Font)cellStyleL1CollectionNameFont);
            XSSFCellStyle cellStyleGeneral = workbook.createCellStyle();
            cellStyleGeneral.setLocked(false);
            cellStyleGeneral.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleGeneral.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleGeneral.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSXCellBorders(cellStyleGeneral);
            cellStyleGeneral.setFont((Font)fontC);
            cellStyleGeneral.setWrapText(true);
            XSSFCellStyle cellStyleText = workbook.createCellStyle();
            cellStyleText.setLocked(false);
            cellStyleText.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
            cellStyleText.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleText.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSXCellBorders(cellStyleText);
            cellStyleText.setFont((Font)fontC);
            cellStyleText.setWrapText(true);
            XSSFCellStyle cellStyleReadOnly = workbook.createCellStyle();
            cellStyleReadOnly.setLocked(true);
            cellStyleReadOnly.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleReadOnly.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleReadOnly.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSXCellBorders(cellStyleReadOnly);
            cellStyleReadOnly.setFont((Font)fontC);
            cellStyleReadOnly.setWrapText(true);
            XSSFCreationHelper factory = workbook.getCreationHelper();
            XSSFDrawing drawing = workbook.getSheetAt(0).createDrawingPatriarch();
            int headerRowIndex = showFilter != false ? 6 : 3;
            int columnsCounter = 0;
            int maxColumnsCount = 0;
            int masterRowCounter = headerRowIndex;
            ArrayList<String> propertiesList = null;
            LinkedHashMap usedPropertiesMap = new LinkedHashMap();
            HashMap<Class, String> sectionsNamesMap = new HashMap<Class, String>();
            HashMap columnsNamesMap = new HashMap();
            HashMap<Class, LinkedList> columnsMap = new HashMap<Class, LinkedList>();
            HashMap<Class, Integer> sectionsLevelsMap = new HashMap<Class, Integer>();
            List crtSectionsList = crt.getReportSections();
            for (ReportSection rs : crtSectionsList) {
                HashMap<String, String> propertiesToColumnsNamesMap = new HashMap<String, String>();
                propertiesList = new ArrayList<String>();
                for (ReportColumn rc : rs.getReportColumns()) {
                    propertiesList.add(rc.getPropertyName());
                    propertiesToColumnsNamesMap.put(rc.getPropertyName(), rc.getColumnName());
                }
                usedPropertiesMap.put(rs.getElementClass(), propertiesList);
                sectionsNamesMap.put(rs.getElementClass(), rs.getCustomName());
                columnsNamesMap.put(rs.getElementClass(), propertiesToColumnsNamesMap);
                columnsMap.put(rs.getElementClass(), rs.getReportColumns());
                sectionsLevelsMap.put(rs.getElementClass(), new Integer(rs.getLevel()));
            }
            int rowCounter = 0;
            XSSFSheet propertiesMapWS = workbook.createSheet("propertiesMap");
            for (Map.Entry pairs : usedPropertiesMap.entrySet()) {
                Class clazz = (Class)pairs.getKey();
                XSSFRow hRow = propertiesMapWS.createRow(rowCounter);
                XSSFCell hCellLevel = hRow.createCell(0);
                hCellLevel.setCellStyle((CellStyle)cellStyleReadOnly);
                hCellLevel.setCellValue((double)((Integer)sectionsLevelsMap.get(clazz)).intValue());
                XSSFCell hCellClassName = hRow.createCell(1);
                hCellClassName.setCellStyle((CellStyle)cellStyleReadOnly);
                hCellClassName.setCellValue(clazz.getName());
                int colCounter = 1;
                for (String propertyName : (List)pairs.getValue()) {
                    XSSFCell hCellPropertyName = hRow.createCell(++colCounter);
                    hCellPropertyName.setCellStyle((CellStyle)cellStyleReadOnly);
                    hCellPropertyName.setCellValue(propertyName);
                }
                ++rowCounter;
            }
            HashMap<Class, CallSite> nameToLOVMap = new HashMap<Class, CallSite>();
            Iterator setsIt = null;
            if (currentModel instanceof DesignPart) {
                setsIt = ((DesignPart)currentModel).getSearchableSets().iterator();
            } else if (currentModel instanceof StorageDesign) {
                setsIt = ((StorageDesign)currentModel).getSearchableSets().iterator();
            }
            int lovSheetCounter = 0;
            while (setsIt.hasNext()) {
                SearchSet ss = (SearchSet)setsIt.next();
                Class clazz = ss.getClazz();
                rowCounter = 0;
                ElementSet elements = (ElementSet)((Object)ss.getSet());
                if (elements.size() <= 0) continue;
                nameToLOVMap.put(ss.getClazz(), (CallSite)((Object)("lov_" + lovSheetCounter)));
                XSSFSheet hiddenWS = workbook.createSheet("lov_" + lovSheetCounter);
                workbook.setSheetHidden(lovSheetCounter + 1, true);
                elements.sort();
                Iterator elIt = elements.iterator();
                while (elIt.hasNext()) {
                    obj = (ModelIDObject)elIt.next();
                    XSSFRow hRow = hiddenWS.createRow(rowCounter);
                    XSSFCell hCellObjID = hRow.createCell(0);
                    hCellObjID.setCellStyle((CellStyle)cellStyleReadOnly);
                    hCellObjID.setCellValue(obj.getObjectID());
                    XSSFCell hCellObjValue = hRow.createCell(1);
                    hCellObjValue.setCellStyle((CellStyle)cellStyleReadOnly);
                    hCellObjValue.setCellValue(obj.getName());
                    ++rowCounter;
                }
                hiddenWS.protectSheet("");
                ++lovSheetCounter;
            }
            XSSFRow headerRow = null;
            boolean createHeader = true;
            int objCount = 0;
            Collections.sort(objects, new PropertiesComparator(objects, ((ReportSection)crt.getReportSections().get(0)).getReportColumns()));
            Iterator objectsIt = objects.iterator();
            while (objectsIt.hasNext()) {
                ++objCount;
                SearchResultObject ro = (SearchResultObject)objectsIt.next();
                obj = (ModelIDObject)ro.getObj();
                String objName = obj.getName();
                ClassDescription cd = this.metaDataManager.getClassDescription(obj.getClass().getName());
                if (usedPropertiesMap.size() == 1) {
                    if (objCount == 1) {
                        headerRow = worksheet.createRow(masterRowCounter);
                        headerRow.setHeight((short)((double)headerRow.getHeight() * 1.2));
                        createHeader = true;
                    } else {
                        createHeader = false;
                    }
                } else {
                    headerRow = worksheet.createRow(masterRowCounter);
                    headerRow.setHeight((short)((double)headerRow.getHeight() * 1.2));
                    createHeader = true;
                }
                int newLines = 1;
                columnsCounter = 0;
                boolean createDataRow = true;
                XSSFRow dataRow = null;
                Iterator usedPropertiesIt = ((List)usedPropertiesMap.get(obj.getClass())).iterator();
                while (usedPropertiesIt.hasNext() && columnsCounter <= 30) {
                    RichTextString str;
                    Comment comment;
                    ClientAnchor anchor;
                    String propertyName = (String)usedPropertiesIt.next();
                    ClassDescription.PropertyDescription pd = cd.getSearchablePropertyDescriptionByName(propertyName);
                    boolean isDynamicProperty = false;
                    String value = "";
                    String className = "java.lang.String";
                    if (pd != null) {
                        className = pd.className;
                        java.lang.reflect.Method method = pd.getter;
                        value = this.getPropertiesValue(method, className, obj);
                    } else {
                        value = obj.getProperty(propertyName);
                        isDynamicProperty = true;
                    }
                    XSSFCell headerCell = null;
                    if (createHeader) {
                        headerCell = headerRow.createCell(columnsCounter);
                        headerCell.setCellStyle((CellStyle)cellStyleH);
                        HashMap propsToNamesMap = (HashMap)columnsNamesMap.get(ro.getClazz());
                        headerCell.setCellValue((String)propsToNamesMap.get(propertyName));
                    }
                    if (createDataRow) {
                        dataRow = createHeader ? worksheet.createRow(masterRowCounter + 1) : worksheet.createRow(masterRowCounter);
                        dataRow.setHeight((short)((double)dataRow.getHeight() * 1.2));
                        createDataRow = false;
                    }
                    cell = dataRow.createCell(columnsCounter);
                    cell.setCellStyle((CellStyle)cellStyleGeneral);
                    cell.setCellValue(value);
                    if (pd == null || ReportUtils.isReadOnlyProperty(cd, pd.name)) {
                        if (isDynamicProperty) {
                            cell.setCellStyle((CellStyle)cellStyleGeneral);
                        } else {
                            cell.setCellStyle((CellStyle)cellStyleReadOnly);
                        }
                    } else if (ReportUtils.isObjectTypeProperty(cd, pd.name)) {
                        String lov = this.getNameLOV(nameToLOVMap, Class.forName(pd.className));
                        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(lov + "!B1:B65000");
                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                        validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                        validation.setErrorStyle(0);
                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                        validation.setShowErrorBox(true);
                        worksheet.addValidationData((DataValidation)validation);
                        cell.setCellStyle((CellStyle)cellStyleGeneral);
                    } else if (className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1) {
                        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(new String[]{"true", "false"});
                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                        validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                        validation.setErrorStyle(0);
                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                        validation.setShowErrorBox(true);
                        worksheet.addValidationData((DataValidation)validation);
                        cell.setCellStyle((CellStyle)cellStyleText);
                    } else {
                        cell.setCellStyle((CellStyle)cellStyleGeneral);
                    }
                    if (columnsCounter == 0) {
                        anchor = factory.createClientAnchor();
                        anchor.setCol1(cell.getColumnIndex());
                        anchor.setCol2(cell.getColumnIndex() + 3);
                        anchor.setRow1(cell.getRowIndex());
                        anchor.setRow2(cell.getRowIndex() + 3);
                        comment = drawing.createCellComment(anchor);
                        str = factory.createRichTextString("ObjectID:" + obj.getObjectID() + ";\nClass:" + obj.getClass().getName());
                        comment.setString(str);
                        cell.setCellComment(comment);
                    }
                    if ((headerRow.getRowNum() == 3 || headerRow.getRowNum() == 6) && createHeader) {
                        if (columnsCounter == 0) {
                            anchor = factory.createClientAnchor();
                            anchor.setCol1(headerCell.getColumnIndex());
                            anchor.setCol2(headerCell.getColumnIndex() + 3);
                            anchor.setRow1(headerCell.getRowIndex());
                            anchor.setRow2(headerCell.getRowIndex() + 2);
                            comment = drawing.createCellComment(anchor);
                            str = factory.createRichTextString("DesignID:" + designId);
                            comment.setString(str);
                            headerCell.setCellComment(comment);
                        } else if (columnsCounter == 1) {
                            anchor = factory.createClientAnchor();
                            anchor.setCol1(headerCell.getColumnIndex());
                            anchor.setCol2(headerCell.getColumnIndex() + 3);
                            anchor.setRow1(headerCell.getRowIndex());
                            anchor.setRow2(headerCell.getRowIndex() + 2);
                            comment = drawing.createCellComment(anchor);
                            str = factory.createRichTextString("ModelID:" + modelId);
                            comment.setString(str);
                            headerCell.setCellComment(comment);
                        }
                    }
                    int currentValueNewLines = 1;
                    if (value != null) {
                        Matcher m = Pattern.compile("\n|\r", 8).matcher(value);
                        while (m.find()) {
                            ++currentValueNewLines;
                        }
                    }
                    if (newLines < currentValueNewLines) {
                        newLines = currentValueNewLines;
                    }
                    String[] lines = value.split("\\r?\\n");
                    for (int y = 0; y < lines.length; ++y) {
                        String line = lines[y];
                        if (line.length() <= 255) continue;
                        this.checkWordWrap(line, 255);
                        --newLines;
                    }
                    if (++columnsCounter <= maxColumnsCount) continue;
                    maxColumnsCount = columnsCounter;
                }
                int rowsToIncrease = newLines + this.wordWrappedRowsCount;
                if (rowsToIncrease <= 107) {
                    dataRow.setHeight((short)(dataRow.getHeight() * rowsToIncrease));
                } else {
                    dataRow.setHeight((short)(dataRow.getHeight() * 107));
                }
                this.wordWrappedRowsCount = 0;
                int dataRowsCounter = 0;
                boolean initialDataRowCounter = false;
                boolean headersCounter = false;
                dataRow = null;
                for (Map.Entry pairs : usedPropertiesMap.entrySet()) {
                    Class clazz = (Class)pairs.getKey();
                    usedPropertiesIt = ((List)pairs.getValue()).iterator();
                    if (clazz.equals(obj.getClass())) continue;
                    boolean removeHeaderRow = true;
                    columnsCounter = 1;
                    XSSFRow collectionNameRow = null;
                    if (columnsCounter == 1) {
                        collectionNameRow = worksheet.createRow(masterRowCounter + 3);
                        collectionNameRow.setHeight((short)((double)collectionNameRow.getHeight() * 1.2));
                        masterRowCounter = collectionNameRow.getRowNum();
                        XSSFCell collectionNameCell = collectionNameRow.createCell(columnsCounter);
                        collectionNameCell.setCellValue((String)sectionsNamesMap.get(clazz));
                        collectionNameCell.setCellStyle((CellStyle)cellStyleL1CollectionName);
                    }
                    XSSFRow headerRow_L1 = worksheet.createRow(masterRowCounter + 1);
                    headerRow_L1.setHeight((short)((double)headerRow_L1.getHeight() * 1.2));
                    masterRowCounter = headerRow_L1.getRowNum();
                    TreeMap<Integer, XSSFRow> dataRowsmap = new TreeMap<Integer, XSSFRow>();
                    while (usedPropertiesIt.hasNext()) {
                        String propertyName = (String)usedPropertiesIt.next();
                        XSSFCell headerCell = headerRow_L1.createCell(columnsCounter);
                        headerCell.setCellStyle((CellStyle)cellStyleL1Header);
                        HashMap propsToNamesMap = (HashMap)columnsNamesMap.get(clazz);
                        headerCell.setCellValue((String)propsToNamesMap.get(propertyName));
                        java.lang.reflect.Method method = null;
                        for (ReportSection rs : crtSectionsList) {
                            Object cd1;
                            if (!rs.getElementClass().equals(clazz)) continue;
                            if (rs.getType().equals("collection")) {
                                cd1 = (ClassDescription.CollectionDescription)rs.getElement();
                                method = ((ClassDescription.CollectionDescription)cd1).getter;
                                break;
                            }
                            if (rs.getType().equals("roPropertiesList")) {
                                ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)rs.getElement();
                                method = pd.getter;
                                break;
                            }
                            cd1 = (ClassDescription)rs.getElement();
                            ClassDescription.PropertyDescription pd = ((ClassDescription)cd1).getSearchablePropertyDescriptionByName(rs.getPropertyName());
                            if (pd == null) break;
                            method = pd.getter;
                            break;
                        }
                        dataRowsCounter = 1;
                        if (method != null) {
                            removeHeaderRow = true;
                            List<Object> items = new ArrayList();
                            Object col = method.invoke((Object)obj, new Object[0]);
                            Iterator<Object> itemsListIt = null;
                            if (col instanceof Collection) {
                                items = new ArrayList((Collection)col);
                                Collections.sort(items, new PropertiesComparator(items, (List)columnsMap.get(clazz)));
                                itemsListIt = items.iterator();
                            } else if (col instanceof ElementSet) {
                                items = Arrays.asList(((ElementSet)col).toArray());
                                Collections.sort(items, new PropertiesComparator(items, (List)columnsMap.get(clazz)));
                                itemsListIt = items.iterator();
                            }
                            if (itemsListIt == null) continue;
                            if (items.size() > 0) {
                                removeHeaderRow = false;
                                while (itemsListIt.hasNext()) {
                                    Object rObj = itemsListIt.next();
                                    ClassDescription cd1 = this.metaDataManager.getClassDescription(rObj.getClass().getName());
                                    ClassDescription.PropertyDescription pd = cd1.getSearchablePropertyDescriptionByName(propertyName);
                                    String value = "";
                                    String className = "java.lang.String";
                                    if (pd != null) {
                                        className = pd.className;
                                        java.lang.reflect.Method method1 = pd.getter;
                                        value = this.getPropertiesValue(method1, className, rObj);
                                    } else {
                                        DesignObject o = (DesignObject)rObj;
                                        value = o.getProperty(propertyName);
                                    }
                                    if (columnsCounter == 1) {
                                        dataRow = worksheet.createRow(headerRow_L1.getRowNum() + dataRowsCounter);
                                        dataRow.setHeight((short)((double)dataRow.getHeight() * 1.2));
                                        dataRowsmap.put(new Integer(dataRowsCounter), dataRow);
                                        ++dataRowsCounter;
                                    } else {
                                        dataRow = (XSSFRow)dataRowsmap.get(new Integer(dataRowsCounter));
                                        ++dataRowsCounter;
                                    }
                                    cell = dataRow.createCell(columnsCounter);
                                    cell.setCellStyle((CellStyle)cellStyleL1Data);
                                    cell.setCellValue(value);
                                    if (pd == null || ReportUtils.isReadOnlyProperty(cd1, pd.name)) {
                                        cell.setCellStyle((CellStyle)cellStyleReadOnly);
                                    } else if (ReportUtils.isObjectTypeProperty(cd1, pd.name)) {
                                        String lov = this.getNameLOV(nameToLOVMap, Class.forName(pd.className));
                                        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(lov + "!B1:B65000");
                                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                                        validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                                        validation.setErrorStyle(0);
                                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                                        validation.setShowErrorBox(true);
                                        worksheet.addValidationData((DataValidation)validation);
                                        cell.setCellStyle((CellStyle)cellStyleGeneral);
                                    } else if (className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1) {
                                        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(new String[]{"true", "false"});
                                        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), columnsCounter, columnsCounter);
                                        validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                                        validation.setErrorStyle(0);
                                        validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                                        validation.setShowErrorBox(true);
                                        worksheet.addValidationData((DataValidation)validation);
                                        cell.setCellStyle((CellStyle)cellStyleText);
                                    } else {
                                        cell.setCellStyle((CellStyle)cellStyleGeneral);
                                    }
                                    if (columnsCounter == 1) {
                                        ClientAnchor anchor = factory.createClientAnchor();
                                        anchor.setCol1(cell.getColumnIndex());
                                        anchor.setCol2(cell.getColumnIndex() + 3);
                                        anchor.setRow1(cell.getRowIndex());
                                        anchor.setRow2(cell.getRowIndex() + 3);
                                        Comment comment = drawing.createCellComment(anchor);
                                        RichTextString str = factory.createRichTextString("ObjectID:" + ((ModelIDObject)rObj).getObjectID() + ";\nClass:" + rObj.getClass().getName());
                                        comment.setString(str);
                                        cell.setCellComment(comment);
                                    }
                                    masterRowCounter = dataRow.getRowNum();
                                }
                            }
                        }
                        if (++columnsCounter <= maxColumnsCount) continue;
                        maxColumnsCount = columnsCounter;
                    }
                    if (!removeHeaderRow) continue;
                    masterRowCounter -= 4;
                    worksheet.removeRow((Row)collectionNameRow);
                    worksheet.removeRow((Row)headerRow_L1);
                }
                if (createHeader) {
                    masterRowCounter += 2;
                    continue;
                }
                ++masterRowCounter;
            }
            for (int i = 0; i < maxColumnsCount; ++i) {
                worksheet.autoSizeColumn(i);
            }
            if (maxColumnsCount == 0) {
                maxColumnsCount = 1;
            }
            worksheet.addMergedRegion(new CellRangeAddress(1, 1, 0, maxColumnsCount - 1));
            worksheet.protectSheet("");
            workbook.write(fileOut);
            fileOut.flush();
            ((FileOutputStream)fileOut).close();
            boolean openReport = false;
            if (Desktop.isDesktopSupported()) {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV1"), this.reportFileName, this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                openReport = true;
            } else {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV2"), this.reportFileName, this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
            }
            if (openReport) {
                Desktop.getDesktop().open(new File(this.reportsPath, this.reportFileName));
            }
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().contains("Access is denied")) {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), e.getMessage()), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                LOGGER.error("Exception during report generation " + e.getMessage(), e);
            } else {
                JOptionPane.showMessageDialog(parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                LOGGER.error("Exception during report generation " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception during report generation " + e.getMessage(), e);
            JOptionPane.showMessageDialog(parent, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.generateSearchResultsXLSFile() Exception : " + e.getMessage(), e);
            e.printStackTrace();
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.flush();
                    ((FileOutputStream)fileOut).close();
                }
                catch (IOException e) {
                    LOGGER.error("ReportsGenerator.generateSearchResultsXLSFile() : " + e.getMessage(), e);
                }
            }
        }
    }

    private void setXLSXCellBorders(XSSFCellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.index);
    }

    private void createPDFReport() {
        this.extraParams.put("xsltFile", this.xsltFile.getAbsolutePath());
        this.extraParams.put("reportFileName", this.reportFileName);
        this.extraParams.put("objectsList", this.currentObjectsList);
        this.extraParams.put("diagramsList", this.generatedDiagramsNamesListPerModel);
        this.extraParams.put("loaded_designs", true);
        this.extraParams.put("subviews_section_included", this.reportTemplate.isUseDiagrams());
        this.extraParams.put("dpv_objects_map", this.swObjectsMap);
        HashMap<String, String> dpvToSVGSuffixMap1 = new HashMap<String, String>();
        for (Map.Entry pairs : this.dpvToSVGSuffixMap.entrySet()) {
            DesignPartView dpv = (DesignPartView)pairs.getKey();
            dpvToSVGSuffixMap1.put(dpv.getName(), (String)pairs.getValue());
        }
        this.extraParams.put("dpv_to_suffix_map", dpvToSVGSuffixMap1);
        if (this.model instanceof RelationalDesign) {
            List schemaNames = this.getSchemaNames();
            this.extraParams.put("schemaNamesList", schemaNames);
            if (schemaNames.size() <= 1) {
                this.extraParams.put("groupBySchemaName", true);
            } else {
                this.extraParams.put("groupBySchemaName", false);
            }
        } else {
            this.extraParams.put("schemaNamesList", new ArrayList());
            this.extraParams.put("groupBySchemaName", true);
        }
    }

    private List getSchemaNames() {
        ArrayList<String> schemaNames = new ArrayList<String>();
        Iterator it = ((RelationalDesign)this.model).getSchemaObjectSet().iterator();
        while (it.hasNext()) {
            SchemaObject so = (SchemaObject)it.next();
            schemaNames.add(so.getName());
        }
        return schemaNames;
    }

    private String getSizePrecisionScale(Object obj, String dataType) {
        if (((String)dataType).equalsIgnoreCase("unknown")) {
            return "";
        }
        String precision = "";
        String scale = "";
        String size = "";
        if (obj instanceof Column) {
            precision = ((Column)obj).getPrecision();
            scale = ((Column)obj).getScale();
            size = ((Column)obj).getSize();
        } else if (obj instanceof Attribute) {
            precision = ((Attribute)obj).getPrecision();
            scale = ((Attribute)obj).getScale();
            size = ((Attribute)obj).getSize();
        } else if (obj instanceof Domain) {
            precision = ((Domain)obj).getPrecision();
            scale = ((Domain)obj).getScale();
            size = ((Domain)obj).getSize();
        } else if (obj instanceof TypeElement) {
            precision = Integer.valueOf(((TypeElement)obj).getPrecision()).toString();
            scale = Integer.valueOf(((TypeElement)obj).getScale()).toString();
            size = ((TypeElement)obj).getSize();
        }
        if (precision != null && !precision.trim().equals("") && !precision.trim().equals("0")) {
            if (((String)(dataType = (String)dataType + " (" + precision)).indexOf("(") > -1) {
                if (scale != null && !scale.trim().equals("") && !scale.trim().equals("0")) {
                    dataType = (String)dataType + "," + scale;
                }
                dataType = (String)dataType + ")";
            }
        } else if (size != null && !size.trim().equals("") && !size.trim().equals("0")) {
            dataType = (String)dataType + " (" + size + ") ";
        }
        dataType = ((String)dataType).replace("(0,0)", "");
        dataType = ((String)dataType).replace("(0)", "");
        dataType = ((String)dataType).replace("()", "");
        dataType = ((String)dataType).replace("Unknown", "");
        dataType = ((String)dataType).replace("unknown", "");
        dataType = ((String)dataType).replace("UNKNOWN", "");
        return dataType;
    }

    private void generateDiagrams(DesignPart model, DesignObject object) {
        this.dpvToSVGSuffixMap.clear();
        this.monitor.setNote("Generating diagrams ...");
        this.generatedDiagramsNamesListPerModel.clear();
        Iterator allDiagramsIt = null;
        if (model != null) {
            ArrayList<DesignPartView> allDiagrams = new ArrayList<DesignPartView>();
            for (DesignPartView dpv : model.getAllDiagrams()) {
                List dList = ReportsGenerator.getDisplays(dpv);
                allDiagrams.add(dpv);
                allDiagrams.addAll(dList);
            }
            this.lastDiagram = (DesignPartViewPlaceHolder)((DesignPartView)allDiagrams.get(allDiagrams.size() - 1)).getPlaceHolder();
            allDiagramsIt = allDiagrams.iterator();
        }
        if (object != null) {
            ArrayList<DesignPartView> diagrams = new ArrayList<DesignPartView>();
            diagrams.add(object.getDesignPart().getMainView());
            diagrams.addAll(object.getAffectedDPVs());
            allDiagramsIt = diagrams.iterator();
        }
        int seq = 1;
        while (allDiagramsIt.hasNext()) {
            DesignPartView dpv = (DesignPartView)allDiagramsIt.next();
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            String s = "__dg_rm_" + seq;
            this.dpvToSVGSuffixMap.put(dpv, s);
            ++seq;
        }
        Collections.sort(this.generatedDiagramsNamesListPerModel, this.toStringComparator);
    }

    protected static List getDisplays(DesignPartView dpv) {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        Iterator it = dpv.getDisplays().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder phd = (DesignPartViewPlaceHolder)it.next();
            list.add(phd.getDesignPartView());
        }
        return list;
    }

    private DesignPartView getDiagramForObject(DesignObject object) {
        return this.getDiagramForObject(object, this.subviewsMap);
    }

    private DesignPartView getDiagramForObject(DesignObject object, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap) {
        for (DesignPartView dpv : object.getAffectedDPVs()) {
            if (subViewsMap != null) {
                if (subViewsMap.get(dpv.getPlaceHolder()) == null) continue;
                return dpv;
            }
            return dpv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePDF(DesignPartView dpv, DesignPartViewPlaceHolder ph, String diagramName) {
        AbstractDiagram diagram = null;
        RepaintManager currentManager = null;
        double scale = 0.0;
        boolean forceClose = false;
        boolean showGrid = false;
        boolean showPageGrid = false;
        try {
            if (this.openedDiagramscounter == 3) {
                for (DesignPartViewPlaceHolder d : this.diagramsToBeClosedList) {
                    d.setVisibleNoLater(false);
                }
                this.diagramsToBeClosedList.clear();
                this.diagramsToBeClosedList.add(ph);
                this.openedDiagramscounter = 0;
            }
            ++this.openedDiagramscounter;
            this.diagramsToBeClosedList.add(ph);
            if (this.lastDiagram == ph) {
                forceClose = true;
            }
            File dir = new File(this.reportsPath, this.modelExtraFilesDirName);
            boolean success = false;
            success = !dir.exists() ? dir.mkdir() : true;
            if (success) {
                File tempFile = new File(dir, diagramName + ".pdf");
                if (tempFile.exists()) {
                    return;
                }
                diagram = dpv.getWorkSpace();
                scale = diagram.getScale();
                ((Diagram)diagram).actualSize();
                showGrid = diagram.isGridVisible();
                showPageGrid = diagram.isPageGridVisible();
                diagram.setGridVisible(false);
                diagram.setPageGridVisible(false);
                if (showGrid || showPageGrid) {
                    diagram.repaint();
                }
                currentManager = RepaintManager.currentManager(diagram);
                currentManager.setDoubleBufferingEnabled(false);
                PDFExporter.diagramToPDF((Diagram)diagram, tempFile.getAbsolutePath());
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception when generating PDF (" + diagramName + ")" + e.getMessage(), e);
        }
        finally {
            if (forceClose) {
                for (DesignPartViewPlaceHolder d : this.diagramsToBeClosedList) {
                    d.setVisibleNoLater(false);
                }
                this.diagramsToBeClosedList.clear();
                this.openedDiagramscounter = 0;
            }
            if (currentManager != null) {
                currentManager.setDoubleBufferingEnabled(true);
            }
            if (diagram != null) {
                diagram.setScale(scale);
                diagram.setGridVisible(showGrid);
                diagram.setPageGridVisible(showPageGrid);
            }
        }
    }

    private static String getDiagramName(DesignPartView dpv) {
        String name = "";
        name = dpv.getName();
        if ((name == null || "".equals(name)) && ((name = dpv.getDesignPart().getName()) == null || "".equals(name))) {
            name = dpv.getDesignPart().getObjectTypeName();
        }
        return name;
    }

    private static boolean ensureDisplayViewVisible(DesignPartViewPlaceHolder placeHolder) {
        placeHolder.setVisibleNoLater(true);
        boolean nowVisible = placeHolder.getVisible();
        return nowVisible;
    }

    public ModelIDObject getModelByID(Design d, String modelObjId) {
        ArrayList<ModelIDObject> allModels = new ArrayList<ModelIDObject>();
        for (RelationalDesign rd : d.getRelationalDesigns()) {
            allModels.add(rd);
            StorageDesign[] storageDesigns = rd.getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < storageDesigns.length; ++i) {
                allModels.add(storageDesigns[i]);
            }
        }
        for (MultidimensionalDesign md : d.getMultidimensionalDesigns()) {
            allModels.add(md);
        }
        for (DataFlowDesign dfd : d.getProcessModel().getDataFlowDesigns()) {
            if (!dfd.isTopLevel()) continue;
            allModels.add(dfd);
        }
        allModels.add(d.getLogicalDesign());
        allModels.add(d.getDataTypesDesign());
        allModels.add(d.getProcessModel());
        allModels.add(d.getBusinessInfoDesign());
        for (ModelIDObject model : allModels) {
            if (!model.getObjectID().equals(modelObjId)) continue;
            return model;
        }
        return null;
    }

    private Document gatherObjComparisonData(List objectsList, HashMap extraParams) {
        Document document = null;
        try {
            boolean getModels = true;
            boolean isCompareModels = (Boolean)extraParams.get("compareModels");
            boolean separate = (Boolean)extraParams.get("separateObjByStatus");
            boolean isDMDImport = (Boolean)extraParams.get("DMDImport");
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/objectscomparison", "osdmObjectsComparison:Objects");
            document.appendChild(rootElement);
            String namespace = "osdmObjectsComparison:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element separateObj = document.createElement(namespace + "SeparateObjByStatus");
            separateObj.appendChild(document.createTextNode(separate ? "Y" : "N"));
            rootElement.appendChild(separateObj);
            Element dmdImp = document.createElement(namespace + "IsDMDImport");
            dmdImp.appendChild(document.createTextNode(isDMDImport ? "Y" : "N"));
            rootElement.appendChild(dmdImp);
            Element objCollection = document.createElement(namespace + "ObjectsCollection");
            rootElement.appendChild(objCollection);
            Collections.sort(objectsList, new ObjectsComparator());
            Iterator it = objectsList.iterator();
            while (it.hasNext()) {
                Object pc1;
                ArrayList propertiesList = new ArrayList();
                CompareTabularView.SelectionPair sp = (CompareTabularView.SelectionPair)it.next();
                ModelIdObjectSelection obj = sp.leftSel;
                if (isCompareModels) {
                    pc1 = ((CompareObjectSelection)obj).getPropertiesComparator();
                    propertiesList.addAll(((oracle.dbtools.crest.model.design.compare.PropertiesComparator)pc1).getPropertiesList());
                    propertiesList.addAll(((oracle.dbtools.crest.model.design.compare.PropertiesComparator)pc1).getStoragePropertiesList());
                } else if (isDMDImport) {
                    pc1 = ((CompareCWDDesigns)obj).getPropertiesComparator();
                    propertiesList.addAll(((oracle.dbtools.crest.model.design.compare.PropertiesComparator)pc1).getPropertiesList());
                    propertiesList.addAll(((oracle.dbtools.crest.model.design.compare.PropertiesComparator)pc1).getStoragePropertiesList());
                } else {
                    pc1 = ((EngineeringObjectSelection)obj).getPropertiesComparator();
                    propertiesList.addAll(pc1.getPropertiesList());
                }
                String statusStr = "";
                int status = sp.getStatus();
                switch (status) {
                    case 0: {
                        statusStr = CompareTabularView.UNCHANGED;
                        break;
                    }
                    case 1: {
                        statusStr = CompareTabularView.MODIFIED;
                        break;
                    }
                    case 2: {
                        statusStr = CompareTabularView.NEW;
                        break;
                    }
                    case 3: {
                        statusStr = CompareTabularView.DELETED;
                    }
                }
                if (statusStr.equals(CompareTabularView.UNCHANGED)) continue;
                if (isCompareModels && getModels) {
                    Element designNameElement = document.createElement(namespace + "DesignName");
                    designNameElement.appendChild(document.createTextNode(sp.getModel() != null ? sp.getModel().getDesign().getName() : ""));
                    rootElement.appendChild(designNameElement);
                    Element srcModelNameElement = document.createElement(namespace + "SourceModelName");
                    srcModelNameElement.appendChild(document.createTextNode(sp.getModel() != null ? sp.getModel().getName() : ""));
                    rootElement.appendChild(srcModelNameElement);
                    Element trgModelNameElement = document.createElement(namespace + "TargetModelName");
                    trgModelNameElement.appendChild(document.createTextNode(sp.getParentModel() != null ? sp.getParentModel().getName() : ""));
                    rootElement.appendChild(trgModelNameElement);
                    getModels = false;
                }
                Element objDetails = document.createElement(namespace + "ObjectDetails");
                objCollection.appendChild(objDetails);
                Element object = null;
                object = document.createElement(namespace + "Object");
                Attr attribute = document.createAttribute("SourceValue");
                attribute.setValue(sp.getLeftObj() != null ? sp.getLeftObj().getLongName() : "");
                object.setAttributeNode(attribute);
                attribute = document.createAttribute("TargetValue");
                attribute.setValue(sp.getRightObj() != null ? sp.getRightObj().getLongName() : "");
                object.setAttributeNode(attribute);
                attribute = document.createAttribute("Type");
                attribute.setValue(sp.getType());
                object.setAttributeNode(attribute);
                attribute = document.createAttribute("Status");
                attribute.setValue(statusStr);
                object.setAttributeNode(attribute);
                if (isDMDImport) {
                    attribute = document.createAttribute("DMDImpModelName");
                    attribute.setValue(sp.getModel().getName());
                    object.setAttributeNode(attribute);
                }
                objDetails.appendChild(object);
                if (!statusStr.equals(CompareTabularView.MODIFIED)) continue;
                Element propertiesC = null;
                Element propertiesItem = null;
                boolean createProperties = true;
                for (EngPropertyHolder ph : propertiesList) {
                    if (!ph.isModified()) continue;
                    if (createProperties) {
                        propertiesC = document.createElement(namespace + "PropertiesCollection");
                        object.appendChild(propertiesC);
                        createProperties = false;
                    }
                    Element propertiesD = document.createElement(namespace + "PropertyDetails");
                    propertiesC.appendChild(propertiesD);
                    propertiesItem = document.createElement(namespace + "PropertyName");
                    propertiesItem.appendChild(document.createTextNode(ph.getName()));
                    propertiesD.appendChild(propertiesItem);
                    propertiesItem = document.createElement(namespace + "PropertyOldValue");
                    propertiesItem.appendChild(document.createTextNode(ph.getLeftValue()));
                    propertiesD.appendChild(propertiesItem);
                    propertiesItem = document.createElement(namespace + "PropertyNewValue");
                    propertiesItem.appendChild(document.createTextNode(ph.getRightValue()));
                    propertiesD.appendChild(propertiesItem);
                }
            }
            rootElement.appendChild(objCollection);
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.gatherObjCOmparisonData() Exception : " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    public ProgressDialog getMonitor() {
        return new ProgressDialog(this.appView, "", 0, 100);
    }

    private void addDiagramsElement_old(DesignObject object, Document document, String namespace, Element parent) {
        ArrayList<DesignPartView> dpvList = new ArrayList<DesignPartView>();
        ArrayList l = new ArrayList(object.getAffectedDPVs());
        for (DesignPartView dpv : l) {
            if (dpv.isMainDiagram()) {
                if (!this.settings.isEmbedMainDiagramInReports()) continue;
                dpvList.add(dpv);
                continue;
            }
            dpvList.add(dpv);
        }
        Collections.sort(dpvList, new DPVComparator());
        Iterator dpvsIt = dpvList.iterator();
        Element diagramsCollectionElement = document.createElement(namespace + "DiagramsCollection");
        while (dpvsIt.hasNext()) {
            DesignPartView dpv = (DesignPartView)dpvsIt.next();
            String diagramName = ReportsGenerator.getDiagramName(dpv);
            for (String dPath : this.generatedDiagramsNamesListPerModel) {
                Element swDiagramLinkElement;
                Element diagramNameElement;
                String dName = dPath.substring(dPath.indexOf("/") + 1, dPath.length());
                String dn = dPath.substring(dPath.indexOf("/") + 1, dPath.length() - 4);
                if (!diagramName.equals(dn)) continue;
                try {
                    Path from = Paths.get(this.reportsPath, this.modelExtraFilesDirName, dName);
                    Path to = Paths.get(this.reportsPath, this.reportFilesDirName, dName);
                    CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                    Files.copy(from, to, options);
                }
                catch (Exception e1) {
                    LOGGER.error("Cannot copy diagram file from model directory to report directory " + e1.getMessage(), e1);
                }
                Element diagramElement = document.createElement(namespace + "Diagram");
                diagramsCollectionElement.appendChild(diagramElement);
                if (this.settings.isEmbedDiagramsInReports()) {
                    diagramNameElement = document.createElement(namespace + "Name");
                    diagramNameElement.appendChild(document.createTextNode("/" + dpv.getName()));
                    diagramElement.appendChild(diagramNameElement);
                    try {
                        swDiagramLinkElement = document.createElement(namespace + "Link");
                        if (((String)this.extraParams.get("out_format")).equals("HTML")) {
                            swDiagramLinkElement.appendChild(document.createTextNode(URLEncoder.encode(dpv.getName(), "UTF-8").replace("+", "%20")));
                        } else {
                            swDiagramLinkElement.appendChild(document.createTextNode(dpv.getName()));
                        }
                        diagramElement.appendChild(swDiagramLinkElement);
                    }
                    catch (Exception e) {
                        LOGGER.error("ReportsGenersator.addDiagramsElement() " + e.getMessage(), e);
                    }
                    Element diagramSuffixElement = document.createElement(namespace + "Suffix");
                    diagramSuffixElement.appendChild(document.createTextNode((String)this.dpvToSVGSuffixMap.get(dpv)));
                    diagramElement.appendChild(diagramSuffixElement);
                    break;
                }
                diagramNameElement = document.createElement(namespace + "Name");
                diagramNameElement.appendChild(document.createTextNode(dPath));
                diagramElement.appendChild(diagramNameElement);
                try {
                    swDiagramLinkElement = document.createElement(namespace + "Link");
                    swDiagramLinkElement.appendChild(document.createTextNode(dPath));
                    diagramElement.appendChild(swDiagramLinkElement);
                }
                catch (Exception e) {
                    LOGGER.error("ReportsGenersator.addDiagramsElement() " + e.getMessage(), e);
                }
                break;
            }
            parent.appendChild(diagramsCollectionElement);
        }
    }

    private void addDiagramsElement(DesignObject object, Document document, String namespace, Element parent) {
        ArrayList<DesignPartView> dpvList = new ArrayList<DesignPartView>();
        ArrayList l = new ArrayList(object.getAffectedDPVs());
        for (DesignPartView dpv : l) {
            if (dpv.isMainDiagram()) {
                if (!this.settings.isEmbedMainDiagramInReports() || this.dpvToSVGSuffixMap.get(dpv) == null) continue;
                dpvList.add(dpv);
                continue;
            }
            if (this.dpvToSVGSuffixMap.get(dpv) == null) continue;
            dpvList.add(dpv);
        }
        if (dpvList.size() > 0) {
            Collections.sort(dpvList, new DPVComparator());
            Iterator dpvsIt = dpvList.iterator();
            Element diagramsCollectionElement = document.createElement(namespace + "DiagramsCollection");
            while (dpvsIt.hasNext()) {
                DesignPartView dpv = (DesignPartView)dpvsIt.next();
                Element diagramElement = document.createElement(namespace + "Diagram");
                diagramsCollectionElement.appendChild(diagramElement);
                Element diagramNameElement = document.createElement(namespace + "Name");
                diagramNameElement.appendChild(document.createTextNode("/" + dpv.getName()));
                diagramElement.appendChild(diagramNameElement);
                try {
                    Element swDiagramLinkElement = document.createElement(namespace + "Link");
                    if (((String)this.extraParams.get("out_format")).equals("HTML")) {
                        swDiagramLinkElement.appendChild(document.createTextNode(URLEncoder.encode(dpv.getName(), "UTF-8").replace("+", "%20")));
                    } else {
                        swDiagramLinkElement.appendChild(document.createTextNode(dpv.getName()));
                    }
                    diagramElement.appendChild(swDiagramLinkElement);
                }
                catch (Exception e) {
                    LOGGER.error("ReportsGenersator.addDiagramsElement() " + e.getMessage(), e);
                }
                Element diagramSuffixElement = document.createElement(namespace + "Suffix");
                diagramSuffixElement.appendChild(document.createTextNode((String)this.dpvToSVGSuffixMap.get(dpv)));
                diagramElement.appendChild(diagramSuffixElement);
                parent.appendChild(diagramsCollectionElement);
            }
        }
    }

    private String getPropertiesValue(java.lang.reflect.Method method, String className, Object obj) {
        String value = "";
        try {
            if (method != null) {
                Object object = method.invoke(obj, new Object[0]);
                if (className.indexOf("java.lang.String") > -1) {
                    if (object != null) {
                        value = (String)object;
                    }
                } else if (className.indexOf("java.lang.Integer") > -1) {
                    if (object != null) {
                        value = ((Integer)object).toString();
                    }
                } else if (className.indexOf("java.lang.Boolean") > -1) {
                    if (object != null) {
                        value = this.replaceBooleanValues.booleanValue() ? ((Boolean)object != false ? this.strTrue : this.strFalse) : ((Boolean)object).toString();
                    }
                } else if (className.indexOf("boolean") > -1) {
                    if (object != null) {
                        value = this.replaceBooleanValues.booleanValue() ? (object.toString().equals("true") ? this.strTrue : this.strFalse) : object.toString();
                    }
                } else if (className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    if (object != null) {
                        value = object.toString();
                    }
                } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                    value = object != null && object instanceof Iterable ? ReportUtils.iteratorToString(((Iterable)object).iterator()) : (object != null && object instanceof List ? ReportUtils.listToString((List)object) : (object instanceof ModelObject ? ((ModelObject)object).getName() : object.toString()));
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        return value;
    }

    private String getNameLOV(Map map, Class clazz) {
        Object obj = map.get(clazz);
        if (obj == null) {
            Class cl;
            Iterator it = map.keySet().iterator();
            while (it.hasNext() && (!clazz.isAssignableFrom(cl = (Class)it.next()) || (obj = map.get(cl)) == null)) {
            }
            if (obj != null) {
                map.put(clazz, obj);
            } else {
                for (Class sup = clazz.getSuperclass(); sup != null && !sup.getName().equalsIgnoreCase("Object"); sup = sup.getSuperclass()) {
                    obj = map.get(sup);
                    if (obj == null) {
                        continue;
                    }
                    map.put(clazz, obj);
                    break;
                }
            }
        }
        return (String)obj;
    }

    private String checkWordWrap(String input, int length) {
        ++this.wordWrappedRowsCount;
        String text = input.trim();
        if (text.length() > length && text.contains(" ")) {
            String line = text.substring(0, length);
            int lineBreakIndex = line.indexOf("\n");
            int lineLastSpaceIndex = line.lastIndexOf(" ");
            int inputFirstSpaceIndex = text.indexOf(" ");
            int breakIndex = lineBreakIndex > -1 ? lineBreakIndex : (lineLastSpaceIndex > -1 ? lineLastSpaceIndex : inputFirstSpaceIndex);
            return text.substring(0, breakIndex) + "\n" + this.checkWordWrap(text.substring(breakIndex + 1), length);
        }
        return text;
    }

    private Element createHeaderSection(Document document, String namespace, Element rootElement) {
        Element rCaption = document.createElement(namespace + "ReportCaption");
        rCaption.appendChild(document.createTextNode(this.reportCaption));
        rootElement.appendChild(rCaption);
        Element rCompanyName = document.createElement(namespace + "CompanyName");
        rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
        rootElement.appendChild(rCompanyName);
        Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
        usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
        rootElement.appendChild(usePageBreaks);
        if (this.model != null) {
            Element e = document.createElement(namespace + "DesignName");
            e.appendChild(document.createTextNode(this.design.getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "VersionDate");
            e.appendChild(document.createTextNode(dateFormat.format(new Date())));
            rootElement.appendChild(e);
            String designComment = this.design.getComment();
            if (designComment != "" && designComment != null) {
                Element versionCommentElement = document.createElement(namespace + "VersionComment");
                versionCommentElement.appendChild(document.createCDATASection(designComment));
                rootElement.appendChild(versionCommentElement);
            }
            e = document.createElement(namespace + "ModelName");
            e.appendChild(document.createTextNode(this.model.getName()));
            rootElement.appendChild(e);
        }
        return rootElement;
    }

    private Element createSubviewsSection(Document document, String namespace, Element baseElement, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, DesignPart model, List objects) {
        Element subViewsCollectionElement = document.createElement(namespace + "SubViewsCollection");
        try {
            ArrayList<DesignPartViewPlaceHolder> sortedSWList = new ArrayList<DesignPartViewPlaceHolder>();
            if (subViewsMap.size() == 0) {
                sortedSWList.addAll(model.getAllDPVPlaceHoldersForObjects(objects, this.settings.isEmbedMainDiagramInReports()));
            } else {
                for (Map.Entry<DesignPartViewPlaceHolder, List<String>> entry : subViewsMap.entrySet()) {
                    DesignPartViewPlaceHolder sw = entry.getKey();
                    sortedSWList.add(sw);
                }
            }
            Collections.sort(sortedSWList, new SubviewsComparator());
            if (this.reportTemplate.isUseDiagrams() && sortedSWList.size() > 0) {
                if (this.reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() || this.settings.isEmbedDiagramsInReports()) {
                    this.generateDiagrams(model, null);
                }
                for (DesignPartViewPlaceHolder sw : sortedSWList) {
                    String suffix;
                    if (sw.getDesignPartView().isMainDiagram()) continue;
                    Element subViewsDetailsElement = document.createElement(namespace + "SubViewsDetails");
                    Element swNameElement = document.createElement(namespace + "SWName");
                    Object swName = "";
                    swName = this.settings.isEmbedDiagramsInReports() ? sw.getName() : this.reportFilesDirName + "/" + sw.getName() + ".pdf";
                    swNameElement.appendChild(document.createTextNode((String)swName));
                    subViewsDetailsElement.appendChild(swNameElement);
                    Element swDiagramLinkElement = document.createElement(namespace + "SWDiagramLink");
                    if (this.settings.isEmbedDiagramsInReports()) {
                        if (((String)this.extraParams.get("out_format")).equals("HTML")) {
                            swDiagramLinkElement.appendChild(document.createTextNode(URLEncoder.encode((String)swName, "UTF-8").replace("+", "%20")));
                        } else {
                            swDiagramLinkElement.appendChild(document.createTextNode((String)swName));
                        }
                    } else {
                        swDiagramLinkElement.appendChild(document.createTextNode((String)swName));
                    }
                    subViewsDetailsElement.appendChild(swDiagramLinkElement);
                    String description = "";
                    description = sw.getComment() == null || sw.getComment().equals("") ? sw.getCommentInRDBMS() : sw.getComment();
                    String notes = sw.getNotes();
                    if (description != "" && description != null || notes != "" && notes != null) {
                        Element descriptionNotesElement = document.createElement(namespace + "SWDescriptionNotes");
                        if (description != "" && description != null) {
                            Element descriptionElement = document.createElement(namespace + "SWDescription");
                            descriptionElement.appendChild(document.createCDATASection(description));
                            descriptionNotesElement.appendChild(descriptionElement);
                        }
                        if (notes != "" && notes != null) {
                            Element notesElement = document.createElement(namespace + "SWNotes");
                            notesElement.appendChild(document.createCDATASection(notes));
                            descriptionNotesElement.appendChild(notesElement);
                        }
                        subViewsDetailsElement.appendChild(descriptionNotesElement);
                    }
                    Iterator it = null;
                    Object o = objects.get(0);
                    if (o instanceof Table) {
                        it = ((DPVRelational)sw.getDesignPartView()).getTables().iterator();
                    } else if (o instanceof Entity) {
                        it = ((DPVLogical)sw.getDesignPartView()).getEntities().iterator();
                    } else if (o instanceof TableView) {
                        it = ((DPVRelational)sw.getDesignPartView()).getTVViews().iterator();
                    } else if (o instanceof EntityView) {
                        it = ((DPVLogical)sw.getDesignPartView()).getTVViews().iterator();
                    }
                    List<String> swObjectsList = subViewsMap.get(sw);
                    if (swObjectsList == null) {
                        swObjectsList = new ArrayList<String>();
                        while (it.hasNext()) {
                            ContainerView tv;
                            Object dObject;
                            Object dObj = dObject = it.next();
                            if (dObject instanceof TVView) {
                                tv = (TVView)dObject;
                                dObj = tv.getModel();
                            } else if (dObject instanceof TVEntityView) {
                                tv = (TVEntityView)dObject;
                                dObj = tv.getModel();
                            }
                            if (!objects.contains(dObj)) continue;
                            swObjectsList.add((String)dObj);
                        }
                    }
                    if ((suffix = (String)this.dpvToSVGSuffixMap.get(sw.getObject())) == null) {
                        suffix = "";
                    }
                    Collections.sort(swObjectsList, new ObjectsComparator());
                    ArrayList<String> swObjectsListNames = new ArrayList<String>();
                    Element swObjectsElement = document.createElement(namespace + "SWObjects");
                    if (swObjectsList != null && swObjectsList.size() > 0) {
                        for (DesignObject designObject : swObjectsList) {
                            String objName = designObject.getLongName();
                            Element swObjectElement = document.createElement(namespace + "SWObject");
                            swObjectsElement.appendChild(swObjectElement);
                            Element swObjectNameElement = document.createElement(namespace + "SWObjectName");
                            swObjectNameElement.appendChild(document.createTextNode(objName));
                            swObjectElement.appendChild(swObjectNameElement);
                            Element swObjectLinkElement = document.createElement(namespace + "SWObjectLink");
                            swObjectLinkElement.appendChild(document.createTextNode(URLEncoder.encode((String)(suffix.isEmpty() ? designObject.getShortObjectID() : designObject.getShortObjectID() + suffix), "UTF-8").replace("+", "%20")));
                            swObjectElement.appendChild(swObjectLinkElement);
                            swObjectsListNames.add(designObject.getName());
                        }
                    }
                    subViewsDetailsElement.appendChild(swObjectsElement);
                    subViewsCollectionElement.appendChild(subViewsDetailsElement);
                    this.swObjectsMap.put((String)swName, swObjectsListNames);
                }
                baseElement.appendChild(subViewsCollectionElement);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Subviews Section : " + e.getMessage(), e);
            return subViewsCollectionElement;
        }
        return baseElement;
    }

    private Element createDescriptionAndNotesSection(Document document, String namespace, Element baseElement, Object object) {
        Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
        try {
            if (this.reportTemplate.isUseDescriptionInfo()) {
                String description = "";
                String notes = "";
                if (object instanceof DesignObject) {
                    DesignObject desObj = (DesignObject)object;
                    description = desObj.getComment() == null || desObj.getComment().equals("") ? desObj.getCommentInRDBMS() : desObj.getComment();
                    notes = desObj.getNotes();
                } else if (object instanceof AbstractView) {
                    AbstractView view = (AbstractView)object;
                    description = view.getComment() == null || view.getComment().equals("") ? view.getCommentInRDBMS() : view.getComment();
                    notes = view.getNotes();
                }
                if (description != null && !description.equals("") || notes != null && !notes.equals("")) {
                    if (description != null && !description.equals("")) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        descriptionNotesElement.appendChild(descriptionElement);
                    }
                    if (notes != null && !notes.equals("")) {
                        Element notesElement = document.createElement(namespace + "Notes");
                        notesElement.appendChild(document.createCDATASection(notes));
                        descriptionNotesElement.appendChild(notesElement);
                    }
                    baseElement.appendChild(descriptionNotesElement);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Description And Notes Section : " + e.getMessage(), e);
            return descriptionNotesElement;
        }
        return baseElement;
    }

    private Element createDiagramSuffixElement(Document document, String namespace, Element baseElement, DesignObject object) {
        try {
            if (this.settings.isEmbedDiagramsInReports()) {
                String suffix;
                DesignPartView dpv = null;
                dpv = this.settings.isEmbedMainDiagramInReports() ? object.getDesignPart().getMainView() : this.getDiagramForObject(object);
                if (dpv != null && (suffix = (String)this.dpvToSVGSuffixMap.get(dpv)) != null && !suffix.trim().equals("")) {
                    Element e = document.createElement(namespace + "DiagramSuffix");
                    e.appendChild(document.createTextNode(suffix));
                    baseElement.appendChild(e);
                }
            }
            return baseElement;
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create diagram suffix element  : " + e.getMessage(), e);
            return baseElement;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Element createTableDetailsSection(Document document, String namespace, Element baseElement, DesignObject object) {
        try {
            FKElement remotelColumn;
            Object columnsNames;
            Element fkCollection;
            FKElement col;
            Element columnsCollection;
            Element e;
            Table table = null;
            TableView tableView = null;
            boolean isTable = false;
            if (object instanceof Table) {
                table = (Table)object;
                isTable = true;
                e = document.createElement(namespace + "TableName");
                e.appendChild(document.createTextNode(table.getLongName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedTableName");
                e.appendChild(document.createTextNode(table.getShortObjectID()));
                baseElement.appendChild(e);
            } else if (object instanceof TableView) {
                tableView = (TableView)object;
                isTable = false;
                e = document.createElement(namespace + "ViewName");
                e.appendChild(document.createTextNode(tableView.getLongName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedViewName");
                e.appendChild(document.createTextNode(tableView.getShortObjectID()));
                baseElement.appendChild(e);
            }
            this.createDiagramSuffixElement(document, namespace, baseElement, object);
            if (isTable) {
                e = document.createElement(namespace + "FunctionalName");
                e.appendChild(document.createTextNode(table.getEngEntity() != null ? table.getEngEntity().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "Abbreviation");
                e.appendChild(document.createTextNode(table.getAbbreviation()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ClassificationTypeName");
                e.appendChild(document.createTextNode(table.getClassificationTypeName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ObjectTypeName");
                e.appendChild(document.createTextNode(table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "MVPrebuilt");
                e.appendChild(document.createTextNode(table.isOnPrebuiltTable() ? "Yes" : ""));
                baseElement.appendChild(e);
                if (table.getUserDefinedSQL() != null) {
                    e = document.createElement(namespace + "MVQuery");
                    e.appendChild(document.createCDATASection(table.getUserDefinedSQL()));
                    baseElement.appendChild(e);
                }
            } else {
                if (tableView.isBST()) {
                    e = document.createElement(namespace + "StructuredTypeName");
                    e.appendChild(document.createTextNode(tableView.getBasedOnStructuredType().getName()));
                    baseElement.appendChild(e);
                }
                if (this.settings.isIncludeSelectStatementInViewReport()) {
                    e = document.createElement(namespace + "SelectStatement");
                    e.appendChild(document.createCDATASection(tableView.getUserDefinedSQL()));
                    baseElement.appendChild(e);
                }
            }
            this.createDescriptionAndNotesSection(document, namespace, baseElement, object);
            if (isTable && this.reportTemplate.isUseQuantitativeInfo()) {
                Element quantitativeInfoCollectionElement = document.createElement(namespace + "QuantitativeInfoCollection");
                e = document.createElement(namespace + "NumberOfColumns");
                e.appendChild(document.createTextNode(Integer.valueOf(table.getElements().length).toString()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMin");
                e.appendChild(document.createTextNode(table.getMinVolumes()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMax");
                e.appendChild(document.createTextNode(table.getMaxVolumes()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedNumberOfRows");
                e.appendChild(document.createTextNode(table.getExpectedVolumes()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedGrowth");
                e.appendChild(document.createTextNode(table.getGrowthPercent()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "GrowthInterval");
                e.appendChild(document.createTextNode(table.getGrowthType()));
                quantitativeInfoCollectionElement.appendChild(e);
                baseElement.appendChild(quantitativeInfoCollectionElement);
            }
            if (this.reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() && this.settings.isEmbedDiagramsInReports()) {
                this.addDiagramsElement(object, document, namespace, baseElement);
            }
            if (isTable) {
                if (this.reportTemplate.isUseTableColumns()) {
                    int columnsCounter = 0;
                    columnsCollection = null;
                    for (Column column : Arrays.asList(table.getElements())) {
                        String personalInfo;
                        void var16_45;
                        if (columnsCounter == 0) {
                            columnsCollection = document.createElement(namespace + "ColumnsCollection");
                            baseElement.appendChild(columnsCollection);
                        }
                        Element columnDetails = document.createElement(namespace + "ColumnDetails");
                        columnsCollection.appendChild(columnDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        String fk = column.isFKElement() || column.isPartOfUnresolvedFK(table) ? "F" : "";
                        e.appendChild(document.createTextNode(fk));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                        columnDetails.appendChild(e);
                        String dataType = "";
                        String string = "";
                        String domainName = "";
                        switch (column.getUse()) {
                            case 0: {
                                String string2 = "DOM";
                                Domain domain = column.getDomain();
                                domainName = domain.getName();
                                dataType = this.getSizePrecisionScale(domain, domain.getLogicalDatatype().getName());
                                domainName = domainName.replace("Unknown", "");
                                domainName = domainName.replace("unknown", "");
                                domainName = domainName.replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                String string3 = "LT";
                                dataType = this.getSizePrecisionScale(column, column.getLogicalDatatype().getName());
                                break;
                            }
                            case 2: {
                                String string4 = "DT";
                                dataType = column.getDistinctType().getName();
                                break;
                            }
                            case 3: {
                                if (column.isReference()) {
                                    String string5 = "RST";
                                } else {
                                    String string6 = "ST";
                                }
                                dataType = column.getStructuredType().getName();
                                break;
                            }
                            case 4: {
                                String string7 = "CT";
                                dataType = column.getCollectionType().getName();
                            }
                        }
                        e = document.createElement(namespace + "DataType");
                        String string8 = column.isAutoIncrementColumn() ? " - AI" : "";
                        String id = column.isIdentityColumn() ? " - ID" : "";
                        e.appendChild(document.createTextNode(dataType + string8 + id));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "DataTypeKind");
                        e.appendChild(document.createTextNode((String)var16_45));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "DomainName");
                        e.appendChild(document.createTextNode(domainName));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "Formula");
                        e.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                        columnDetails.appendChild(e);
                        Object security = "";
                        String string9 = column.isContainsPII() == null ? "" : (personalInfo = column.isContainsPII() != false ? "Y" : "");
                        String sensitiveInfo = column.isContainsSensitiveInformation() == null ? "" : (column.isContainsSensitiveInformation() != false ? "Y" : "");
                        String maskInfo = column.getMaskingType();
                        security = personalInfo + "/" + sensitiveInfo + "/" + maskInfo;
                        security = ((String)security).replace("//", "");
                        e = document.createElement(namespace + "Security");
                        e.appendChild(document.createTextNode((String)security));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PreferredAbbreviation");
                        e.appendChild(document.createTextNode(column.getAbbreviation()));
                        columnDetails.appendChild(e);
                        ++columnsCounter;
                    }
                }
            } else if (this.reportTemplate.isUseTableColumns()) {
                int columnsCounter = 0;
                columnsCollection = null;
                Iterator<Object> itColumns = tableView.getElementsCollection().iterator();
                boolean bl = false;
                while (itColumns.hasNext()) {
                    void var16_54;
                    void var12_22;
                    FKElement column = (FKElement)itColumns.next();
                    ++var12_22;
                    if (columnsCounter == 0) {
                        columnsCollection = document.createElement(namespace + "ColumnsCollection");
                        baseElement.appendChild(columnsCollection);
                    }
                    Element columnDetails = document.createElement(namespace + "ColumnDetails");
                    columnsCollection.appendChild(columnDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf((int)var12_22).toString()));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "ColumnName");
                    e.appendChild(document.createTextNode(column.getName()));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "PK");
                    e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "FK");
                    String fk = column.isFKElement() || column.isPartOfUnresolvedFK(tableView) ? "F" : "";
                    e.appendChild(document.createTextNode(fk));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "DataType");
                    String string = "";
                    if (column instanceof ColumnView) {
                        e.appendChild(document.createTextNode(((ColumnView)column).getDataTypeString()));
                    } else if (column instanceof Column) {
                        String string10;
                        col = (Column)column;
                        e.appendChild(document.createTextNode(((Column)col).getDatatypeString()));
                        String string11 = ((Column)col).isContainsPII() == null ? "" : (string10 = ((Column)col).isContainsPII() != false ? "Y" : "");
                        String sensitiveInfo = ((Column)col).isContainsSensitiveInformation() == null ? "" : (((Column)col).isContainsSensitiveInformation() != false ? "Y" : "");
                        String maskInfo = ((Column)col).getMaskingType();
                        String string13 = string10 + "/" + sensitiveInfo + "/" + maskInfo;
                        string13 = string13.replace("//", "");
                    }
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "Security");
                    e.appendChild(document.createTextNode((String)var16_54));
                    columnDetails.appendChild(e);
                    ++columnsCounter;
                }
            }
            if (this.reportTemplate.isUseTableColumnsComments()) {
                Iterator<ContainedObject> columnsIterator;
                int columnsCommentsCounter = 0;
                Element columnsCommentsCollection = null;
                if (isTable) {
                    List<ContainedObject> list = Arrays.asList(table.getElements());
                    columnsIterator = list.iterator();
                } else {
                    List<ContainedObject> list = Arrays.asList(tableView.getElements());
                    columnsIterator = list.iterator();
                }
                while (columnsIterator.hasNext()) {
                    void var16_63;
                    ContainedObject containedObject = columnsIterator.next();
                    String sequence = "";
                    String cName = "";
                    String description = "";
                    String string = "";
                    if (containedObject instanceof Column) {
                        col = (Column)containedObject;
                        sequence = Integer.valueOf(col.getContainer().getIndexOf(col) + 1).toString();
                        cName = col.getName();
                        description = col.getComment() == null || col.getComment().equals("") ? col.getCommentInRDBMS() : col.getComment();
                        String string14 = col.getNotes();
                    } else if (containedObject instanceof ColumnView) {
                        col = (ColumnView)containedObject;
                        sequence = Integer.valueOf(Arrays.asList(tableView.getElements()).indexOf(col) + 1).toString();
                        cName = col.getName();
                        description = col.getComment() == null || col.getComment().equals("") ? col.getCommentInRDBMS() : col.getComment();
                        String string15 = col.getNotes();
                    }
                    if ((description == null || description.equals("")) && (var16_63 == null || var16_63.equals(""))) continue;
                    if (columnsCommentsCounter == 0) {
                        columnsCommentsCollection = document.createElement(namespace + "ColumnsCommentsCollection");
                        baseElement.appendChild(columnsCommentsCollection);
                    }
                    Element columnCommentsDetails = document.createElement(namespace + "ColumnCommentsDetails");
                    columnsCommentsCollection.appendChild(columnCommentsDetails);
                    e = document.createElement(namespace + "ColumnCommentsSequence");
                    e.appendChild(document.createTextNode(sequence));
                    columnCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "ColumnCommentsName");
                    e.appendChild(document.createTextNode(cName));
                    columnCommentsDetails.appendChild(e);
                    if (description != "" && description != null) {
                        Element element = document.createElement(namespace + "ColumnDescription");
                        element.appendChild(document.createCDATASection(description));
                        columnCommentsDetails.appendChild(element);
                    }
                    if (var16_63 != "" && var16_63 != null) {
                        Element element = document.createElement(namespace + "ColumnNotes");
                        element.appendChild(document.createCDATASection((String)var16_63));
                        columnCommentsDetails.appendChild(element);
                    }
                    ++columnsCommentsCounter;
                }
            }
            if (isTable) {
                if (this.reportTemplate.isUseTableIndexes()) {
                    int indesexCounter = 0;
                    HashMap<String, String> usedNames = new HashMap<String, String>();
                    Element indesexCollection = null;
                    Iterator iterator = table.getKeySet().iterator();
                    while (iterator.hasNext()) {
                        Index index = (Index)iterator.next();
                        if (index.isFK()) continue;
                        if (indesexCounter == 0) {
                            indesexCollection = document.createElement(namespace + "IndexesCollection");
                            baseElement.appendChild(indesexCollection);
                        }
                        Iterator<ContainedObject> itIdxColumns = null;
                        if (index.hasIndexExpression()) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(" ");
                            itIdxColumns = list.iterator();
                        } else {
                            itIdxColumns = Arrays.asList(index.getElements()).iterator();
                        }
                        while (itIdxColumns.hasNext()) {
                            void var16_68;
                            Column col2 = null;
                            Object var16_65 = null;
                            ContainedObject obj = itIdxColumns.next();
                            if (obj instanceof Column) {
                                col2 = (Column)obj;
                                String string = col2.getName();
                            } else {
                                String string = ((Object)obj).toString();
                            }
                            Element element = document.createElement(namespace + "IndexDetails");
                            indesexCollection.appendChild(element);
                            String state = index.getIndexState();
                            boolean nameUsed = false;
                            String cName = index.getName();
                            for (Map.Entry pair : usedNames.entrySet()) {
                                String name = (String)pair.getKey();
                                String st = (String)pair.getValue();
                                if (!name.equals(cName) || !st.equals(state)) continue;
                                nameUsed = true;
                                break;
                            }
                            if (!nameUsed) {
                                usedNames.put(cName, state);
                            }
                            e = document.createElement(namespace + "IndexName");
                            e.appendChild(document.createTextNode(nameUsed ? "" : index.getName()));
                            element.appendChild(e);
                            state = state.equals("Unique Plain Index") ? "UN" : (state.equals("Unique Constraint") ? "UK" : (state.equals("Primary Constraint") ? "PK" : ""));
                            e = document.createElement(namespace + "IndexState");
                            e.appendChild(document.createTextNode(nameUsed ? "" : state));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexFunctional");
                            e.appendChild(document.createTextNode(!"".equalsIgnoreCase(index.getIndexExpression()) ? "Y" : ""));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexSpatial");
                            e.appendChild(document.createTextNode(index.isSpatialIndex() ? "Y" : ""));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexExpression");
                            e.appendChild(document.createTextNode(index.getIndexExpression()));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexColumnName");
                            e.appendChild(document.createTextNode((String)var16_68));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexSortOrder");
                            if (col2 != null) {
                                e.appendChild(document.createTextNode(index.getColumnSortOrder(col2)));
                            } else {
                                e.appendChild(document.createTextNode(" "));
                            }
                            element.appendChild(e);
                        }
                        ++indesexCounter;
                    }
                }
                if (this.reportTemplate.isUseTableConstraints()) {
                    int constraintsCounter = 0;
                    Element constraintsCollection = null;
                    Node tableLevelConstraintsCollection = null;
                    for (TableLevelConstraint tlConstraint : table.getCheckConstraints()) {
                        if (constraintsCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            baseElement.appendChild(constraintsCollection);
                            tableLevelConstraintsCollection = document.createElement(namespace + "TableLevelConstraintsCollection");
                            constraintsCollection.appendChild(tableLevelConstraintsCollection);
                        }
                        Element constraintDetails = document.createElement(namespace + "TableLevelConstraintDetails");
                        tableLevelConstraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "TLConstraintType");
                        e.appendChild(document.createTextNode(constraintsCounter == 0 ? "Table Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "TLConstraintName");
                        e.appendChild(document.createTextNode(tlConstraint.getName()));
                        constraintDetails.appendChild(e);
                        Element tlConstraintElement = document.createElement(namespace + "TLConstraintRule");
                        tlConstraintElement.appendChild(document.createCDATASection(tlConstraint.getRule()));
                        constraintDetails.appendChild(tlConstraintElement);
                        ++constraintsCounter;
                    }
                    int columnConstraintsCounter = 0;
                    Element columnLevelConstraintsCollection = null;
                    for (Column column : Arrays.asList(table.getElements())) {
                        if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                        if (constraintsCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            baseElement.appendChild(constraintsCollection);
                        }
                        if (columnConstraintsCounter == 0) {
                            columnLevelConstraintsCollection = document.createElement(namespace + "ColumnLevelConstraintsCollection");
                            constraintsCollection.appendChild(columnLevelConstraintsCollection);
                        }
                        Object constraintName = "";
                        CheckConstraint checkConstraint = column.getCheck();
                        if (checkConstraint != null && !((String)(constraintName = checkConstraint.getName())).equals("")) {
                            constraintName = " / " + (String)constraintName;
                        }
                        Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                        columnLevelConstraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "ContstraintType");
                        e.appendChild(document.createTextNode(columnConstraintsCounter == 0 ? "Column Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "ALCConstraintName");
                        e.appendChild(document.createTextNode(column.getName() + (String)constraintName));
                        constraintDetails.appendChild(e);
                        Element rangesCollection = null;
                        Iterator itRanges = column.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintDetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (column.getValueList() != null) {
                            Iterator itVL = column.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)column.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintDetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if (checkConstraint != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintDetails.appendChild(ccCollection);
                            String generic = checkConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = checkConstraint.getTypes();
                            for (int i = 0; i < types.length; ++i) {
                                RDBMSType rdbmsType = (RDBMSType)types[i];
                                String text = checkConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                        ++columnConstraintsCounter;
                    }
                }
            }
            if (this.reportTemplate.isUseTableFKReferringTo()) {
                void var12_33;
                int fkCount = 0;
                fkCollection = null;
                Iterator<FKIndexAssociation> itFKFrom = isTable ? table.getFKAssociationsList().iterator() : tableView.getFKAssociationsList().iterator();
                while (itFKFrom.hasNext()) {
                    Element fkDetails;
                    KeyObject ri;
                    FKIndexAssociation fKIndexAssociation = itFKFrom.next();
                    if (fkCount == 0) {
                        fkCollection = document.createElement(namespace + "FKRTCollection");
                        baseElement.appendChild(fkCollection);
                    }
                    if ((ri = fKIndexAssociation.getRemoteIndex()) == null) {
                        void var16_73;
                        fkDetails = document.createElement(namespace + "FKRTDetails");
                        fkCollection.appendChild(fkDetails);
                        e = document.createElement(namespace + "FKName");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getName()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferringTo");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getReferredTableLongName()));
                        fkDetails.appendChild(e);
                        String rFKList = fKIndexAssociation.getReferredColumnNames();
                        String string = "";
                        for (FKElement fKElement : Arrays.asList(fKIndexAssociation.getLocalFKIndex().getElements())) {
                            if (fKElement == null) continue;
                            String string16 = (String)var16_73 + "\n" + fKElement.getName();
                        }
                        e = document.createElement(namespace + "FKReferringColumnName");
                        e.appendChild(document.createTextNode(var16_73.trim()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferredColumnName");
                        e.appendChild(document.createTextNode(rFKList.replaceAll(",", "\n")));
                        fkDetails.appendChild(e);
                    } else {
                        void var18_100;
                        void var18_98;
                        fkDetails = document.createElement(namespace + "FKRTDetails");
                        fkCollection.appendChild(fkDetails);
                        e = document.createElement(namespace + "FKName");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getName()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferringTo");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getRemoteTable().getName()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKMandatory");
                        e.appendChild(document.createTextNode(fKIndexAssociation.isMandatory() ? "Y" : ""));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKTransferable");
                        e.appendChild(document.createTextNode(fKIndexAssociation.isTransferable() ? "Y" : ""));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKInArc");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getArc() != null ? "Y" : ""));
                        fkDetails.appendChild(e);
                        List<ContainedObject> referedColumnsList = Arrays.asList(ri.getElements());
                        List<ContainedObject> list = Arrays.asList(fKIndexAssociation.getLocalFKIndex().getElements());
                        columnsNames = "";
                        boolean bl = false;
                        while (var18_98 < list.size()) {
                            FKElement localColumn = (FKElement)list.get((int)var18_98);
                            if (localColumn != null) {
                                columnsNames = (String)columnsNames + "\n" + localColumn.getName();
                            }
                            ++var18_98;
                        }
                        String string = "";
                        for (int i = 0; i < referedColumnsList.size(); ++i) {
                            remotelColumn = (FKElement)referedColumnsList.get(i);
                            if (remotelColumn == null) continue;
                            String string17 = (String)var18_100 + "\n" + remotelColumn.getName();
                        }
                        e = document.createElement(namespace + "FKReferringColumnName");
                        e.appendChild(document.createTextNode(((String)columnsNames).trim()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferredColumnName");
                        e.appendChild(document.createTextNode(var18_100.trim()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKDeleteRule");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getDeleteRule().equals("NO ACTION") ? "" : fKIndexAssociation.getDeleteRule()));
                        fkDetails.appendChild(e);
                    }
                    ++fkCount;
                }
                Object var12_30 = null;
                if (isTable) {
                    List<ImpliedForeignKey> list = table.getImpliedForeignKeyList();
                } else {
                    List<ImpliedForeignKey> list = tableView.getImpliedForeignKeyList();
                }
                for (ImpliedForeignKey join : var12_33) {
                    if (fkCount == 0) {
                        fkCollection = document.createElement(namespace + "FKRTCollection");
                        baseElement.appendChild(fkCollection);
                    }
                    Element fkDetails = document.createElement(namespace + "FKRTDetails");
                    fkCollection.appendChild(fkDetails);
                    e = document.createElement(namespace + "FKName");
                    String string18 = join.getName() + "\nimplied Fkey - source:\n";
                    string18 = string18 + join.getFormattedDiscoverySource();
                    e.appendChild(document.createTextNode(string18));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferringTo");
                    e.appendChild(document.createTextNode(join.getReferredTableLongName()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKMandatory");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKTransferable");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKInArc");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                    columnsNames = join.getLocalColumnName();
                    String string19 = join.getReferredColumnName();
                    e = document.createElement(namespace + "FKReferringColumnName");
                    e.appendChild(document.createTextNode(((String)columnsNames).trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferredColumnName");
                    e.appendChild(document.createTextNode(string19.trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKDeleteRule");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                }
            }
            if (this.reportTemplate.isUseTableFKReferredFrom()) {
                Iterator itFKTo;
                int fkCount = 0;
                fkCollection = null;
                if (isTable) {
                    FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet();
                    itFKTo = fKIndexAssociationSet.getAssociationsWith(table).iterator();
                } else {
                    FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)tableView.getDesignPart()).getFKIndexAssociationSet();
                    itFKTo = fKIndexAssociationSet.getAssociationsWith(tableView).iterator();
                }
                while (itFKTo.hasNext()) {
                    void var18_108;
                    void var18_106;
                    FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)itFKTo.next();
                    if (fkCount == 0) {
                        fkCollection = document.createElement(namespace + "FKRFCollection");
                        baseElement.appendChild(fkCollection);
                    }
                    Element fkDetails = document.createElement(namespace + "FKRFDetails");
                    fkCollection.appendChild(fkDetails);
                    e = document.createElement(namespace + "FKName");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getName()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferredFrom");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getContainerWithKeyObject().getName()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKMandatory");
                    e.appendChild(document.createTextNode(fKIndexAssociation.isMandatory() ? "Y" : ""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKTransferable");
                    e.appendChild(document.createTextNode(fKIndexAssociation.isTransferable() ? "Y" : ""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKInArc");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getArc() != null ? "Y" : ""));
                    fkDetails.appendChild(e);
                    KeyObject ri = fKIndexAssociation.getRemoteIndex();
                    List<ContainedObject> referingColumnsList = Arrays.asList(ri.getElements());
                    List<ContainedObject> list = Arrays.asList(fKIndexAssociation.getLocalFKIndex().getElements());
                    columnsNames = "";
                    boolean bl = false;
                    while (var18_106 < list.size()) {
                        FKElement localColumn = (FKElement)list.get((int)var18_106);
                        if (localColumn != null) {
                            columnsNames = (String)columnsNames + "\n" + localColumn.getName();
                        }
                        ++var18_106;
                    }
                    String string = "";
                    for (int i = 0; i < referingColumnsList.size(); ++i) {
                        remotelColumn = (FKElement)referingColumnsList.get(i);
                        if (remotelColumn == null) continue;
                        String string20 = (String)var18_108 + "\n" + remotelColumn.getName();
                    }
                    e = document.createElement(namespace + "FKReferringColumnName");
                    e.appendChild(document.createTextNode(var18_108.trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferredColumnName");
                    e.appendChild(document.createTextNode(((String)columnsNames).trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKDeleteRule");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getDeleteRule().equals("NO ACTION") ? "" : fKIndexAssociation.getDeleteRule()));
                    fkDetails.appendChild(e);
                    ++fkCount;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Table Details Section : " + e.getMessage(), e);
            return baseElement;
        }
        return baseElement;
    }

    private Element createEntityDetailsSection(Document document, String namespace, Element baseElement, DesignObject object) {
        try {
            Element attributesCollection;
            Element e;
            Entity entity = null;
            EntityView entityView = null;
            boolean isEntity = false;
            if (object instanceof Entity) {
                entity = (Entity)object;
                isEntity = true;
                e = document.createElement(namespace + "EntityName");
                e.appendChild(document.createTextNode(entity.getName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedEntityName");
                e.appendChild(document.createTextNode(entity.getShortObjectID()));
                baseElement.appendChild(e);
            } else if (object instanceof EntityView) {
                entityView = (EntityView)object;
                isEntity = false;
                e = document.createElement(namespace + "ViewName");
                e.appendChild(document.createTextNode(entityView.getLongName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedViewName");
                e.appendChild(document.createTextNode(entityView.getShortObjectID()));
                baseElement.appendChild(e);
            }
            this.createDiagramSuffixElement(document, namespace, baseElement, object);
            if (isEntity) {
                e = document.createElement(namespace + "Abbreviation");
                e.appendChild(document.createTextNode(entity.getPreferredAbbreviation()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ClassificationTypeName");
                e.appendChild(document.createTextNode(""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ObjectTypeName");
                e.appendChild(document.createTextNode(entity.getBasedOnStructuredType() != null ? entity.getBasedOnStructuredType().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "SuperType");
                e.appendChild(document.createTextNode(entity.getHierarchicalParent() != null ? entity.getHierarchicalParent().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "Synonyms");
                e.appendChild(document.createTextNode(entity.getSynonym()));
                baseElement.appendChild(e);
            } else {
                if (entityView.isBST()) {
                    e = document.createElement(namespace + "StructuredTypeName");
                    e.appendChild(document.createTextNode(entityView.getBasedOnStructuredType().getName()));
                    baseElement.appendChild(e);
                }
                if (this.settings.isIncludeSelectStatementInViewReport()) {
                    e = document.createElement(namespace + "SelectStatement");
                    e.appendChild(document.createCDATASection(entityView.getUserDefinedSQL()));
                    baseElement.appendChild(e);
                }
            }
            if (isEntity) {
                Element mappedTablesCollection = null;
                Iterator itMappedTables = entity.getAllMappedtables().iterator();
                int mapCount = 0;
                while (itMappedTables.hasNext()) {
                    Table table = (Table)itMappedTables.next();
                    if (mapCount == 0) {
                        mappedTablesCollection = document.createElement(namespace + "MappedTablesCollection");
                        baseElement.appendChild(mappedTablesCollection);
                    }
                    Element mappedTableDetails = document.createElement(namespace + "MappedTablesDetails");
                    mappedTablesCollection.appendChild(mappedTableDetails);
                    String modelName = table.getDesign().getRelationalDesign().getName() != null ? table.getDesign().getRelationalDesign().getName() + "." : "";
                    e = document.createElement(namespace + "TableName");
                    e.appendChild(document.createTextNode(modelName + table.getLongName()));
                    mappedTableDetails.appendChild(e);
                    ++mapCount;
                }
            }
            this.createDescriptionAndNotesSection(document, namespace, baseElement, object);
            if (isEntity && this.reportTemplate.isUseQuantitativeInfo()) {
                Element quantitativeInfoElement = document.createElement(namespace + "QuantitativeInfoCollection");
                e = document.createElement(namespace + "NumberOfAttributes");
                e.appendChild(document.createTextNode(Integer.valueOf(entity.getElements().length).toString()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMin");
                e.appendChild(document.createTextNode(entity.getMinVolumes()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMax");
                e.appendChild(document.createTextNode(entity.getMaxVolumes()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedNumberOfRows");
                e.appendChild(document.createTextNode(entity.getExpectedVolumes()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedGrowth");
                e.appendChild(document.createTextNode(entity.getGrowthPercent()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "GrowthInterval");
                e.appendChild(document.createTextNode(entity.getGrowthType()));
                quantitativeInfoElement.appendChild(e);
                baseElement.appendChild(quantitativeInfoElement);
            }
            if (this.reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() && this.generatedDiagramsNamesListPerModel.size() > 0) {
                this.addDiagramsElement(object, document, namespace, baseElement);
            }
            if (isEntity) {
                if (this.reportTemplate.isUseEntityAttributes()) {
                    int attrCount = 0;
                    attributesCollection = null;
                    Iterator atrributesIterator = entity.getAttributes().iterator();
                    entity.getElements();
                    while (atrributesIterator.hasNext()) {
                        Attribute attribute = (Attribute)atrributesIterator.next();
                        if (attrCount == 0) {
                            attributesCollection = document.createElement(namespace + "AttributesCollection");
                            baseElement.appendChild(attributesCollection);
                        }
                        Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                        attributesCollection.appendChild(attributeDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(attribute.getContainer().getIndexOf(attribute) + 1).toString()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "AttributeName");
                        e.appendChild(document.createTextNode(attribute.getName()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(attribute.isPKElement() ? "P" : ""));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        e.appendChild(document.createTextNode(attribute.isFKElement() ? "F" : ""));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(attribute.getNullsAllowed() ? "" : "Y"));
                        attributeDetails.appendChild(e);
                        String dataType = "";
                        String dataTypeKind = "";
                        String domainName = "";
                        switch (attribute.getUse()) {
                            case 0: {
                                dataTypeKind = "DOM";
                                Domain dom = attribute.getDomain();
                                domainName = dom.getName();
                                dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                                domainName = domainName.replace("Unknown", "");
                                domainName = domainName.replace("unknown", "");
                                domainName = domainName.replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                dataTypeKind = "LT";
                                dataType = this.getSizePrecisionScale(attribute, attribute.getLogicalDatatype().getName());
                                break;
                            }
                            case 2: {
                                dataTypeKind = "DT";
                                dataType = attribute.getDistinctType().getName();
                                break;
                            }
                            case 3: {
                                dataTypeKind = attribute.isReference() ? "RST" : "ST";
                                dataType = attribute.getStructuredType().getName();
                                break;
                            }
                            case 4: {
                                dataTypeKind = "CT";
                                dataType = attribute.getCollectionType().getName();
                            }
                        }
                        e = document.createElement(namespace + "DataType");
                        e.appendChild(document.createTextNode(dataType));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "DataTypeKind");
                        e.appendChild(document.createTextNode(dataTypeKind));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "DomainName");
                        e.appendChild(document.createTextNode(domainName));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "Formula");
                        e.appendChild(document.createTextNode((attribute.getFormulaDesc() + " " + attribute.getDefaultValue()).trim()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "PreferredAbbreviation");
                        e.appendChild(document.createTextNode(attribute.getPreferredAbbreviation()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "AttributeSynonyms");
                        e.appendChild(document.createTextNode(attribute.getSynonym()));
                        attributeDetails.appendChild(e);
                        ++attrCount;
                    }
                }
            } else if (this.reportTemplate.isUseEntityAttributes()) {
                int attrCount = 0;
                attributesCollection = null;
                Iterator atrributesIterator = entityView.getElementsCollection().iterator();
                int seq = 0;
                while (atrributesIterator.hasNext()) {
                    AttributeView attribute = (AttributeView)atrributesIterator.next();
                    ++seq;
                    if (attrCount == 0) {
                        attributesCollection = document.createElement(namespace + "AttributesCollection");
                        baseElement.appendChild(attributesCollection);
                    }
                    Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                    attributesCollection.appendChild(attributeDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(seq).toString()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "PK");
                    e.appendChild(document.createTextNode(attribute.isPKElement() ? "P" : ""));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "FK");
                    e.appendChild(document.createTextNode(attribute.isFKElement() ? "F" : ""));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(attribute.getNullsAllowed() ? "" : "Y"));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DataType");
                    e.appendChild(document.createTextNode(attribute.getDataTypeString()));
                    attributeDetails.appendChild(e);
                    ++attrCount;
                }
            }
            if (this.reportTemplate.isUseEntityAttributesComments()) {
                Iterator<ContainedObject> atrributesIterator;
                List<ContainedObject> l;
                int attributeCommentsCounter = 0;
                Element attributesCommentsCollection = null;
                if (isEntity) {
                    l = entity.getAttributes();
                    atrributesIterator = l.iterator();
                } else {
                    l = Arrays.asList(entityView.getElements());
                    atrributesIterator = l.iterator();
                }
                while (atrributesIterator.hasNext()) {
                    ContainedObjectWithDomain attr;
                    ContainedObject o = atrributesIterator.next();
                    String sequence = "";
                    String cName = "";
                    String description = "";
                    String notes = "";
                    if (o instanceof Attribute) {
                        attr = (Attribute)o;
                        sequence = Integer.valueOf(attr.getContainer().getIndexOf(attr) + 1).toString();
                        cName = attr.getName();
                        description = ((Attribute)attr).getComment() == null || ((Attribute)attr).getComment().equals("") ? ((Attribute)attr).getCommentInRDBMS() : ((Attribute)attr).getComment();
                        notes = ((Attribute)attr).getNotes();
                    } else if (o instanceof AttributeView) {
                        attr = (AttributeView)o;
                        sequence = Integer.valueOf(Arrays.asList(entityView.getElements()).indexOf(attr) + 1).toString();
                        cName = attr.getName();
                        description = attr.getComment() == null || attr.getComment().equals("") ? attr.getCommentInRDBMS() : attr.getComment();
                        notes = attr.getNotes();
                    }
                    if ((description == null || description.equals("")) && (notes == null || notes.equals(""))) continue;
                    if (attributeCommentsCounter == 0) {
                        attributesCommentsCollection = document.createElement(namespace + "AttributesCommentsCollection");
                        baseElement.appendChild(attributesCommentsCollection);
                    }
                    Element attributeCommentsDetails = document.createElement(namespace + "AttributeCommentsDetails");
                    attributesCommentsCollection.appendChild(attributeCommentsDetails);
                    e = document.createElement(namespace + "AttributeCommentsSequence");
                    e.appendChild(document.createTextNode(sequence));
                    attributeCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeCommentsName");
                    e.appendChild(document.createTextNode(cName));
                    attributeCommentsDetails.appendChild(e);
                    if (description != "" && description != null) {
                        Element columnDescriptionElement = document.createElement(namespace + "AttributeDescription");
                        columnDescriptionElement.appendChild(document.createCDATASection(description));
                        attributeCommentsDetails.appendChild(columnDescriptionElement);
                    }
                    if (notes != "" && notes != null) {
                        Element attributeNotesElement = document.createElement(namespace + "AttributeNotes");
                        attributeNotesElement.appendChild(document.createCDATASection(notes));
                        attributeCommentsDetails.appendChild(attributeNotesElement);
                    }
                    ++attributeCommentsCounter;
                }
            }
            if (isEntity) {
                if (this.reportTemplate.isUseEntityConstraints()) {
                    Element constraintsCollection = null;
                    Iterator attributesIterator = entity.getAttributes().iterator();
                    int attrCounter = 0;
                    while (attributesIterator.hasNext()) {
                        Attribute attribute = (Attribute)attributesIterator.next();
                        if (attribute.getAVTs().size() <= 0 && attribute.getValueList() == null && attribute.getCheck() == null) continue;
                        if (attrCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            baseElement.appendChild(constraintsCollection);
                        }
                        Object constraintName = "";
                        CheckConstraint ccConstraint = attribute.getCheck();
                        if (ccConstraint != null && !((String)(constraintName = ccConstraint.getName())).equals("")) {
                            constraintName = " / " + (String)constraintName;
                        }
                        Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                        constraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "ContstraintType");
                        e.appendChild(document.createTextNode(attrCounter == 0 ? "Attribute Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "ALCConstraintName");
                        e.appendChild(document.createTextNode(attribute.getName() + (String)constraintName));
                        constraintDetails.appendChild(e);
                        Element rangesCollection = null;
                        Iterator itRanges = attribute.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintDetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (attribute.getValueList() != null) {
                            Iterator itVL = attribute.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)attribute.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintDetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if (ccConstraint != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintDetails.appendChild(ccCollection);
                            String generic = ccConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = ccConstraint.getTypes();
                            for (int i = 0; i < types.length; ++i) {
                                RDBMSType rdbmsType = (RDBMSType)types[i];
                                String text = ccConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                        ++attrCounter;
                    }
                }
                if (this.reportTemplate.isUseEntityIdentifiers()) {
                    Element identifiersCollection = null;
                    Iterator itKeySet = entity.getKeySet().iterator();
                    ArrayList<String> usedNames = new ArrayList<String>();
                    int idCounter = 0;
                    while (itKeySet.hasNext()) {
                        if (idCounter == 0) {
                            identifiersCollection = document.createElement(namespace + "IdentifiersCollection");
                            baseElement.appendChild(identifiersCollection);
                        }
                        CandidateKey cc = (CandidateKey)itKeySet.next();
                        ContainedObject[] elements = cc.getElements();
                        for (int i = 0; i < elements.length; ++i) {
                            ContainedObject s = elements[i];
                            Element identifierDetails = document.createElement(namespace + "IdentifierDetails");
                            identifiersCollection.appendChild(identifierDetails);
                            boolean nameUsed = false;
                            String cName = cc.getName();
                            for (String name : usedNames) {
                                if (!name.equals(cName)) continue;
                                nameUsed = true;
                                break;
                            }
                            if (!nameUsed) {
                                usedNames.add(cName);
                            }
                            e = document.createElement(namespace + "IdentifierName");
                            e.appendChild(document.createTextNode(nameUsed ? "" : cc.getName()));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "PrimaryIdentifier");
                            e.appendChild(document.createTextNode(nameUsed ? "" : (cc.getKeyState().equals("Primary Key") ? "Y" : "")));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "ElementName");
                            e.appendChild(document.createTextNode(s.getName()));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "ElementType");
                            e.appendChild(document.createTextNode("A"));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "SourceLabel");
                            e.appendChild(document.createTextNode(""));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "TargetLabel");
                            e.appendChild(document.createTextNode(""));
                            identifierDetails.appendChild(e);
                        }
                        ++idCounter;
                    }
                }
                if (this.reportTemplate.isUseEntityRelationships()) {
                    Element relationshipsCollection = null;
                    Iterator relationshipsIterator = this.design.getLogicalDesign().getRelationSet().getRelationsTo(entity).iterator();
                    int relCounter = 0;
                    while (relationshipsIterator.hasNext()) {
                        if (relCounter == 0) {
                            relationshipsCollection = document.createElement(namespace + "RelationshipsCollection");
                            baseElement.appendChild(relationshipsCollection);
                        }
                        Relation relation = (Relation)relationshipsIterator.next();
                        Element relationshipDetails = document.createElement(namespace + "RelationshipDetails");
                        relationshipsCollection.appendChild(relationshipDetails);
                        if (entity == relation.getSourceEntity()) {
                            e = document.createElement(namespace + "SourceName");
                            e.appendChild(document.createTextNode(relation.getTargetEntity().getName()));
                            relationshipDetails.appendChild(e);
                        } else if (entity == relation.getTargetEntity()) {
                            e = document.createElement(namespace + "SourceName");
                            e.appendChild(document.createTextNode(relation.getSourceEntity().getName()));
                            relationshipDetails.appendChild(e);
                        }
                        e = document.createElement(namespace + "SourceRole");
                        e.appendChild(document.createTextNode(relation.getNameOnSource() != null ? relation.getNameOnSource() : ""));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "TargetRole");
                        e.appendChild(document.createTextNode(relation.getNameOnTarget() != null ? relation.getNameOnTarget() : ""));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "InArc");
                        e.appendChild(document.createTextNode(relation.inArc() ? "Y" : ""));
                        relationshipDetails.appendChild(e);
                        Object cardinality = "";
                        Object scard = relation.isOptionalSource() ? "0" : "1";
                        String repr = relation.getTargetCardinality().toString();
                        scard = (String)scard + ".." + repr;
                        Object tcard = relation.isOptionalTarget() ? "0" : "1";
                        repr = relation.getSourceCardinality().toString();
                        tcard = (String)tcard + ".." + repr;
                        cardinality = (String)scard + ":" + (String)tcard;
                        e = document.createElement(namespace + "Cardinality");
                        e.appendChild(document.createTextNode((String)cardinality));
                        relationshipDetails.appendChild(e);
                        String domRoleName = "";
                        String dRoleName = relation.getDominantRole().getName();
                        if (dRoleName != null) {
                            domRoleName = dRoleName.equals("None") ? "" : dRoleName;
                        }
                        e = document.createElement(namespace + "DominantRole");
                        e.appendChild(document.createTextNode(domRoleName));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "Identifying");
                        e.appendChild(document.createTextNode(relation.isIdentifying() ? "Y" : ""));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "Transferable");
                        e.appendChild(document.createTextNode(relation.isTransferable() ? "Y" : ""));
                        relationshipDetails.appendChild(e);
                        ++relCounter;
                    }
                }
                Element incomingProcessesCollection = null;
                Element outgoingProcessesCollection = null;
                boolean createIncCollection = true;
                boolean createOutCollection = true;
                ProcessModel processModel = entity.getDesign().getProcessModel();
                for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
                    String tlName = dfd.getTopLevelDataFlowDesign() != null ? dfd.getTopLevelDataFlowDesign().getName() : "";
                    Iterator dfdit = dfd.getProcessSet().iterator();
                    while (dfdit.hasNext()) {
                        Process process = (Process)dfdit.next();
                        if (process.getType() != 0) continue;
                        for (Process.ProcessedObject po : process.getProcessedEntitiesAndFlows(false, entity)) {
                            if (po.getObject() != entity) continue;
                            Object crud = "";
                            if (po.isOpRead()) {
                                crud = "R";
                            } else {
                                if (po.isOpCreate()) {
                                    crud = "C";
                                }
                                if (po.isOpUpdate()) {
                                    crud = (String)crud + "U";
                                }
                                if (po.isOpDelete()) {
                                    crud = (String)crud + "D";
                                }
                            }
                            if (po.isInbound()) {
                                if (!this.reportTemplate.isUseEntityIncomingProcesses()) continue;
                                if (createIncCollection) {
                                    incomingProcessesCollection = document.createElement(namespace + "IncomingProcessesCollection");
                                    baseElement.appendChild(incomingProcessesCollection);
                                    createIncCollection = false;
                                }
                                Element inProcessesDetails = document.createElement(namespace + "IncomingProcessDetails");
                                incomingProcessesCollection.appendChild(inProcessesDetails);
                                e = document.createElement(namespace + "IncomingProcessName");
                                e.appendChild(document.createTextNode(process.getName()));
                                inProcessesDetails.appendChild(e);
                                e = document.createElement(namespace + "IncomingFlowName");
                                e.appendChild(document.createTextNode(po.getFlow().getName()));
                                inProcessesDetails.appendChild(e);
                                e = document.createElement(namespace + "IncomingCRUDCode");
                                e.appendChild(document.createTextNode((String)crud));
                                inProcessesDetails.appendChild(e);
                                e = document.createElement(namespace + "IncomingDFDName");
                                e.appendChild(document.createTextNode(tlName));
                                inProcessesDetails.appendChild(e);
                                continue;
                            }
                            if (!this.reportTemplate.isUseEntityOutgoingProcesses()) continue;
                            if (createOutCollection) {
                                outgoingProcessesCollection = document.createElement(namespace + "OutgoingProcessesCollection");
                                baseElement.appendChild(outgoingProcessesCollection);
                                createOutCollection = false;
                            }
                            Element outProcessesDetails = document.createElement(namespace + "OugoingProcessDetails");
                            outgoingProcessesCollection.appendChild(outProcessesDetails);
                            e = document.createElement(namespace + "OutgoingProcessName");
                            e.appendChild(document.createTextNode(process.getName()));
                            outProcessesDetails.appendChild(e);
                            e = document.createElement(namespace + "OutgoingFlowName");
                            e.appendChild(document.createTextNode(po.getFlow().getName()));
                            outProcessesDetails.appendChild(e);
                            e = document.createElement(namespace + "OutgoingCRUDCode");
                            e.appendChild(document.createTextNode((String)crud));
                            outProcessesDetails.appendChild(e);
                            e = document.createElement(namespace + "OutgoingDFDName");
                            e.appendChild(document.createTextNode(tlName));
                            outProcessesDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Entity Details Section : " + e.getMessage(), e);
            return baseElement;
        }
        return baseElement;
    }

    private Element createSTDetailsSection(Document document, String namespace, Element baseElement, StructuredType structuredType) {
        try {
            Element e = document.createElement(namespace + "STName");
            e.appendChild(document.createTextNode(structuredType.getLongName()));
            baseElement.appendChild(e);
            this.createDiagramSuffixElement(document, namespace, baseElement, structuredType);
            e = document.createElement(namespace + "EncodedSTName");
            e.appendChild(document.createTextNode(structuredType.getShortObjectID()));
            baseElement.appendChild(e);
            e = document.createElement(namespace + "STSuperType");
            e.appendChild(document.createTextNode(structuredType.getParentType() != null ? structuredType.getParentType().getName() : ""));
            baseElement.appendChild(e);
            this.createDescriptionAndNotesSection(document, namespace, baseElement, structuredType);
            if (this.reportTemplate.isUseDiagrams() && ApplicationView.isGUIMode() && this.generatedDiagramsNamesListPerModel.size() > 0) {
                this.addDiagramsElement(structuredType, document, namespace, baseElement);
            }
            if (this.reportTemplate.isUseSTAttributes()) {
                int attrCount = 0;
                Element attributesCollection = null;
                for (TypeElement attribute : Arrays.asList(structuredType.getElements())) {
                    if (attrCount == 0) {
                        attributesCollection = document.createElement(namespace + "AttributesCollection");
                        baseElement.appendChild(attributesCollection);
                    }
                    Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                    attributesCollection.appendChild(attributeDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(attribute.getStructuredType().getIndexOf(attribute) + 1).toString()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(attribute.isMandatory() ? "Y" : ""));
                    attributeDetails.appendChild(e);
                    String dataType = "";
                    String dataTypeKind = "";
                    String domainName = "";
                    DesignObject dtType = attribute.getType();
                    if (dtType instanceof Domain) {
                        dataTypeKind = "DOM";
                        Domain dom = attribute.getDomain();
                        domainName = attribute.getType().getName();
                        dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                        domainName = domainName.replace("Unknown", "");
                        domainName = domainName.replace("unknown", "");
                        domainName = domainName.replace("UNKNOWN", "");
                    } else if (dtType instanceof LogicalDatatype) {
                        dataTypeKind = "LT";
                        dataType = this.getSizePrecisionScale(attribute, attribute.getType().getName());
                    } else if (dtType instanceof DistinctType) {
                        dataTypeKind = "DT";
                    } else if (dtType instanceof StructuredType) {
                        dataTypeKind = "ST";
                    } else if (dtType instanceof CollectionType) {
                        dataTypeKind = "CT";
                    }
                    e = document.createElement(namespace + "DataType");
                    e.appendChild(document.createTextNode(dataType));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DataTypeKind");
                    e.appendChild(document.createTextNode(dataTypeKind));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DomainName");
                    e.appendChild(document.createTextNode(domainName));
                    attributeDetails.appendChild(e);
                    ++attrCount;
                }
            }
            if (this.reportTemplate.isUseSTAttributesComments()) {
                int attributeCommentsCounter = 0;
                Element attributesCommentsCollection = null;
                for (TypeElement attribute : structuredType.getAttributesList()) {
                    String attributeDescription = "";
                    attributeDescription = attribute.getComment() == null || attribute.getComment().equals("") ? attribute.getCommentInRDBMS() : attribute.getComment();
                    String attributeNotes = attribute.getNotes();
                    if ((attributeDescription == null || attributeDescription.equals("")) && (attributeNotes == null || attributeNotes.equals(""))) continue;
                    if (attributeCommentsCounter == 0) {
                        attributesCommentsCollection = document.createElement(namespace + "AttributesCommentsCollection");
                        baseElement.appendChild(attributesCommentsCollection);
                    }
                    Element attributeCommentsDetails = document.createElement(namespace + "AttributeCommentsDetails");
                    attributesCommentsCollection.appendChild(attributeCommentsDetails);
                    e = document.createElement(namespace + "AttributeCommentsSequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(attribute.getStructuredType().getIndexOf(attribute) + 1).toString()));
                    attributeCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeCommentsName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeCommentsDetails.appendChild(e);
                    if (attributeDescription != "" && attributeDescription != null) {
                        Element columnDescriptionElement = document.createElement(namespace + "AttributeDescription");
                        columnDescriptionElement.appendChild(document.createCDATASection(attributeDescription));
                        attributeCommentsDetails.appendChild(columnDescriptionElement);
                    }
                    if (attributeNotes != "" && attributeNotes != null) {
                        Element attributeNotesElement = document.createElement(namespace + "AttributeNotes");
                        attributeNotesElement.appendChild(document.createCDATASection(attributeNotes));
                        attributeCommentsDetails.appendChild(attributeNotesElement);
                    }
                    ++attributeCommentsCounter;
                }
            }
            if (this.reportTemplate.isUseSTMethods()) {
                int methodsCounter = 0;
                Element methodsCollection = null;
                for (Method method : structuredType.getMethodsList()) {
                    if (methodsCounter == 0) {
                        methodsCollection = document.createElement(namespace + "MethodsCollection");
                        baseElement.appendChild(methodsCollection);
                    }
                    Element methodDetails = document.createElement(namespace + "MethodDetails");
                    methodsCollection.appendChild(methodDetails);
                    e = document.createElement(namespace + "MethodSequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(methodsCounter + 1).toString()));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodName");
                    e.appendChild(document.createTextNode(method.getName()));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodConstructor");
                    e.appendChild(document.createTextNode(method.isConstructor() ? "Y" : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodOverriding");
                    e.appendChild(document.createTextNode(method.isOverriding() ? "Y" : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodOverridenMethod");
                    e.appendChild(document.createTextNode(method.getOverridedMethod() != null ? method.getOverridedMethod().getName() : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodReturnValue");
                    e.appendChild(document.createTextNode(method.getReturnValue() != null ? method.getReturnValue().getDataType() : ""));
                    methodDetails.appendChild(e);
                    int paramCounter = 0;
                    Element methodsParamsCollection = null;
                    for (MethodParam param : method.getParameters()) {
                        if (paramCounter == 0) {
                            methodsParamsCollection = document.createElement(namespace + "MethodParametersCollection");
                            methodDetails.appendChild(methodsParamsCollection);
                        }
                        Element methodParamsDetails = document.createElement(namespace + "MethodParameterDetails");
                        methodsParamsCollection.appendChild(methodParamsDetails);
                        e = document.createElement(namespace + "ParameterName");
                        e.appendChild(document.createTextNode(param.getName()));
                        methodParamsDetails.appendChild(e);
                        e = document.createElement(namespace + "ParameterType");
                        e.appendChild(document.createTextNode(param.getDataType()));
                        methodParamsDetails.appendChild(e);
                        ++paramCounter;
                    }
                    ++methodsCounter;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Structured Type Details Section : " + e.getMessage(), e);
            return baseElement;
        }
        return baseElement;
    }

    private Element createUsedInObjectsSection(Document document, String namespace, Element baseElement, DesignObject object) {
        Element e;
        String eName;
        DesignObject desObj;
        short objectType = 0;
        DesignObject currentDesObj = null;
        String tableModelNameXMLTag = "";
        String tableNameXMLTag = "";
        String columnNameXMLTag = "";
        String entityModelNameXMLTag = "";
        String entityNameXMLTag = "";
        String attributeNameXMLTag = "";
        String structuredTypeNameXMLTag = "";
        String typeElementNameXMLTag = "";
        boolean templateFlagTables = false;
        boolean templateFlagEntites = false;
        boolean templateFlagST = false;
        if (object instanceof Domain) {
            currentDesObj = (Domain)object;
            objectType = 0;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseDomainUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseDomainUsedInEntities();
            templateFlagST = this.reportTemplate.isUseDomainUsedInStructuredTypes();
        } else if (object instanceof StructuredType) {
            currentDesObj = (StructuredType)object;
            objectType = 3;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseSTUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseSTUsedInEntities();
            templateFlagST = this.reportTemplate.isUseSTUsedInStructuredTypes();
        } else if (object instanceof CollectionType) {
            currentDesObj = (CollectionType)object;
            objectType = 4;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseCTUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseCTUsedInEntities();
            templateFlagST = this.reportTemplate.isUseCTUsedInStructuredTypes();
        } else if (object instanceof DistinctType) {
            currentDesObj = (DistinctType)object;
            objectType = 2;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseDTUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseDTUsedInTables();
            templateFlagST = this.reportTemplate.isUseDTUsedInStructuredTypes();
        }
        boolean create_header = true;
        Element tablesCollection = null;
        ArrayList<String> modelUsedNames = new ArrayList<String>();
        ArrayList<String> tableUsedNames = new ArrayList<String>();
        Iterator relationalDesignsIterator = this.design.getRelationalDesigns().iterator();
        Iterator allEntitiesIterator = this.design.getLogicalDesign().getEntitySet().iterator();
        Iterator stIterator = this.design.getDataTypesDesign().getStructuredTypeSet().iterator();
        if (templateFlagTables) {
            while (relationalDesignsIterator.hasNext()) {
                RelationalDesign rd = (RelationalDesign)relationalDesignsIterator.next();
                Iterator itAllTables = rd.getTableSet().iterator();
                while (itAllTables.hasNext()) {
                    Table table = (Table)itAllTables.next();
                    for (Column column : Arrays.asList(table.getElements())) {
                        if (column.getUse() != objectType) continue;
                        desObj = null;
                        if (currentDesObj instanceof StructuredType) {
                            desObj = column.getStructuredType();
                        } else if (currentDesObj instanceof CollectionType) {
                            desObj = column.getCollectionType();
                        } else if (currentDesObj instanceof DistinctType) {
                            desObj = column.getDistinctType();
                        } else if (currentDesObj instanceof Domain) {
                            desObj = column.getDomain();
                        }
                        if (currentDesObj != desObj) continue;
                        if (create_header) {
                            tablesCollection = document.createElement(namespace + "TablesCollection");
                            baseElement.appendChild(tablesCollection);
                            create_header = false;
                        }
                        boolean modelNameUsed = false;
                        String cName = rd.getName();
                        for (String name : modelUsedNames) {
                            if (!name.equals(cName)) continue;
                            modelNameUsed = true;
                            break;
                        }
                        if (!modelNameUsed) {
                            modelUsedNames.add(cName);
                        }
                        boolean tableNameUsed = false;
                        String tName = table.getLongName();
                        for (String name : tableUsedNames) {
                            if (!name.equals(tName)) continue;
                            tableNameUsed = true;
                            break;
                        }
                        if (!tableNameUsed) {
                            tableUsedNames.add(tName);
                        }
                        Element tableDetails = document.createElement(namespace + "TableDetails");
                        tablesCollection.appendChild(tableDetails);
                        Element e2 = document.createElement(namespace + tableModelNameXMLTag);
                        e2.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                        tableDetails.appendChild(e2);
                        e2 = document.createElement(namespace + tableNameXMLTag);
                        e2.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                        tableDetails.appendChild(e2);
                        e2 = document.createElement(namespace + columnNameXMLTag);
                        e2.appendChild(document.createTextNode(column.getName()));
                        tableDetails.appendChild(e2);
                    }
                }
            }
        }
        if (templateFlagEntites) {
            create_header = true;
            Element entitiesCollection = null;
            ArrayList entityUsedNames = new ArrayList();
            while (allEntitiesIterator.hasNext()) {
                Entity entity = (Entity)allEntitiesIterator.next();
                for (Attribute attribute : Arrays.asList(entity.getElements())) {
                    if (attribute.getUse() != objectType) continue;
                    desObj = null;
                    if (currentDesObj instanceof StructuredType) {
                        desObj = attribute.getStructuredType();
                    } else if (currentDesObj instanceof CollectionType) {
                        desObj = attribute.getCollectionType();
                    } else if (currentDesObj instanceof DistinctType) {
                        desObj = attribute.getDistinctType();
                    } else if (currentDesObj instanceof Domain) {
                        desObj = attribute.getDomain();
                    }
                    if (currentDesObj != desObj) continue;
                    if (create_header) {
                        entitiesCollection = document.createElement(namespace + "EntitiesCollection");
                        baseElement.appendChild(entitiesCollection);
                        create_header = false;
                    }
                    boolean entityNameUsed = false;
                    eName = entity.getName();
                    for (String name : entityUsedNames) {
                        if (!name.equals(eName)) continue;
                        entityNameUsed = true;
                        break;
                    }
                    if (!entityNameUsed) {
                        tableUsedNames.add(eName);
                    }
                    Element entityDetails = document.createElement(namespace + "EntityDetails");
                    entitiesCollection.appendChild(entityDetails);
                    e = document.createElement(namespace + entityNameXMLTag);
                    e.appendChild(document.createTextNode(!entityNameUsed ? entity.getName() : ""));
                    entityDetails.appendChild(e);
                    e = document.createElement(namespace + attributeNameXMLTag);
                    e.appendChild(document.createTextNode(attribute.getName()));
                    entityDetails.appendChild(e);
                }
            }
        }
        if (templateFlagST) {
            create_header = true;
            Element stCollection = null;
            ArrayList stUsedNames = new ArrayList();
            while (stIterator.hasNext()) {
                StructuredType st = (StructuredType)stIterator.next();
                for (TypeElement typeElement : Arrays.asList(st.getElements())) {
                    desObj = typeElement.getType();
                    if (currentDesObj != desObj) continue;
                    if (create_header) {
                        stCollection = document.createElement(namespace + "STCollection");
                        baseElement.appendChild(stCollection);
                        create_header = false;
                    }
                    boolean stNameUsed = false;
                    eName = st.getName();
                    for (String name : stUsedNames) {
                        if (!name.equals(eName)) continue;
                        stNameUsed = true;
                        break;
                    }
                    if (!stNameUsed) {
                        tableUsedNames.add(eName);
                    }
                    Element stDetails = document.createElement(namespace + "STDetails");
                    stCollection.appendChild(stDetails);
                    e = document.createElement(namespace + structuredTypeNameXMLTag);
                    e.appendChild(document.createTextNode(!stNameUsed ? st.getName() : ""));
                    stDetails.appendChild(e);
                    e = document.createElement(namespace + typeElementNameXMLTag);
                    e.appendChild(document.createTextNode(typeElement.getName()));
                    stDetails.appendChild(e);
                }
            }
        }
        return baseElement;
    }

    private class ObjectsComparator
    implements Comparator {
        private ObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            String s1 = "";
            String s2 = "";
            if (one instanceof DesignObject) {
                s1 = ((DesignObject)one).getName();
            } else if (one instanceof SearchResultObject) {
                s1 = ((ModelIDObject)((SearchResultObject)one).getObj()).getName();
            } else if (one instanceof AbstractView) {
                s1 = ((AbstractView)one).getName();
            }
            if (two instanceof DesignObject) {
                s2 = ((DesignObject)two).getName();
            } else if (two instanceof SearchResultObject) {
                s2 = ((ModelIDObject)((SearchResultObject)two).getObj()).getName();
            } else if (two instanceof AbstractView) {
                s2 = ((AbstractView)two).getName();
            }
            return s1.compareTo(s2);
        }
    }

    private class UDPComparator
    implements Comparator {
        private UDPComparator() {
        }

        public int compare(Object one, Object two) {
            UserDefinedProperty o1 = (UserDefinedProperty)one;
            UserDefinedProperty o2 = (UserDefinedProperty)two;
            String s1 = o1.getName() + " / " + o1.getLibrary().getFileName();
            String s2 = o2.getName() + " / " + o2.getLibrary().getFileName();
            return s1.compareTo(s2);
        }
    }

    class PropertiesComparator
    implements Comparator {
        TreeMap tm = new TreeMap();
        Iterator it0 = null;

        public PropertiesComparator(List searchResultObjectslist, List searchablePropertieslist) {
            for (ReportColumn rc : searchablePropertieslist) {
                String order = rc.getColumnOrder();
                if (order == null || order.equals("")) continue;
                this.tm.put(rc.getColumnOrder(), rc.getPropertyName());
            }
            if (this.tm.size() == 0) {
                this.sortByName(searchablePropertieslist);
            }
        }

        private void sortByName(List searchablePropertieslist) {
            for (ReportColumn rc : searchablePropertieslist) {
                if (!rc.getColumnName().equalsIgnoreCase("name")) continue;
                this.tm.put(1, rc.getPropertyName());
            }
        }

        public int compare(Object o1, Object o2) {
            ClassDescription cd1 = null;
            ClassDescription cd2 = null;
            Object obj1 = null;
            Object obj2 = null;
            if (o1 instanceof SearchResultObject) {
                SearchResultObject ro1 = (SearchResultObject)o1;
                obj1 = ro1.getObj();
            } else {
                obj1 = o1;
            }
            Class<?> classObj1 = obj1.getClass();
            cd1 = ReportsGenerator.this.metaDataManager.getClassDescription(classObj1.getName());
            if (o2 instanceof SearchResultObject) {
                SearchResultObject ro2 = (SearchResultObject)o2;
                obj2 = ro2.getObj();
            } else {
                obj2 = o2;
            }
            Class<?> classObj2 = obj2.getClass();
            cd2 = ReportsGenerator.this.metaDataManager.getClassDescription(classObj2.getName());
            String className1 = "";
            for (Map.Entry pairs : this.tm.entrySet()) {
                String v1 = "";
                String v2 = "";
                try {
                    ClassDescription.PropertyDescription pd2;
                    ClassDescription.PropertyDescription pd1 = cd1.getPropertyDescriptionByNameInclRO((String)pairs.getValue());
                    if (pd1 != null) {
                        className1 = pd1.className;
                        java.lang.reflect.Method method1 = pd1.getter;
                        v1 = ReportUtils.getValue((ModelIDObject)obj1, method1, className1);
                    }
                    if ((pd2 = cd2.getPropertyDescriptionByNameInclRO((String)pairs.getValue())) != null) {
                        String className2 = pd2.className;
                        java.lang.reflect.Method method2 = pd2.getter;
                        v2 = ReportUtils.getValue((ModelIDObject)obj2, method2, className2);
                    }
                    if (v1.equals(v2)) continue;
                    if (pd1.isDateTime()) {
                        Date d1 = new SimpleDateFormat(ReportUtils.dateFormat).parse(v1);
                        Date d2 = new SimpleDateFormat(ReportUtils.dateFormat).parse(v2);
                        return d1.compareTo(d2);
                    }
                    if (className1.indexOf("java.lang.Integer") > -1) {
                        return new Integer(v1).compareTo(new Integer(v2));
                    }
                    if (className1.indexOf("java.lang.Float") > -1) {
                        return new Float(v1).compareTo(new Float(v2));
                    }
                    if (className1.indexOf("java.lang.Short") > -1) {
                        return new Short(v1).compareTo(new Short(v2));
                    }
                    if (className1.indexOf("java.lang.Long") > -1) {
                        return new Long(v1).compareTo(new Long(v2));
                    }
                    if (className1.indexOf("java.lang.Double") > -1) {
                        return new Double(v1).compareTo(new Double(v2));
                    }
                    if (className1.indexOf("int") > -1) {
                        return Integer.valueOf(v1).compareTo(Integer.valueOf(v2));
                    }
                    if (className1.indexOf("float") > -1) {
                        return Float.valueOf(v1).compareTo(Float.valueOf(v2));
                    }
                    if (className1.indexOf("short") > -1) {
                        return Short.valueOf(v1).compareTo(Short.valueOf(v2));
                    }
                    if (className1.indexOf("long") > -1) {
                        return Long.valueOf(v1).compareTo(Long.valueOf(v2));
                    }
                    if (className1.indexOf("double") > -1) {
                        return Double.valueOf(v1).compareTo(Double.valueOf(v2));
                    }
                    return v1.compareTo(v2);
                }
                catch (Exception e) {
                    LOGGER.error("Exception in search results report generation (objects sort) " + e.getMessage(), e);
                }
            }
            return 0;
        }
    }

    private class DPVComparator
    implements Comparator {
        private DPVComparator() {
        }

        public int compare(Object one, Object two) {
            DesignPartView o1 = (DesignPartView)one;
            DesignPartView o2 = (DesignPartView)two;
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class SubviewsComparator
    implements Comparator {
        private SubviewsComparator() {
        }

        public int compare(Object one, Object two) {
            DesignPartViewPlaceHolder o1 = (DesignPartViewPlaceHolder)one;
            DesignPartViewPlaceHolder o2 = (DesignPartViewPlaceHolder)two;
            return o1.getName().compareTo(o2.getName());
        }
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;

        public ValueComparator(Map<String, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            Integer y;
            Integer x = this.base.get(a);
            if (x.equals(y = this.base.get(b))) {
                return a.compareTo(b);
            }
            return x.compareTo(y);
        }
    }
}

