/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.transformations.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ChangeNamePrefixDialog
extends CustomDialog {
    private JPanel general;
    private JTextField tfFind;
    private JTextField tfReplace;
    private JCheckBox chbCaseSensitive;
    private JCheckBox chbAddNewPrefix;
    private JCheckBox chbTables;
    private JCheckBox chbColumns;
    private JCheckBox chbIndices;
    private JCheckBox chbViews;
    private JCheckBox chbPKUKConstraints;
    private JCheckBox chbFKConstraints;
    private JDialog dialog;
    private RelationalDesign relDesign;
    private DesignPartView dpv = null;
    private String oldPrefix;
    private String newPrefix;
    private int counter = 0;
    private JRadioButton rbClassificationsReplacement;
    private JRadioButton rbCustomReplacement;
    private JPanel northPanel;
    private JPanel centerPanel;
    private static final Logger LOGGER = new Logger(ChangeNamePrefixDialog.class);

    public ChangeNamePrefixDialog(ApplicationView appView, DesignPartView dpv) {
        super(appView);
        this.relDesign = (RelationalDesign)dpv.getDesignPart();
        this.dpv = dpv;
        this.process();
    }

    public ChangeNamePrefixDialog(ApplicationView appView, RelationalDesign relDesign) {
        super(appView);
        this.relDesign = relDesign;
        this.process();
    }

    private void process() {
        this.setLayout(new BorderLayout());
        this.general = new JPanel(new BorderLayout());
        this.initGeneralView();
        this.add((Component)this.general, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        JButton bnOK = new JButton(Messages.getString("ChangeNamePrefixDialog.Apply"));
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(Messages.getString("ChangeNamePrefixDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        bottomPanel.add(bnHelp);
        this.add((Component)bottomPanel, "South");
    }

    private void setObjectConstraints(JPanel panel, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)panel.getLayout()).getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    private void initGeneralView() {
        this.northPanel = new JPanel(new SpringLayout());
        this.northPanel.setPreferredSize(new Dimension(100, 30));
        this.centerPanel = new JPanel(new BorderLayout());
        this.initGeneral();
        this.initTextFields();
        this.initObjects();
        this.general.add((Component)this.northPanel, "North");
        this.general.add((Component)this.centerPanel, "Center");
    }

    private void initGeneral() {
        this.rbCustomReplacement = new JRadioButton(Messages.getString("ChangeNamePrefixDialog.PrefixReplacement"));
        this.rbCustomReplacement.addActionListener(new RadioCustomReplacementListener());
        this.rbCustomReplacement.setSelected(true);
        this.rbCustomReplacement.setToolTipText(Messages.getString("ChangeNamePrefixDialog.ChangeCurrentPrefixWithNewPrefix"));
        this.rbClassificationsReplacement = new JRadioButton(Messages.getString("ChangeNamePrefixDialog.AddClassificationPrefix"));
        this.rbClassificationsReplacement.addActionListener(new RadioClassificationsReplacementListener());
        this.rbClassificationsReplacement.setSelected(false);
        this.rbClassificationsReplacement.setToolTipText(Messages.getString("ChangeNamePrefixDialog.AddPrefixAccordingToClassificationType"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbCustomReplacement);
        group.add(this.rbClassificationsReplacement);
        this.northPanel.add(this.rbCustomReplacement);
        this.northPanel.add(this.rbClassificationsReplacement);
        this.setObjectConstraints(this.northPanel, this.rbCustomReplacement, 4, 5);
        this.setObjectConstraints(this.northPanel, this.rbClassificationsReplacement, 190, 5);
    }

    private void initTextFields() {
        JPanel pnTextFields = new JPanel(new SpringLayout());
        TitledBorder tb = new TitledBorder(Messages.getString("ChangeNamePrefixDialog.Prefix"));
        pnTextFields.setBorder(BorderFactory.createCompoundBorder(tb, BorderFactory.createEmptyBorder(1, 5, 67, 360)));
        this.setObjectConstraints(this.northPanel, pnTextFields, 4, 25);
        Dimension dim = new Dimension(190, 20);
        JLabel lbFind = new JLabel(Messages.getString("ChangeNamePrefixDialog.CurrentPrefix"));
        pnTextFields.add(lbFind);
        this.setObjectConstraints(pnTextFields, lbFind, 8, 1);
        this.tfFind = new JTextField();
        this.tfFind.setPreferredSize(dim);
        pnTextFields.add(this.tfFind);
        this.setObjectConstraints(pnTextFields, this.tfFind, 130, 1);
        JLabel lbReplace = new JLabel(Messages.getString("ChangeNamePrefixDialog.NewPrefix"));
        pnTextFields.add(lbReplace);
        this.setObjectConstraints(pnTextFields, lbReplace, 8, 23);
        this.tfReplace = new JTextField();
        this.tfReplace.setPreferredSize(dim);
        pnTextFields.add(this.tfReplace);
        this.setObjectConstraints(pnTextFields, this.tfReplace, 130, 23);
        this.chbCaseSensitive = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.CaseSensitive"));
        pnTextFields.add(this.chbCaseSensitive);
        this.setObjectConstraints(pnTextFields, this.chbCaseSensitive, 8, 47);
        this.chbAddNewPrefix = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.AddNewPrefix"));
        this.chbAddNewPrefix.setToolTipText(Messages.getString("ChangeNamePrefixDialog.AddPrefixCaseOfMissingPrefix"));
        pnTextFields.add(this.chbAddNewPrefix);
        this.setObjectConstraints(pnTextFields, this.chbAddNewPrefix, 200, 47);
        this.centerPanel.add((Component)pnTextFields, "North");
    }

    private void initObjects() {
        JPanel pnObjects = new JPanel(new SpringLayout());
        TitledBorder tb = new TitledBorder(Messages.getString("ChangeNamePrefixDialog.ApplyTo"));
        pnObjects.setBorder(BorderFactory.createCompoundBorder(tb, BorderFactory.createEmptyBorder(1, 5, 80, 360)));
        this.setObjectConstraints(this.northPanel, pnObjects, 4, 116);
        this.chbTables = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Tables"));
        this.chbTables.setSelected(true);
        this.chbColumns = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Columns"));
        this.chbIndices = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Indexes"));
        this.chbViews = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Views"));
        this.chbPKUKConstraints = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.PKUKConstraints"));
        this.chbFKConstraints = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.FKConstraints"));
        pnObjects.add(this.chbTables);
        pnObjects.add(this.chbViews);
        pnObjects.add(this.chbColumns);
        pnObjects.add(this.chbIndices);
        pnObjects.add(this.chbPKUKConstraints);
        pnObjects.add(this.chbFKConstraints);
        this.setObjectConstraints(pnObjects, this.chbTables, 8, 0);
        this.setObjectConstraints(pnObjects, this.chbColumns, 160, 0);
        this.setObjectConstraints(pnObjects, this.chbViews, 8, 30);
        this.setObjectConstraints(pnObjects, this.chbIndices, 160, 30);
        this.setObjectConstraints(pnObjects, this.chbFKConstraints, 8, 60);
        this.setObjectConstraints(pnObjects, this.chbPKUKConstraints, 160, 60);
        this.centerPanel.add((Component)pnObjects, "South");
    }

    @Override
    protected void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ChangeNamePrefixDialog.ChangeObjectNamesPrefix"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setPreferredSize(new Dimension(360, 280));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "CHANGE_OBJECT_NAMES_PREFIX_DIALOG";
    }

    private void runTransformation() {
        this.transform();
        this.close();
    }

    private void manageControls(boolean classifications) {
        if (classifications) {
            this.tfFind.setText("");
            this.tfFind.setEnabled(false);
            this.tfReplace.setText("");
            this.tfReplace.setEnabled(false);
            this.chbCaseSensitive.setSelected(false);
            this.chbCaseSensitive.setEnabled(false);
            this.chbAddNewPrefix.setSelected(false);
            this.chbAddNewPrefix.setEnabled(false);
            this.chbTables.setSelected(true);
            this.chbTables.setEnabled(false);
            this.chbColumns.setSelected(false);
            this.chbColumns.setEnabled(false);
            this.chbIndices.setSelected(false);
            this.chbIndices.setEnabled(false);
            this.chbViews.setSelected(false);
            this.chbViews.setEnabled(false);
            this.chbPKUKConstraints.setSelected(false);
            this.chbPKUKConstraints.setEnabled(false);
            this.chbFKConstraints.setSelected(false);
            this.chbFKConstraints.setEnabled(false);
        } else {
            this.tfFind.setEnabled(true);
            this.tfReplace.setEnabled(true);
            this.chbCaseSensitive.setEnabled(true);
            this.chbAddNewPrefix.setEnabled(true);
            this.chbTables.setSelected(true);
            this.chbTables.setEnabled(true);
            this.chbColumns.setSelected(false);
            this.chbColumns.setEnabled(true);
            this.chbIndices.setSelected(false);
            this.chbIndices.setEnabled(true);
            this.chbViews.setSelected(false);
            this.chbViews.setEnabled(true);
            this.chbPKUKConstraints.setSelected(false);
            this.chbPKUKConstraints.setEnabled(true);
            this.chbFKConstraints.setSelected(false);
            this.chbFKConstraints.setEnabled(true);
        }
    }

    private void transform() {
        try {
            this.counter = 0;
            this.oldPrefix = this.tfFind.getText();
            this.newPrefix = this.tfReplace.getText();
            if (this.chbTables.isSelected()) {
                this.renameTables();
            }
            if (this.rbCustomReplacement.isSelected()) {
                if (this.chbColumns.isSelected()) {
                    this.renameColumns();
                }
                if (this.chbIndices.isSelected()) {
                    this.renameIndices();
                }
                if (this.chbPKUKConstraints.isSelected()) {
                    this.renamePKUKConstraints();
                }
                if (this.chbFKConstraints.isSelected()) {
                    this.renameFKConstraints();
                }
                if (this.chbViews.isSelected()) {
                    this.renameViews();
                }
            }
            String message = this.counter == 1 ? Messages.getString("ChangeNamePrefixDialog.NameHasBeenChanged") : MessageFormat.format(Messages.getString("ChangeNamePrefixDialog.ManyNameHasBeenChanged"), String.valueOf(this.counter));
            MessageDialogs.showMessage(this, message);
        }
        catch (Exception e) {
            LOGGER.error("ChangeNamePrefixDialog.transform()", e);
        }
    }

    private void convertName(DesignObject object) {
        Object name = object.getName();
        boolean convert = false;
        convert = this.chbCaseSensitive.isSelected() ? ((String)name).startsWith(this.oldPrefix) : ((String)name).toUpperCase().startsWith(this.oldPrefix.toUpperCase());
        if (convert) {
            name = this.newPrefix + ((String)name).substring(this.oldPrefix.length());
            object.setName((String)name);
            object.setDirty(true);
            ++this.counter;
        }
    }

    private void convertClassificationName(Table table) {
        String classTypePrefix;
        Object name = table.getName();
        ClassificationType type = this.relDesign.getDesign().getDesignLevelSettings().getClassificationTypeByID(table.getTypeID());
        if (type != null && (classTypePrefix = type.getTypePrefix()) != null && !"".equals(classTypePrefix)) {
            name = classTypePrefix + (String)name;
            table.setName((String)name);
            table.setDirty(true);
            ++this.counter;
        }
    }

    private void renameTables() {
        Table[] tables = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                if (this.rbClassificationsReplacement.isSelected()) {
                    this.convertClassificationName(table);
                } else {
                    this.convertName(table);
                }
                table.setDirty(true);
                continue;
            }
            if (this.rbClassificationsReplacement.isSelected()) {
                this.convertClassificationName(table);
            } else {
                this.convertName(table);
            }
            table.setDirty(true);
        }
    }

    private void renameColumns() {
        Table[] tables = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Column column;
            int j;
            Table table = tables[i];
            Column[] columns = (Column[])table.getElements();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                for (j = 0; j < columns.length; ++j) {
                    column = columns[j];
                    this.convertName(column);
                }
                table.setDirty(true);
                continue;
            }
            for (j = 0; j < columns.length; ++j) {
                column = columns[j];
                this.convertName(column);
            }
            table.setDirty(true);
        }
    }

    private void renameIndices() {
        Table[] tables = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Index index;
            Table table = tables[i];
            Iterator it = table.getIndexes().iterator();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                while (it.hasNext()) {
                    index = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                    this.convertName(index);
                }
                table.setDirty(true);
                continue;
            }
            while (it.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                this.convertName(index);
            }
            table.setDirty(true);
        }
    }

    private void renamePKUKConstraints() {
        Table[] tables = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Index index;
            Table table = tables[i];
            Iterator itPK = table.getPKeys().iterator();
            Iterator itUK = table.getUKeys().iterator();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                while (itPK.hasNext()) {
                    index = (Index)((ContainerObjectPlaceHolder)itPK.next()).getObject();
                    this.convertName(index);
                }
                while (itUK.hasNext()) {
                    index = (Index)((ContainerObjectPlaceHolder)itUK.next()).getObject();
                    this.convertName(index);
                }
                table.setDirty(true);
                continue;
            }
            while (itPK.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)itPK.next()).getObject();
                this.convertName(index);
            }
            while (itUK.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)itUK.next()).getObject();
                this.convertName(index);
            }
            table.setDirty(true);
        }
    }

    private void renameFKConstraints() {
        Table[] tables = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            FKIndexAssociation fk;
            Table table = tables[i];
            Iterator<FKIndexAssociation> it = table.getFKAssociationsList().iterator();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                while (it.hasNext()) {
                    fk = it.next();
                    this.convertName(fk);
                }
                table.setDirty(true);
                continue;
            }
            while (it.hasNext()) {
                fk = it.next();
                this.convertName(fk);
            }
            table.setDirty(true);
        }
    }

    private void renameViews() {
        TableView[] views = (TableView[])this.relDesign.getTableViewSet().toArray();
        for (int i = 0; i < views.length; ++i) {
            TableView view = views[i];
            if (this.dpv != null) {
                if (view.getFirstViewForDPV(this.dpv) == null) continue;
                this.convertName(view);
                continue;
            }
            this.convertName(view);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ChangeNamePrefixDialog.this.rbCustomReplacement.isSelected()) {
                if (!"".equalsIgnoreCase(ChangeNamePrefixDialog.this.tfFind.getText())) {
                    if (!"".equalsIgnoreCase(ChangeNamePrefixDialog.this.tfReplace.getText())) {
                        ChangeNamePrefixDialog.this.runTransformation();
                    } else {
                        MessageDialogs.showWarningMessage(ChangeNamePrefixDialog.this, Messages.getString("ChangeNamePrefixDialog.NewPrefixNotBeEmpty"));
                        ChangeNamePrefixDialog.this.tfReplace.requestFocus();
                    }
                } else if (ChangeNamePrefixDialog.this.chbAddNewPrefix.isSelected()) {
                    if (!"".equalsIgnoreCase(ChangeNamePrefixDialog.this.tfReplace.getText())) {
                        ChangeNamePrefixDialog.this.runTransformation();
                    } else {
                        int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ChangeNamePrefixDialog.NewPrefixNotSpecified"), Messages.getString("ChangeNamePrefixDialog.Confirm"), 0);
                        if (res == 0) {
                            ChangeNamePrefixDialog.this.runTransformation();
                        }
                    }
                } else {
                    MessageDialogs.showWarningMessage(ChangeNamePrefixDialog.this, Messages.getString("ChangeNamePrefixDialog.CurrentPrefixCanBeEmpty"));
                    ChangeNamePrefixDialog.this.tfFind.requestFocus();
                }
            } else if (ChangeNamePrefixDialog.this.rbClassificationsReplacement.isSelected()) {
                ChangeNamePrefixDialog.this.runTransformation();
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangeNamePrefixDialog.this.close();
        }
    }

    private class RadioCustomReplacementListener
    implements ActionListener {
        private RadioCustomReplacementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangeNamePrefixDialog.this.manageControls(false);
        }
    }

    private class RadioClassificationsReplacementListener
    implements ActionListener {
        private RadioClassificationsReplacementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangeNamePrefixDialog.this.manageControls(true);
        }
    }
}

