/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.spacecalculation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.printing.DesignPrintModule;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.ide.Ide;

public class SpaceCalculationDB2
extends JDialog
implements ChangeListener {
    public static final String KEY_ESCAPE = "ESCAPE";
    private ApplicationView appView;
    private JTabbedPane tpane;
    protected JPanel propQTY;
    protected JPanel estSpace;
    private JPanel settings;
    protected JLabel lbName;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected final String[] NONE = new String[]{""};
    protected final String[] YES_NO = new String[]{Messages.getString("SpaceCalculationDB2.YES"), Messages.getString("SpaceCalculationDB2.NO")};
    protected static final int FIELD_WIDTH = 25;
    protected AbstractStorageDesignDB2 storageDesign;
    private JTable qtyTable;
    private JTable spaceTable;
    private JButton bnPrint;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SpaceCalculationDB2.this.dispose();
        }
    };
    JCheckBox chbUseObjectSet;
    JRadioButton bInsert;
    JRadioButton bLoad;
    ButtonGroup bgInsert = new ButtonGroup();
    private JIntegerField ifFreePage;
    private JIntegerField ifPCTFREE;
    private JCheckBox chbUsePCTFilling;
    private JIntegerField ifPCTFilling;
    List propQList = new ArrayList();
    List backupList = new ArrayList();
    StorageTemplateDB2 tempStorageTemplate;
    List spaceList = new ArrayList();

    public SpaceCalculationDB2(ApplicationView view, AbstractStorageDesignDB2 storageDesign) {
        super(view.getFrame());
        this.appView = view;
        this.storageDesign = storageDesign;
        this.storageDesign.setScDialogVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SpaceCalculationDB2.this.storageDesign.setScDialogVisible(false);
            }
        });
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tpane = new JTabbedPane();
        this.tpane.addChangeListener(this);
        this.tpane.setPreferredSize(new Dimension(890, 500));
        this.propQTY = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("SpaceCalculationDB2.ProposedQTY"), this.propQTY);
        this.initQTYView();
        this.addTabs();
        this.estSpace = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("SpaceCalculationDB2.EstimatedSpace"), this.estSpace);
        this.initSpaceView();
        this.settings = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("SpaceCalculationDB2.Settings"), this.settings);
        this.initSettingsView();
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.tpane, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnApply = new JButton(Messages.getString("SpaceCalculationDB2.Calculate"));
        bnApply.addActionListener(new CalculateAction());
        bnApply.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setMnemonic(65);
        bottomPanel.add(bnApply);
        this.bnPrint = new JButton(Messages.getString("SpaceCalculationDB2.Print"));
        this.bnPrint.addActionListener(new PrintAction());
        this.bnPrint.setCursor(Cursor.getPredefinedCursor(12));
        this.bnPrint.setMnemonic(80);
        bottomPanel.add(this.bnPrint);
        JButton bnCancel = new JButton(Messages.getString("SpaceCalculationDB2.Close"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnPrint.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnCancel);
        jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(jpanel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.calculate();
    }

    public String getCaption() {
        return Messages.getString("SpaceCalculationDB2.SpaceCalculation");
    }

    protected void addTabs() {
    }

    protected void initQTYView() {
        this.qtyTable = new JTable(new PropQTYTableModel());
        this.qtyTable.addMouseListener(new SpaceMouseListener(this.propQList));
        this.qtyTable.setToolTipText(Messages.getString("SpaceCalculationDB2.UseDoubleClickPropertyDialog"));
        this.qtyTable.getSelectionModel().setSelectionMode(0);
        this.qtyTable.setAutoResizeMode(0);
        TableColumnModel colmod = this.qtyTable.getColumnModel();
        Enumeration<TableColumn> cen = colmod.getColumns();
        int i = 0;
        while (cen.hasMoreElements()) {
            TableColumn tc = cen.nextElement();
            if (i == 0) {
                tc.setPreferredWidth(210);
            } else {
                tc.setPreferredWidth(110);
            }
            ++i;
        }
        JScrollPane sp = new JScrollPane(this.qtyTable);
        int h = this.getPane().getPreferredSize().height - 40;
        int w = this.getPane().getPreferredSize().width;
        sp.setPreferredSize(new Dimension(w, h));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.propQTY.add(sp);
    }

    protected void initSpaceView() {
        this.spaceTable = new JTable(new SpaceTableModel());
        this.spaceTable.addMouseListener(new SpaceMouseListener(this.spaceList));
        this.spaceTable.setToolTipText(Messages.getString("SpaceCalculationDB2.UseDoubleClickPropertyDialog"));
        this.spaceTable.getSelectionModel().setSelectionMode(0);
        this.spaceTable.setAutoResizeMode(0);
        this.spaceTable.setDefaultRenderer(Object.class, new SpaceColorRenderer(this.spaceList));
        TableColumnModel colmod = this.spaceTable.getColumnModel();
        Enumeration<TableColumn> cen = colmod.getColumns();
        int i = 0;
        while (cen.hasMoreElements()) {
            TableColumn tc = cen.nextElement();
            if (i == 0) {
                tc.setPreferredWidth(210);
            } else {
                tc.setPreferredWidth(135);
            }
            ++i;
        }
        JScrollPane sp = new JScrollPane(this.spaceTable);
        int h = this.getPane().getPreferredSize().height - 40;
        int w = this.getPane().getPreferredSize().width;
        sp.setPreferredSize(new Dimension(w, h));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.estSpace.add(sp);
    }

    private JTable getSpaceTable() {
        JTable sptable = new JTable(new SpaceTableModel());
        sptable.setDefaultRenderer(Object.class, new SpaceColorRenderer(this.spaceList));
        sptable.setAutoResizeMode(0);
        Dimension size = new Dimension(this.spaceTable.getSize().width, this.spaceTable.getSize().height + this.spaceTable.getTableHeader().getSize().height + 20);
        sptable.setSize(size);
        TableColumnModel colmod = this.spaceTable.getColumnModel();
        TableColumnModel spcols = sptable.getColumnModel();
        Enumeration<TableColumn> cen = colmod.getColumns();
        Enumeration<TableColumn> spen = spcols.getColumns();
        while (cen.hasMoreElements()) {
            TableColumn tc = cen.nextElement();
            TableColumn spcol = spen.nextElement();
            spcol.setPreferredWidth(tc.getPreferredWidth());
        }
        return sptable;
    }

    private JTable getQTYTable() {
        JTable qtable = new JTable(new PropQTYTableModel());
        qtable.setAutoResizeMode(0);
        Dimension size = new Dimension(this.qtyTable.getSize().width, this.qtyTable.getSize().height + this.qtyTable.getTableHeader().getSize().height + 20);
        qtable.setSize(size);
        TableColumnModel colmod = this.qtyTable.getColumnModel();
        Enumeration<TableColumn> cen = colmod.getColumns();
        TableColumnModel qcols = qtable.getColumnModel();
        Enumeration<TableColumn> qen = qcols.getColumns();
        while (cen.hasMoreElements()) {
            TableColumn tc = cen.nextElement();
            TableColumn qcol = qen.nextElement();
            qcol.setPreferredWidth(tc.getPreferredWidth());
        }
        return qtable;
    }

    SpringLayout getSettingsLayout() {
        return (SpringLayout)this.settings.getLayout();
    }

    void initSettingsView() {
        this.initUseObjectSettings();
        this.initInsertMethod();
        this.initFreePage();
        this.initPCTFree();
        this.initPCTFilling();
        this.chbUseObjectSet.setSelected(true);
        this.setUseObjectSettings(false);
    }

    void initUseObjectSettings() {
        this.chbUseObjectSet = new JCheckBox(Messages.getString("SpaceCalculationDB2.UseObjectLevelSettings"));
        this.settings.add(this.chbUseObjectSet);
        this.chbUseObjectSet.addActionListener(new UseObSetCheckBoxListener());
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.chbUseObjectSet, 10, 10);
    }

    void initInsertMethod() {
        this.bInsert = new JRadioButton(Messages.getString("SpaceCalculationDB2.InsertMethodSQLInsert"), true);
        this.bLoad = new JRadioButton(Messages.getString("SpaceCalculationDB2.InsertMethodLoad"), false);
        this.bgInsert.add(this.bInsert);
        this.bgInsert.add(this.bLoad);
        this.settings.add(this.bInsert);
        this.settings.add(this.bLoad);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.bInsert, 30, 40);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.bLoad, 30, 60);
    }

    void initFreePage() {
        JLabel label = new JLabel(Messages.getString("SpaceCalculationDB2.FreePage"));
        this.settings.add(label);
        this.ifFreePage = new JIntegerField(0, 3);
        this.settings.add(this.ifFreePage);
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), label, 30, 90);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.ifFreePage, 130, 90);
        this.ifFreePage.setValue(0L);
    }

    void initPCTFree() {
        JLabel label = new JLabel(Messages.getString("SpaceCalculationDB2.PCTFREE"));
        this.settings.add(label);
        this.ifPCTFREE = new JIntegerField(0, 3);
        this.settings.add(this.ifPCTFREE);
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), label, 30, 120);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.ifPCTFREE, 130, 120);
        this.ifPCTFREE.setValue(5L);
    }

    void initPCTFilling() {
        JLabel label = new JLabel(Messages.getString("SpaceCalculationDB2.UsePCTFillingForVarTypes"));
        this.settings.add(label);
        this.chbUsePCTFilling = new JCheckBox("");
        this.chbUsePCTFilling.addActionListener(new CheckBoxListener());
        this.settings.add(this.chbUsePCTFilling);
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), label, 30, 150);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.chbUsePCTFilling, 190, 150);
        label = new JLabel(Messages.getString("SpaceCalculationDB2.PCTFilling"));
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), label, 120, 180);
        this.settings.add(label);
        this.ifPCTFilling = new JIntegerField(0, 3);
        this.settings.add(this.ifPCTFilling);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.ifPCTFilling, 195, 180);
        this.setPCTFillingUse(false);
        this.ifPCTFilling.setValue(66L);
    }

    private void setPCTFillingUse(boolean use) {
        this.ifPCTFilling.setEditable(use);
        this.ifPCTFilling.setEnabled(use);
    }

    private void setUseObjectSettings(boolean use) {
        this.bInsert.setEnabled(use);
        this.bLoad.setEnabled(use);
        this.ifPCTFREE.setEditable(use);
        this.ifPCTFREE.setEnabled(use);
        this.ifFreePage.setEditable(use);
        this.ifFreePage.setEnabled(use);
        this.ifPCTFilling.setEditable(use && this.chbUsePCTFilling.isSelected());
        this.ifPCTFilling.setEnabled(use && this.chbUsePCTFilling.isSelected());
        this.chbUsePCTFilling.setEnabled(use);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.propQTY.getLayout();
    }

    protected SpringLayout getCommentsLayout() {
        return (SpringLayout)this.estSpace.getLayout();
    }

    protected void setLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(125));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int x, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    public JTabbedPane getPane() {
        return this.tpane;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.tpane != null && this.bnPrint != null) {
            this.bnPrint.setEnabled(this.tpane.getSelectedIndex() < 2);
        }
    }

    void backupAndSet() {
        StorageObject ts;
        BackupData bd;
        this.backupList.clear();
        this.tempStorageTemplate = this.storageDesign.getStorageTemplateSet().createStorageTemplate(null);
        this.tempStorageTemplate.setPctFree(this.ifPCTFREE.getIntValue());
        this.tempStorageTemplate.setFreePage(this.ifFreePage.getIntValue());
        String insMethod = this.bInsert.isSelected() ? "SQL Insert" : "Load/Reorg";
        boolean usePCTFil = this.chbUsePCTFilling.isSelected();
        int pctFil = this.ifPCTFilling.getIntValue();
        Iterator it = this.storageDesign.getTableSpaceSet().iterator();
        while (it.hasNext()) {
            bd = new BackupData();
            bd.storageObject = ts = (TableSpaceDB2)it.next();
            bd.stTemplate = ((TableSpaceDB2)ts).getStorageTemplate();
            this.backupList.add(bd);
            ((TableSpaceDB2)ts).setStorageTemplate(this.tempStorageTemplate);
        }
        it = this.storageDesign.getIndexProxySet().iterator();
        while (it.hasNext()) {
            bd = new BackupData();
            bd.storageObject = ts = (IndexProxyDB2)it.next();
            bd.stTemplate = ((IndexProxyDB2)ts).getStorageTemplate();
            this.backupList.add(bd);
            ((IndexProxyDB2)ts).setStorageTemplate(this.tempStorageTemplate);
        }
        it = this.storageDesign.getAUXTableIndexSet().iterator();
        while (it.hasNext()) {
            bd = new BackupData();
            bd.storageObject = ts = (AUXTableIndexDB2)it.next();
            bd.stTemplate = ((AUXTableIndexDB2)ts).getStorageTemplate();
            this.backupList.add(bd);
            ((AUXTableIndexDB2)ts).setStorageTemplate(this.tempStorageTemplate);
        }
        it = this.storageDesign.getTableProxySet().iterator();
        while (it.hasNext()) {
            bd = new BackupData();
            bd.storageObject = ts = (TableProxyDB2)it.next();
            bd.insMode = ((TableProxyDB2)ts).getInsertMethod();
            bd.usePctFilling = ((TableProxyDB2)ts).isUsePCTFilling();
            bd.pctFilling = ((TableProxyDB2)ts).getPctFilling();
            this.backupList.add(bd);
            ((TableProxyDB2)ts).setInsertMethod(insMethod);
            ((TableProxyDB2)ts).setUsePCTFilling(usePCTFil);
            ((TableProxyDB2)ts).setPctFilling(pctFil);
        }
    }

    void restore() {
        for (BackupData bd : this.backupList) {
            if (bd.storageObject instanceof TableSpaceDB2) {
                TableSpaceDB2 ts = (TableSpaceDB2)bd.storageObject;
                ts.setStorageTemplate(bd.stTemplate);
                continue;
            }
            if (bd.storageObject instanceof IndexProxyDB2) {
                IndexProxyDB2 ip = (IndexProxyDB2)bd.storageObject;
                ip.setStorageTemplate(bd.stTemplate);
                continue;
            }
            if (bd.storageObject instanceof AUXTableIndexDB2) {
                AUXTableIndexDB2 ai = (AUXTableIndexDB2)bd.storageObject;
                ai.setStorageTemplate(bd.stTemplate);
                continue;
            }
            if (!(bd.storageObject instanceof TableProxyDB2)) continue;
            TableProxyDB2 tp = (TableProxyDB2)bd.storageObject;
            tp.setInsertMethod(bd.insMode);
            tp.setUsePCTFilling(bd.usePctFilling);
            tp.setPctFilling(bd.pctFilling);
        }
        this.storageDesign.getStorageTemplateSet().remove(this.tempStorageTemplate);
    }

    boolean useObjectLevelSettings() {
        return this.chbUseObjectSet.isSelected();
    }

    void loadPropQLIst() {
        PropQTYData pqd;
        this.propQList.clear();
        for (StorageObject ts : this.storageDesign.getTableSpaceSet()) {
            if (ts.isNullInstance()) continue;
            pqd = new PropQTYData();
            pqd.storageObject = ts;
            pqd.name = ts.getName();
            pqd.type = "TableSpace";
            pqd.priQTY = Integer.toString(((TableSpaceDB2)ts).getProposedPRIQTY());
            pqd.secQTY = Integer.toString(((TableSpaceDB2)ts).getProposedSECQTY());
            pqd.initSpace = Integer.toString(((TableSpaceDB2)ts).getInitialNumberUsedPages());
            pqd.maxSpace = Integer.toString(((TableSpaceDB2)ts).getMaxNumberUsedPages());
            if (((TableSpaceDB2)ts).getStorageTemplate() != null) {
                pqd.currPQTY = Integer.toString(((TableSpaceDB2)ts).getStorageTemplate().getSgPriqty());
                pqd.currSQTY = Integer.toString(((TableSpaceDB2)ts).getStorageTemplate().getSgSeqty());
            } else {
                pqd.currPQTY = "";
                pqd.currSQTY = "";
            }
            this.propQList.add(pqd);
        }
        Iterator it = this.storageDesign.getIndexProxySet().iterator();
        while (it.hasNext()) {
            StorageObject ts;
            ts = (IndexProxyDB2)it.next();
            pqd = new PropQTYData();
            pqd.storageObject = ts;
            pqd.name = ((IndexProxy)ts).getTableProxy().getName() + "." + ((IndexProxyDB2)ts).getName();
            pqd.type = "Index";
            pqd.priQTY = Integer.toString(((IndexProxyDB2)ts).getProposedPRIQTY());
            pqd.secQTY = Integer.toString(((IndexProxyDB2)ts).getProposedSECQTY());
            pqd.initSpace = Integer.toString(((IndexProxyDB2)ts).getInitialNumberUsedPages());
            pqd.maxSpace = Integer.toString(((IndexProxyDB2)ts).getMaxNumberUsedPages());
            if (((IndexProxyDB2)ts).getStorageTemplate() != null) {
                pqd.currPQTY = Integer.toString(((IndexProxyDB2)ts).getStorageTemplate().getSgPriqty());
                pqd.currSQTY = Integer.toString(((IndexProxyDB2)ts).getStorageTemplate().getSgSeqty());
            } else {
                pqd.currPQTY = "";
                pqd.currSQTY = "";
            }
            this.propQList.add(pqd);
        }
        for (StorageObject ts : this.storageDesign.getAUXTableIndexSet()) {
            pqd = new PropQTYData();
            pqd.storageObject = ts;
            pqd.name = ((AUXTableIndexDB2)ts).getAuxTable().getName() + "." + ts.getName();
            pqd.type = Messages.getString("SpaceCalculationDB2.0");
            pqd.priQTY = Integer.toString(((AUXTableIndexDB2)ts).getProposedPRIQTY());
            pqd.secQTY = Integer.toString(((AUXTableIndexDB2)ts).getProposedSECQTY());
            pqd.initSpace = Integer.toString(((AUXTableIndexDB2)ts).getInitialNumberUsedPages());
            pqd.maxSpace = Integer.toString(((AUXTableIndexDB2)ts).getMaxNumberUsedPages());
            if (((AUXTableIndexDB2)ts).getStorageTemplate() != null) {
                pqd.currPQTY = Integer.toString(((AUXTableIndexDB2)ts).getStorageTemplate().getSgPriqty());
                pqd.currSQTY = Integer.toString(((AUXTableIndexDB2)ts).getStorageTemplate().getSgSeqty());
            } else {
                pqd.currPQTY = "";
                pqd.currSQTY = "";
            }
            this.propQList.add(pqd);
        }
    }

    void calculate() {
        if (this.useObjectLevelSettings()) {
            this.loadPropQLIst();
            ((PropQTYTableModel)this.qtyTable.getModel()).dataChanged();
            this.loadSpaceLIst();
            ((SpaceTableModel)this.spaceTable.getModel()).dataChanged();
        } else {
            try {
                this.backupAndSet();
                this.loadPropQLIst();
                ((PropQTYTableModel)this.qtyTable.getModel()).dataChanged();
                this.loadSpaceLIst();
                ((SpaceTableModel)this.spaceTable.getModel()).dataChanged();
            }
            catch (Exception e) {
                System.out.println("Error: SpaceCalculationDB2.calculate");
            }
            finally {
                this.restore();
            }
        }
    }

    void loadSpaceLIst() {
        SpaceData pqd;
        SpaceData pqd2;
        StorageObject ts2;
        Iterator it;
        this.spaceList.clear();
        int initSpace = 0;
        int maxSpace = 0;
        int initSpaceKB = 0;
        int maxSpaceKB = 0;
        Iterator outIt = this.storageDesign.getDataBaseSet().iterator();
        while (outIt.hasNext()) {
            initSpace = 0;
            maxSpace = 0;
            initSpaceKB = 0;
            maxSpaceKB = 0;
            DataBaseDB2 db = (DataBaseDB2)outIt.next();
            it = this.storageDesign.getTableProxySet().iterator();
            while (it.hasNext()) {
                ts2 = (TableProxyDB2)it.next();
                if (!db.containsTable((TableProxyDB2)ts2)) continue;
                pqd2 = new SpaceData();
                pqd2.storageObject = ts2;
                pqd2.name = ((RelationalObjectProxy)ts2).getName();
                pqd2.type = "Table";
                pqd2.initSpace = Integer.toString(((TableProxyDB2)ts2).getInitialNumberUsedPages());
                pqd2.maxSpace = Integer.toString(((TableProxyDB2)ts2).getMaxNumberUsedPages());
                pqd2.initSpaceKB = Integer.toString(((TableProxyDB2)ts2).getInitialStorageKB());
                pqd2.maxSpaceKB = Integer.toString(((TableProxyDB2)ts2).getMaxStorageKB());
                this.spaceList.add(pqd2);
                initSpace += ((TableProxyDB2)ts2).getInitialNumberUsedPages();
                maxSpace += ((TableProxyDB2)ts2).getMaxNumberUsedPages();
                initSpaceKB += ((TableProxyDB2)ts2).getInitialStorageKB();
                maxSpaceKB += ((TableProxyDB2)ts2).getMaxStorageKB();
            }
            if (initSpace <= 0) continue;
            pqd = new SpaceData();
            pqd.initSpace = Integer.toString(initSpace);
            pqd.maxSpace = Integer.toString(maxSpace);
            pqd.initSpaceKB = Integer.toString(initSpaceKB);
            pqd.maxSpaceKB = Integer.toString(maxSpaceKB);
            pqd.storageObject = db;
            pqd.name = db.getName();
            pqd.type = Messages.getString("SpaceCalculationDB2.DataBase");
            this.spaceList.add(pqd);
        }
        outIt = this.storageDesign.getStorageGroupSet().iterator();
        while (outIt.hasNext()) {
            initSpace = 0;
            maxSpace = 0;
            initSpaceKB = 0;
            maxSpaceKB = 0;
            StorageGroupDB2 sg = (StorageGroupDB2)outIt.next();
            it = this.storageDesign.getIndexProxySet().iterator();
            while (it.hasNext()) {
                ts2 = (IndexProxyDB2)it.next();
                if (!sg.containsIndex((IndexProxyDB2)ts2)) continue;
                pqd2 = new SpaceData();
                pqd2.storageObject = ts2;
                pqd2.name = ((IndexProxy)ts2).getTableProxy().getName() + "." + ((IndexProxyDB2)ts2).getName();
                pqd2.type = "Index";
                pqd2.initSpace = Integer.toString(((IndexProxyDB2)ts2).getInitialNumberUsedPages());
                pqd2.maxSpace = Integer.toString(((IndexProxyDB2)ts2).getMaxNumberUsedPages());
                pqd2.initSpaceKB = Integer.toString((int)((IndexProxyDB2)ts2).getInitialNumberUsedKB());
                pqd2.maxSpaceKB = Integer.toString((int)((IndexProxyDB2)ts2).getMaxNumberUsedKB());
                this.spaceList.add(pqd2);
                initSpace += ((IndexProxyDB2)ts2).getInitialNumberUsedPages();
                maxSpace += ((IndexProxyDB2)ts2).getMaxNumberUsedPages();
                initSpaceKB = (int)((long)initSpaceKB + ((IndexProxyDB2)ts2).getInitialNumberUsedKB());
                maxSpaceKB = (int)((long)maxSpaceKB + ((IndexProxyDB2)ts2).getMaxNumberUsedKB());
            }
            for (StorageObject ts2 : this.storageDesign.getAUXTableIndexSet()) {
                if (!sg.containsAUXTableIndex((AUXTableIndexDB2)ts2)) continue;
                pqd2 = new SpaceData();
                pqd2.storageObject = ts2;
                pqd2.name = ((AUXTableIndexDB2)ts2).getAuxTable().getName() + "." + ts2.getName();
                pqd2.type = "AUXTableIndex";
                pqd2.initSpace = Integer.toString(((AUXTableIndexDB2)ts2).getInitialNumberUsedPages());
                pqd2.maxSpace = Integer.toString(((AUXTableIndexDB2)ts2).getMaxNumberUsedPages());
                pqd2.initSpaceKB = Integer.toString((int)((AUXTableIndexDB2)ts2).getInitialNumberUsedKB());
                pqd2.maxSpaceKB = Integer.toString((int)((AUXTableIndexDB2)ts2).getMaxNumberUsedKB());
                this.spaceList.add(pqd2);
                initSpace += ((AUXTableIndexDB2)ts2).getInitialNumberUsedPages();
                maxSpace += ((AUXTableIndexDB2)ts2).getMaxNumberUsedPages();
                initSpaceKB = (int)((long)initSpaceKB + ((AUXTableIndexDB2)ts2).getInitialNumberUsedKB());
                maxSpaceKB = (int)((long)maxSpaceKB + ((AUXTableIndexDB2)ts2).getMaxNumberUsedKB());
            }
            for (StorageObject ts2 : this.storageDesign.getTableSpaceSet()) {
                if (ts2.isNullInstance() || !sg.containsTableSpace((TableSpaceDB2)ts2)) continue;
                pqd2 = new SpaceData();
                pqd2.storageObject = ts2;
                pqd2.name = ((TableSpaceDB2)ts2).getDataBase() != null ? ((TableSpaceDB2)ts2).getDataBase().getName() + "." + ts2.getName() : ts2.getName();
                pqd2.type = "TableSpace";
                pqd2.initSpace = Integer.toString(((TableSpaceDB2)ts2).getInitialNumberUsedPages());
                pqd2.maxSpace = Integer.toString(((TableSpaceDB2)ts2).getMaxNumberUsedPages());
                pqd2.initSpaceKB = Integer.toString(((TableSpaceDB2)ts2).getInitialNumberUsedPages());
                pqd2.maxSpaceKB = Integer.toString(((TableSpaceDB2)ts2).getMaxNumberUsedKB());
                this.spaceList.add(pqd2);
                initSpace += ((TableSpaceDB2)ts2).getInitialNumberUsedPages();
                maxSpace += ((TableSpaceDB2)ts2).getMaxNumberUsedPages();
                initSpaceKB += ((TableSpaceDB2)ts2).getInitialNumberUsedKB();
                maxSpaceKB += ((TableSpaceDB2)ts2).getMaxNumberUsedKB();
            }
            if (initSpace <= 0) continue;
            pqd = new SpaceData();
            pqd.initSpace = Integer.toString(initSpace);
            pqd.maxSpace = Integer.toString(maxSpace);
            pqd.initSpaceKB = Integer.toString(initSpaceKB);
            pqd.maxSpaceKB = Integer.toString(maxSpaceKB);
            pqd.storageObject = sg;
            pqd.name = sg.getName();
            pqd.type = "StorageGroup";
            this.spaceList.add(pqd);
        }
    }

    private class CalculateAction
    implements ActionListener {
        private CalculateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpaceCalculationDB2.this.calculate();
        }
    }

    private class PrintAction
    implements ActionListener {
        private PrintAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            block10: {
                if (SpaceCalculationDB2.this.tpane.getSelectedIndex() > 1) {
                    return;
                }
                DesignPrintModule printer = null;
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    String[] errors;
                    if (printer == null) {
                        printer = new DesignPrintModule();
                    }
                    if ((errors = printer.connect()) != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        JPanel jpan = new JPanel();
                        JTable jtab = SpaceCalculationDB2.this.tpane.getSelectedIndex() == 0 ? SpaceCalculationDB2.this.getQTYTable() : SpaceCalculationDB2.this.getSpaceTable();
                        jtab.setPreferredSize(jtab.getSize());
                        jpan.setLayout(new SpringLayout());
                        jpan.setSize(jtab.getSize());
                        jpan.add(jtab.getTableHeader());
                        jpan.add(jtab);
                        SpaceCalculationDB2.this.tpane.add(jpan);
                        JPanel component = jpan;
                        Dimension size = component.getSize();
                        if (size.height <= 0 || size.width <= 0) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("SpaceCalculationDB2.NoPrintableArea"), MessageFormat.format(Messages.getString("SpaceCalculationDB2.Width"), size.width), MessageFormat.format(Messages.getString("SpaceCalculationDB2.Height"), size.height)}, Messages.getString("SpaceCalculationDB2.Information"), 2);
                            return;
                        }
                        printer.setComponentToPrint(component, size);
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.add(printer.getButtonPanel(), "North");
                        panel.add((Component)new JScrollPane(printer.getViewComponent()), "Center");
                        JDialog dialog = new JDialog(SpaceCalculationDB2.this.appView.getFrame(), Messages.getString("SpaceCalculationDB2.Print"), true);
                        dialog.setContentPane(panel);
                        dialog.pack();
                        dialog.setSize(800, 600);
                        CommonUtil.centerOnScreen(dialog);
                        dialog.setVisible(true);
                        SpaceCalculationDB2.this.tpane.remove(jpan);
                        break block10;
                    }
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors, Messages.getString("SpaceCalculationDB2.PrintError"), 0);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpaceCalculationDB2.this.dispose();
        }
    }

    class PropQTYTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SpaceCalculationDB2.Name"), Messages.getString("SpaceCalculationDB2.Type"), Messages.getString("SpaceCalculationDB2.ProposedPRIQTY"), Messages.getString("SpaceCalculationDB2.ProposedSECQTY"), Messages.getString("SpaceCalculationDB2.InitialPages"), Messages.getString("SpaceCalculationDB2.MaxPages"), Messages.getString("SpaceCalculationDB2.CurrentPRIQTY"), Messages.getString("SpaceCalculationDB2.CurrentSECQTY")};
        String nullString = "Null";

        PropQTYTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return SpaceCalculationDB2.this.propQList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            PropQTYData pqd = (PropQTYData)SpaceCalculationDB2.this.propQList.get(row);
            switch (col) {
                case 0: {
                    return pqd.name;
                }
                case 1: {
                    return pqd.type;
                }
                case 2: {
                    return pqd.priQTY;
                }
                case 3: {
                    return pqd.secQTY;
                }
                case 4: {
                    return pqd.initSpace;
                }
                case 5: {
                    return pqd.maxSpace;
                }
                case 6: {
                    return pqd.currPQTY;
                }
                case 7: {
                    return pqd.currSQTY;
                }
            }
            return this.nullString;
        }
    }

    class SpaceMouseListener
    implements MouseListener {
        List estDataList;

        SpaceMouseListener(List estDataList) {
            this.estDataList = estDataList;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source;
            if (e.getClickCount() == 2 && (source = e.getSource()) instanceof JTable) {
                int selrow = ((JTable)source).getSelectedRow();
                if (((EstData)this.estDataList.get((int)selrow)).storageObject != null) {
                    ((EstData)this.estDataList.get((int)selrow)).storageObject.showPropertyDialog();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class SpaceTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SpaceCalculationDB2.Name"), Messages.getString("SpaceCalculationDB2.Type"), Messages.getString("SpaceCalculationDB2.InitialPages"), Messages.getString("SpaceCalculationDB2.MaxPages"), Messages.getString("SpaceCalculationDB2.InitialSpaceKB"), Messages.getString("SpaceCalculationDB2.MaxSpaceKB")};
        String nullString = "";

        SpaceTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return SpaceCalculationDB2.this.spaceList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            SpaceData pqd = (SpaceData)SpaceCalculationDB2.this.spaceList.get(row);
            switch (col) {
                case 0: {
                    return pqd.name;
                }
                case 1: {
                    return pqd.type;
                }
                case 2: {
                    return pqd.initSpace;
                }
                case 3: {
                    return pqd.maxSpace;
                }
                case 4: {
                    return pqd.initSpaceKB;
                }
                case 5: {
                    return pqd.maxSpaceKB;
                }
            }
            return this.nullString;
        }
    }

    public class SpaceColorRenderer
    extends DefaultTableCellRenderer {
        List estDataList;

        public SpaceColorRenderer(List estDataList) {
            this.estDataList = estDataList;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fc;
            Color bc;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            EstData ed = (EstData)this.estDataList.get(row);
            if (ed.type != null && (ed.type.equalsIgnoreCase("DataBase") || ed.type.equalsIgnoreCase("StorageGroup"))) {
                bc = Color.GRAY;
                fc = Color.WHITE;
            } else {
                bc = Color.WHITE;
                fc = Color.BLACK;
            }
            this.setBackground(bc);
            this.setForeground(fc);
            return this;
        }
    }

    private class UseObSetCheckBoxListener
    implements ActionListener {
        private UseObSetCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpaceCalculationDB2.this.setUseObjectSettings(!SpaceCalculationDB2.this.chbUseObjectSet.isSelected());
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpaceCalculationDB2.this.setPCTFillingUse(SpaceCalculationDB2.this.chbUsePCTFilling.isSelected());
        }
    }

    class BackupData
    extends EstData {
        StorageTemplateDB2 stTemplate;
        String insMode;
        int pctFilling;
        boolean usePctFilling;

        BackupData() {
        }
    }

    class PropQTYData
    extends EstData {
        String priQTY;
        String secQTY;
        String initSpace;
        String maxSpace;
        String currPQTY;
        String currSQTY;

        PropQTYData() {
        }
    }

    class SpaceData
    extends EstData {
        String initSpace;
        String maxSpace;
        String initSpaceKB;
        String maxSpaceKB;

        SpaceData() {
        }
    }

    class EstData {
        StorageObject storageObject;
        String name;
        String type;

        EstData() {
        }
    }
}

