/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;

public class SearchProfile {
    public static final String SP_NAME = "SearchProfile";
    public static final String SP_FILE_EXTENSION = ".sposdm";
    private ApplicationView appView;
    private String fileName;
    private String description;
    private String filePath;
    private boolean active;
    private Map<SearchSet, List<Property>> objects;

    public SearchProfile(ApplicationView appView, String fileName, String filePath, String description, boolean active) {
        this.appView = appView;
        this.fileName = fileName;
        this.filePath = filePath;
        this.description = description;
        this.active = active;
        this.addbjects();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Map<SearchSet, List<Property>> getObjects() {
        if (this.objects == null) {
            this.objects = new LinkedHashMap<SearchSet, List<Property>>();
        }
        return this.objects;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private void addbjects() {
        Property p;
        List allPropertiesList;
        Class clazz;
        SearchSet ss;
        MetaDataManager metaDataManager = this.appView.getXMLTransformationManager().getMetaDataManager();
        Iterator relSetsIt = this.appView.getCurrentDesign().getRelationalDesign().getSearchableSets(true).iterator();
        Iterator logSetsIt = this.appView.getCurrentDesign().getLogicalDesign().getSearchableSets().iterator();
        ArrayList<Property> propertiesList = null;
        while (relSetsIt.hasNext()) {
            ss = (SearchSet)relSetsIt.next();
            propertiesList = new ArrayList<Property>();
            clazz = ss.getClazz();
            allPropertiesList = ReportUtils.getSearchablePropertyDescriptions(clazz, metaDataManager);
            for (ClassDescription.PropertyDescription pd : allPropertiesList) {
                p = new Property(pd, true);
                propertiesList.add(p);
            }
            this.getObjects().put(ss, propertiesList);
        }
        while (logSetsIt.hasNext()) {
            ss = (SearchSet)logSetsIt.next();
            propertiesList = new ArrayList();
            clazz = ss.getClazz();
            allPropertiesList = ReportUtils.getSearchablePropertyDescriptions(clazz, metaDataManager);
            for (ClassDescription.PropertyDescription pd : allPropertiesList) {
                p = new Property(pd, true);
                propertiesList.add(p);
            }
            this.getObjects().put(ss, propertiesList);
        }
    }

    public void setUsedProperties(Map map) {
        block0: for (Map.Entry<SearchSet, List<Property>> pairs : this.getObjects().entrySet()) {
            String clazzName = pairs.getKey().getClazz().getName();
            List<Property> propertiesList = pairs.getValue();
            for (Map.Entry pairs1 : map.entrySet()) {
                String clazzName1 = (String)pairs1.getKey();
                List propertiesList1 = (List)pairs1.getValue();
                if (!clazzName.equals(clazzName1)) continue;
                for (Property property : propertiesList) {
                    property.setUsed(false);
                    String propertyName = property.getPd().name;
                    for (String property1 : propertiesList1) {
                        if (!propertyName.equals(property1)) continue;
                        property.setUsed(true);
                    }
                }
                continue block0;
            }
        }
    }

    public static class Property {
        private ClassDescription.PropertyDescription pd;
        private boolean used;

        Property(ClassDescription.PropertyDescription pd, boolean used) {
            this.pd = pd;
            this.used = used;
        }

        public ClassDescription.PropertyDescription getPd() {
            return this.pd;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void setUsed(boolean used) {
            this.used = used;
        }
    }
}

