/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SelectObjectDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class ApplyPropertiesValuesDialog
extends CustomDialogML {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String EMPTY_STR = "empty string";
    protected JDialog dialog;
    public Window parentWindow;
    protected boolean result = false;
    protected JPanel buttonsPanel;
    public JButton btnApply;
    public JButton btnClose;
    public JButton btnHelp;
    private JTable propertiesTable;
    private TableRowSorter<PropertiesListModel> sorter;
    private List propertiesList = new ArrayList();
    private List allPropertiesList = new ArrayList();
    private JScrollPane propertiesPane;
    private ModelIDObject currentModel;
    private List objects;
    private Iterator setsIt = null;
    GUIConfiguration configuration;
    private JPopupMenu menuStringTypeProperty;
    private JPopupMenu menuBooleanTypeProperty;
    private JMenuItem miEmptyString = new JMenuItem("empty string");
    private JMenuItem miTrue = new JMenuItem("true");
    private JMenuItem miFalse = new JMenuItem("false");
    private MetaDataManager metaDataManager;
    private PropertiesListModel propertiesListModel;
    private JSearchTextField txtFilter;
    private int dialogMinWidth = 500;
    private int dialogMinHeight = 500;
    private static final Logger LOGGER = new Logger(ApplyPropertiesValuesDialog.class);

    public ApplyPropertiesValuesDialog(ApplicationView appView, List objects, List allPropertiesList, ModelIDObject currentModel) {
        super(appView);
        this.objects = objects;
        this.currentModel = currentModel;
        this.allPropertiesList = allPropertiesList;
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        this.configuration = GUIConfiguration.getInstance();
        this.initUI();
        this.filterProperties();
    }

    private void initUI() {
        this.txtFilter = new JSearchTextField(true, true, "Name");
        this.txtFilter.setPreferredSize(new Dimension(120, 20));
        this.txtFilter.getDocument().addDocumentListener(new FilterPropertiesListener());
        this.propertiesListModel = new PropertiesListModel();
        this.propertiesTable = new JTable(this.propertiesListModel);
        this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.getTableHeader().setReorderingAllowed(false);
        this.propertiesTable.setDefaultRenderer(Object.class, new TableRowColorRenderer());
        TableColumn col0 = this.propertiesTable.getColumnModel().getColumn(0);
        col0.setMinWidth(80);
        col0.setPreferredWidth(180);
        TableColumn col1 = this.propertiesTable.getColumnModel().getColumn(1);
        col1.setMinWidth(80);
        col1.setPreferredWidth(135);
        TableColumn col2 = this.propertiesTable.getColumnModel().getColumn(2);
        col2.setMinWidth(80);
        col2.setPreferredWidth(135);
        col2.setCellEditor(new NewValueColumnCellEditor());
        TableColumn col3 = this.propertiesTable.getColumnModel().getColumn(3);
        col3.setCellRenderer(new ButtonColumnCellRenderer());
        col3.setCellEditor(new ButtonColumnCellEditor());
        col3.setMinWidth(20);
        col3.setMaxWidth(20);
        col3.setPreferredWidth(20);
        TableColumn col4 = this.propertiesTable.getColumnModel().getColumn(4);
        col4.setMinWidth(100);
        col4.setMaxWidth(100);
        col4.setPreferredWidth(100);
        TableColumn col5 = this.propertiesTable.getColumnModel().getColumn(5);
        this.propertiesTable.getColumnModel().removeColumn(col5);
        this.menuStringTypeProperty = new JPopupMenu();
        this.menuStringTypeProperty.add(this.miEmptyString);
        this.miEmptyString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow();
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(ApplyPropertiesValuesDialog.EMPTY_STR, row, 2);
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
        });
        this.menuBooleanTypeProperty = new JPopupMenu();
        this.menuBooleanTypeProperty.add(this.miTrue);
        this.menuBooleanTypeProperty.add(this.miFalse);
        this.miTrue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow();
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(ApplyPropertiesValuesDialog.TRUE_STR, row, 2);
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
        });
        this.miFalse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow();
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(ApplyPropertiesValuesDialog.FALSE_STR, row, 2);
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
        });
        JPanel jp = new JPanel((LayoutManager)new MigLayout(new LC().fill()));
        jp.setBorder(BorderFactory.createTitledBorder("Available Properties"));
        this.propertiesPane = new JScrollPane(this.propertiesTable);
        jp.add((Component)this.propertiesPane, new CC().grow());
        this.initButtonsPanel();
        this.add((Component)this.txtFilter, new CC().gapLeft("10").wrap());
        this.add((Component)jp, new CC().grow().wrap());
        this.add((Component)this.buttonsPanel, new CC().spanX().alignX("right"));
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(2));
        this.btnApply = new JButton(Messages.getString("ApplyPropertiesValuesDialog.Apply"));
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.addActionListener(new ApplyAction());
        this.btnApply.setMnemonic(65);
        this.buttonsPanel.add(this.btnApply);
        this.btnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new CloseAction());
        this.btnClose.setMnemonic(67);
        this.buttonsPanel.add(this.btnClose);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonsPanel.add(this.btnHelp);
    }

    private void filterProperties() {
        this.propertiesList.clear();
        Iterator it = this.allPropertiesList.iterator();
        while (it.hasNext()) {
            try {
                PropertyObject po = (PropertyObject)it.next();
                ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                Method m = pd.setter;
                String className = pd.className;
                if (ReportConstants.isPropertyInNonUpdatableList(po.getName()) || !po.isProperty() || m == null) continue;
                PObject pObject = null;
                if (className.indexOf("java.lang.String") > -1 || className.indexOf("java.lang.Integer") > -1 || className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    pObject = new PObject(po, "", "Y", false);
                    this.propertiesList.add(pObject);
                } else {
                    Class<?> aClass = Class.forName(className);
                    if (!(!ModelIDObject.class.isAssignableFrom(aClass) || className.equals(ModelIDObject.class.getName()) || className.equals(DesignObject.class.getName()) || className.equals(RelationalObjectProxy.class.getName()) || className.equals(StorageObject.class.getName()))) {
                        if (this.currentModel instanceof DesignPart) {
                            this.setsIt = ((DesignPart)this.currentModel).getSearchableSets().iterator();
                        } else if (this.currentModel instanceof StorageDesign) {
                            this.setsIt = ((StorageDesign)this.currentModel).getSearchableSets().iterator();
                        }
                        boolean add = false;
                        while (this.setsIt.hasNext()) {
                            SearchSet ss = (SearchSet)this.setsIt.next();
                            Class clazz = ss.getClazz();
                            if (!aClass.isAssignableFrom(clazz)) continue;
                            add = true;
                            break;
                        }
                        if (add) {
                            pObject = new PObject(po, "", "Y", true);
                            this.propertiesList.add(pObject);
                        }
                    }
                }
                if (pObject == null) continue;
                this.getObjectsCommonValue(pObject);
            }
            catch (Exception e) {
                LOGGER.error("Exception in ApplyPropertiesValuesDialog.filterProperties() ", e);
            }
        }
        Class<?> clazz = null;
        Iterator oIt = this.objects.iterator();
        if (oIt.hasNext()) {
            SearchResultObject ro = (SearchResultObject)oIt.next();
            ModelIDObject obj = (ModelIDObject)ro.getObj();
            clazz = obj.getClass();
        }
        try {
            for (UserDefinedProperty p : this.getApplicationView().getCurrentDesign().getUserDefinedProperties()) {
                for (Map.Entry<Class, Boolean> pairs : p.getObjectsVisibilityMap().entrySet()) {
                    Class clz = pairs.getKey();
                    if (clz != clazz) continue;
                    ClassDescription.PropertyDescription pd = new ClassDescription.PropertyDescription();
                    pd.className = p.getType().equals(UserDefinedProperty.DATE) ? "java.util.Date" : (p.getType().equals(UserDefinedProperty.LIST) ? "java.util.List" : "java.lang.String");
                    pd.name = p.getName();
                    pd.defaultValue = "";
                    PropertyObject po = new PropertyObject(pd, "", false, false, true, false);
                    PObject pObject = new PObject(po, "", "Y", false);
                    this.propertiesList.add(pObject);
                    if (pObject == null) continue;
                    this.getObjectsCommonValue(pObject);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in ApplyPropertiesValuesDialog.filterProperties() DUP ", e);
        }
        this.propertiesTable.updateUI();
        if (this.propertiesList.size() > 0) {
            this.sorter = new TableRowSorter<PropertiesListModel>(this.propertiesListModel);
            this.sorter.setSortsOnUpdates(true);
            this.propertiesTable.setRowSorter(this.sorter);
            this.propertiesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.propertiesTable, 0);
        }
    }

    private void getObjectsCommonValue(PObject pObject) {
        PropertyObject po = pObject.getPropertyObject();
        ClassDescription.PropertyDescription pd = po.getPropertyDescription();
        Method m = pd.getter;
        String className = pd.className;
        UserDefinedProperty udp = this.getApplicationView().getCurrentDesign().getUserDefinedPropertyByName(pd.name);
        String previousValue = "";
        String currentvalue = "";
        boolean hasMatch = false;
        int counter = 0;
        for (SearchResultObject ro : this.objects) {
            block21: {
                try {
                    ModelIDObject obj = (ModelIDObject)ro.getObj();
                    if (udp != null) {
                        currentvalue = obj.getProperty(udp.getName());
                    } else {
                        Object object = m.invoke((Object)obj, new Object[0]);
                        if (className.indexOf("java.lang.String") > -1) {
                            if (object != null) {
                                currentvalue = (String)object;
                            }
                        } else if (className.indexOf("java.lang.Integer") > -1) {
                            if (object != null) {
                                currentvalue = ((Integer)object).toString();
                            }
                        } else if (className.indexOf("java.lang.Boolean") > -1) {
                            if (object != null) {
                                currentvalue = ((Boolean)object).toString();
                            }
                        } else if (className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                            if (object != null) {
                                currentvalue = object.toString();
                            }
                        } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                            currentvalue = ((ModelObject)object).getName();
                        }
                    }
                    if (counter == 0) {
                        previousValue = currentvalue;
                    }
                    if (!currentvalue.equals("") && currentvalue.equals(previousValue)) {
                        previousValue = currentvalue;
                        hasMatch = true;
                        break block21;
                    }
                    hasMatch = false;
                    break;
                }
                catch (Exception e1) {
                    LOGGER.error("Exception in ApplyPropertiesValuesDialog.getObjectsCommonValue() ", e1);
                }
            }
            ++counter;
        }
        if (hasMatch) {
            pObject.setOldValue(previousValue);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ApplyPropertiesValuesDialog.SetCommonProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "MODIFY_PROPERTIES_VALUES_DIALOG";
    }

    public boolean showDialog() {
        this.parentWindow = this.getDialog();
        this.getDialog().setVisible(true);
        return this.result;
    }

    private List loadObjects(String className) {
        try {
            ArrayList availableObjectsList = new ArrayList();
            Class<?> obj = Class.forName(className);
            if (this.currentModel instanceof DesignPart) {
                this.setsIt = ((DesignPart)this.currentModel).getSearchableSets().iterator();
            } else if (this.currentModel instanceof StorageDesign) {
                this.setsIt = ((StorageDesign)this.currentModel).getSearchableSets().iterator();
            }
            ArrayList collection = new ArrayList();
            while (this.setsIt.hasNext()) {
                SearchSet ss = (SearchSet)this.setsIt.next();
                Class clazz = ss.getClazz();
                if (!obj.isAssignableFrom(clazz)) continue;
                ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
                break;
            }
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                availableObjectsList.add(it.next());
            }
            return availableObjectsList;
        }
        catch (Exception e) {
            LOGGER.error("Exception in ApplyPropertiesValuesDialog.loadObjects() ", e);
            return null;
        }
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.getSize() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (((ModelIDObject)list.get(i)).getName().compareTo(((ModelIDObject)list.get(i - 1)).getName()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void newFilter() {
        RowFilter rf = null;
        if (this.propertiesTable != null) {
            if (!"".equals(this.txtFilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.txtFilter.getText(), this.propertiesTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.propertiesTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.propertiesTable.getRowSorter()).setRowFilter(null);
                this.propertiesTable.clearSelection();
            }
        }
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class FilterPropertiesListener
    implements DocumentListener {
        private FilterPropertiesListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ApplyPropertiesValuesDialog.this.newFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ApplyPropertiesValuesDialog.this.newFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ApplyPropertiesValuesDialog.this.newFilter();
        }
    }

    private class PropertiesListModel
    extends DefaultTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ApplyPropertiesValuesDialog.PropertyName"), Messages.getString("ApplyPropertiesValuesDialog.OldPropertyValue"), Messages.getString("ApplyPropertiesValuesDialog.NewPropertyValue"), "", Messages.getString("ApplyPropertiesValuesDialog.PropertyType"), "hidden column"};

        private PropertiesListModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(rowIndex);
            String type = (String)this.getValueAt(rowIndex, 4);
            if (columnIndex == 2) {
                return !t.isObjectType() && !type.equals("List");
            }
            if (columnIndex == 3) {
                return t.isObjectType() || type.equals("String") || type.equals("boolean") || type.equals("Boolean") || type.equals("List") || type.equals("Date");
            }
            if (columnIndex == 5) {
                return false;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return ApplyPropertiesValuesDialog.this.propertiesList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(row);
            PropertyObject po = t.getPropertyObject();
            String defaultValue = po.getPropertyDescription().defaultValue;
            String type = (String)this.getValueAt(row, 4);
            if (col == 2 && !value.equals("")) {
                if (type.equals("String")) {
                    if (defaultValue.equals("")) {
                        t.setNewValue(value);
                    } else {
                        t.setNewValue(value);
                    }
                } else if (type.equals("Number")) {
                    try {
                        Float f = new Float((String)value);
                        double i = f.doubleValue();
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("Integer")) {
                    try {
                        Integer.valueOf((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equalsIgnoreCase("boolean")) {
                    String v = ((String)value).toLowerCase();
                    if (!v.trim().equals("")) {
                        if (v.equals(ApplyPropertiesValuesDialog.TRUE_STR) || v.equals(ApplyPropertiesValuesDialog.FALSE_STR)) {
                            t.setNewValue(v);
                        } else {
                            JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueNotBoolean"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                        }
                    }
                } else if (type.equals("float")) {
                    try {
                        Float.parseFloat((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("short")) {
                    try {
                        Short.parseShort((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("long")) {
                    try {
                        Long.parseLong((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("double")) {
                    try {
                        Float f = new Float((String)value);
                        double i = f.doubleValue();
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("int")) {
                    try {
                        Integer.parseInt((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else {
                    t.setNewValue(value);
                }
            } else if (col == 5) {
                t.setExtraValue((String)value);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(rowIndex);
            PropertyObject po = t.getPropertyObject();
            ClassDescription.PropertyDescription pd = po.getPropertyDescription();
            String className = pd.className;
            UserDefinedProperty udp = ApplyPropertiesValuesDialog.this.getApplicationView().getCurrentDesign().getUserDefinedPropertyByName(pd.name);
            if (udp != null) {
                String s = udp.getType();
                className = s.replace(UserDefinedProperty.TEXT, "String");
            }
            if (columnIndex == 0) {
                return ReportUtils.getDisplayName(po.getPropertyDescription().name);
            }
            if (columnIndex == 1) {
                return t.getOldValue();
            }
            if (columnIndex == 2) {
                return t.getNewValue();
            }
            if (columnIndex == 4) {
                if (className.lastIndexOf(".") > -1) {
                    return className.substring(className.lastIndexOf(".") + 1, className.length());
                }
                return className;
            }
            if (columnIndex == 5) {
                return t.getExtraValue();
            }
            return "";
        }
    }

    public class TableRowColorRenderer
    extends DefaultTableCellRenderer {
        public TableRowColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(table.convertRowIndexToModel(row));
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tText = "";
            PropertyObject po = t.getPropertyObject();
            ClassDescription.PropertyDescription pd = po.getPropertyDescription();
            UserDefinedProperty udp = ApplyPropertiesValuesDialog.this.getApplicationView().getCurrentDesign().getUserDefinedPropertyByName(pd.name);
            if (udp != null) {
                if (isSelected) {
                    this.setForeground(Color.white);
                    this.setBackground(table.getSelectionBackground());
                } else {
                    if (column == 0) {
                        this.setForeground(Color.decode("0xc4a02c"));
                    } else {
                        this.setForeground(table.getForeground());
                    }
                    this.setBackground(table.getBackground());
                }
                if (column == 0) {
                    tText = Messages.getString("ApplyPropertiesValuesDialog.UserDefinedProperty");
                }
            } else if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (!tText.equals("")) {
                this.setToolTipText(tText);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    class NewValueColumnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TableCellEditor editor;

        NewValueColumnCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editor != null) {
                return this.editor.getCellEditorValue();
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(table.convertRowIndexToModel(row));
            PropertyObject po = t.getPropertyObject();
            ClassDescription.PropertyDescription pd = po.getPropertyDescription();
            UserDefinedProperty udp = ApplyPropertiesValuesDialog.this.getApplicationView().getCurrentDesign().getUserDefinedPropertyByName(pd.name);
            String type = (String)ApplyPropertiesValuesDialog.this.propertiesTable.getModel().getValueAt(table.convertRowIndexToModel(row), 4);
            if (type.equals("String") || type.equals("Boolean") || type.equals("boolean") || type.equals("Integer") || type.equals("float") || type.equals("short") || type.equals("long") || type.equals("double") || type.equals("int")) {
                this.editor = new DefaultCellEditor(new JTextField());
            } else if (type.equals("Date")) {
                this.editor = new DateButtonEditor(table, row, column);
            }
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class ButtonColumnCellRenderer
    implements TableCellRenderer {
        ButtonColumnCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String type = (String)table.getValueAt(row, 4);
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(table.convertRowIndexToModel(row));
            if (t.isObjectType()) {
                JButton button = new JButton();
                button.setText("...");
                button.setIcon(null);
                button.setEnabled(true);
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
                return button;
            }
            if (type.equals("String")) {
                JButton button = new JButton();
                button.setIcon(GUIConfiguration.getInstance().getIcon("NEW_ASSOCIATION_B2A", 16));
                button.setText("");
                button.setEnabled(true);
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
                return button;
            }
            if (type.equals("Boolean") || type.equals("boolean")) {
                JButton button = new JButton();
                button.setIcon(GUIConfiguration.getInstance().getIcon("NEW_ASSOCIATION_B2A", 16));
                button.setText("");
                button.setEnabled(true);
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
                return button;
            }
            if (type.equals("Date")) {
                JButton button = new JButton();
                button.setIcon(GUIConfiguration.getInstance().getIcon("NEW_ASSOCIATION_B2A", 16));
                button.setText("");
                button.setEnabled(true);
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
                return button;
            }
            if (type.equals("List")) {
                JButton button = new JButton();
                button.setText("...");
                button.setIcon(null);
                button.setEnabled(true);
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
                return button;
            }
            JButton button = new JButton();
            button.setText("");
            button.setIcon(null);
            button.setEnabled(false);
            button.setForeground(Color.WHITE);
            button.setBackground(Color.WHITE);
            return button;
        }
    }

    class ButtonColumnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        int row;
        int column;
        private JButton button;

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JViewport viewport = (JViewport)table.getParent();
            Rectangle rect = table.getCellRect(row, column, true);
            Point pt = viewport.getViewPosition();
            table.setRowSelectionInterval(row, row);
            Rectangle currentCell = table.getCellRect(row, column, false);
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(table.convertRowIndexToModel(row));
            PropertyObject po = t.getPropertyObject();
            ClassDescription.PropertyDescription pd = po.getPropertyDescription();
            UserDefinedProperty udp = ApplyPropertiesValuesDialog.this.getApplicationView().getCurrentDesign().getUserDefinedPropertyByName(pd.name);
            String type = (String)ApplyPropertiesValuesDialog.this.propertiesTable.getModel().getValueAt(table.convertRowIndexToModel(row), 4);
            if (!(type.equals("Integer") || type.equals("float") || type.equals("short") || type.equals("long") || type.equals("double") || type.equals("int"))) {
                if (type.equals("String")) {
                    ApplyPropertiesValuesDialog.this.menuStringTypeProperty.show(ApplyPropertiesValuesDialog.this, rect.x - pt.x, rect.y - pt.y);
                } else if (type.equals("Boolean") || type.equals("boolean")) {
                    ApplyPropertiesValuesDialog.this.menuBooleanTypeProperty.show(ApplyPropertiesValuesDialog.this, rect.x - pt.x, rect.y - pt.y);
                } else if (!type.equals("Date")) {
                    SelectObjectDialog d = null;
                    Object seelctedPbject = ApplyPropertiesValuesDialog.this.propertiesTable.getValueAt(ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow(), 2);
                    if (udp != null) {
                        ArrayList<String> lovList = new ArrayList<String>();
                        for (Map.Entry<String, Boolean> pairs : udp.getLovMap().entrySet()) {
                            String val = pairs.getKey();
                            lovList.add(val);
                        }
                        d = new SelectObjectDialog(ApplyPropertiesValuesDialog.this.getApplicationView(), lovList, seelctedPbject);
                        d.showDialog();
                    } else {
                        d = new SelectObjectDialog(ApplyPropertiesValuesDialog.this.getApplicationView(), ApplyPropertiesValuesDialog.this.loadObjects(pd.className), seelctedPbject);
                        d.showDialog();
                    }
                    Object selectedObject = d.getSelectedObject();
                    if (selectedObject != null) {
                        if (selectedObject == " ") {
                            ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(null, ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow(), 2);
                        } else {
                            ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(selectedObject, ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow(), 2);
                        }
                    }
                    ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
                }
            }
            return this.button;
        }
    }

    protected class ApplyAction
    implements ActionListener {
        protected ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                for (PObject t : ApplyPropertiesValuesDialog.this.propertiesList) {
                    PropertyObject po = t.getPropertyObject();
                    ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                    String className = pd.className;
                    Method m = pd.setter;
                    Object value = t.getNewValue();
                    UserDefinedProperty udp = ApplyPropertiesValuesDialog.this.getApplicationView().getCurrentDesign().getUserDefinedPropertyByName(pd.name);
                    boolean go = false;
                    if (!t.isObjectType()) {
                        if (t.getExtraValue().equals("Y")) {
                            if (className.equals("java.lang.String")) {
                                if (!((String)value).trim().equals("") || value.equals(ApplyPropertiesValuesDialog.EMPTY_STR)) {
                                    go = true;
                                }
                            } else {
                                go = !((String)value).trim().equals("");
                            }
                        } else if (t.getExtraValue().equals("N")) {
                            go = true;
                        }
                    } else if (value != null) {
                        if ("".equals(value)) {
                            go = false;
                        } else if (" ".equals(value)) {
                            value = null;
                            go = true;
                        } else if (!"".equals(value)) {
                            go = true;
                        }
                    }
                    if (!go) continue;
                    for (SearchResultObject ro : ApplyPropertiesValuesDialog.this.objects) {
                        try {
                            ModelIDObject obj = (ModelIDObject)ro.getObj();
                            if (udp != null) {
                                obj.setProperty(udp.getName(), (String)value);
                            } else if (className.equals("java.lang.String")) {
                                if (value.equals(ApplyPropertiesValuesDialog.EMPTY_STR)) {
                                    m.invoke((Object)obj, "");
                                } else {
                                    m.invoke((Object)obj, value);
                                }
                            } else if (value != null && (value.equals(ApplyPropertiesValuesDialog.TRUE_STR) || value.equals(ApplyPropertiesValuesDialog.FALSE_STR))) {
                                m.invoke((Object)obj, Boolean.parseBoolean((String)value));
                            } else {
                                m.invoke((Object)obj, value);
                                MDTransformer.setRelatedProperty(obj, pd);
                            }
                            obj.setDirty(true);
                        }
                        catch (Exception e1) {
                            LOGGER.error("Exception in ModifyPropertiesValuesDialog.ApplyAction() ", e1);
                        }
                    }
                    if (className.equals("java.lang.String")) {
                        if (value.equals(ApplyPropertiesValuesDialog.EMPTY_STR)) {
                            t.setOldValue("");
                        } else {
                            t.setOldValue(value);
                        }
                    } else {
                        t.setOldValue(value);
                    }
                    t.setNewValue("");
                    ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
                }
                JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.Completed"), Messages.getString("ApplyPropertiesValuesDialog.Information"), 1);
            }
            catch (Exception ex) {
                LOGGER.error("Exception in ApplyPropertiesValuesDialog.ApplyAction() ", ex);
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplyPropertiesValuesDialog.this.close();
        }
    }

    class PObject {
        private PropertyObject propertyObject;
        private Object oldValue = "";
        private Object newValue = "";
        private String extraValue = "";
        private boolean objectType;

        public PObject(PropertyObject po, Object newValue, String extraValue, boolean objectType) {
            this.propertyObject = po;
            this.extraValue = extraValue;
            this.objectType = objectType;
        }

        public PropertyObject getPropertyObject() {
            return this.propertyObject;
        }

        public void setPropertyObject(PropertyObject propertyObject) {
            this.propertyObject = propertyObject;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }

        public String getExtraValue() {
            return this.extraValue;
        }

        public void setExtraValue(String extraValue) {
            this.extraValue = extraValue;
        }

        public boolean isObjectType() {
            return this.objectType;
        }
    }

    class DateButtonEditor
    extends DefaultCellEditor {
        final DateFormat dateFormat;
        private JPanel jp;
        private Date[] dat;
        private CalendarPopupButton calendarButton;
        private JButton clearValueButton;
        private Date dDate;
        private Date dDefault;
        private CalendarPanel cpDate;

        public DateButtonEditor(final JTable table, final int row, final int col) {
            super(new JTextField());
            this.dateFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
            this.dat = null;
            this.dDefault = new Date();
            this.jp = new JPanel(new BorderLayout());
            this.calendarButton = new CalendarPopupButton();
            this.calendarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DateButtonEditor.this.dDate != null) {
                        DateButtonEditor.this.cpDate.setSelectedDate(DateButtonEditor.this.dDate);
                        DateButtonEditor.this.cpDate.makeDateVisible(DateButtonEditor.this.dDate);
                    } else {
                        DateButtonEditor.this.cpDate.setSelectedDate(DateButtonEditor.this.dDefault);
                        DateButtonEditor.this.cpDate.makeDateVisible(DateButtonEditor.this.dDefault);
                    }
                }
            });
            this.cpDate = this.calendarButton.getCalendarPanel();
            this.cpDate.setSelectedDate(new Date());
            this.cpDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                        DateButtonEditor.this.dat = DateButtonEditor.this.cpDate.getSelectedDates();
                        if (DateButtonEditor.this.dat.length > 0) {
                            DateButtonEditor.this.dDate = DateButtonEditor.this.dat[0];
                            DateButtonEditor.this.calendarButton.setText(DateButtonEditor.this.dateFormat.format(DateButtonEditor.this.dat[0]));
                        } else {
                            DateButtonEditor.this.dDate = null;
                            DateButtonEditor.this.calendarButton.setText("");
                        }
                    }
                }
            });
            this.clearValueButton = new JButton(ApplyPropertiesValuesDialog.this.configuration.getIcon("REMOVE_ICON", 16));
            this.clearValueButton.setPreferredSize(new Dimension(18, 18));
            this.clearValueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int icol = table.getEditingColumn();
                    int irow = table.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        table.getCellEditor(irow, icol).stopCellEditing();
                    }
                    DateButtonEditor.this.dDate = null;
                    DateButtonEditor.this.calendarButton.setText("");
                    table.getModel().setValueAt("", row, col);
                }
            });
            this.jp.add((Component)this.calendarButton, "Center");
            this.jp.add((Component)this.clearValueButton, "East");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.calendarButton.setForeground(table.getSelectionForeground());
                this.calendarButton.setBackground(table.getSelectionBackground());
            } else {
                this.calendarButton.setForeground(table.getForeground());
                this.calendarButton.setBackground(table.getBackground());
            }
            return this.jp;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.dat != null) {
                return this.dateFormat.format(this.dat[0]);
            }
            return "";
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}

