/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.util.Collection;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.FKConnection;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKContainer;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;

public class TVView
extends TVFKContainer {
    public TVView(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public void setModel(DesignObject object) {
        super.setModel(object);
    }

    public TableView getTableViewModel() {
        return (TableView)this.getModel();
    }

    @Override
    public boolean acceptsDrop(SelectableObject selectable) {
        return false;
    }

    @Override
    public void drop(SelectableObject selectable) {
        Object[] array = selectable.getSelectedContainedObject();
        if (this.acceptsDrop(selectable)) {
            for (int i = 0; i < array.length; ++i) {
                this.getTableViewModel().add((FKElement)array[i]);
            }
        }
    }

    @Override
    public boolean shouldShowLongNameContained() {
        return true;
    }

    public boolean needsLayout() {
        return true;
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getDesign().getRelationalDesign().getMainView();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public void addTVFKRelations() {
        TableView view = (TableView)this.getModel();
        DesignPartView dpv = this.getDesignPartView();
        FKIndexAssociation[] fkass = view.getFKAssociations();
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTV(dpv) == null) {
                fkass[i].setTargetTVTable(this);
            }
            fkass[i].getSourceTV(dpv);
            TopView tv = fkass[i].getFirstViewForDPV(dpv);
            if (tv == null || tv.getCellView() != null) continue;
            dpv.add(tv);
        }
        Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(view);
        for (FKIndexAssociation fk : col) {
            if (fk.getSourceTV(dpv) == null) {
                fk.setSourceTVTable(this);
            }
            fk.getTargetTV(dpv);
            TopView tv = fk.getFirstViewForDPV(dpv);
            if (tv != null && tv.getCellView() == null) {
                dpv.add(tv);
            }
            if (fk.getContainerWithKeyObject() != fk.getRemoteTable()) continue;
            ((TVFKRelation)fk.getViewFor(dpv)).repairSelfReference(this);
        }
    }

    public void addTVFKRelations(DesignPartView dpv) {
        TableView view = (TableView)this.getModel();
        FKIndexAssociation[] fkass = view.getFKAssociations();
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTV(dpv) != null) continue;
            fkass[i].setTargetTVTable(this);
        }
        Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(view);
        for (FKIndexAssociation fk : col) {
            if (fk.getSourceTV(dpv) == null) {
                fk.setSourceTVTable(this);
            }
            if (fk.getContainerWithKeyObject() != fk.getRemoteTable()) continue;
            ((TVFKRelation)fk.getViewFor(dpv)).repairSelfReference(this);
        }
    }

    public void addImpliedTVFKRelations() {
        TableView view = (TableView)this.getModel();
        DPVRelational dpv = (DPVRelational)this.getDesignPartView();
        FKConnection[] fkass = view.getImpliedForeignKeyList().toArray(new FKConnection[0]);
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTopView(dpv) == null) {
                fkass[i].setTargetTopView(this);
            }
            fkass[i].getSourceTopView(dpv);
            TopView tv = fkass[i].getViewFor(dpv);
            if (tv == null || tv.getCellView() != null) continue;
            dpv.add(tv);
        }
        for (ImpliedForeignKey ifk : ((RelationalDesign)dpv.getDesignPart()).getImpliedFKsTo((FKContainer)view, dpv)) {
            if (ifk.getSourceTV(dpv) == null) {
                ifk.setSourceTVTable(this);
            }
            ifk.getTargetTV(dpv);
            TopView tv = ifk.getFirstViewForDPV(dpv);
            if (tv == null || tv.getCellView() != null) continue;
            dpv.add(tv);
        }
    }

    public void reassignFKs() {
        TVView newtvt = (TVView)((ContainerWithKeyObject)this.getModel()).getAnotherView(this);
        if (newtvt != null) {
            TableView view = (TableView)this.getModel();
            Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(view);
            for (FKIndexAssociation fk : col) {
                if (!fk.matchSourceTV(this.getDesignPartView(), this)) continue;
                fk.setSourceTVTable(newtvt);
            }
            FKIndexAssociation[] fkar = view.getFKAssociations();
            for (int i = 0; i < fkar.length; ++i) {
                if (!fkar[i].matchTargetTV(this.getDesignPartView(), this)) continue;
                fkar[i].setTargetTVTable(newtvt);
            }
        } else {
            this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
        }
    }

    @Override
    protected void doPrivateActions() {
        this.reassignFKs();
    }

    @Override
    protected ContainerView createViewSynonim(ApplicationView appv, DesignPartView dpv) {
        return new TVView(appv, dpv);
    }

    @Override
    protected void hideRelations() {
    }

    @Override
    public String toString() {
        int i = this.getViewNumber();
        Object s = i == 0 ? "" : ":" + i;
        return this.getModel().getName() + (String)s;
    }
}

