/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.multidimensional.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public abstract class AbstractMDTV
extends ContainerView {
    protected Set listeners = new HashSet();
    protected static Logger LOGGER = new Logger(AbstractMDTV.class);

    public AbstractMDTV(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public void addTopViewListener(TopViewListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTopViewListener(TopViewListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setModel(DesignObject object) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = object;
        object.setTopView(this);
        this.model.addObjectListener(this);
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    @Override
    public String toString() {
        int i = this.getModel().getViewNumber(this);
        Object s = i == 0 ? "" : ":" + i;
        return this.getModel().getName() + (String)s;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        TopViewListener[] listenersCopy = this.listeners.toArray(new TopViewListener[0]);
        for (int i = 0; i < listenersCopy.length; ++i) {
            try {
                listenersCopy[i].changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Listener caused exception: ", e);
            }
        }
    }

    @Override
    public void remove(boolean removeModel) {
        if (removeModel) {
            int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AbstractMDTV.AreYouSureYouWantToDelete"), this.getModel().getName()), Messages.getString("AbstractMDTV.ConfirObjectDelete"), 0);
            if (res == 0) {
                this.getModel().remove();
                this.getDesignPartView().getWorkSpace().repaint();
            }
        } else {
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
            if (this.getCellView() != null) {
                Object[] cells = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(cells);
                this.getDesignPartView().getWorkSpace().repaint();
            }
        }
    }

    public void addTVLinks() {
        AbstractMDObject mdObject = (AbstractMDObject)this.getModel();
        DesignPartView dpv = this.getDesignPartView();
        Collection col = this.getDesign().getMultidimensionalDesign().getLinkSet().getLinksToSource(mdObject);
        for (Link link : col) {
            if (link.getSourceTV(dpv) != null) continue;
            link.setSourceTV(this);
        }
        col = this.getDesign().getMultidimensionalDesign().getLinkSet().getLinksToTarget(mdObject);
        for (Link link : col) {
            if (link.getTargetTV(dpv) != null) continue;
            link.setTargetTV(this);
        }
    }
}

