/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineeringcompare;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;

public class CompareCheckEditor
extends CompareTreeRenderer
implements TreeCellEditor,
ActionListener {
    private Set listeners = new HashSet();
    protected CellEditorListener list;

    public CompareCheckEditor(boolean showCheckbox) {
        super(showCheckbox);
        this.cbox.addActionListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component comp = this.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        return comp;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.node;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event == null) {
            return true;
        }
        Object obj = event.getSource();
        if (obj instanceof JTree && event instanceof MouseEvent) {
            TreePath path;
            Rectangle r;
            JTree tree = (JTree)obj;
            MouseEvent e = (MouseEvent)event;
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                this.node = (ModelIdObjectSelection)selPath.getLastPathComponent();
            }
            if ((r = tree.getPathBounds(path = tree.getPathForLocation(e.getX(), e.getY()))) == null) {
                return false;
            }
            Dimension d = this.cbox.getPreferredSize();
            r.setSize(new Dimension(d.width, r.height));
            if (r.contains(e.getX(), e.getY())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEditingStopped() {
        CellEditorListener[] ls = this.listeners.toArray(new CellEditorListener[0]);
        for (int i = 0; i < ls.length; ++i) {
            try {
                ls[i].editingStopped(new ChangeEvent(this));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] ls = this.listeners.toArray(new CellEditorListener[0]);
        for (int i = 0; i < ls.length; ++i) {
            try {
                ls[i].editingCanceled(new ChangeEvent(this));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.node.setSelected(this.cbox.isSelected());
    }
}

