/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolderRecursive;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.engineering.Messages;

public class StaticRelationalDesign
extends DesignObject {
    RelationalDesign design;
    DesignObjectCollection tables;
    DesignObjectCollection fkeys;
    DesignObjectCollection candkeys;

    public StaticRelationalDesign(RelationalDesign design) {
        super(design);
        this.setDesign(design.getDesign());
        this.setName(Messages.getString("StaticRelationalDesign.RelationalModel"));
        this.design = design;
        this.loadtables();
        this.loadfkeys();
        this.loadCandkeys();
    }

    private void loadElements(DesignObjectCollection col, Iterator it) {
        while (it.hasNext()) {
            DesignObject object = (DesignObject)it.next();
            col.add(new DesignObjectPlaceHolder((DesignPart)this.design, object));
        }
    }

    private void loadContainerElements(DesignObjectCollection col, Iterator it) {
        while (it.hasNext()) {
            DesignObject object = (DesignObject)it.next();
            col.add(new ContainerObjectPlaceHolderRecursive(this.design, object, true));
        }
    }

    private void loadtables() {
        this.tables = new DesignObjectCollection();
        this.tables.setName(Messages.getString("StaticRelationalDesign.Tables"));
        this.tables.setParent(this);
        this.tables.setElementDescriptor(Entity.class);
        this.loadContainerElements(this.tables, this.design.getTableSet().iterator());
    }

    private void loadfkeys() {
        this.fkeys = new DesignObjectCollection();
        this.fkeys.setName(Messages.getString("StaticRelationalDesign.ForeignKeys"));
        this.fkeys.setParent(this);
        this.fkeys.setElementDescriptor(Relation.class);
        this.loadElements(this.fkeys, this.design.getFKIndexAssociationSet().iterator());
    }

    private void loadCandkeys() {
        this.candkeys = new DesignObjectCollection();
        this.candkeys.setName(Messages.getString("StaticRelationalDesign.CandidateKeys"));
        this.candkeys.setParent(this);
        this.candkeys.setElementDescriptor(CandidateKey.class);
        this.loadElements(this.candkeys, this.design.getGlobalIndexSet().iterator());
    }

    @Override
    public void setShouldEngineer(boolean value, boolean setDirty) {
        super.setShouldEngineer(value, setDirty);
        this.propagateShouldEngineer(value, setDirty);
    }

    public void propagateShouldEngineer(boolean selected) {
        this.propagateShouldEngineer(selected, true);
    }

    public void propagateShouldEngineer(boolean selected, boolean setDirty) {
        int k = this.getNumberOfChildren();
        for (int i = 0; i < k; ++i) {
            ModelObject object = this.getChild(i);
            if (object instanceof DesignObject) {
                DesignObject dp = (DesignObject)object;
                dp.setShouldEngineer(selected, setDirty);
                continue;
            }
            if (!(object instanceof DesignObjectCollection)) continue;
            DesignObjectCollection col = (DesignObjectCollection)object;
            for (Object obj : col) {
                if (!(obj instanceof DesignObject)) continue;
                DesignObject dp = (DesignObject)obj;
                dp.setShouldEngineer(selected, setDirty);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.tables;
            }
            case 1: {
                return this.candkeys;
            }
            case 2: {
                return this.fkeys;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.tables) {
            return 0;
        }
        if (child == this.candkeys) {
            return 1;
        }
        if (child == this.fkeys) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public void showPropertyDialog() {
    }
}

