/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;

public class TableSpacePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private TableSpaceUDBv81 tableSpace;
    private JComboBox cbDBDefinition;
    private JComboBox cbType;
    private JComboBox cbManagedBy;
    private JComboBox cbAutoResize;
    private JTextField ifInitialSize;
    private JTextField ifIncreaseSize;
    private JTextField ifMaxSize;
    private JComboBox cbDBPartitionGroup;
    private JComboBox cbPageSize;
    private JTextField ifExtentSize;
    private JTextField ifPrefetchSize;
    private JComboBox cbBufferPool;
    private JDecimalField dfOverhead;
    private JDecimalField dfTransferRate;
    private JComboBox cbDroppedTblRecovery;
    private JComboBox cbFileSystemCaching;
    protected JPanel tables;
    protected DefaultListModel tablesListModel;
    protected JList tablesList;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected DefaultListModel allGroupsModel;
    protected DefaultListModel selectedGroupsModel;
    private JList allGroupsList;
    private JList selectedGroupsList;
    private JButton bnAddGroup;
    private JButton bnRemoveGroup;
    protected JComboBox cbGrantOption;

    public TableSpacePropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.tableSpace = (TableSpaceUDBv81)object;
        this.setHeight(600);
        this.initCommentsView(190);
        this.initCommentsInRDBMS(190);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableSpacePropertyDialogUDBv81.TableSpaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDBDefinition();
        this.initType();
        this.initManagedBy();
        this.initAutoResize();
        this.initInitialSize();
        this.initIncreaseSize();
        this.initMaxSize();
        this.initDBPartitionGroup();
        this.initPageSize();
        this.initExtentSize();
        this.initPrefetchSize();
        this.initBufferPool();
        this.initOverhead();
        this.initTransferRate();
        this.initDroppedTblRecovery();
        this.initFileSystemCaching();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initDBDefinition() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.DBDefinitionOnly"));
        this.general.add(label);
        this.cbDBDefinition = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDBDefinition);
        this.cbDBDefinition.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDBDefinition);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDBDefinition, 50);
    }

    private void initType() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.DataType"));
        this.general.add(label);
        this.cbType = new JComboBox<String>(TableSpaceUDBv81.getAvailableDataTypes());
        this.cbType.addActionListener(new TypeListener());
        this.setBG(this.cbType);
        this.cbType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbType, 80);
    }

    private void initManagedBy() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.ManagedBy"));
        this.general.add(label);
        this.cbManagedBy = new JComboBox<Object>(TableSpaceUDBv81.getAvailableManagedByTypes());
        this.setBG(this.cbManagedBy);
        this.cbManagedBy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbManagedBy);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbManagedBy, 110);
    }

    private void initAutoResize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.AutoResize"));
        this.general.add(label);
        this.cbAutoResize = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAutoResize);
        this.cbAutoResize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoResize);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbAutoResize, 140);
    }

    private void initInitialSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.InitialSize"));
        this.general.add(label);
        this.ifInitialSize = new JTextField("", 26);
        this.general.add(this.ifInitialSize);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifInitialSize, 170);
    }

    private void initIncreaseSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.IncreaseSize"));
        this.general.add(label);
        this.ifIncreaseSize = new JTextField("", 26);
        this.general.add(this.ifIncreaseSize);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifIncreaseSize, 200);
    }

    private void initMaxSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.MaxSize"));
        this.general.add(label);
        this.ifMaxSize = new JTextField("", 26);
        this.general.add(this.ifMaxSize);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifMaxSize, 230);
    }

    private void initDBPartitionGroup() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.DBPartitionGroup"));
        this.general.add(label);
        this.cbDBPartitionGroup = new JComboBox();
        this.setBG(this.cbDBPartitionGroup);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getNodeGroupSet().toArray(), this.cbDBPartitionGroup);
        }
        this.cbDBPartitionGroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDBPartitionGroup);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbDBPartitionGroup, 260);
    }

    private void initPageSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.PageSize"));
        this.general.add(label);
        this.cbPageSize = new JComboBox<Object>(TableSpaceUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbPageSize, 290);
    }

    private void initExtentSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.ExtentSize"));
        this.general.add(label);
        this.ifExtentSize = new JTextField("", 26);
        this.general.add(this.ifExtentSize);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.ifExtentSize, 320);
    }

    private void initPrefetchSize() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.PrefetchSize"));
        this.general.add(label);
        this.ifPrefetchSize = new JTextField("", 26);
        this.general.add(this.ifPrefetchSize);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.ifPrefetchSize, 350);
    }

    private void initBufferPool() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.BufferPool"));
        this.general.add(label);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbBufferPool, 380);
    }

    private void initOverhead() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.Overhead"));
        this.general.add(label);
        this.dfOverhead = new JDecimalField(0.0, 26);
        this.general.add(this.dfOverhead);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.dfOverhead, 410);
    }

    private void initTransferRate() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.TransferRate"));
        this.general.add(label);
        this.dfTransferRate = new JDecimalField(0.0, 26);
        this.general.add(this.dfTransferRate);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.dfTransferRate, 440);
    }

    private void initDroppedTblRecovery() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.DroppedTableRec"));
        this.general.add(label);
        this.cbDroppedTblRecovery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDroppedTblRecovery);
        this.cbDroppedTblRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDroppedTblRecovery);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.cbDroppedTblRecovery, 470);
    }

    private void initFileSystemCaching() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.FileSystemCaching"));
        this.general.add(label);
        this.cbFileSystemCaching = new JComboBox<String>(YES_NO);
        this.setBG(this.cbFileSystemCaching);
        this.cbFileSystemCaching.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFileSystemCaching);
        this.setLabelConstraints(label, 500);
        this.setObjectConstraints(this.cbFileSystemCaching, 500);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TableSpacePropertyDialogUDBv81.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TableSpacePropertyDialogUDBv81.this.getStorageDesign().getTableSpaceSet().getElementsList());
                list.remove(TableSpacePropertyDialogUDBv81.this.tableSpace);
                new PropertiesPropagationDialog(TableSpacePropertyDialogUDBv81.this.getAppView(), TableSpacePropertyDialogUDBv81.this.tableSpace, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 540);
    }

    @Override
    protected void addTabs() {
        this.initUsePrivilegesView();
        this.initTablesView();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogUDBv81.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initToUserGroups();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.AllUsers"));
        this.usePrivilegesPanel.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(190, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.SelectedUsers"));
        this.usePrivilegesPanel.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(190, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 315, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 312, 32);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("TableSpacePropertyDialogUDBv81.Add"));
        this.bnAddUser.addActionListener(new AddColumnsActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 215, 75);
        this.bnRemoveUser = new JButton(Messages.getString("TableSpacePropertyDialogUDBv81.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 215, 105);
        TableSpacePropertyDialogUDBv81.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    private void initToUserGroups() {
        this.initAllUserGroupsList();
        this.initSelectedUserGroupsList();
        this.initGroupsButtons();
    }

    private void initAllUserGroupsList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.AllUsersGroups"));
        this.usePrivilegesPanel.add(label);
        this.allGroupsModel = new DefaultListModel();
        this.allGroupsList = new JList(this.allGroupsModel);
        ListSelectionModel listSelectionModel = this.allGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllGroupListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allGroupsList);
        sp.setPreferredSize(new Dimension(190, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 184);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 202);
    }

    private void initSelectedUserGroupsList() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.SelectedUserGroups"));
        this.usePrivilegesPanel.add(label);
        this.selectedGroupsModel = new DefaultListModel();
        this.selectedGroupsList = new JList(this.selectedGroupsModel);
        ListSelectionModel listSelectionModel = this.selectedGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedGroupListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedGroupsList);
        sp.setPreferredSize(new Dimension(190, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 315, 184);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 312, 202);
    }

    private void initGroupsButtons() {
        this.bnAddGroup = new JButton(Messages.getString("TableSpacePropertyDialogUDBv81.Add"));
        this.bnAddGroup.addActionListener(new AddGroupsActionListener());
        this.bnAddGroup.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddGroup, 215, 245);
        this.bnRemoveGroup = new JButton(Messages.getString("TableSpacePropertyDialogUDBv81.Remove"));
        this.bnRemoveGroup.setEnabled(false);
        this.bnRemoveGroup.addActionListener(new RemoveGroupsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveGroup, 215, 275);
        TableSpacePropertyDialogUDBv81.equalizeButtonSizes(this.bnAddGroup, this.bnRemoveGroup);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogUDBv81.GrantOption"));
        this.usePrivilegesPanel.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 350);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 350);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogUDBv81.Tables"), this.tables);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tablesList);
        spTS.setPreferredSize(new Dimension(495, 400));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTSLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbDBDefinition.setSelectedItem(this.tableSpace.getDBDefOnly() ? YES_NO[0] : YES_NO[1]);
        this.cbManagedBy.setSelectedItem(this.tableSpace.getManagedBy());
        this.cbAutoResize.setSelectedItem(this.tableSpace.getAutoResize());
        this.ifInitialSize.setText(this.tableSpace.getInitialSize());
        this.ifIncreaseSize.setText(this.tableSpace.getIncreaseSize());
        this.ifMaxSize.setText(this.tableSpace.getMaxSize());
        this.cbType.setSelectedItem(this.tableSpace.getDataType());
        this.cbDBPartitionGroup.setSelectedItem(this.tableSpace.getNodeGroup());
        this.cbPageSize.setSelectedItem(this.tableSpace.getPageSize());
        this.ifExtentSize.setText(this.tableSpace.getExtentSize());
        this.ifPrefetchSize.setText(this.tableSpace.getPrefetchSize());
        this.cbBufferPool.setSelectedItem(this.tableSpace.getBufferPool());
        this.dfOverhead.setValue(this.tableSpace.getOverhead());
        this.dfTransferRate.setValue(this.tableSpace.getTransferRate());
        this.cbDroppedTblRecovery.setSelectedItem(this.tableSpace.getDroppedTableRecovery() ? YES_NO[0] : YES_NO[1]);
        this.cbFileSystemCaching.setSelectedItem(this.tableSpace.getFileSystemCaching() ? YES_NO[0] : YES_NO[1]);
        if (this.tableSpace.getDataType().equalsIgnoreCase("REGULAR")) {
            this.cbDroppedTblRecovery.setEnabled(true);
        } else {
            this.cbDroppedTblRecovery.setEnabled(false);
        }
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (this.tableSpace.getUserSet().contains(user.getName())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        Object[] userGroupSet = this.getStorageDesign().getUserGroupSet().toArray();
        for (int i = 0; i < userGroupSet.length; ++i) {
            UserGroupUDB group = (UserGroupUDB)userGroupSet[i];
            if (this.tableSpace.getUserGroupSet().contains(group.getName())) {
                this.selectedGroupsModel.addElement(group);
                continue;
            }
            this.allGroupsModel.addElement(group);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogUDBv81.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        Object[] tss = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            if (((TableProxyUDBv81)tss[i]).getTableSpace() != this.tableSpace) continue;
            this.tablesListModel.addElement(tss[i]);
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.tableSpace.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null) {
            this.tableSpace.setName(this.tfName.getText());
            Object selected = this.cbDBDefinition.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setDBDefOnly(result);
            this.tableSpace.setManagedBy((String)this.cbManagedBy.getSelectedItem());
            this.tableSpace.setAutoResize((String)this.cbAutoResize.getSelectedItem());
            this.tableSpace.setInitialSize(this.ifInitialSize.getText());
            this.tableSpace.setIncreaseSize(this.ifIncreaseSize.getText());
            this.tableSpace.setMaxSize(this.ifMaxSize.getText());
            this.tableSpace.setDataType((String)this.cbType.getSelectedItem());
            selected = this.cbDBPartitionGroup.getSelectedItem();
            if (selected instanceof NodeGroupUDB) {
                this.tableSpace.setNodeGroup((NodeGroupUDB)selected);
            } else {
                this.tableSpace.setNodeGroup(null);
            }
            this.tableSpace.setPageSize((Integer)this.cbPageSize.getSelectedItem());
            this.tableSpace.setExtentSize(this.ifExtentSize.getText());
            this.tableSpace.setPrefetchSize(this.ifPrefetchSize.getText());
            selected = this.cbBufferPool.getSelectedItem();
            if (selected instanceof BufferPoolUDBv81) {
                this.tableSpace.setBufferPool((BufferPoolUDBv81)selected);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setOverhead(this.dfOverhead.getFloatValue());
            this.tableSpace.setTransferRate(this.dfTransferRate.getFloatValue());
            selected = this.cbDroppedTblRecovery.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setDroppedTableRecovery(result);
            selected = this.cbFileSystemCaching.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setFileSystemCaching(result);
            Object[] userSet = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)ob).getName());
            }
            Object[] userGroupsSet = this.selectedGroupsModel.toArray();
            for (int i = 0; i < userGroupsSet.length; ++i) {
                Object ob = userGroupsSet[i];
                if (!(ob instanceof UserGroupUDB)) continue;
                this.tableSpace.setGroups(((UserGroupUDB)ob).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.tableSpace.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)TableSpacePropertyDialogUDBv81.this.cbType.getSelectedItem()).equalsIgnoreCase("REGULAR")) {
                TableSpacePropertyDialogUDBv81.this.cbDroppedTblRecovery.setEnabled(true);
            } else {
                TableSpacePropertyDialogUDBv81.this.cbDroppedTblRecovery.setEnabled(false);
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDBv81.this.allUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDBv81.this.bnAddUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDBv81.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDBv81.this.selectedUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDBv81.this.bnRemoveUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDBv81.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDBv81.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDBv81.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDBv81.this.selectedUsersModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDBv81.this.selectedUsersModel.addElement(ob);
                    TableSpacePropertyDialogUDBv81.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDBv81.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDBv81.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDBv81.this.allUsersModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDBv81.this.allUsersModel.addElement(ob);
                    TableSpacePropertyDialogUDBv81.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class AllGroupListSelectionHandler
    implements ListSelectionListener {
        private AllGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDBv81.this.allGroupsList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDBv81.this.bnAddGroup.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDBv81.this.bnAddGroup.setEnabled(true);
                }
            }
        }
    }

    private class SelectedGroupListSelectionHandler
    implements ListSelectionListener {
        private SelectedGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableSpacePropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDBv81.this.selectedGroupsList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDBv81.this.bnRemoveGroup.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDBv81.this.bnRemoveGroup.setEnabled(true);
                }
            }
        }
    }

    private class AddGroupsActionListener
    implements ActionListener {
        private AddGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDBv81.this.allGroupsModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDBv81.this.allGroupsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDBv81.this.selectedGroupsModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDBv81.this.selectedGroupsModel.addElement(ob);
                    TableSpacePropertyDialogUDBv81.this.allGroupsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveGroupsActionListener
    implements ActionListener {
        private RemoveGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TableSpacePropertyDialogUDBv81.this.selectedGroupsModel.isEmpty()) {
                Object[] selectedObjects = TableSpacePropertyDialogUDBv81.this.selectedGroupsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TableSpacePropertyDialogUDBv81.this.allGroupsModel.contains(ob)) continue;
                    TableSpacePropertyDialogUDBv81.this.allGroupsModel.addElement(ob);
                    TableSpacePropertyDialogUDBv81.this.selectedGroupsModel.removeElement(ob);
                }
            }
        }
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyUDBv81)TableSpacePropertyDialogUDBv81.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogUDBv81 dialog = new TablePropertyDialogUDBv81(TableSpacePropertyDialogUDBv81.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

