/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.PermissionsPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SequencePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    protected SequenceUDBv81 sequence;
    protected JComboBox cbScheme;
    protected JComboBox cbDataType;
    protected JComboBox cbCycle;
    protected JComboBox cbOrder;
    protected JIntegerField ifStartWith;
    protected JIntegerField ifIncrementBy;
    protected JIntegerField ifMinValue;
    protected JIntegerField ifMaxValue;
    protected JTextField tfOwner;
    protected JTextField ifCache;
    private static final int SEQ_VALUE_MAX_DIGITS_UDB = 19;
    private JButton bnPermissions;
    private PermissionsPropertyDialogUDB dialog;

    public SequencePropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.sequence = (SequenceUDBv81)object;
        this.setHeight(420);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SequencePropertyDialogUDBv81.SequenceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initScheme();
        this.initOwner();
        this.initDataType();
        this.initStartWith();
        this.initIncrementBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    protected void initDataType() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.DataType"));
        this.general.add(label);
        this.cbDataType = new JComboBox<String>(SequenceUDB.DATA_TYPES);
        this.setBG(this.cbDataType);
        this.cbDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataType);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDataType, 110);
    }

    protected void initStartWith() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.StartWith"));
        this.general.add(label);
        this.ifStartWith = new JIntegerField(0, 26);
        this.general.add(this.ifStartWith);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifStartWith, 140);
    }

    protected void initIncrementBy() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.IncrementBy"));
        this.general.add(label);
        this.ifIncrementBy = new JIntegerField(0, 26);
        this.general.add(this.ifIncrementBy);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifIncrementBy, 170);
    }

    protected void initMinValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.MinValue"));
        this.general.add(label);
        this.ifMinValue = new JIntegerField();
        this.ifMinValue.setColumns(26);
        this.ifMinValue.setLargeIntegerDocument(19);
        this.general.add(this.ifMinValue);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifMinValue, 200);
    }

    protected void initMaxValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.MaxValue"));
        this.general.add(label);
        this.ifMaxValue = new JIntegerField();
        this.ifMaxValue.setColumns(26);
        this.ifMaxValue.setLargeIntegerDocument(19);
        this.general.add(this.ifMaxValue);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifMaxValue, 230);
    }

    protected void initCycle() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Cycle"));
        this.general.add(label);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCycle);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbCycle, 260);
    }

    protected void initCache() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Cache"));
        this.general.add(label);
        this.ifCache = new JTextField("", 26);
        this.general.add(this.ifCache);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifCache, 290);
    }

    protected void initOrder() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Order"));
        this.general.add(label);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrder);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbOrder, 320);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("SequencePropertyDialogUDBv81.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(((StorageDesignUDBv81)SequencePropertyDialogUDBv81.this.getStorageDesign()).getSequenceSet().getElementsList());
                list.remove(SequencePropertyDialogUDBv81.this.sequence);
                new PropertiesPropagationDialog(SequencePropertyDialogUDBv81.this.getAppView(), SequencePropertyDialogUDBv81.this.sequence, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 360);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TableViewPropertyDialogUDBv81.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 360);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.sequence.getName());
        this.tfName.setText(this.sequence.getName());
        this.cbScheme.setSelectedItem(this.sequence.getSchema());
        this.cbDataType.setSelectedItem(this.sequence.getDatatype());
        this.ifStartWith.setValue((long)this.sequence.getStartWith());
        this.ifIncrementBy.setValue((long)this.sequence.getIncrementBy());
        try {
            if (!"NO".equalsIgnoreCase(this.sequence.getMinValue())) {
                double d = Double.parseDouble(this.sequence.getMinValue());
            }
            this.ifMinValue.setText(this.sequence.getMinValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMinValue.setText("");
        }
        try {
            if (!"NO".equalsIgnoreCase(this.sequence.getMaxValue())) {
                double nfe = Double.parseDouble(this.sequence.getMaxValue());
            }
            this.ifMaxValue.setText(this.sequence.getMaxValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMaxValue.setText("");
        }
        this.cbCycle.setSelectedItem(SequencePropertyDialogUDBv81.translateYesNoForDisplay(this.sequence.getCycle()));
        if (this.sequence.getCache() == 0) {
            this.ifCache.setText(NO);
        } else {
            this.ifCache.setText(Integer.toString(this.sequence.getCache()));
        }
        this.cbOrder.setSelectedItem(SequencePropertyDialogUDBv81.translateYesNoForDisplay(this.sequence.getOrder()));
        this.getCommentsList().setText(this.sequence.getComment());
    }

    @Override
    protected void setProperties() {
        if (this.sequence != null) {
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDBv81) {
                this.sequence.setOwner(((SchemaUDBv81)selected).getOwner());
                this.sequence.setSchema((SchemaUDBv81)selected);
            } else {
                this.sequence.setOwner(null);
                this.sequence.setSchema(null);
            }
            this.sequence.setName(this.tfName.getText());
            this.sequence.setDatatype((String)this.cbDataType.getSelectedItem());
            this.sequence.setStartWith(this.ifStartWith.getIntValue());
            this.sequence.setIncrementBy(this.ifIncrementBy.getIntValue());
            try {
                if (!"NO".equalsIgnoreCase(this.ifMinValue.getText())) {
                    double d = Double.parseDouble(this.ifMinValue.getText());
                }
                this.sequence.setMinValue(this.ifMinValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMinValue("");
            }
            try {
                if (!"NO".equalsIgnoreCase(this.ifMaxValue.getText())) {
                    double nfe = Double.parseDouble(this.ifMaxValue.getText());
                }
                this.sequence.setMaxValue(this.ifMaxValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMaxValue("");
            }
            this.sequence.setCycle(SequencePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCycle.getSelectedItem()));
            this.sequence.setOrder(SequencePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
            String cache = this.ifCache.getText();
            if (cache.equalsIgnoreCase(NO)) {
                this.sequence.setCache(0);
            } else {
                try {
                    this.sequence.setCache(Integer.parseInt(cache));
                }
                catch (NumberFormatException e) {
                    this.sequence.setCache(0);
                }
            }
            this.sequence.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbScheme.getSelectedItem();
        if (selectedSchema instanceof SchemaUDB) {
            newName = ((SchemaUDB)selectedSchema).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDBv81 schema = (SchemaUDBv81)SequencePropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    SequencePropertyDialogUDBv81.this.tfOwner.setText(schema.getOwner().toString());
                } else {
                    SequencePropertyDialogUDBv81.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException e1) {
                SequencePropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SequencePropertyDialogUDBv81.this.dialog == null) {
                SequencePropertyDialogUDBv81.this.dialog = new PermissionsPropertyDialogUDB(SequencePropertyDialogUDBv81.this.getAppView(), SequencePropertyDialogUDBv81.this.getStorageDesign(), SequencePropertyDialogUDBv81.this.sequence);
            }
            SequencePropertyDialogUDBv81.this.dialog.setVisible(true);
        }
    }
}

