/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.IndexPropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableViewPropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SchemaPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private SchemaUDBv81 schema;
    private JComboBox cbOwner;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;

    public SchemaPropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.schema = (SchemaUDBv81)object;
        this.setHeight(130);
        this.initCommentsView(30);
        this.initCommentsInRDBMS(30);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertyDialogUDBv81.SchemaProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDBv81.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    @Override
    protected void addTabs() {
        this.initTablesView();
        this.initViewsView();
        this.initIndexesView();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDBv81.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDBv81.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane spTS = new JScrollPane(this.viewList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(spTS);
        this.setObjectConstraints(this.getViewLayout(), spTS, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDBv81.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane spTS = new JScrollPane(this.indexList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(spTS);
        this.setObjectConstraints(this.getIndexLayout(), spTS, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.schema.getName());
        this.tfName.setText(this.schema.getName());
        this.cbOwner.setSelectedItem(this.schema.getOwner());
        Object[] table = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < table.length; ++i) {
            if (((TableProxyUDBv81)table[i]).getSchema() != this.schema) continue;
            this.tableListModel.addElement(table[i]);
        }
        Object[] view = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i = 0; i < view.length; ++i) {
            if (((TableViewProxyUDBv81)view[i]).getSchema() != this.schema) continue;
            this.viewListModel.addElement(view[i]);
        }
        Object[] index = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < index.length; ++i) {
            if (((IndexProxyUDBv81)index[i]).getSchema() != this.schema) continue;
            this.indexListModel.addElement(index[i]);
        }
        this.getCommentsList().insert(this.schema.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.schema.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.schema != null) {
            this.schema.setName(this.tfName.getText());
            Object selected = this.cbOwner.getSelectedItem();
            if (selected instanceof OwnerUDBv81) {
                this.schema.setOwner((OwnerUDBv81)selected);
            } else {
                this.schema.setOwner(null);
            }
            this.schema.setComment(this.getCommentsList().getText());
            this.schema.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyUDBv81)SchemaPropertyDialogUDBv81.this.tableList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TablePropertyDialogUDBv81 dialog = new TablePropertyDialogUDBv81(SchemaPropertyDialogUDBv81.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableViewProxyUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TableViewProxyUDBv81)SchemaPropertyDialogUDBv81.this.viewList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableViewPropertyDialogUDBv81 dialog = new TableViewPropertyDialogUDBv81(SchemaPropertyDialogUDBv81.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyUDBv81)SchemaPropertyDialogUDBv81.this.indexList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogUDBv81 dialog = new IndexPropertyDialogUDBv81(SchemaPropertyDialogUDBv81.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

