/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.IndexPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableViewPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SchemaPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private SchemaUDB schema;
    private JComboBox cbOwner;
    private JComboBox cbSchemaObject;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel privs;
    private JComboBox cbUser;
    private JComboBox cbGrantOption;
    private DefaultListModel allPrivsModel;
    private DefaultListModel selectedPrivsModel;
    private JList allPrivsList;
    private JList selectedPrivsList;
    private JButton bnPrivsAdd;
    private JButton bnPrivsRemove;

    public SchemaPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.schema = (SchemaUDB)object;
        this.setHeight(210);
        this.initCommentsView(70);
        this.initCommentsInRDBMS(70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertyDialogUDB.SchemaProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initSchemaObject();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDB.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initSchemaObject() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDB.ImplementsSchema"));
        this.general.add(label);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbSchemaObject, 80);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
        this.initTablesView();
        this.initViewsView();
        this.initIndexesView();
    }

    private void initPrivilegesView() {
        this.privs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Privileges"), this.privs);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initUser();
        this.initGrantOption();
        this.initAllPrivsList();
        this.initSelectedPrivsList();
        this.initPrivsButtons();
    }

    protected SpringLayout getPrivsLayout() {
        return (SpringLayout)this.privs.getLayout();
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDB.User"));
        this.privs.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        this.cbUser.addActionListener(new UserListener());
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbUser);
        this.setLabelConstraints(this.getPrivsLayout(), label, 20);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbUser, 20);
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDB.GrantOption"));
        this.privs.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbGrantOption);
        this.setLabelConstraints(this.getPrivsLayout(), label, 50);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbGrantOption, 50);
    }

    private void initAllPrivsList() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDB.AllPrivileges"));
        this.privs.add(label);
        this.allPrivsModel = new DefaultListModel();
        this.allPrivsList = new JList(this.allPrivsModel);
        ListSelectionModel listSelectionModel = this.allPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allPrivsList);
        sp.setPreferredSize(new Dimension(144, 70));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(sp);
        this.setLabelConstraints(this.getPrivsLayout(), label, 12, 84);
        this.setObjectConstraints(this.getPrivsLayout(), sp, 10, 102);
    }

    private void initSelectedPrivsList() {
        JLabel label = new JLabel(Messages.getString("SchemaPropertyDialogUDB.SelectedPrivileges"));
        this.privs.add(label);
        this.selectedPrivsModel = new DefaultListModel();
        this.selectedPrivsList = new JList(this.selectedPrivsModel);
        ListSelectionModel listSelectionModel = this.selectedPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedPrivsList);
        sp.setPreferredSize(new Dimension(145, 70));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(sp);
        this.setLabelConstraints(this.getPrivsLayout(), label, 292, 84);
        this.setObjectConstraints(this.getPrivsLayout(), sp, 290, 102);
    }

    private void initPrivsButtons() {
        this.bnPrivsAdd = new JButton(Messages.getString("SchemaPropertyDialogUDB.Add"));
        this.bnPrivsAdd.addActionListener(new AddPrivsActionListener());
        this.bnPrivsAdd.setEnabled(false);
        this.privs.add(this.bnPrivsAdd);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsAdd, 175, 110);
        this.bnPrivsRemove = new JButton(Messages.getString("SchemaPropertyDialogUDB.Remove"));
        this.bnPrivsRemove.setEnabled(false);
        this.bnPrivsRemove.addActionListener(new RemovePrivsActionListener());
        this.privs.add(this.bnPrivsRemove);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsRemove, 175, 140);
        SchemaPropertyDialogUDB.equalizeButtonSizes(this.bnPrivsAdd, this.bnPrivsRemove);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(395, 160));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane spTS = new JScrollPane(this.viewList);
        spTS.setPreferredSize(new Dimension(395, 160));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(spTS);
        this.setObjectConstraints(this.getViewLayout(), spTS, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane spTS = new JScrollPane(this.indexList);
        spTS.setPreferredSize(new Dimension(395, 160));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(spTS);
        this.setObjectConstraints(this.getIndexLayout(), spTS, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private PrivilegesUDB getPrivileges(Object user) {
        PrivilegesUDB priv2;
        for (PrivilegesUDB priv2 : this.getStorageDesign().getPrivilegesSet()) {
            if (priv2.getUser() != user && priv2.getGroup() != user) continue;
            return priv2;
        }
        priv2 = this.getStorageDesign().getPrivilegesSet().createPriv();
        priv2.setSchema(this.schema);
        if (user instanceof OwnerUDB) {
            priv2.setUser((OwnerUDB)user);
        } else if (user instanceof UserGroupUDB) {
            priv2.setGroup((UserGroupUDB)user);
        }
        return priv2;
    }

    @Override
    public void initProperties() {
        int i;
        this.initCaption(this.schema.getName());
        this.tfName.setText(this.schema.getName());
        this.cbOwner.setSelectedItem(this.schema.getOwner());
        for (i = 0; i < this.getStorageDesign().getOwnerSet().toArray().length; ++i) {
            this.cbUser.addItem(this.getStorageDesign().getOwnerSet().toArray()[i]);
        }
        for (i = 0; i < this.getStorageDesign().getUserGroupSet().toArray().length; ++i) {
            this.cbUser.addItem(this.getStorageDesign().getUserGroupSet().toArray()[i]);
        }
        PrivilegesUDB priv = this.getPrivilegesForSchema(this.schema);
        if (priv != null) {
            this.cbUser.setSelectedItem(this.getUserPriv(priv));
        }
        this.getCommentsList().insert(this.schema.getComment(), 0);
        Object[] table = this.getStorageDesign().getTableProxySet().toArray();
        for (int i2 = 0; i2 < table.length; ++i2) {
            if (((TableProxyUDB)table[i2]).getSchema() != this.schema) continue;
            this.tableListModel.addElement(table[i2]);
        }
        Object[] view = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i3 = 0; i3 < view.length; ++i3) {
            if (((TableViewProxyUDB)view[i3]).getSchema() != this.schema) continue;
            this.viewListModel.addElement(view[i3]);
        }
        Object[] index = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i4 = 0; i4 < index.length; ++i4) {
            if (((IndexProxyUDB)index[i4]).getSchema() != this.schema) continue;
            this.indexListModel.addElement(index[i4]);
        }
        this.cbSchemaObject.setSelectedItem(this.schema.getSchemaObject());
        this.getCommentsList().insert(this.schema.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.schema.getCommentInRDBMS(), 0);
    }

    private Object getUserPriv(PrivilegesUDB priv) {
        if (priv.getUser() != null) {
            return priv.getUser();
        }
        if (priv.getGroup() != null) {
            return priv.getGroup();
        }
        return null;
    }

    private PrivilegesUDB getPrivilegesForSchema(SchemaUDB schema) {
        for (PrivilegesUDB priv : this.getStorageDesign().getPrivilegesSet()) {
            if (priv.getSchema() != schema) continue;
            return priv;
        }
        return null;
    }

    @Override
    protected void setProperties() {
        if (this.schema != null) {
            this.schema.setName(this.tfName.getText());
            Object selected = this.cbOwner.getSelectedItem();
            if (selected instanceof OwnerUDB) {
                this.schema.setOwner((OwnerUDB)selected);
            } else {
                this.schema.setOwner(null);
            }
            Object user = this.cbUser.getSelectedItem();
            PrivilegesUDB privs = this.getPrivileges(user);
            privs.clear();
            Object[] privileges = this.selectedPrivsModel.toArray();
            for (int i = 0; i < privileges.length; ++i) {
                privs.setSystemPrivileges((String)privileges[i]);
            }
            privs.setGrantOption(SchemaPropertyDialogUDB.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.schema.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            this.schema.setComment(this.getCommentsList().getText());
            this.schema.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class UserListener
    implements ActionListener {
        private UserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SchemaPropertyDialogUDB.this.cbUser.getSelectedItem() != null) {
                Object user = SchemaPropertyDialogUDB.this.cbUser.getSelectedItem();
                PrivilegesUDB privs = SchemaPropertyDialogUDB.this.getPrivileges(user);
                SchemaPropertyDialogUDB.this.allPrivsModel.removeAllElements();
                SchemaPropertyDialogUDB.this.selectedPrivsModel.removeAllElements();
                SchemaPropertyDialogUDB.this.cbGrantOption.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(privs.getGrantOption()));
                String[] privileges = (String[])PrivilegesUDB.getPrivilegesValues().toArray();
                for (int i = 0; i < privileges.length; ++i) {
                    if (privs.getSystemPrivilegesSet().contains(privileges[i])) {
                        SchemaPropertyDialogUDB.this.selectedPrivsModel.addElement(privileges[i]);
                        continue;
                    }
                    SchemaPropertyDialogUDB.this.allPrivsModel.addElement(privileges[i]);
                }
            } else {
                SchemaPropertyDialogUDB.this.allPrivsModel.removeAllElements();
                SchemaPropertyDialogUDB.this.selectedPrivsModel.removeAllElements();
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SchemaPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (SchemaPropertyDialogUDB.this.allPrivsList.getSelectedIndex() == -1) {
                    SchemaPropertyDialogUDB.this.bnPrivsAdd.setEnabled(false);
                } else {
                    SchemaPropertyDialogUDB.this.bnPrivsAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SchemaPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (SchemaPropertyDialogUDB.this.selectedPrivsList.getSelectedIndex() == -1) {
                    SchemaPropertyDialogUDB.this.bnPrivsRemove.setEnabled(false);
                } else {
                    SchemaPropertyDialogUDB.this.bnPrivsRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddPrivsActionListener
    implements ActionListener {
        private AddPrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SchemaPropertyDialogUDB.this.allPrivsModel.isEmpty()) {
                Object[] selectedObjects = SchemaPropertyDialogUDB.this.allPrivsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SchemaPropertyDialogUDB.this.selectedPrivsModel.contains(ob)) continue;
                    SchemaPropertyDialogUDB.this.selectedPrivsModel.addElement(ob);
                    SchemaPropertyDialogUDB.this.allPrivsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemovePrivsActionListener
    implements ActionListener {
        private RemovePrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SchemaPropertyDialogUDB.this.selectedPrivsModel.isEmpty()) {
                Object[] selectedObjects = SchemaPropertyDialogUDB.this.selectedPrivsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SchemaPropertyDialogUDB.this.allPrivsModel.contains(ob)) continue;
                    SchemaPropertyDialogUDB.this.allPrivsModel.addElement(ob);
                    SchemaPropertyDialogUDB.this.selectedPrivsModel.removeElement(ob);
                }
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyUDB selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyUDB)SchemaPropertyDialogUDB.this.tableList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TablePropertyDialogUDB dialog = new TablePropertyDialogUDB(SchemaPropertyDialogUDB.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableViewProxyUDB selected;
            if (e.getClickCount() == 2 && (selected = (TableViewProxyUDB)SchemaPropertyDialogUDB.this.viewList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableViewPropertyDialogUDB dialog = new TableViewPropertyDialogUDB(SchemaPropertyDialogUDB.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyUDB selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyUDB)SchemaPropertyDialogUDB.this.indexList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogUDB dialog = new IndexPropertyDialogUDB(SchemaPropertyDialogUDB.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

