/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableSpacePropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BufferPoolPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private BufferPoolUDB bufferPool;
    private JIntegerField ifSize;
    private JTextField tfNodesWithDiffSize;
    private JComboBox cbPageSize;
    private JComboBox cbExtendedStorage;
    private JPanel scope;
    private DefaultListModel allNodesModel;
    private DefaultListModel selectedNodesModel;
    private JList allNodesList;
    private JList selectedNodesList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;

    public BufferPoolPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.bufferPool = (BufferPoolUDB)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BufferPoolPropertyDialogUDB.BufferPoolProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.bufferPool.getName());
        this.tfName.setText(this.bufferPool.getName());
        this.ifSize.setValue((long)this.bufferPool.getSize());
        this.tfNodesWithDiffSize.setText(this.bufferPool.getNodesWithDiffSize());
        this.cbPageSize.setSelectedItem(new Integer(this.bufferPool.getPageSize()));
        if (this.bufferPool.getExtendedStorage()) {
            this.cbExtendedStorage.setSelectedItem(YES);
        } else {
            this.cbExtendedStorage.setSelectedItem(NO);
        }
        NodeGroupUDB[] volumesSet = (NodeGroupUDB[])this.getStorageDesign().getNodeGroupSet().toArray();
        for (int i = 0; i < volumesSet.length; ++i) {
            NodeGroupUDB vol = volumesSet[i];
            if (this.bufferPool.getScopeSet().contains(vol.getName())) {
                this.selectedNodesModel.addElement(vol);
                continue;
            }
            this.allNodesModel.addElement(vol);
        }
        TableSpaceUDB[] tss = (TableSpaceUDB[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            if (tss[i].getBufferPool() != this.bufferPool) continue;
            this.tsListModel.addElement(tss[i]);
        }
        this.getCommentsList().insert(this.bufferPool.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.bufferPool != null) {
            this.bufferPool.setSize(this.ifSize.getIntValue());
            this.bufferPool.setNodesWithDiffSize(this.tfNodesWithDiffSize.getText());
            Object selected = this.cbPageSize.getSelectedItem();
            if (selected instanceof Integer) {
                this.bufferPool.setPageSize((Integer)selected);
            }
            selected = this.cbExtendedStorage.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.bufferPool.setExtendedStorage(result);
            Object[] nodesSet = this.selectedNodesModel.toArray();
            this.bufferPool.clear();
            for (int i = 0; i < nodesSet.length; ++i) {
                Object ob = nodesSet[i];
                if (!(ob instanceof NodeGroupUDB)) continue;
                this.bufferPool.setScope(((NodeGroupUDB)ob).getName());
            }
            this.bufferPool.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.tfName.setEditable(false);
        this.initSize();
        this.initNodesWithDiffSize();
        this.initPageSize();
        this.initExtendedStorage();
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.Size"));
        this.general.add(label);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.ifSize, 50);
    }

    private void initNodesWithDiffSize() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.DiffSizeNodes"));
        this.general.add(label);
        this.tfNodesWithDiffSize = new JTextField("", 26);
        this.general.add(this.tfNodesWithDiffSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfNodesWithDiffSize, 80);
    }

    private void initPageSize() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.PageSize"));
        this.general.add(label);
        this.cbPageSize = new JComboBox<Object>(BufferPoolUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbPageSize, 110);
    }

    private void initExtendedStorage() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.ExtendedStorage"));
        this.general.add(label);
        this.cbExtendedStorage = new JComboBox<String>(YES_NO);
        this.setBG(this.cbExtendedStorage);
        this.cbExtendedStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtendedStorage);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbExtendedStorage, 140);
    }

    @Override
    protected void addTabs() {
        this.initScopeView();
        this.initTableSpacesView();
    }

    private void initScopeView() {
        this.scope = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDB.Scope"), this.scope);
        this.initScope();
    }

    private void initScope() {
        this.initAllVolumesList();
        this.initSelectedVolumesList();
        this.initButtons();
    }

    protected SpringLayout getScopeLayout() {
        return (SpringLayout)this.scope.getLayout();
    }

    private void initAllVolumesList() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.AllNodes"));
        this.scope.add(label);
        this.allNodesModel = new DefaultListModel();
        this.allNodesList = new JList(this.allNodesModel);
        ListSelectionModel listSelectionModel = this.allNodesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allNodesList);
        sp.setPreferredSize(new Dimension(144, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(sp);
        this.setLabelConstraints(this.getScopeLayout(), label, 12, 4);
        this.setObjectConstraints(this.getScopeLayout(), sp, 10, 22);
    }

    private void initSelectedVolumesList() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.SelectedNodes"));
        this.scope.add(label);
        this.selectedNodesModel = new DefaultListModel();
        this.selectedNodesList = new JList(this.selectedNodesModel);
        ListSelectionModel listSelectionModel = this.selectedNodesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedNodesList);
        sp.setPreferredSize(new Dimension(145, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(sp);
        this.setLabelConstraints(this.getScopeLayout(), label, 292, 4);
        this.setObjectConstraints(this.getScopeLayout(), sp, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("BufferPoolPropertyDialogUDB.Add"));
        this.bnAdd.addActionListener(new AddNodesActionListener());
        this.bnAdd.setEnabled(false);
        this.scope.add(this.bnAdd);
        this.setObjectConstraints(this.getScopeLayout(), this.bnAdd, 175, 60);
        this.bnRemove = new JButton(Messages.getString("BufferPoolPropertyDialogUDB.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveNodesActionListener());
        this.scope.add(this.bnRemove);
        this.setObjectConstraints(this.getScopeLayout(), this.bnRemove, 175, 90);
        BufferPoolPropertyDialogUDB.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initTableSpacesView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDB.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new ListMouseListenerTS());
        JScrollPane spTS = new JScrollPane(this.tsList);
        spTS.setPreferredSize(new Dimension(395, 150));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(spTS);
        this.setObjectConstraints(this.getTSLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BufferPoolPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDB.this.allNodesList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDB.this.bnAdd.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDB.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BufferPoolPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDB.this.selectedNodesList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDB.this.bnRemove.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDB.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddNodesActionListener
    implements ActionListener {
        private AddNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BufferPoolPropertyDialogUDB.this.allNodesModel.isEmpty()) {
                Object[] selectedObjects = BufferPoolPropertyDialogUDB.this.allNodesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BufferPoolPropertyDialogUDB.this.selectedNodesModel.contains(ob)) continue;
                    BufferPoolPropertyDialogUDB.this.selectedNodesModel.addElement(ob);
                    BufferPoolPropertyDialogUDB.this.allNodesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveNodesActionListener
    implements ActionListener {
        private RemoveNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BufferPoolPropertyDialogUDB.this.selectedNodesModel.isEmpty()) {
                Object[] selectedObjects = BufferPoolPropertyDialogUDB.this.selectedNodesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BufferPoolPropertyDialogUDB.this.allNodesModel.contains(ob)) continue;
                    BufferPoolPropertyDialogUDB.this.allNodesModel.addElement(ob);
                    BufferPoolPropertyDialogUDB.this.selectedNodesModel.removeElement(ob);
                }
            }
        }
    }

    private class ListMouseListenerTS
    extends MouseAdapter {
        private ListMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableSpaceUDB selected;
            if (e.getClickCount() == 2 && (selected = (TableSpaceUDB)BufferPoolPropertyDialogUDB.this.tsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableSpacePropertyDialogUDB dialog = new TableSpacePropertyDialogUDB(BufferPoolPropertyDialogUDB.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

