/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.UserAndRolePermissionsDialogSqlServerv2k5;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private UserSqlServer user;
    private JTextField tfDatabase;
    private JTextField tfLogin;
    private JPanel panelPrivileges;
    private JList allPrivilegesList;
    private JList selectedPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private DefaultListModel selectedPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogSqlServerv2k5 dialog;

    public UserPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.user = (UserSqlServer)object;
        this.setHeight(190);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UserPropertyDialogSqlServer.UserProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatabase();
        this.initLogin();
        this.initPermissionsButton();
    }

    private void initDatabase() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.Database"));
        this.general.add(label);
        this.tfDatabase = new JTextField();
        this.setBG(this.tfDatabase);
        this.tfDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.tfDatabase.setEnabled(false);
        this.general.add(this.tfDatabase);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDatabase, 50);
    }

    private void initLogin() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.Login"));
        this.general.add(label);
        this.tfLogin = new JTextField();
        this.setBG(this.tfLogin);
        this.tfLogin.setEnabled(false);
        this.tfLogin.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfLogin);
        this.setLabelConstraints(label, 75);
        this.setObjectConstraints(this.tfLogin, 75);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("UserPropertyDialogSqlServer.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 130);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
    }

    private void initPrivilegesView() {
        this.panelPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogSqlServer.Privileges"), this.panelPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(Messages.getString("UserPropertyDialogSqlServer.Add"));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnAddPrivileges, 175, 60);
        this.bnRemovePrivileges = new JButton(Messages.getString("UserPropertyDialogSqlServer.Remove"));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnRemovePrivileges, 175, 90);
        UserPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initAllPrivilegesList() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.AllPrivileges"));
        this.panelPrivileges.add(label);
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allPrivilegesList);
        sp.setPreferredSize(new Dimension(144, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(sp);
        this.setLabelConstraints(this.getPrivilegesLayout(), label, 12, 4);
        this.setObjectConstraints(this.getPrivilegesLayout(), sp, 10, 22);
    }

    private void initSelectedPrivilegesList() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.SelectedPrivileges"));
        this.panelPrivileges.add(label);
        this.selectedPrivilegesModel = new DefaultListModel();
        this.selectedPrivilegesList = new JList(this.selectedPrivilegesModel);
        ListSelectionModel listSelectionModel = this.selectedPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedPrivilegesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedPrivilegesList);
        sp.setPreferredSize(new Dimension(145, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(sp);
        this.setLabelConstraints(this.getPrivilegesLayout(), label, 292, 4);
        this.setObjectConstraints(this.getPrivilegesLayout(), sp, 290, 22);
    }

    protected SpringLayout getPrivilegesLayout() {
        return (SpringLayout)this.panelPrivileges.getLayout();
    }

    protected String[] getPrivilegesValuesSet() {
        return (String[])UserSqlServer.getPrivilegesValues().toArray();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.user.getName());
        this.tfName.setText(this.user.getName());
        this.tfDatabase.setText(this.user.getDatabase().getName());
        if (this.user.getLogin() != null) {
            this.tfLogin.setText(this.user.getLogin().getName());
        }
        String[] privilegesSet = this.getPrivilegesValuesSet();
        for (int i = 0; i < privilegesSet.length; ++i) {
            String privilege = privilegesSet[i];
            if (this.user.getPrivilegesSet().contains(privilege)) {
                this.addElementToSortedListModel(this.selectedPrivilegesModel, privilege);
                continue;
            }
            this.addElementToSortedListModel(this.allPrivilegesModel, privilege);
        }
        if (this.user.isNullInstance()) {
            this.selectedPrivilegesList.setEnabled(false);
            this.allPrivilegesList.setEnabled(false);
        }
        this.getCommentsList().insert(this.user.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.user != null) {
            String oldName = this.user.getName();
            this.user.setName(this.tfName.getText());
            Object[] privSet = this.selectedPrivilegesModel.toArray();
            this.user.clear();
            for (int i = 0; i < privSet.length; ++i) {
                Object pr = privSet[i];
                if (!(pr instanceof String)) continue;
                this.user.setSystemPrivileges((String)pr);
            }
            this.user.setComment(this.getCommentsList().getText());
            if (!this.tfName.getText().equals(oldName)) {
                this.user.setNameChanged(true);
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UserPropertyDialogSqlServerv2k5.this.dialog == null) {
                UserPropertyDialogSqlServerv2k5.this.dialog = new UserAndRolePermissionsDialogSqlServerv2k5(UserPropertyDialogSqlServerv2k5.this.getAppView(), UserPropertyDialogSqlServerv2k5.this.getStorageDesign(), UserPropertyDialogSqlServerv2k5.this.user);
            }
            UserPropertyDialogSqlServerv2k5.this.dialog.showDialog();
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UserPropertyDialogSqlServerv2k5.this.allPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = UserPropertyDialogSqlServerv2k5.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UserPropertyDialogSqlServerv2k5.this.selectedPrivilegesModel.contains(ob)) continue;
                    UserPropertyDialogSqlServerv2k5.this.addElementToSortedListModel(UserPropertyDialogSqlServerv2k5.this.selectedPrivilegesModel, ob);
                    UserPropertyDialogSqlServerv2k5.this.allPrivilegesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UserPropertyDialogSqlServerv2k5.this.selectedPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = UserPropertyDialogSqlServerv2k5.this.selectedPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UserPropertyDialogSqlServerv2k5.this.allPrivilegesModel.contains(ob)) continue;
                    UserPropertyDialogSqlServerv2k5.this.addElementToSortedListModel(UserPropertyDialogSqlServerv2k5.this.allPrivilegesModel, ob);
                    UserPropertyDialogSqlServerv2k5.this.selectedPrivilegesModel.removeElement(ob);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (UserPropertyDialogSqlServerv2k5.this.isEditable() && !e.getValueIsAdjusting()) {
                if (UserPropertyDialogSqlServerv2k5.this.allPrivilegesList.getSelectedIndex() == -1) {
                    UserPropertyDialogSqlServerv2k5.this.bnAddPrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogSqlServerv2k5.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class SelectedPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private SelectedPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (UserPropertyDialogSqlServerv2k5.this.isEditable() && !e.getValueIsAdjusting()) {
                if (UserPropertyDialogSqlServerv2k5.this.selectedPrivilegesList.getSelectedIndex() == -1) {
                    UserPropertyDialogSqlServerv2k5.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogSqlServerv2k5.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        }
    }
}

