/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserDefinedTypeSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DataBasePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private DataBaseSqlServer database;
    private JComboBox cbState;
    private JComboBox cbCursorCloseOnCommit;
    private JComboBox cbCursorDefault;
    private JComboBox cbAutoClose;
    private JComboBox cbAutoCreateStatistics;
    private JComboBox cbAutoUpdateStatistics;
    private JComboBox cbRecovery;
    private JComboBox cbTornPageDetection;
    private JComboBox cbAutoShrink;
    private JComboBox cbAnsiNulls;
    private JComboBox cbAnsiPadding;
    private JComboBox cbAnsiWarnings;
    private JComboBox cbArithabort;
    private JComboBox cbConcatNullYieldsNull;
    private JComboBox cbNumericRoundabort;
    private JComboBox cbQuotedIdentifier;
    private JComboBox cbRecursiveTriggers;
    private JTextField tfCollationName;
    private JPanel pTypes;
    private TypesTable tableTypes;
    private TypesTableModel modelTypes;
    private JPanel pDomains;
    private TypesTable tableDomains;
    private TypesTableModel modelDomains;

    public DataBasePropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.database = (DataBaseSqlServer)object;
        this.setHeight(640);
        this.initViews();
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    private void initViews() {
        this.initCommentsView();
        this.initTypesView();
        this.initDomainView();
    }

    private void initDomainView() {
        SpringLayout sl = new SpringLayout();
        this.pDomains = new JPanel(sl);
        this.getPane().addTab(Messages.getString("DataBasePropertyDialogSqlServerv2k5.UserDefinedTypesAccess"), this.pDomains);
        this.tableDomains = new TypesTable();
        this.tableDomains.setPreferredScrollableViewportSize(new Dimension(503, 558));
        JScrollPane pane = new JScrollPane(this.tableDomains);
        this.modelDomains = (TypesTableModel)this.tableDomains.getModel();
        this.setBG(this.tableDomains);
        this.pDomains.add(pane);
        this.setObjectConstraints(sl, pane, 10, 12);
    }

    private void initTypesView() {
        SpringLayout sl = new SpringLayout();
        this.pTypes = new JPanel(sl);
        this.getPane().addTab(Messages.getString("DataBasePropertyDialogSqlServerv2k5.DistinctTypesAccess"), this.pTypes);
        this.tableTypes = new TypesTable();
        this.tableTypes.setPreferredScrollableViewportSize(new Dimension(503, 558));
        JScrollPane pane = new JScrollPane(this.tableTypes);
        this.modelTypes = (TypesTableModel)this.tableTypes.getModel();
        this.setBG(this.tableTypes);
        this.pTypes.add(pane);
        this.setObjectConstraints(sl, pane, 10, 12);
    }

    @Override
    public String getCaption() {
        return Messages.getString("DataBasePropertyDialogSqlServerv2k5.DatabaseProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initState();
        this.initCollationName();
        this.initCursorCloseOnCommit();
        this.initCursorDefault();
        this.initAutoClose();
        this.initAutoCreateStatistics();
        this.initAutoUpdateStatistics();
        this.initRecovery();
        this.initTornPageDetection();
        this.initAutoShrink();
        this.initAnsiPadding();
        this.initAnsiNulls();
        this.initAnsiWarnings();
        this.initArithabort();
        this.initConcatNullYieldsNull();
        this.initNumericRoundabort();
        this.initQuotedIdentifier();
        this.initRecursiveTriggers();
    }

    private void initState() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.State"));
        this.general.add(label);
        this.cbState = new JComboBox<String>(DataBaseSqlServer.USER_STATES);
        this.setBG(this.cbState);
        this.cbState.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbState);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbState, 50);
    }

    private void initCollationName() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.CollationName"));
        this.general.add(label);
        this.tfCollationName = new JTextField("", 26);
        this.general.add(this.tfCollationName);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfCollationName, 80);
    }

    private void initCursorCloseOnCommit() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.CursorClose"));
        this.general.add(label);
        this.cbCursorCloseOnCommit = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbCursorCloseOnCommit);
        this.cbCursorCloseOnCommit.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCursorCloseOnCommit);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbCursorCloseOnCommit, 110);
    }

    private void initCursorDefault() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.CursorDefault"));
        this.general.add(label);
        this.cbCursorDefault = new JComboBox<String>(DataBaseSqlServer.CURSOR_DEFAULT_STATES);
        this.setBG(this.cbCursorDefault);
        this.cbCursorDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCursorDefault);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbCursorDefault, 140);
    }

    private void initAutoClose() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AutoClose"));
        this.general.add(label);
        this.cbAutoClose = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoClose);
        this.cbAutoClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoClose);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbAutoClose, 170);
    }

    private void initAutoCreateStatistics() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AutoCreateStat"));
        this.general.add(label);
        this.cbAutoCreateStatistics = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoCreateStatistics);
        this.cbAutoCreateStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoCreateStatistics);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbAutoCreateStatistics, 200);
    }

    private void initAutoUpdateStatistics() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AutoUpdateStat"));
        this.general.add(label);
        this.cbAutoUpdateStatistics = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoUpdateStatistics);
        this.cbAutoUpdateStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoUpdateStatistics);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbAutoUpdateStatistics, 230);
    }

    private void initAutoShrink() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AutoSrink"));
        this.general.add(label);
        this.cbAutoShrink = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoShrink);
        this.cbAutoShrink.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoShrink);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbAutoShrink, 260);
    }

    private void initRecovery() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.Recovery"));
        this.general.add(label);
        this.cbRecovery = new JComboBox<String>(DataBaseSqlServer.RECOVERY_STATES);
        this.setBG(this.cbRecovery);
        this.cbRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecovery);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbRecovery, 290);
    }

    private void initTornPageDetection() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.TornPage"));
        this.general.add(label);
        this.cbTornPageDetection = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbTornPageDetection);
        this.cbTornPageDetection.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTornPageDetection);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbTornPageDetection, 320);
    }

    private void initAnsiPadding() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AnsiPadding"));
        this.general.add(label);
        this.cbAnsiPadding = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAnsiPadding);
        this.cbAnsiPadding.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAnsiPadding);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbAnsiPadding, 350);
    }

    private void initAnsiNulls() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AnsiNulls"));
        this.general.add(label);
        this.cbAnsiNulls = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAnsiNulls);
        this.cbAnsiNulls.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAnsiNulls);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbAnsiNulls, 380);
    }

    private void initAnsiWarnings() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.AnsiWarnings"));
        this.general.add(label);
        this.cbAnsiWarnings = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAnsiWarnings);
        this.cbAnsiWarnings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAnsiWarnings);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbAnsiWarnings, 410);
    }

    private void initArithabort() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.Arithabort"));
        this.general.add(label);
        this.cbArithabort = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbArithabort);
        this.cbArithabort.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbArithabort);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbArithabort, 440);
    }

    private void initConcatNullYieldsNull() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.ConcatNullYields"));
        this.general.add(label);
        this.cbConcatNullYieldsNull = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbConcatNullYieldsNull);
        this.cbConcatNullYieldsNull.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbConcatNullYieldsNull);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.cbConcatNullYieldsNull, 470);
    }

    private void initNumericRoundabort() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.RoundAbort"));
        this.general.add(label);
        this.cbNumericRoundabort = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbNumericRoundabort);
        this.cbNumericRoundabort.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNumericRoundabort);
        this.setLabelConstraints(label, 500);
        this.setObjectConstraints(this.cbNumericRoundabort, 500);
    }

    private void initQuotedIdentifier() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.QuotedId"));
        this.general.add(label);
        this.cbQuotedIdentifier = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbQuotedIdentifier);
        this.cbQuotedIdentifier.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQuotedIdentifier);
        this.setLabelConstraints(label, 530);
        this.setObjectConstraints(this.cbQuotedIdentifier, 530);
    }

    private void initRecursiveTriggers() {
        JLabel label = new JLabel(Messages.getString("DataBasePropertyDialogSqlServerv2k5.RecursiveTriggers"));
        this.general.add(label);
        this.cbRecursiveTriggers = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbRecursiveTriggers);
        this.cbRecursiveTriggers.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecursiveTriggers);
        this.setLabelConstraints(label, 560);
        this.setObjectConstraints(this.cbRecursiveTriggers, 560);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.cbState.setSelectedItem(this.database.getUserState());
        if (this.database.getCollationName() != null && !this.database.getCollationName().equalsIgnoreCase("null")) {
            this.tfCollationName.setText(this.database.getCollationName());
        }
        this.cbCursorCloseOnCommit.setSelectedItem(this.database.getCursorCloseOnCommit());
        this.cbCursorDefault.setSelectedItem(this.database.getCursorDefault());
        this.cbAutoClose.setSelectedItem(this.database.getAutoClose());
        this.cbAutoCreateStatistics.setSelectedItem(this.database.getAutoCreateStatistics());
        this.cbAutoUpdateStatistics.setSelectedItem(this.database.getAutoUpdateStatistics());
        this.cbRecovery.setSelectedItem(this.database.getRecovery());
        this.cbTornPageDetection.setSelectedItem(this.database.getTornPageDetection());
        this.cbAutoShrink.setSelectedItem(this.database.getAutoShrink());
        this.cbAnsiNulls.setSelectedItem(this.database.getAnsiNulls());
        this.cbAnsiPadding.setSelectedItem(this.database.getAnsiPadding());
        this.cbAnsiWarnings.setSelectedItem(this.database.getAnsiWarnings());
        this.cbArithabort.setSelectedItem(this.database.getArithabort());
        this.cbConcatNullYieldsNull.setSelectedItem(this.database.getConcatNullYieldsNull());
        this.cbNumericRoundabort.setSelectedItem(this.database.getNumericRoundabort());
        this.cbQuotedIdentifier.setSelectedItem(this.database.getQuotedIdentifier());
        this.cbRecursiveTriggers.setSelectedItem(this.database.getRecursiveTriggers());
        this.getCommentsList().insert(this.database.getComment(), 0);
        this.setTypes();
        this.setDomains();
    }

    private void setTypes() {
        Iterator typesIt = this.getStorageDesign().getDistinctTypeProxySet().iterator();
        while (typesIt.hasNext()) {
            boolean check = false;
            Object name = "";
            DistinctTypeProxySqlServerv2k5 distinctType = (DistinctTypeProxySqlServerv2k5)typesIt.next();
            for (UsedUserDefinedData usedDistinctType : ((DataBaseSqlServerv2k5)this.database).getUsedDistinctTypes()) {
                if (usedDistinctType.getDistinctTypeProxy() != distinctType) continue;
                check = true;
                if (usedDistinctType.getSchema() == null) break;
                name = usedDistinctType.getSchema();
                break;
            }
            this.modelTypes.addRow(new Object[]{check, distinctType, name});
        }
    }

    private void setDomains() {
        Iterator typesIt = this.getStorageDesign().getUserDefinedTypeSet().iterator();
        while (typesIt.hasNext()) {
            boolean check = false;
            Object name = "";
            UserDefinedTypeSqlServerv2k5 userDT = (UserDefinedTypeSqlServerv2k5)typesIt.next();
            for (UsedUserDefinedData usedUserDT : ((DataBaseSqlServerv2k5)this.database).getUserDefinedDomains()) {
                if (usedUserDT.getUserDefinedType() != userDT) continue;
                check = true;
                if (usedUserDT.getSchema() == null) break;
                name = usedUserDT.getSchema();
                break;
            }
            this.modelDomains.addRow(new Object[]{check, userDT, name});
        }
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            this.database.setUserState((String)this.cbState.getSelectedItem());
            this.database.setCollationName(this.tfCollationName.getText());
            this.database.setCursorCloseOnCommit((String)this.cbCursorCloseOnCommit.getSelectedItem());
            this.database.setCursorDefault((String)this.cbCursorDefault.getSelectedItem());
            this.database.setAutoClose((String)this.cbAutoClose.getSelectedItem());
            this.database.setAutoCreateStatistics((String)this.cbAutoCreateStatistics.getSelectedItem());
            this.database.setAutoUpdateStatistics((String)this.cbAutoUpdateStatistics.getSelectedItem());
            this.database.setRecovery((String)this.cbRecovery.getSelectedItem());
            this.database.setTornPageDetection((String)this.cbTornPageDetection.getSelectedItem());
            this.database.setAutoShrink((String)this.cbAutoShrink.getSelectedItem());
            this.database.setAnsiNulls((String)this.cbAnsiNulls.getSelectedItem());
            this.database.setAnsiPadding((String)this.cbAnsiPadding.getSelectedItem());
            this.database.setAnsiWarnings((String)this.cbAnsiWarnings.getSelectedItem());
            this.database.setArithabort((String)this.cbArithabort.getSelectedItem());
            this.database.setConcatNullYieldsNull((String)this.cbConcatNullYieldsNull.getSelectedItem());
            this.database.setNumericRoundabort((String)this.cbNumericRoundabort.getSelectedItem());
            this.database.setQuotedIdentifier((String)this.cbQuotedIdentifier.getSelectedItem());
            this.database.setRecursiveTriggers((String)this.cbRecursiveTriggers.getSelectedItem());
            this.modelTypes.removeUnSelectedDT();
            Map selected = this.modelTypes.getSelectedObjects();
            for (DistinctTypeProxySqlServerv2k5 distinctType : selected.keySet()) {
                UsedUserDefinedData usedDistinctType = this.getUsedDisitincType(distinctType);
                if (usedDistinctType == null) {
                    usedDistinctType = ((StorageDesignSqlServerv2k5)this.storageDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    usedDistinctType.setName(distinctType.getName());
                    usedDistinctType.setDatabase(this.database);
                    usedDistinctType.setDistinctTypeProxy(distinctType);
                }
                if (selected.get(distinctType) != null && selected.get(distinctType) instanceof SchemaSqlServer) {
                    usedDistinctType.setSchema((SchemaSqlServer)selected.get(distinctType));
                    continue;
                }
                usedDistinctType.setSchema(null);
            }
            this.modelDomains.removeUnSelectedDomain();
            selected = this.modelDomains.getSelectedDomainsObjects();
            for (UserDefinedTypeSqlServer userDomain : selected.keySet()) {
                UsedUserDefinedData usedDistinctTypeDomain = this.getUsedDomain(userDomain);
                if (usedDistinctTypeDomain == null) {
                    usedDistinctTypeDomain = ((StorageDesignSqlServerv2k5)this.storageDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    usedDistinctTypeDomain.setName(userDomain.getName());
                    usedDistinctTypeDomain.setDatabase(this.database);
                    usedDistinctTypeDomain.setUserDefinedType(userDomain);
                }
                if (selected.get(userDomain) != null && selected.get(userDomain) instanceof SchemaSqlServer) {
                    usedDistinctTypeDomain.setSchema((SchemaSqlServer)selected.get(userDomain));
                    continue;
                }
                usedDistinctTypeDomain.setSchema(null);
            }
            this.database.setComment(this.getCommentsList().getText());
        }
    }

    private UsedUserDefinedData getUsedDisitincType(DistinctTypeProxySqlServer distinctType) {
        for (UsedUserDefinedData usedDT : ((DataBaseSqlServerv2k5)this.database).getUsedDistinctTypes()) {
            if (usedDT.getDistinctTypeProxy() != distinctType || usedDT.getDatabase() != this.database) continue;
            return usedDT;
        }
        return null;
    }

    private UsedUserDefinedData getUsedDomain(UserDefinedTypeSqlServer userDomain) {
        for (UsedUserDefinedData usedDT : ((DataBaseSqlServerv2k5)this.database).getUserDefinedDomains()) {
            if (usedDT.getUserDefinedType() != userDomain || usedDT.getDatabase() != this.database) continue;
            return usedDT;
        }
        return null;
    }

    class TypesTable
    extends JTable {
        TypesTableModel dataModel;

        public TypesTable() {
            this.dataModel = new TypesTableModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            tableColumn.getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
            tableColumn.getColumn(1).setCellRenderer(new UsersTableCellRenderer());
            if (DataBasePropertyDialogSqlServerv2k5.this.database.getSchemas() != null) {
                tableColumn.getColumn(2).setCellEditor(new SchemaComboBoxEditor(DataBasePropertyDialogSqlServerv2k5.this.database.getSchemas().toArray()));
            } else {
                tableColumn.getColumn(2).setCellEditor(new SchemaComboBoxEditor());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(150);
                    continue;
                }
                column.setPreferredWidth(220);
            }
        }
    }

    class TypesTableModel
    extends DefaultTableModel
    implements TableModelListener {
        String[] cNames = new String[]{Messages.getString("DataBasePropertyDialogSqlServerv2k5.Permit"), Messages.getString("DataBasePropertyDialogSqlServerv2k5.TypeName"), Messages.getString("DataBasePropertyDialogSqlServerv2k5.Owner")};
        private Map selectedObj = new HashMap();

        public TypesTableModel() {
            this.addTableModelListener(this);
        }

        public void removeUnSelectedDT() {
            int rowCount = DataBasePropertyDialogSqlServerv2k5.this.modelTypes.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                DistinctTypeProxySqlServerv2k5 distinctType = (DistinctTypeProxySqlServerv2k5)this.getValueAt(i, 1);
                distinctType.clearFromDataBase(DataBasePropertyDialogSqlServerv2k5.this.database);
            }
        }

        public void removeUnSelectedDomain() {
            int rowCount = DataBasePropertyDialogSqlServerv2k5.this.modelDomains.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                UserDefinedTypeSqlServerv2k5 userDefinedType = (UserDefinedTypeSqlServerv2k5)this.getValueAt(i, 1);
                userDefinedType.clearFromDataBase(DataBasePropertyDialogSqlServerv2k5.this.database);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!DataBasePropertyDialogSqlServerv2k5.this.isEditable()) {
                return false;
            }
            return col == 0 || col == 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return null;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
        }

        public Map getSelectedObjects() {
            int rowCount = DataBasePropertyDialogSqlServerv2k5.this.modelTypes.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                this.selectedObj.put(this.getValueAt(i, 1), this.getValueAt(i, 2));
            }
            return this.selectedObj;
        }

        public Map getSelectedDomainsObjects() {
            HashMap<Object, Object> selectedObj = new HashMap<Object, Object>();
            int rowCount = DataBasePropertyDialogSqlServerv2k5.this.modelDomains.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                selectedObj.put(this.getValueAt(i, 1), this.getValueAt(i, 2));
            }
            return selectedObj;
        }
    }

    public class SchemaComboBoxEditor
    extends DefaultCellEditor {
        private JComboBox cbox;

        public SchemaComboBoxEditor(Object[] item) {
            super(new JComboBox<Object>(item));
            this.cbox = (JComboBox)this.getComponent();
            this.cbox.insertItemAt(" ", 0);
        }

        public SchemaComboBoxEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
            this.cbox.addItem(" ");
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class UsersTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        UsersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }
}

