/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UserAndRolePermissionsDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RolePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private RoleSqlServer role;
    private ButtonGroup bGroup;
    private JRadioButton rbIsApplication;
    private JRadioButton rbIsDB;
    private JPasswordField passField;
    private JComboBox cbOwner;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel panelPrivileges;
    private JList allPrivilegesList;
    private JList selectedPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private DefaultListModel selectedPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogSqlServer dialog;

    public RolePropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.role = (RoleSqlServer)object;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertyDialogSqlServer.RoleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.bGroup = new ButtonGroup();
        this.initIsApplRole();
        this.initPassword();
        this.initIsDBRole();
        this.initUsers();
        this.initOwner();
        this.initPermissionsButton();
    }

    private void initPassword() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogSqlServer.Password"));
        this.general.add(label);
        this.passField = new JPasswordField();
        this.setBG(this.passField);
        this.passField.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passField);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.passField, 80);
    }

    private void initUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogSqlServer.AllUsers"));
        this.general.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(144, 120));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getUsersLayout(), label, 12, 184);
        this.setObjectConstraints(this.getUsersLayout(), sp, 10, 202);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogSqlServer.SelectedUsers"));
        this.general.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(145, 120));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getUsersLayout(), label, 267, 184);
        this.setObjectConstraints(this.getUsersLayout(), sp, 265, 202);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("RolePropertyDialogSqlServer.Add"));
        this.bnAdd.addActionListener(new AddUsersActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getUsersLayout(), this.bnAdd, 160, 235);
        this.bnRemove = new JButton(Messages.getString("RolePropertyDialogSqlServer.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveUsersActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getUsersLayout(), this.bnRemove, 160, 265);
        RolePropertyDialogSqlServer.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getUsersLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    private void setIsApplication(boolean use) {
        this.passField.setEnabled(use);
        this.allUsersList.setEnabled(!use);
        this.selectedUsersList.setEnabled(!use);
        this.cbOwner.setEnabled(!use);
    }

    private void setIsDB(boolean use) {
        this.passField.setEnabled(!use);
        this.allUsersList.setEnabled(use);
        this.selectedUsersList.setEnabled(use);
        this.cbOwner.setEnabled(use);
    }

    private void initIsApplRole() {
        this.rbIsApplication = new JRadioButton(Messages.getString("RolePropertyDialogSqlServer.ApplicationRole"));
        this.rbIsApplication.addActionListener(new AppRoleListener());
        this.bGroup.add(this.rbIsApplication);
        this.general.add(this.rbIsApplication);
        this.setObjectConstraints(this.rbIsApplication, 8, 50);
    }

    private void initIsDBRole() {
        this.rbIsDB = new JRadioButton(Messages.getString("RolePropertyDialogSqlServer.DatabaseRole"));
        this.rbIsDB.addActionListener(new DBRoleListener());
        this.bGroup.add(this.rbIsDB);
        this.general.add(this.rbIsDB);
        this.setObjectConstraints(this.rbIsDB, 8, 120);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogSqlServer.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 150);
        this.setObjectConstraints(this.cbOwner, 150);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("RolePropertyDialogSqlServer.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 340);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
    }

    private void initPrivilegesView() {
        this.panelPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogSqlServer.Privileges"), this.panelPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(Messages.getString("RolePropertyDialogSqlServer.Add"));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnAddPrivileges, 160, 160);
        this.bnRemovePrivileges = new JButton(Messages.getString("RolePropertyDialogSqlServer.Remove"));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnRemovePrivileges, 160, 190);
        RolePropertyDialogSqlServer.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initAllPrivilegesList() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogSqlServer.AllPrivileges"));
        this.panelPrivileges.add(label);
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allPrivilegesList);
        sp.setPreferredSize(new Dimension(144, 330));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(sp);
        this.setLabelConstraints(this.getPrivilegesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getPrivilegesLayout(), sp, 10, 32);
    }

    private void initSelectedPrivilegesList() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogSqlServer.SelectedPrivileges"));
        this.panelPrivileges.add(label);
        this.selectedPrivilegesModel = new DefaultListModel();
        this.selectedPrivilegesList = new JList(this.selectedPrivilegesModel);
        ListSelectionModel listSelectionModel = this.selectedPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedPrivilegesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedPrivilegesList);
        sp.setPreferredSize(new Dimension(145, 330));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(sp);
        this.setLabelConstraints(this.getPrivilegesLayout(), label, 267, 14);
        this.setObjectConstraints(this.getPrivilegesLayout(), sp, 265, 32);
    }

    protected SpringLayout getPrivilegesLayout() {
        return (SpringLayout)this.panelPrivileges.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.role.getName());
        this.tfName.setText(this.role.getName());
        this.rbIsApplication.setSelected(this.role.getIsApplicationRole());
        this.passField.setText(this.role.decodePassword());
        this.rbIsDB.setSelected(!this.role.getIsApplicationRole());
        for (UserSqlServer user : this.role.getDatabase().getUsers()) {
            if (user.getName().equalsIgnoreCase("GUEST")) continue;
            this.cbOwner.addItem(user);
        }
        this.cbOwner.setSelectedItem(this.role.getOwner());
        Object[] userSet = this.role.getDatabase().getUsers().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            UserSqlServer user = (UserSqlServer)userSet[i];
            if (user.getName().equalsIgnoreCase("GUEST")) continue;
            if (this.role.getUserSet().contains(user.getName())) {
                this.addElementToSortedListModel(this.selectedUsersModel, user);
                continue;
            }
            this.addElementToSortedListModel(this.allUsersModel, user);
        }
        this.passField.setEnabled(this.role.getIsApplicationRole());
        this.allUsersList.setEnabled(!this.role.getIsApplicationRole());
        this.selectedUsersList.setEnabled(!this.role.getIsApplicationRole());
        this.cbOwner.setEnabled(!this.role.getIsApplicationRole());
        if (this.role.isNullInstance()) {
            this.tfName.setEnabled(false);
            this.rbIsApplication.setEnabled(false);
            this.passField.setEnabled(false);
            this.rbIsDB.setEnabled(false);
            this.cbOwner.setEnabled(false);
            this.allUsersList.setEnabled(false);
            this.selectedUsersList.setEnabled(false);
            this.selectedPrivilegesList.setEnabled(false);
            this.allPrivilegesList.setEnabled(false);
        }
        String[] privilegesSet = (String[])UserSqlServer.getPrivilegesValues().toArray();
        for (int i = 0; i < privilegesSet.length; ++i) {
            String privilege = privilegesSet[i];
            if (this.role.getPrivilegesSet().contains(privilege)) {
                this.addElementToSortedListModel(this.selectedPrivilegesModel, privilege);
                continue;
            }
            this.addElementToSortedListModel(this.allPrivilegesModel, privilege);
        }
        this.getCommentsList().insert(this.role.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.role != null) {
            this.role.setName(this.tfName.getText());
            this.role.setIsApplicationRole(this.rbIsApplication.isSelected());
            this.role.encodePassword(String.valueOf(this.passField.getPassword()));
            this.role.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            Object[] userSet = this.selectedUsersModel.toArray();
            this.role.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof UserSqlServer)) continue;
                this.role.setUsers(((UserSqlServer)ob).getName());
            }
            Object[] privSet = this.selectedPrivilegesModel.toArray();
            for (int i = 0; i < privSet.length; ++i) {
                Object pr = privSet[i];
                if (!(pr instanceof String)) continue;
                this.role.setSystemPrivileges((String)pr);
            }
            this.role.setComment(this.getCommentsList().getText());
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.allUsersList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnAdd.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.selectedUsersList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnRemove.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RolePropertyDialogSqlServer.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = RolePropertyDialogSqlServer.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RolePropertyDialogSqlServer.this.selectedUsersModel.contains(ob)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.selectedUsersModel, ob);
                    RolePropertyDialogSqlServer.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RolePropertyDialogSqlServer.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = RolePropertyDialogSqlServer.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RolePropertyDialogSqlServer.this.allUsersModel.contains(ob)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.allUsersModel, ob);
                    RolePropertyDialogSqlServer.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class AppRoleListener
    implements ActionListener {
        private AppRoleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RolePropertyDialogSqlServer.this.setIsApplication(RolePropertyDialogSqlServer.this.rbIsApplication.isSelected());
        }
    }

    private class DBRoleListener
    implements ActionListener {
        private DBRoleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RolePropertyDialogSqlServer.this.setIsDB(RolePropertyDialogSqlServer.this.rbIsDB.isSelected());
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RolePropertyDialogSqlServer.this.dialog == null) {
                RolePropertyDialogSqlServer.this.dialog = new UserAndRolePermissionsDialogSqlServer(RolePropertyDialogSqlServer.this.getAppView(), RolePropertyDialogSqlServer.this.getStorageDesign(), RolePropertyDialogSqlServer.this.role);
            }
            RolePropertyDialogSqlServer.this.dialog.showDialog();
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RolePropertyDialogSqlServer.this.allPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = RolePropertyDialogSqlServer.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RolePropertyDialogSqlServer.this.selectedPrivilegesModel.contains(ob)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.selectedPrivilegesModel, ob);
                    RolePropertyDialogSqlServer.this.allPrivilegesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RolePropertyDialogSqlServer.this.selectedPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = RolePropertyDialogSqlServer.this.selectedPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RolePropertyDialogSqlServer.this.allPrivilegesModel.contains(ob)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.allPrivilegesModel, ob);
                    RolePropertyDialogSqlServer.this.selectedPrivilegesModel.removeElement(ob);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.allPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnAddPrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class SelectedPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private SelectedPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.selectedPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        }
    }
}

